<?php
/* Copyright (C) Yassine Belkaid y.belkaid@nextconcept.ma
 *
 */

/**
 * \file    btp/market/work_supplies/class/work_supplies.class.php
 * \ingroup work_supplies
 * \brief   This file is work_supplies CRUD class file
 *
 */

require_once DOL_DOCUMENT_ROOT . '/btp/db/nxdb.class.php';

/**
 * Class btp
 *
 * Delay Management class
 */
class MarketWorkSupplies extends NXdb
{
	/**
	 * @var string Error code (or message)
	 * @deprecated
	 * @see btp::errors
	 */
	public $error;
	/**
	 * @var string[] Error codes (or messages)
	 */
	public $errors = array();
	/**
	 * @var string Id to identify managed objects
	 */
	public $element = 'td_supplies';
	/**
	 * @var string Name of table without ptransport_marcheix where object is stored
	 */
	public $table_element 	 = 'td_supplies';

	/**
	 * @var int ID
	 */
	public $id;
	public $fk_createdby;
	public $fk_td_work;
	public $fk_product;
	public $transport;
	public $handling;
	public $charges_supplement;
	public $qty_product;
	public $created_at;
	public $updated_at;

	public $now;
	public $lines = array();
	/**
	 * Constructor
	 *
	 * @param DoliDb $db Database handler
	 */
	public function __construct(DoliDBMysqli $db)
	{
		$this->db 		 = $db;
		$this->now 		 = new \DateTime("now");
		$this->now 		 = $this->now->format('Y-m-d H:i:s');
		$this->updated_at= $this->now;
		return 1;
	}

	/**
	 * Create object into database
	 *
	 * @return int   id of last inserted id, otherwise -1 if error arised 
	 */
	public function create()
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		// Clean parameters
		$this->fk_createdby = $this->fk_createdby ? $this->db->escape($this->fk_createdby) : 0;
		$this->fk_td_work 		= $this->fk_td_work ? $this->db->escape((int)$this->fk_td_work) : 0;
		$this->fk_product	= $this->fk_product ? $this->db->escape((int)$this->fk_product) : 0;
		$this->qty_product	= $this->qty_product ? $this->db->escape((int)$this->qty_product) : 0;
		$this->handling 	= $this->handling ? $this->db->escape($this->handling) : 0;
		$this->transport 	= $this->transport ? $this->db->escape($this->transport) : null;
		$this->charges_supplement= $this->charges_supplement ? $this->db->escape($this->charges_supplement) : null;
		$this->created_at 	= $this->now;

		// Insert request
		$sql = 'INSERT INTO ' . MAIN_DB_PREFIX . $this->table_element . ' (qty_product, fk_createdby, fk_td_work, created_at, updated_at, fk_product, handling, transport, charges_supplement) VALUES (';
		$sql .= $this->qty_product .",".$this->fk_createdby.", ".$this->fk_td_work.", '".$this->created_at."', '".$this->updated_at ."', ".$this->fk_product.", '". $this->handling ."', '". $this->transport ."', ". $this->charges_supplement .")";

		$this->db->begin();
		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error works ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return $this->getLasInsrtedId();
		}
	}

	/**
	 * Load object in memory from the database
	 *
	 * @param int    $id  Id object
	 * @param string $transport transport
	 *
	 * @return int <0 if KO, 0 if not found, >0 if OK
	 */
	public function fetch($id, $fk_td_work = null)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . $this->table_element;

		if (null !== $fk_td_work) {
			$sql .= ' WHERE fk_td_work = ' . $fk_td_work;
		} else {
			$sql .= ' WHERE rowid = ' . $id;
		}

		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);

			if ($numrows) {
				$obj 				 = $this->db->fetch_object($resql);
				$this->id 			 = $obj->rowid;
				$this->fk_createdby  = $obj->fk_createdby;
				$this->fk_td_work 	 	 = $obj->fk_td_work;
				$this->fk_product	 = $obj->fk_product;
				$this->handling 	 = $obj->handling;
				$this->qty_product   = $obj->qty_product;
				$this->transport  	 = $obj->transport;
				$this->charges_supplement= $obj->charges_supplement;
				$this->updated_at 	 = $this->db->jdate($obj->updated_at);
				$this->created_at 	 = $this->db->jdate($obj->created_at);
			}

			$this->db->free($resql);

			if ($numrows) {
				return 1;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	/**
	 * Load object in memory from the database
	 *
	 * @param string $sortorder Sort Order
	 * @param string $sortfield Sort field
	 * @param int    $limit     offset limit
	 * @param int    $offset    offset limit
	 * @param array  $filter    filter array
	 * @param string $filtermode filter mode (AND or OR)
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function fetchAll($wid = null, $sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '', $ignore_id = false)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$ignore_id)
			$sql = 'SELECT s.*, p.price FROM ' . MAIN_DB_PREFIX . $this->table_element.' s, '. MAIN_DB_PREFIX .'product p WHERE s.fk_product = p.rowid';
		else
			$sql = 'SELECT s.*, p.price FROM ' . MAIN_DB_PREFIX . $this->table_element .' s, '. MAIN_DB_PREFIX .'product p WHERE s.fk_product = p.rowid';

		if (!empty($filter)) {
			$sql .= substr($filter, 4) .' AND fk_td_work = '. $wid;
		} else {
			if (!$ignore_id)
				$sql .= ' AND fk_td_work = '. $wid;
		}

		if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}

		$this->lines = array();
		$resql 		 = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;

				$line->id 			= $obj->rowid;
				$line->fk_createdby = $obj->fk_createdby;
				$line->fk_td_work 	= $obj->fk_td_work;
				$line->fk_product 	= $obj->fk_product;
				$line->handling 	= $obj->handling;
				$line->qty_product 	= $obj->qty_product;
				$line->transport 	= $obj->transport;
				$line->charges_supplement= $obj->charges_supplement;
				$line->price 		= $obj->price;
				$line->updated_at 	= $this->db->jdate($obj->updated_at);
				$line->created_at 	= $this->db->jdate($obj->created_at);
				$this->lines[] 		= $line;
			}
			$this->db->free($resql);

			return $num;
		} else {
			$this->error 	= 'Error ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	/**
	 * Update object into database
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function update($id, array $data)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$id)
			return false;

		if (count($data) && is_array($data)) {
			// Update request
			$sql = 'UPDATE ' . MAIN_DB_PREFIX . $this->table_element . ' SET updated_at = "'. $this->now .'",';

			foreach ($data as $key => $val) {
				$val = is_numeric($val) ? $val : '"'. $this->db->escape($val) .'"';
				$sql .= ' `'. $key. '` = '. $val .',';
			}

			$sql  = rtrim($sql, ',');
			$sql .= ' WHERE rowid = ' . $id;

			$this->db->begin();

			$resql = $this->db->query($sql);

			if (!$resql) {
				$this->db->rollback();
				
				$this->error = 'Error ' . $this->db->lasterror();
				$this->errors[] = $this->error;
				dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

				return -1;
			} else {
				$this->db->commit();

				return 1;
			}
		}
	}

	/**
	 * Delete object in database
	 *
	 * @param User $user      User that deletes
	 * @param bool $notrigger false=launch triggers after, true=disable triggers
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function delete($id)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$this->db->begin();

		$sql 	= 'DELETE FROM ' . MAIN_DB_PREFIX . $this->table_element .' WHERE rowid = ' . (int)$id;
		$resql 	= $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}

	/**
     *	Return clicable name (with picto eventually)
     *
     *  @author Yassine Belkaid <y.belkaid@nextconcept.ma>
     *	@param		int			$withpicto		0=_No picto, 1=Includes the picto in the linkn, 2=Picto only
     *	@return		string						String with URL
     */
    public function getNomUrl($withpicto=0,  $id, $wid)
    {
        global $langs;

        $result	= '';
        $settransport	= '';

        $id  	= ($id  ?: '');
        $label  = $langs->trans("Show").': '. $id;

        $link 	 = '<a href="'.DOL_URL_ROOT.'/btp/market/work_supplies/index.php?id='. $id .'&wid='. $wid .'" class="classfortooltip" title="'. $label .'">';
        $linkend ='</a>';
        $picto   = $this->defaultPicto;

        if ($withpicto) $result.=($link.img_object($label, $picto, 'class="classfortooltip"').$linkend);
        if ($withpicto && $withpicto != 2) $result.=' ';
        if ($withpicto != 2) $result.=$link.$label.$linkend;
        return $result;
    }

    public function getStatData($wid = false, $market_id = 0)
    {
    	global $langs;
    	$this->fetchAll(($wid ?: null), '', '', 0, 0, '', ($wid ? false : true));
    	$countAmount = 0;

    	foreach ($this->lines as $key => $obj)
    		$countAmount += ($obj->price*$obj->qty_product)+$obj->charges_supplement;

    	$object 		= new stdClass();
    	$object->number = (!$wid && $market_id ? 0 : count($this->lines));
    	$object->cost 	= (!$wid && $market_id ? 0 : $countAmount);
    	$object->label 	= $langs->trans('Supplies');
    	$object->url 	= (int)$wid ? DOL_URL_ROOT.'/btp/market/work_supplies/index.php?wid='.$wid.'&mid='. $market_id : '';

    	return $object;
    }
}
