<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 */

/**
 * \file       btp/market/works/index.php
 * \ingroup    list
 * \brief      List of works
 */
require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/btp/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/files.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formfile.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/images.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/functions2.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/usergroups.lib.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/user.class.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/usergroup.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/works/class/works.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/market/class/market.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/settings/unit_type/class/unitType.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/btp.lib.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/tools.lib.php';

require_once DOL_DOCUMENT_ROOT.'/btp/lib/btpmarche.lib.php';

// Protection if external user
if (!$user) accessforbidden();

$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
$page = GETPOST("page",'int');
$page = is_numeric($page) ? $page : 0;
$page = $page == -1 ? 0 : $page;
$filter = '';
if (!$sortfield) $sortfield = "rowid";
if (!$sortorder) $sortorder = "DESC";

$offset   = $conf->liste_limit * $page;
$pageprev = $page - 1;
$pagenext = $page + 1;
$id 	  = GETPOST('id','int');
$mid 	  = GETPOST('mid','int');
$action	  = GETPOST('action', 'alpha');
$confirm  = GETPOST('confirm', 'alpha');

if (!$mid)
	die("ID marché n'existe pas!");

$search_ref       = GETPOST('search_ref');
$search_unit_type = GETPOST('search_unit_type');
$search_task      = GETPOST('search_task');
$search_price     = GETPOST('search_price');
$search_qty		  = GETPOST('search_qty');

 // Both test are required to be compatible with all browsers
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
	$search_ref   	 = "";
	$search_task   	 = "";
	$search_unit_type= "";
    $search_price  	 = "";
	$search_qty	 	 = "";
}

/**
 * Actions
 */

// None

/**
 * View
 */

$object  = new MarketWorks($db);
$fuser 	 = new User($db);
$market  = new Market($db);
$unitType= new unitType($db);

llxHeader(array(), $langs->trans('Works'), '', '', '', '', array('/btp/js/btp.js'));

// Filter
$filter .= (!empty($search_ref)) ? " AND rowid = ". $db->escape((int)$search_ref) : "";

$filter .= (isset($search_price) && !empty($search_price)) ? " AND price = ". $db->escape((float)$search_price) : '';
$filter .= isset($search_qty) && !empty($search_qty) ? " AND qty = ". $db->escape((int)$search_qty) : '';
$filter .= (!empty($search_unit_type) && $search_unit_type != -1) ? " AND fk_unit_type = ". $db->escape((int)$search_unit_type) : "";
$filter .= (!empty($search_task)) ? " AND task LIKE '%". $db->escape($search_task) ."%'" : "";

/*************************************
 * Fin des filtres de recherche
*************************************/

// Récupération de l'ID de l'utilisateur
$getworks = $object->fetchAll($mid, $sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter);

// Si erreur SQL
if ($getworks == '-1') {
    print_fiche_titre($langs->trans('Works'), '', 'title_project.png');

    dol_print_error($db, $langs->trans('Error').' '.$object->error);
    exit();
}

// Show table of vacations
$var  = true;
$num  = count($object->lines);
$form = new FormChild($db);
$market->fetch($mid);

if ($id > 0) {
	$object->fetch($id);

	print_barre_liste($langs->trans("Works"), $page, $_SERVER["PHP_SELF"], '', $sortfield, $sortorder, "", $num, "", 'title_project.png');

	$title = $langs->trans("Works");
	$head  = market_prepare_head($market);
	dol_fiche_head($head, 'works', $title, 0, '');
$head     = t_prepare_head($mid);
  dol_fiche_head($head, 'releases', $title, 0, 'submunu1');

	$worksHead  = market_works_prepare_head($object);
	dol_fiche_head($worksHead, '', $langs->trans("Works"), 0, 'submunu2');

	echo $market->getMarketHeader($mid);

	$fuser->fetch($object->fk_createdby);
	$unitType->fetch($object->fk_unit_type);
	$task	= $object->task ?: '';
	$price	= $object->price ? number_format($object->price, 2) : '';
	$qty	= $object->qty ? $object->qty : '';

	print '<table class="border" width="100%">';
	// Created By
	print '<tr><td width="25%">'.$langs->trans("CreatedBy").'</td>';
	print '<td colspan="2">'. $fuser->getNomUrl('1') .'</td></tr>';

	// task
	print '<tr><td class="fieldrequired">'.$langs->trans("Task").'</td>';
	print '<td colspan="2">'. $task .'</td></tr>';

	// Unit type
	print '<tr><td class="fieldrequired">'.$langs->trans("UnitType").'</td>';
	print '<td colspan="2">'. $unitType->getNomUrl(1, $unitType->rowid, $unitType->name) .'</td></tr>';

	// Price
	print '<tr><td class="fieldrequired">'.$langs->trans("Price").'</td>';
	print '<td colspan="2">'. $price .' '.$langs->getCurrencySymbol($conf->currency).'</td></tr>';

	// Qty
	print '<tr><td class="fieldrequired">'.$langs->trans("Quantity").'</td>';
	print '<td colspan="2">'. $qty .'</td></tr>';


	print '</table>';

	print '<br>';
	print '<div style="float: right; margin-top: 8px;">';
	print '<a href="./index.php?mid='. $mid .'" class="butAction">'.$langs->trans('Cancel').'</a>';
	if ($user->id/* && $user->rights->btp->write_all*/) {
		print '<a href="./card.php?action=edit&id='. $id .'&mid='. $mid .'" class="butAction">'.$langs->trans('Modify').'</a>';

		// if ($user->rights->btp->delete)	{
        	print '<a href="./index.php?id='.$id.'&action=delete&mid='. $mid .'" class="butActionDelete">'.$langs->trans("Delete").'</a>';
        // }
		if ($action == 'delete') {
            // if($user->rights->btp->delete) {
            print $form->formconfirm("./card.php?mid=".$mid."&id=".$id, $langs->trans("TitleDeleteWork"), $langs->trans("ConfirmDeleteWork"), "confirm_delete", '', 0, 1);
                // }
        }
	}
	print '</div>';
}
else {
	print_barre_liste($langs->trans("Works"), $page, $_SERVER["PHP_SELF"], '', $sortfield, $sortorder, "", $num, "", 'title_project.png');
	
	$head  = market_prepare_head($market);
	dol_fiche_head($head, 'works', $langs->trans("Works"), 0, '');
$head     = t_prepare_head($mid);
  dol_fiche_head($head, 'releases', $title, 0, 'submunu');

	echo $market->getMarketHeader($mid);

	$moreparam = '&mid='.$mid;

	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	print '<input type="hidden" name="mid" value="'. $mid .'" />';
	print '<table class="noborder" width="100%">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("Ref"),$_SERVER["PHP_SELF"], "rowid", '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("UnitType"),$_SERVER["PHP_SELF"], "fk_unit_type", '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("Task"), $_SERVER["PHP_SELF"], 'task', '',  $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("Price"),$_SERVER["PHP_SELF"], 'price', '',  $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("Quantity"), $_SERVER["PHP_SELF"],'qty','', $moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("total"), $_SERVER["PHP_SELF"],'','', $moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'','','',$sortfield,$sortorder,'maxwidthsearch ');
	print "</tr>";

	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';
	print '<td class="liste_titre" align="center">';
	print '<input class="flat center" size="14" type="text" name="search_ref" value="'.dol_escape_htmltag($search_ref).'" />';
	print '</td>';

    print '<td class="liste_titre" align="center">';
    print $form->selectarray("search_unit_type", $unitType->getNames(), $search_unit_type, 1);
    print '</td>';

	print '<td class="liste_titre" align="center">';
	print '<input class="flat center" size="30" type="text" name="search_task" value="'.dol_escape_htmltag($search_task).'" />';
	print '</td>';

	print '<td class="liste_titre" align="center"><input class="flat center" type="text" size="14" name="search_price" value="'.$search_price.'"></td>';

	print '<td class="liste_titre" align="center"><input class="flat center" type="text" size="14" name="search_qty" value="'.$search_qty.'"></td>';

	print '<td class="liste_titre" align="center"></td>';

	// ACTION
	print '<td align="right" style="min-width:62px;">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';
	print "</tr>\n";

	// Lines
	if (count($object->lines)) {
		foreach ($object->lines as $line) {
			$var = !$var;
			$unitType->fetch($line->fk_unit_type);
			$task		= $line->task ? $line->task : '';
			$qty		= $line->qty ? $line->qty : '';
			$price		= $line->price ? number_format($line->price, 2) : '';

			print '<tr '.$bc[$var].'>';
			print '<td align="left">';
				print $object->getNomUrl(1,  $line->id, $line->fk_market);
			print '</td>';
			print '<td align="center">'. $unitType->getNomUrl(1, $unitType->rowid, $unitType->name) .'</td>';
			print '<td align="center">'. $task .'</td>';
			print '<td align="center">'. $price .'</td>';
			print '<td align="center">'. $qty .'</td>';
			print '<td align="center">'. $qty*$line->price .'</td>';
			print '<td>&nbsp;</td>';
			print '</tr>';
		}
	} else {
		print '<tr>';
	    print '<td colspan="6" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';
	}

	

	if ($user->id /*&& $user->rights->btp->write*/) {
		// $exceedingCls = $totalExceedingDays ? 'red' : 'green';
		print '<tr>';
	    print '<td colspan="6" '.$bc[false].'">';

		print '<br>';
		print '<div style="float: right; margin-top: 8px;">';
		print '<a href="./card.php?action=add&mid='. $mid .'" class="butAction">'.$langs->trans('AddWork').'</a>';
		
		print '</div>';
	    print '</td></tr>';
	}

	print '</table>';
	print '</form>';
}

llxFooter();

$db->close();

?>