<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file       appeloffres/index.php
 * \ingroup    list
 * \brief      List of markets
 */
require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/material/amortization/class/amortization.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/material/machine/class/machine.class.php';
include_once DOL_DOCUMENT_ROOT.'/societe/class/societe.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/machine.lib.php';

$form 		= new Form($db);
$amortization   = new amortization($db);
$machine     = new machine($db);
$societe     = new Societe($db);

$var = false;
$filter = '';
$td_travaux =  array(1 => 'Travaux 1', 2 => 'Travaux 2' );
$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
if (! $sortfield) $sortfield = "rowid";
if (! $sortorder) $sortorder = "DESC";
$action  = GETPOST('action', 'alpha');
$mid 	  = GETPOST('mid', 'int');
$id 	  = GETPOST('id','int');
$search_amount      		= GETPOST('search_amount');
$search_date_start      		= "";
	if (GETPOST('search_date_start') !=="") {
	    list($etd, $etm, $ety) = explode("/", GETPOST('search_date_start'));
	    $search_date_start         = $ety.'-'.$etm.'-'.$etd ;
	}
$search_duration    		= GETPOST('search_duration');
$search_machine    		= GETPOST('search_machine');
$search_tva    		= GETPOST('search_tva');
$search_supplier    		= GETPOST('search_supplier');
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
$search_amount      		= '';
$search_date_start      		= '';
$search_duration    		= '';
$search_machine    		= '';
$search_tva    		= '';
$search_supplier    		= '';
}
$filter .= (!empty($search_date_start) && $search_date_start != -1) ? " AND date_start = '". $db->escape($search_date_start)."'\n" : "";
$filter .= (!empty($search_amount) && $search_amount != -1) ? " AND amount = ".$db->escape($search_amount):"";
$filter .= (!empty($search_duration) && $search_duration != -1) ? " AND duration = ".$db->escape($search_duration):"";
$filter .= " AND machine_id = ".$mid;
$filter .= (!empty($search_tva) && $search_tva != -1) ? " AND tva = ".$db->escape($search_tva): "";
$filter .= (!empty($search_supplier) && $search_supplier != -1) ? " AND supplier_id = ".$db->escape($search_supplier): "";


$getamortizations = $amortization->fetchAll($sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter);

// Si erreur SQL
if ($getamortizations == '-1') {
    print_fiche_titre($langs->trans('ListOfamortization'), '', 'title_project.png');

    dol_print_error($db, $langs->trans('Error').' '.$amortization->error);
    exit();
}
if ($id > 0) {
	$amortization->fetch($id);
	//llxHeader('', $langs->trans('amortization'));
	//print_fiche_titre($langs->trans("amortization"));
	$machine->fetch($mid);
	llxHeader('', $langs->trans('amortization'));
	print_fiche_titre($langs->trans("amortization"));
	$head  		= material_prepare_head($machine);
	dol_fiche_head($head, 'amortization', $langs->trans('amortization'), 1, '');
	$html .= '<table class="border" width="100%">';
		$html .= '<tr><td width="25%">'.$langs->trans("code").'</td>';
        $html .= '<td colspan="2">'. $machine->code .'</td></tr>';
        $html .= '<tr><td width="25%">'.$langs->trans("regigster_num").'</td>';
        $html .= '<td colspan="2">'. $machine->regigster_num .'</td></tr>';
    $html .= '</table><br />';
    echo $html;
	print_fiche_titre($langs->trans("amortization"));


	print '<table class="border" width="100%">';
	// amount
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("amount").'</td>';
	print '<td colspan="2">'. $amortization->amount .'</td></tr>';
	// duration
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("duration").'</td>';
	print '<td colspan="2">'. $amortization->duration .'</td></tr>';
	// engin
	/*print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("machine").'</td>';
	$machine->fetch($amortization->machine_id);
	print '<td colspan="2">'. $machine->getNomUrl(1) .'</td></tr>';
	*/// date
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("date_start").'</td>';
	print '<td colspan="2">'. dol_print_date($amortization->date_start,'day') .'</td></tr>';
	// chantier
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("tva").'</td>';
	print '<td colspan="2">'. $amortization->tva .'</td></tr>';
	//travaux
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("supplier").'</td>';
	$societe->fetch($amortization->supplier_id);
	print '<td colspan="2">'. $societe->getNomUrl(1) .'</td></tr>';
	
	print '</table>';
	print '<br>';
	print '<div style="float: right; margin-top: 8px;">';
	print '<a href="./index.php?mid='. $mid .'" class="butAction">'.$langs->trans('Cancel').'</a>';
		print '<a href="./card.php?action=edit&id='. $id .'&mid='.$mid.'" class="butAction">'.$langs->trans('Modify').'</a>';
		print '<a href="./index.php?action=delete&id='. $id .'&mid='.$mid.'" class="butAction">'.$langs->trans('Delete').'</a>';
	print '</div>';
	if ($action == 'delete') {
                    print $form->formconfirm("card.php?id=".$id."?mid=".$mid, $langs->trans("TitleDelete"),$langs->trans("ConfirmDelete"),"confirm_delete", '', 0, 1);
                }
}
else {

 // Both test are required to be compatible with all browsers
$morejs  = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.js", "/btp/js/jquery/timepicker/timepicker-fr.js","/btp/js/fuel_consoma.js");
$morecss = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.css");

llxHeader('', $langs->trans('amortization'),'','','','',$morejs,$morecss,0,0);
print_fiche_titre($langs->trans("ListOfamortization"));
$machine->fetch($mid);
	$head = material_prepare_head($machine);
   	dol_fiche_head($head, 'amortization', $langs->trans('ListOfamortization'), 1, '');
   	$moreparam = '&mid='.$mid;
		$html .= '<table class="border" width="100%">';
		$html .= '<tr><td width="25%">'.$langs->trans("code").'</td>';
        $html .= '<td colspan="2">'. $machine->code .'</td></tr>';
        $html .= '<tr><td width="25%">'.$langs->trans("regigster_num").'</td>';
        $html .= '<td colspan="2">'. $machine->regigster_num .'</td></tr>';
    $html .= '</table><br />';
    echo $html;
	//dol_fiche_head('', 'amortization', $langs->trans("ListOfamortization"), 1, '');

	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	print '<input name="id" value="'. $id .'" type="hidden" />';
	print '<input name="mid" value="'. $mid .'" type="hidden" />';
	print '<table class="noborder" width="100%;">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("date_start"), $_SERVER["PHP_SELF"], 'date_start', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("amount"),$_SERVER["PHP_SELF"],"amount", '',$moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("duration"),$_SERVER["PHP_SELF"],"duration", '',$moreparam,'align="center"',$sortfield,$sortorder);
	//print_liste_field_titre($langs->trans("machine"),$_SERVER["PHP_SELF"],"machine_id", '','','align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("tva"), $_SERVER["PHP_SELF"], 'tva', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("supplier"), $_SERVER["PHP_SELF"], 'supplier_id', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'',$moreparam,'',$sortfield,$sortorder,'maxwidthsearch ');
	print "</tr>\n";

	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';
	//datec
	print '<td class="liste_titre" olspan="1" align="center">';
    print '<input type="text" value="'.dol_print_date($search_date_start,'day').'" class="datepicker" autocomplete="off"  name="search_date_start"  readonly="readonly" /> ';
    print '</td>';
	// amount
	print '<td class="liste_titre" olspan="1" align="center">';
	print '<input class="flat" style="width: 85px"  type="number" step="0.01" min="0" name="search_amount" value="'.$search_amount.'">';
	print '</td>';
	// duration
	print '<td class="liste_titre" olspan="1" align="center">';
	print '<input class="flat" style="width: 85px"  type="number" step="0.01" min="0" name="search_duration" value="'.$search_duration.'">';
	print '</td>';
	// engin
	/*print '<td class="liste_titre" olspan="1" align="center">';
	print $form->selectarray('search_machine', $machine->getMats(), $search_machine, 1, 0, 0, 'required="required"');
	print '</td>';*/
	// tva
	print '<td class="liste_titre" olspan="1" align="center">';
	print '<input class="flat" style="width: 85px"  type="number" step="0.01" min="0" name="search_tva" value="'.$search_tva.'">';
	print '</td>';
	// supplier
	print '<td class="liste_titre" olspan="1" align="center">';
	print  $form->select_thirdparty($search_supplier,"search_supplier",'s.fournisseur=1');
    print '</td>';

	// ACTION
	print '<td align="right" style="min-width:62px;">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';

	print "</tr>\n";

	// Lines
	if (count($amortization->rows)) {
		//$createdBy = new User($db);
		foreach($amortization->rows as $obj) {
			  $amount 				= $obj->amount ;
			  $date_start 			= dol_print_date($obj->date_start,'day') ;
			  $duration 			= $obj->duration ;
			  //$machine->fetch($obj->machine_id) ;
			  $tva         			= $obj->tva ;
			  $societe->fetch($obj->supplier_id);
	
			

			print '<tr '.$bc[$var].'>';
			print '<td align="left" style ="white-space: nowrap;">';
				print $amortization->getNomUrl(1,  $obj->id,$mid, $date_start);
			print '</td>';
			 
			print '<td align="center">'. $amount .'</td>';
			print '<td align="center">'. $duration .'</td>';
			//print '<td align="center">'. $machine->getNomUrl(1) .'</td>';
			print '<td align="center">'. $tva .'</td>';
			print '<td align="center">'. $societe->getNomUrl(1) .'</td>';

			print '</tr>'."\n";

		}
	} else {
		print '<tr>';
	    print '<td colspan="9" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';
	}

	print '</table>';
	print '</form>';


		print '<br>';
		print '<div style="float: right; margin-top: 8px;">';
		print '<a href="./card.php?action=add&mid='.$mid.'" class="butAction">'.$langs->trans('Addamortization').'</a>';
		print '</div>';


}

llxFooter();

$db->close();


?>