<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file       appeloffres/index.php
 * \ingroup    list
 * \brief      List of markets
 */
require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/material/const_diposals_affect/class/const_diposals_affect.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/material/const_site_diposals/class/const_site_diposals.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/settings/unit_type/class/UnitType.class.php';
include_once DOL_DOCUMENT_ROOT.'/product/class/product.class.php';

$form 		= new Form($db);
$const_diposals_affect   = new const_diposals_affect($db);
$const_site_diposals   = new const_site_diposals($db);
$unit_type   = new UnitType($db);
$produit   = new product($db);
$var = false;
$filter = '';
$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
if (! $sortfield) $sortfield = "rowid";
if (! $sortorder) $sortorder = "DESC";
$id 	  = GETPOST('id','int');
$search_ref      		= GETPOST('search_ref');
$search_designation      		= GETPOST('search_designation');
$search_product    		= GETPOST('search_product');
$search_qty    		= GETPOST('search_qty');
$search_price    		= GETPOST('search_price');
$search_unit_type    		= GETPOST('search_unit_type');
$search_const_site_diposals    		= GETPOST('search_const_site_diposals');
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
$search_ref      		= '';
$search_designation      		= '';
$search_product    		= '';
$search_qty    		= '';
$search_price    		= '';
$search_unit_type    		= '';
$search_const_site_diposals    		= '';
}
$filter .= (!empty($search_ref) && $search_ref != -1) ? " AND ref = '". $db->escape($search_ref)."'\n" : "";
$filter .= (!empty($search_designation) && $search_designation != -1) ? " AND designation = '". $db->escape($search_designation)."'\n" : "";
$filter .= (!empty($search_product) && $search_product != -1) ? " AND product_id = ".$db->escape($search_product):"";
$filter .= (!empty($search_qty) && $search_qty != -1) ? " AND qty = ".$db->escape($search_qty):"";
$filter .= (!empty($search_price) && $search_price != -1) ? " AND price = ".$db->escape($search_price):"";
$filter .= (!empty($search_unit_type) && $search_unit_type != -1) ? " AND unit_type_id = ".$db->escape($search_unit_type) : "";
$filter .= (!empty($search_const_site_diposals) && $search_const_site_diposals != -1) ? " AND const_disposal_id = ".$db->escape($search_const_site_diposals) : "";


$getconst_diposals_affects = $const_diposals_affect->fetchAll($sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter);

// Si erreur SQL
if ($getconst_diposals_affects == '-1') {
    print_fiche_titre($langs->trans('ListOfconst_diposals_affect'), '', 'title_project.png');

    dol_print_error($db, $langs->trans('Error').' '.$const_diposals_affect->error);
    exit();
}
if ($id > 0) {
	$const_diposals_affect->fetch($id);
	llxHeader('', $langs->trans('const_diposals_affect'));
	print_fiche_titre($langs->trans("const_diposals_affect"));


	print '<table class="border" width="100%">';
	// ref
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("ref").'</td>';
	print '<td colspan="2">'. $const_diposals_affect->ref .'</td></tr>';
	// date
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("designation").'</td>';
	print '<td colspan="2">'. $const_diposals_affect->designation .'</td></tr>';
	// quantité
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("qty").'</td>';
	print '<td colspan="2">'. $const_diposals_affect->qty .'</td></tr>';
	// prix
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("price").'</td>';
	print '<td colspan="2">'. $const_diposals_affect->price .'</td></tr>';
	// lubricant
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("product").'</td>';
	$produit->fetch($const_diposals_affect->product_id);
	print '<td colspan="2">'. $produit->getNomUrl(1) .'</td></tr>';
	// unité
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("unit_type").'</td>';
	$unit_type->fetch($const_diposals_affect->unit_type_id);
	print '<td colspan="2">'. $unit_type->getNomUrl(1) .'</td></tr>';
	//chantier
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("const_site_diposals").'</td>';
	$const_site_diposals->fetch($const_diposals_affect->const_disposal_id);
	print '<td colspan="2">'. $const_site_diposals->getNomUrl(1) .'</td></tr>';
	
	print '</table>';
	print '<br>';
	print '<div style="float: right; margin-top: 8px;">';
	print '<a href="./index.php?mid='. $mid .'" class="butAction">'.$langs->trans('Cancel').'</a>';
		print '<a href="./card.php?action=edit&id='. $id .'" class="butAction">'.$langs->trans('Modify').'</a>';
	print '</div>';
}
else {

 // Both test are required to be compatible with all browsers

llxHeader('', $langs->trans('const_diposals_affect'));
print_fiche_titre($langs->trans("ListOfconst_diposals_affect"));


	dol_fiche_head('', 'const_diposals_affect', $langs->trans("ListOfconst_diposals_affect"), 1, '');

	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	print '<input name="id" value="'. $id .'" type="hidden" />';
	print '<table class="noborder" width="100%;">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("ref"),$_SERVER["PHP_SELF"],"ref", '','','align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("designation"), $_SERVER["PHP_SELF"], 'designation', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("product"), $_SERVER["PHP_SELF"], 'product_id', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("qty"),$_SERVER["PHP_SELF"], "qty", '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("price"),$_SERVER["PHP_SELF"], "price", '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("unit_type"), $_SERVER["PHP_SELF"], 'unit_type_id', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("const_site_diposals"), $_SERVER["PHP_SELF"], 'const_disposal_id', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'','','',$sortfield,$sortorder,'maxwidthsearch ');
	print "</tr>\n";

	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';
	// ref
	print '<td class="liste_titre" colspan="1" align="center">';
	print '<input class="flat" type="text" size="14" name="search_ref" value="'.$search_ref.'">';
	print '</td>';
	// designation
	print '<td class="liste_titre" colspan="1" align="center">';
	print '<input class="flat" type="text" size="14" name="search_designation" value="'.$search_designation.'">';
	print '</td>';
	// product
	print '<td class="liste_titre" olspan="1" align="center">';
	print $form->select_produits_list($search_product,'search_product', 0, 30, 0, '', 0, 2);
    print '</td>';
    // qty
	print '<td class="liste_titre" olspan="1" align="center">';
	print '<input class="flat" style="width: 85px"  type="number" min="0" name="search_qty" value="'.$search_qty.'">';
	print '</td>';
	// price
	print '<td class="liste_titre" olspan="1" align="center">';
	print '<input class="flat" style="width: 85px"  type="number" step="0.01" min="0" name="search_price" value="'.$search_price.'">';
	print '</td>';
	// unit_type
	print '<td class="liste_titre" olspan="1" align="center">';
	print $form->selectarray('search_unit_type', $unit_type, $search_unit_type, 1, 0, 0, 'required="required"');
	print '</td>';

	// const_site_diposals
	print '<td class="liste_titre" olspan="1" align="center">';
	print $form->selectarray('search_const_site_diposals', $const_site_diposals->getNames(), $search_const_site_diposals, 1, 0, 0, 'required="required"');
	print '</td>';

	// ACTION
	print '<td align="right" style="min-width:62px;">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';

	print "</tr>\n";

	// Lines
	if (count($const_diposals_affect->rows)) {
		//$createdBy = new User($db);
		foreach($const_diposals_affect->rows as $obj) {
			  $ref 				= $obj->ref ;
			  $designation 			= $obj->designation ;
			  $produit->fetch($obj->product_id) ;
			  $qty 	   		    = $obj->qty ;
			  $price 	   		    = $obj->price ;
			  $unit_type->fetch($obj->unit_type_id) ;
			  $const_site_diposals->fetch($obj->const_disposal_id) ;
			

			print '<tr '.$bc[$var].'>';
			print '<td align="left" style ="white-space: nowrap;">';
				print $const_diposals_affect->getNomUrl(1,  $obj->id, $ref);
			print '</td>';
			 
			print '<td align="center">'. $designation .'</td>';
			print '<td align="center">'. $produit->getNomUrl(1) .'</td>';
			print '<td align="center">'. $qty .'</td>';
			print '<td align="center">'. $price .'</td>';
			print '<td align="center">'. $unit_type->getNomUrl(1) .'</td>';
			print '<td align="center">'. $const_site_diposals->getNomUrl(1) .'</td>';

			print '<td><div style="float: right; margin-top: 8px;">';
			print '<a href="./card.php?action=delete&id='. $obj->id .'" >'.$langs->trans('Delete').'</a>';
			print '</div></td>';
			print '</tr>'."\n";

		}
	} else {
		print '<tr>';
	    print '<td colspan="9" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';
	}

	print '</table>';
	print '</form>';


		print '<br>';
		print '<div style="float: right; margin-top: 8px;">';
		print '<a href="./card.php?action=add" class="butAction">'.$langs->trans('Addconst_diposals_affect').'</a>';
		print '</div>';


}

llxFooter();

$db->close();


?>