<?php 
/* Copyright (C) 2016		Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *   	\file       marches/list.php
 *		\ingroup    list
 *		\brief      Gestion des marches
 */

require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/material/const_site_diposals/class/const_site_diposals.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/material/constraction_site/class/constraction_site.class.php';

// Get parameters
$action  = GETPOST('action', 'alpha');
$id 	 = GETPOST('id', 'int');
$request_method = $_SERVER['REQUEST_METHOD'];

//$langs->load('marches');
// Protection if external user
if ($user->societe_id > 0) accessforbidden();

$now 	= new DateTime('now');
$now       = $now->format('Y-m-d');
$form       = new Form($db);
$error 	= false;

if ($action == 'create' && $request_method === 'POST') {
	$const_site_diposals = new const_site_diposals($db);

    if (!$error) {
        if (isset($_POST['datec_']) && !empty($_POST['datec_'])) {
            list($etd, $etm, $ety) = explode("/", $_POST['datec_']);
            $const_site_diposals->datec         = $ety.'-'.$etm.'-'.$etd ;
        }
          $const_site_diposals->num            = trim(GETPOST('num_'));
          $const_site_diposals->const_site_destin_id     = trim(GETPOST('const_site_destin_id_'));
          $const_site_diposals->const_site_sender_id  = trim(GETPOST('const_site_sender_id_'));
          $const_site_diposals->created_by     = $user->id;
            //if(!$const_site_diposals->check_mat($const_site_diposals->mat)){
                    $const_site_diposalsID = $const_site_diposals->create();
            
                    // If no SQL error we redirect to the request card
                    if ($const_site_diposalsID > 0) {
                        //header('Location: index.php?id='.$getMarcheID);
                        header('Location: index.php');
                        exit;
                    } else {
                        // Otherwise we display the request form with the SQL error message
                        header('Location: card.php?action=request&error=SQL_Create&msg='.$const_site_diposals->error);
                        exit;
                    }
               /* }
            else{
                $msg ='Cette marticule '.$const_site_diposals->mat.' est deja saisée !';
                 header('Location: card.php?action=request&error=SQL_Create&msg='.$msg);
                        exit;
            }*/
    }
}

if ($action == 'update' && $request_method === 'POST') {
    // If no right to modify a request
    /*if (!$user->rights->marches->write) {
        header('Location: ./card.php?action=request&error=CantUpdate');
        exit;
    }*/

    $const_site_diposals_id = (int) GETPOST('const_site_diposals_id', 'int');

    if (!$const_site_diposals_id || $const_site_diposals_id <= 0) {
        header('Location: ./card.php?action=request&error=CantUpdate');
        exit;
    }

    $const_site_diposals = new const_site_diposals($db);
    $const_site_diposals->fetch($const_site_diposals_id);

   // $canedit = ($user->rights->marches->write || $user->rights->marches->write_all);
    $canedit = true ; 


    // If this is the requestor or has read/write rights
    if ($canedit) {
        $datec = '';
        if (isset($_POST['datec_']) && !empty($_POST['datec_'])) {
            list($etd, $etm, $ety) = explode("/", $_POST['datec_']);
            $datec         = $ety.'-'.$etm.'-'.$etd ;
        }
        $data = array(
          'datec'  =>$datec,
          'num'    =>trim(GETPOST('num_')),
          'const_site_destin_id' =>trim(GETPOST('const_site_destin_id_')),
          'const_site_sender_id'  =>trim(GETPOST('const_site_sender_id_'))
        );

		$getconst_site_diposalsID = $const_site_diposals->update($const_site_diposals_id, $data);
        
                if ($getconst_site_diposalsID > 0) {
                    header('Location: ./index.php?id='.$const_site_diposals_id);
                    exit;
                } else {
                    // Otherwise we display the request form with the SQL error message
                    header('Location: ./card.php?id='. $const_site_diposals_id .'&action=edit&error=SQL_Create&msg='.$const_site_diposals->error);
                    exit;
                } 
    }
}

// If delete of request
if ($action == 'confirm_delete' && GETPOST('confirm') == 'yes' ) {
	$error=0;

	//$db->begin();

	$event  = new const_site_diposals($db);
	//$canedit = ($user->rights->marches->write_all || $user->rights->marches->delete);
    $canedit = true;
	// Si l'utilisateur à le droit de lire ce contrat, il peut le supprimer
	if ($canedit) {
        $event->fetch($id);
		$event->delete();
	}
	else {
		$error = $langs->trans('ErrorCantDelete');
	}

	if (!$error) {
		//$db->commit();
		header('Location: index.php');
		exit;
	}
	else {
		
        header('Location: index.php?leftmenu=marches');
        exit;
	}
}

/*
 * View
 */

$form      = new Form($db);
$const_site_diposals     = new const_site_diposals($db);
$constraction_site     = new constraction_site($db);

$morejs  = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.js", "/btp/js/jquery/timepicker/timepicker-fr.js","/btp/js/fuel_consoma.js");
$morecss = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.css");

llxHeader(array(), $langs->trans('const_site_diposals'),'','','','',$morejs,$morecss,0,0);

if (empty($id) || $action == 'add' || $action == 'request' || $action == 'create') {
	// Si l'utilisateur n'a pas le droit de créer un marché
    /*if (empty($user->rights->marches->write) || empty($user->rights->marches->write_all)) {
        $errors[]=$langs->trans('CantCreate');
    }
    else {*/
        // Formulaire appel d'offre
        print_fiche_titre($langs->trans('Addconst_site_diposals'));

        // Si il y a une erreur
        if (GETPOST('error')) {
            switch(GETPOST('error')) {
                case 'nobudget' :
                    $errors[] = $langs->trans('errorNoBudget');
                    break;
                case 'SQL_Create' :
                    $errors[] = $langs->trans('ErrorSQLCreateCP').' <b>'.htmlentities($_GET['msg']).'</b>';
                    break;
                case 'CantCreate' :
                    $errors[] = $langs->trans('CantCreateCP');
                    break;
                case 'nouser' :
                    $errors[] = $langs->trans('errorNoUser');
                    break;
                case 'nodatedebut' :
                    $errors[] = $langs->trans('NoDateDebut');
                    break;
                case 'nobank' :
                    $errors[] = $langs->trans('errorNoBank');
                    break;
                case 'noqc' :
                    $errors[] = $langs->trans('errorNoQc');
                    break;
                case 'alreadyExists' :
                    $errors[] = $langs->trans('alreadyExistAO');
                    break;
                case 'noref' :
                    $errors[] = $langs->trans('errorNoRef');
                    break;
            }

	        setEventMessage($errors, 'errors');
        }

        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">'."\n";
        print '<input type="hidden" name="action" value="create" />'."\n";

        print '<table class="border" width="100%">';
        print '<tbody>';



       //date
        print '<tr><td class="fieldrequired">'.$langs->trans("datec").'</td><td>';
        print '<input type="text" class="datepicker" autocomplete="off"  name="datec_" required="required" readonly="readonly" /> ';
        print '</td></tr>';

        //Numéro
        print '<tr><td class="fieldrequired">'.$langs->trans("num").'</td><td>';
        print '<input type="text" value="" name="num_" required="required" />';
        print '</td></tr>';
        
        //Engin 
        print '<tr><td>'.$langs->trans("const_site_destin").'</td><td>'; 
        $const_sites = $constraction_site->getNames();
        print $form->selectarray('const_site_destin_id_', $const_sites,(GETPOST('const_site_destin_id_') ? GETPOST('const_site_destin_id_') : null), 0, 0, 0, 'required="required"');
        print '</td></tr>';

        //Chantier 
        print '<tr><td>'.$langs->trans("const_site_sender").'</td><td>'; 
        $const_sites = $constraction_site->getNames();
        print $form->selectarray('const_site_sender_id_', $const_sites,(GETPOST('const_site_sender_id_') ? GETPOST('const_site_sender_id_') : null), 0, 0, 0, 'required="required"');
        print '</td></tr>';

        print '</tbody>';
        print '</table>';

        print '<div class="center">';
        print '<input type="submit" value="'. $langs->trans("Createconst_site_diposals") .'" name="bouton" class="butAction">';
        print '&nbsp; &nbsp; ';
        print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
        print '</div>';
        print '</form>';
    //}
}
else {
    if ($error) {
        print '<div class="tabBar">';
        print $error;
        print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
        print '</div>';
    }
    else {
        // Affichage de la fiche d'une demande de congés payés

        if ($id > 0) {
            $const_site_diposals->fetch($id);

			//$canedit = ($user->rights->marches->delete || $user->rights->marches->write_all);

            // Si il y a une erreur
            if (GETPOST('error')) {
                switch(GETPOST('error')) {
                    case 'datefin' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorEndDateCP');
                        break;
                    case 'SQL_Create' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorSQLCreateCP').' '.$_GET['msg'];
                        break;
                    case 'CantCreate' :
                        $errors[] = $langs->transnoentitiesnoconv('CantCreateCP');
                        break;
                    case 'Valideur' :
                        $errors[] = $langs->transnoentitiesnoconv('InvalidValidatorCP');
                        break;
                    case 'nodatedebut' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateDebut');
                        break;
                    case 'nodatefin' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateFin');
                        break;
                    case 'DureeHoliday' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorDureeCP');
                        break;
                    case 'NoMotifRefuse' :
                        $errors[] = $langs->transnoentitiesnoconv('NoMotifRefuseCP');
                        break;
                    case 'mail' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorMailNotSend')."\n".$_GET['error_content'];
                        break;
                }

	            setEventMessage($errors, 'errors');
            }

            // On vérifie si l'utilisateur à le droit de lire cette demande
           // if ($canedit) {
                if ($action == 'delete') {
                    $const_site_diposals->fetch($id);
     print_fiche_titre($langs->trans("const_site_diposals"));


    print '<table class="border" width="100%">';
    // num
    print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("num").'</td>';
    print '<td colspan="2">'. $const_site_diposals->num .'</td></tr>';
    // date
    print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("datec").'</td>';
    print '<td colspan="2">'. dol_print_date($const_site_diposals->datec,'day') .'</td></tr>';
    // chantier destinataire
    print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("const_site_destin").'</td>';
    $constraction_site->fetch($const_site_diposals->const_site_destin_id);
    print '<td colspan="2">'. $constraction_site->getNomUrl(1) .'</td></tr>';
    //chantier émeteur
    print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("const_site_sender").'</td>';
    $constraction_site->fetch($const_site_diposals->const_site_sender_id);
    print '<td colspan="2">'. $constraction_site->getNomUrl(1) .'</td></tr>';
    
    print '</table>';
                        print $form->formconfirm("card.php?id=".$id, $langs->trans("TitleDelete"),$langs->trans("ConfirmDelete"),"confirm_delete", '', 0, 1);
                }

                // Si annulation de la demande
                if ($action == 'cancel') {
                    print $form->formconfirm("card.php?id=".$id, $langs->trans("TitleCancelSC"), $langs->trans("ConfirmCancelSC"),"confirm_cancel", '', 1, 1);
                }

                dol_fiche_head('', 'const_site_diposalss', $langs->trans("const_site_diposals"), 0, '');

                if ($action == 'edit') {
                    $edit = true;
                    print '<form method="post" action="'.$_SERVER['PHP_SELF'].'?id='.$id.'">'."\n";
                    print '<input type="hidden" name="action" value="update" />'."\n";
                    print '<input type="hidden" name="const_site_diposals_id" value="'.$id.'" />'."\n";

                    print '<table class="border" width="100%">';
                    print '<tbody>';



        //date
        print '<tr><td class="fieldrequired">'.$langs->trans("datec").'</td><td>';
        print '<input type="text" value="'.dol_print_date($const_site_diposals->datec,'day').'" class="datepicker" autocomplete="off"  name="datec_" required="required" readonly="readonly" /> ';
        print '</td></tr>';


        //Numéro
        print '<tr><td class="fieldrequired">'.$langs->trans("num").'</td><td>';
        print '<input type="text" value="'.$const_site_diposals->num.'" name="num_" required="required" />';
        print '</td></tr>';

        //Engin 
        print '<tr><td>'.$langs->trans("const_site_destin").'</td><td>'; 
        $const_sites = $constraction_site->getNames();
        print $form->selectarray('const_site_destin_id_', $const_sites,(GETPOST('const_site_destin_id_') ? GETPOST('const_site_destin_id_') : $const_site_diposals->const_site_destin_id), 0, 0, 0, 'required="required"');
        print '</td></tr>';


        //Chantier 
        print '<tr><td>'.$langs->trans("const_site_sender").'</td><td>'; 
        $const_sites = $constraction_site->getNames();
        print $form->selectarray('const_site_sender_id_', $const_sites,(GETPOST('const_site_sender_id_') ? GETPOST('const_site_sender_id_') : $const_site_diposals->const_site_sender_id), 0, 0, 0, 'required="required"');
        print '</td></tr>';



                    print '</tbody>';
                    print '</table>';

                    print '<div class="center">';
                    print '<input type="submit" value="'. $langs->trans("Modify") .'" name="bouton" class="butAction">';
                    print '&nbsp; &nbsp; ';
                    print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
                    print '</div>';
                    print '</table>';
                }

                dol_fiche_end();

                if (!$edit) {
		            print '<div class="tabsAction">';

                    // Boutons d'actions
                    //if ($canedit) {
                        print '<a href="card.php?id='.$_GET['id'].'&action=edit" class="butAction">'.$langs->trans("Modify").'</a>';
                    //}

                    // If draft
                   // if ($user->rights->marches->delete)	{
                    	print '<a href="card.php?id='.$_GET['id'].'&action=delete" class="butActionDelete">'.$langs->trans("Delete").'</a>';
                   // }

                    print '</div>';
                }

        } else {
                
                print '<div class="tabBar">';
                print $langs->trans('ErrorUserViewSC');
                print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
                print '</div>';
            }

        /*} else {
            print '<div class="tabBar">';
            print $langs->trans('ErrorIDFicheSC');
            print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
            print '</div>';
        }*/

    }

}

// End of page
llxFooter();

if (is_object($db)) $db->close();

?>