<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file       appeloffres/index.php
 * \ingroup    list
 * \brief      List of markets
 */
require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/btp/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/material/consumptions_supplies/class/consumptions_supplies.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/material/constraction_site/class/constraction_site.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/settings/unit_type/class/UnitType.class.php';
include_once DOL_DOCUMENT_ROOT.'/product/class/product.class.php';

$form 		= new FormChild($db);
$consumptions_supplies   = new consumptions_supplies($db);
$constraction_site   = new constraction_site($db);
$unit_type   = new UnitType($db);
$produit   = new product($db);
$var = false;
$filter = '';
$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
if (! $sortfield) $sortfield = "rowid";
if (! $sortorder) $sortorder = "DESC";
$id 	  = GETPOST('id','int');
$search_num      		= GETPOST('search_num');
$search_datec      		= "";
if (GETPOST('search_datec') !=="") {
    list($etd, $etm, $ety) = explode("/", GETPOST('search_datec'));
    $search_datec         = $ety.'-'.$etm.'-'.$etd ;
}
$search_product    		= GETPOST('search_product');
$search_qty    		= GETPOST('search_qty');
$search_unit_type    		= GETPOST('search_unit_type');
$search_const_site    		= GETPOST('search_const_site');
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
$search_num      		= '';
$search_datec      		= '';
$search_product    		= '';
$search_qty    		= '';
$search_const_site    		= '';
}
$filter .= (!empty($search_datec) && $search_datec != -1) ? " AND datec = '". $db->escape($search_datec)."'\n" : "";
$filter .= (!empty($search_num) && $search_num != -1) ? " AND num = ".$db->escape($search_num):"";
$filter .= (!empty($search_product) && $search_product != -1) ? " AND product_id= ".$db->escape($search_product): "";
$filter .= (!empty($search_qty) && $search_qty != -1) ? " AND qty= ".$db->escape($search_qty): "";
$filter .= (!empty($search_unit_type) && $search_unit_type != -1) ? " AND unit_type_id = ".$db->escape($search_unit_type): "";
$filter .= (!empty($search_const_site) && $search_const_site != -1) ? " AND const_site_id = ".$db->escape($search_const_site): "";


$getconsumptions_suppliess = $consumptions_supplies->fetchAll($sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter);

// Si erreur SQL
if ($getconsumptions_suppliess == '-1') {
    print_fiche_titre($langs->trans('ListOfconsumptions_supplies'), '', 'title_project.png');

    dol_print_error($db, $langs->trans('Error').' '.$consumptions_supplies->error);
    exit();
}
if ($id > 0) {
	$consumptions_supplies->fetch($id);
	llxHeader('', $langs->trans('consumptions_supplies'));
	print_fiche_titre($langs->trans("consumptions_supplies"));


	print '<table class="border" width="100%">';
	// num
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("num").'</td>';
	print '<td colspan="2">'. $consumptions_supplies->num .'</td></tr>';
	// date
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("datec").'</td>';
	print '<td colspan="2">'. dol_print_date($consumptions_supplies->datec,'day') .'</td></tr>';
	// quantité
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("qty").'</td>';
	print '<td colspan="2">'. $consumptions_supplies->qty .'</td></tr>';
	// lubricant
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("product").'</td>';
	$produit->fetch($consumptions_supplies->product_id);
	print '<td colspan="2">'. $produit->getNomUrl(1) .'</td></tr>';
	// unité
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("unit_type").'</td>';
	$unit_type->fetch($consumptions_supplies->unit_type_id);
	print '<td colspan="2">'. $unit_type->getNomUrl(1) .'</td></tr>';
	//chantier
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("constraction_site").'</td>';
	$constraction_site->fetch($consumptions_supplies->const_site_id);
	print '<td colspan="2">'. $constraction_site->getNomUrl(1) .'</td></tr>';
	
	print '</table>';
	print '<br>';
	print '<div style="float: right; margin-top: 8px;">';
	print '<a href="./index.php?mid='. $mid .'" class="butAction">'.$langs->trans('Cancel').'</a>';
		print '<a href="./card.php?action=edit&id='. $id .'" class="butAction">'.$langs->trans('Modify').'</a>';
	print '</div>';
}
else {

 // Both test are required to be compatible with all browsers
$morejs  = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.js", "/btp/js/jquery/timepicker/timepicker-fr.js","/btp/js/fuel_consoma.js");
$morecss = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.css");

llxHeader('', $langs->trans('consumptions_supplies'),'','','','',$morejs,$morecss,0,0);
print_fiche_titre($langs->trans("ListOfconsumptions_supplies"));


	dol_fiche_head('', 'consumptions_supplies', $langs->trans("ListOfconsumptions_supplies"), 1, '');

	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	print '<input name="id" value="'. $id .'" type="hidden" />';
	print '<table class="noborder" width="100%;">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("num"),$_SERVER["PHP_SELF"],"num", '','','align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("datec"), $_SERVER["PHP_SELF"], 'datec', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("product"), $_SERVER["PHP_SELF"], 'product_id', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("qty"),$_SERVER["PHP_SELF"], "qty", '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("unit_type"), $_SERVER["PHP_SELF"], 'unit_type_id', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("constraction_site"), $_SERVER["PHP_SELF"], 'const_site_id', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'','','',$sortfield,$sortorder,'maxwidthsearch ');
	print "</tr>\n";

	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';
	// num
	print '<td class="liste_titre" olspan="1" align="center">';
	print '<input class="flat" style="width: 85px"  type="number" min="0" name="search_num" value="'.$search_num.'">';
	print '</td>';
	//datec
	print '<td class="liste_titre" olspan="1" align="center">';
    print '<input type="text" value="'.dol_print_date($search_datec,'day').'" class="datepicker" autocomplete="off"  name="search_datec"  readonly="readonly" /> ';
    print '</td>';
	// product
	print '<td class="liste_titre" olspan="1" align="center">';
	print $form->select_produits_list($search_product,'search_product', 0, 30, 0, '', 0, 2);
    print '</td>';
    // qty
	print '<td class="liste_titre" olspan="1" align="center">';
	print '<input class="flat" style="width: 85px"  type="number" min="0" name="search_qty" value="'.$search_qty.'">';
	print '</td>';
	// unit_type
	print '<td class="liste_titre" olspan="1" align="center">';
	print $form->selectarray('search_unit_type', $unit_type->getNames(), $search_unit_type, 1, 0, 0, 'required="required"');
	print '</td>';
	// const_site
	print '<td class="liste_titre" olspan="1" align="center">';
	print $form->selectarray('search_const_site', $constraction_site->getNames(), $search_const_site, 1, 0, 0, 'required="required"');
	print '</td>';

	// ACTION
	print '<td align="right" style="min-width:62px;">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';

	print "</tr>\n";

	// Lines
	if (count($consumptions_supplies->rows)) {
		//$createdBy = new User($db);
		foreach($consumptions_supplies->rows as $obj) {
			  $num 				= $obj->num ;
			  $datec 			= dol_print_date($obj->datec,'day') ;
			  $produit->fetch($obj->product_id) ;
			  $qty 	   		    = $obj->qty ;
			  $unit_type->fetch($obj->unit_type_id) ;
			  $constraction_site->fetch($obj->const_site_id) ;
			

			print '<tr '.$bc[$var].'>';
			print '<td align="left" style ="white-space: nowrap;">';
				print $consumptions_supplies->getNomUrl(1,  $obj->id, $num);
			print '</td>';
			 
			print '<td align="center">'. $datec .'</td>';
			print '<td align="center">'. $produit->getNomUrl(1) .'</td>';
			print '<td align="center">'. $qty .'</td>';
			print '<td align="center">'. $unit_type->getNomUrl(1) .'</td>';
			print '<td align="center">'. $constraction_site->getNomUrl(1) .'</td>';

			print '<td><div style="float: right; margin-top: 8px;">';
			print '<a href="./card.php?action=delete&id='. $obj->id .'" >'.$langs->trans('Delete').'</a>';
			print '</div></td>';
			print '</tr>'."\n";

		}
	} else {
		print '<tr>';
	    print '<td colspan="9" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';
	}

	print '</table>';
	print '</form>';


		print '<br>';
		print '<div style="float: right; margin-top: 8px;">';
		print '<a href="./card.php?action=add" class="butAction">'.$langs->trans('Addconsumptions_supplies').'</a>';
		print '</div>';


}

llxFooter();

$db->close();


?>
