<?php 
/* Copyright (C) 2016		Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *   	\file       marches/list.php
 *		\ingroup    list
 *		\brief      Gestion des marches
 */
require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/btp/material/defects/class/Defects.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/material/defect_machine/class/defect_machine.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/machine.lib.php';
require_once DOL_DOCUMENT_ROOT.'/btp/material/machine/class/machine.class.php';


$defect_machine       = new defect_machine($db);
$machine       = new machine($db);
// Get parameters
$myparam = GETPOST("myparam");
$action  = GETPOST('action', 'alpha');
$id 	 = GETPOST('id', 'int');
$did      = GETPOST('did','int');
$request_method = $_SERVER['REQUEST_METHOD'];
$langs->load('btp');
// Protection if external user
if ($user->societe_id > 0) accessforbidden();
$now 	= new DateTime('now');
$error 	= false;
if ($action == 'update' && $request_method === 'POST') {
    $defect_id = (int) GETPOST('defect_id', 'int');
    if (!$defect_id || $defect_id <= 0) {
        header('Location: ./card.php?action=request&error=CantUpdate');
        exit;
    }
    $defect = new Defects($db);
    $defect->fetch($defect_id);
    $canedit = true ; 
    $name  = trim(GETPOST('name'));
      if ($canedit) {
        $name   = trim(GETPOST('name'));
		// Update
        $data = array(
            'name'             => $name,

        );
          if(empty($name)){
             header('Location: ./card.php?id='. $defect_id .'&action=edit&error=SQL_Create&msg="Veuillez renseigner tout les champs"');
           exit;
          }
        $getMarcheID = $defect->update($defect_id, $data);
 
        if ($getMarcheID > 0) {
        header('Location: ./index.php?id='.$defect_id.'&did='.$did);
            exit;
        } else {
            // Otherwise we display the request form with the SQL error message
            header('Location: ./card.php?id='. $defect_id .'&action=edit&error=SQL_Create&msg="Veuillez renseigner tout les champs"');
            exit;
        }
    }
}
// If delete of request
if ($action == 'confirm_delete' && GETPOST('confirm') == 'yes' ) {
	$error=0;
	$defect  = new Defects($db);
	 $canedit = true;
	if ($canedit) {
        $defect->fetch($id);
		$defect->delete();
	}
	else {
		$error = $langs->trans('ErrorCantDelete');
	}
	if (!$error) {
		//$db->commit();
		header('Location: index.php?did='.$did);
		exit;
	}
	else {
		
        header('Location: index.php?leftmenu=marches');
        exit;
	}
}
/*
 * View
 */
$form           = new Form($db);
$defect     = new Defects($db);



llxHeader(array(), $langs->trans('listevents'),'','','','',$morejs,$morecss,0,0);
print_fiche_titre($langs->trans("defects"));
$defect_machine->fetch($did);
$machine->fetch($defect_machine->machine_id);
    $head       = material_prepare_head($machine);
    dol_fiche_head($head, 'defect_machine', $langs->trans('defect_machine'), 0, '');
    $defects  = defect_prepare_head($defect_machine);
    dol_fiche_head($defects, 'defects', $langs->trans("defects"), 0, '');
///////////////////////////insertion d'un lrh
if ($action == 'create' && $request_method === 'POST') {
    $defect = new Defects($db);
    $name     = GETPOST('name');
     // Vars
    $defect->name         = trim(GETPOST('name'));
    $defect->created_by   = $user->id;
                   if(empty($name)){
  header('Location: card.php?action=request&error=SQL_Create&msg="Veuillez renseigner tout les champs"');
exit;
                   }
     $getMarcheID = $defect->create();
 if ($getMarcheID > 0) {
            //header('Location: index.php?id='.$getMarcheID);
              echo '<script language="Javascript">

document.location.replace("index.php?did='.$did.'");
</script>'; 
            exit;
        } else {
            // Otherwise we display the request form with the SQL error message
  header('Location: card.php?action=request&error=SQL_Create&msg="ce jour est déja pointé"');
   exit(); 
        }
}








if (empty($id) || $action == 'add' || $action == 'request' || $action == 'create') {
        // Formulaire
        print_fiche_titre($langs->trans('ajoutdefect'));
        // Si il y a une erreur
        if (GETPOST('error')) {
            switch(GETPOST('error')) {
                case 'nobudget' :
                    $errors[] = $langs->trans('errorNoBudget');
                    break;
                case 'SQL_Create' :
                    $errors[] = $langs->trans('ErrorSQLCreateCP').' <b>'.htmlentities($_GET['msg']).'</b>';
                    break;
                case 'CantCreate' :
                    $errors[] = $langs->trans('CantCreateCP');
                    break;
                case 'nouser' :
                    $errors[] = $langs->trans('errorNoUser');
                    break;
                case 'nodatedebut' :
                    $errors[] = $langs->trans('NoDateDebut');
                    break;
                case 'nobank' :
                    $errors[] = $langs->trans('errorNoBank');
                    break;
                case 'noqc' :
                    $errors[] = $langs->trans('errorNoQc');
                    break;
                case 'alreadyExists' :
                    $errors[] = $langs->trans('alreadyExistAO');
                    break;
                case 'noref' :
                    $errors[] = $langs->trans('errorNoRef');
                    break;
            }
	        setEventMessage($errors, 'errors');
        }

        print '<form method="POST" action="'.$_SERVER['PHP_SELF'].'?did='.$did.'">'."\n";
        print '<input type="hidden" name="action" value="create" />'."\n";
        print '<table class="border" width="100%">';
        print '<tbody>';
        // Name
        print '<tr><td class="fieldrequired">'.$langs->trans("Name").'</td><td class="fieldrequired">';
        print '<input type=text name="name" required="required">';
        print '</td></tr>';
        print '</tbody>';
        print '</table>';
        print '<div class="center">';
    print '<input type="submit" value="'. $langs->trans("createdefect") .'" name="bouton" class="butAction">';
        print '&nbsp; &nbsp; ';
        print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
        print '</div>';
        print '</form>';
}
else {
    if ($error) {
        print '<div class="tabBar">';
        print $error;
        print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
        print '</div>';
    }
    else {
        // Affichage 
        if ($id > 0) {
            $defect->fetch($id);
            // Si il y a une erreur
            if (GETPOST('error')) {
                switch(GETPOST('error')) {
                    case 'datefin' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorEndDateCP');
                        break;
                    case 'SQL_Create' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorSQLCreateCP').' '.$_GET['msg'];
                        break;
                    case 'CantCreate' :
                        $errors[] = $langs->transnoentitiesnoconv('CantCreateCP');
                        break;
                    case 'Valideur' :
                        $errors[] = $langs->transnoentitiesnoconv('InvalidValidatorCP');
                        break;
                    case 'nodatedebut' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateDebut');
                        break;
                    case 'nodatefin' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateFin');
                        break;
                    case 'DureeHoliday' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorDureeCP');
                        break;
                    case 'NoMotifRefuse' :
                        $errors[] = $langs->transnoentitiesnoconv('NoMotifRefuseCP');
                        break;
                    case 'mail' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorMailNotSend')."\n".$_GET['error_content'];
                        break;
                }
	            setEventMessage($errors, 'errors');
            }

            // On vérifie si l'utilisateur à le droit de lire cette demande
           // if ($canedit) {
               

                // Si annulation de la demande
                if ($action == 'cancel') {
                    print $form->formconfirm("card.php?id=".$id, $langs->trans("TitleCancelSC"), $langs->trans("ConfirmCancelSC"),"confirm_cancel", '', 1, 1);
                }
                if ($action == 'edit') {
                    $edit = true;
                    $id=$_GET['id'];

                

                    print '<form method="post" action="'.$_SERVER['PHP_SELF'].'?id='.$id.'&did='.$did.'">'."\n";
                    print '<input type="hidden" name="action" value="update" />'."\n";
                    print '<input type="hidden" id="h" name="defect_id" value='.$id.' />'."\n";
                    print '<table class="border" width="100%">';
                    print '<tbody>';
                    // Name
                    print '<tr><td class="fieldrequired">'.$langs->trans("Name").'</td><td>';
                    print '<input name="name" required="required" type=text value="'.$defect->name.'"</td></tr>';
                    print '</tbody>';
                    print '</table>';
                    print '<div class="center">';
                    print '<input type="submit" value="'. $langs->trans("Modify") .'" name="bouton" class="butAction">';
                    print '&nbsp; &nbsp; ';
                    print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
                    print '</div>';
                    print '</table>';
                }
                dol_fiche_end();
                if (!$edit) {
		            print '<div class="tabsAction">';
                    // Boutons d'actions
                        print '<a href="card.php?id='.$_GET['id'].'&action=edit" class="butAction">'.$langs->trans("Modify").'</a>';
                    // If draft
                   	print '<a href="card.php?id='.$_GET['id'].'&action=delete" class="butActionDelete">'.$langs->trans("Delete").'</a>';
                    print '</div>';
                }

        } else {
                
                print '<div class="tabBar">';
                print $langs->trans('ErrorUserViewSC');
                print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
                print '</div>';
            }
    }

}
//confirmation de suppression
if ($action == 'confirm_delete' && GETPOST('confirm') == 'yes' ) {
    $error=0;
   $defect  = new Defects($db);
    $canedit = true;
    if ($canedit) {
        $defect->fetch($id);
        $defect->delete();
    }
    else {
        $error = $langs->trans('ErrorCantDelete');
    }
    if (!$error) {
        //$db->commit();
        header('Location: index.php');
        exit;
    }
    else {
        
        header('Location: index.php?leftmenu=pointage');
        exit;
    }
}
// End of page
llxFooter();llxFooter();

$db->close();


?>
