<?php 
/* Copyright (C) 2016		Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *   	\file       marches/list.php
 *		\ingroup    list
 *		\brief      Gestion des marches
 */

require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/material/intervention/class/intervention.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/material/machine/class/machine.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/material/defect_machine/class/defect_machine.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/machine.lib.php';
// Get parameters
 $action  = GETPOST('action', 'alpha');
$id 	 = GETPOST('id', 'int');
$mid      = GETPOST('mid', 'int');
$request_method = $_SERVER['REQUEST_METHOD'];

//$langs->load('marches');
// Protection if external user
if ($user->societe_id > 0) accessforbidden();

$now 	= new DateTime('now');
$now       = $now->format('Y-m-d');
$form       = new Form($db);
$error 	= false;

if ($action == 'create' && $request_method === 'POST') {
	$intervention = new intervention($db);

    if (!$error) {
        if (isset($_POST['date_start_']) && !empty($_POST['date_start_'])) {
            list($etd, $etm, $ety) = explode("/", $_POST['date_start_']);
            $intervention->date_start         = $ety.'-'.$etm.'-'.$etd ;
        }
        if (isset($_POST['date_end_']) && !empty($_POST['date_end_'])) {
            list($etd, $etm, $ety) = explode("/", $_POST['date_end_']);
            $intervention->date_end         = $ety.'-'.$etm.'-'.$etd ;
        }
          $intervention->spare_parts            = trim(GETPOST('spare_parts_'));
          $intervention->cause_failure            = trim(GETPOST('cause_failure_'));
          $intervention->machine_id            = (int)$mid;
          $intervention->machine_status     = trim(GETPOST('machine_status_'));
          $intervention->description     = trim(GETPOST('description_'));
          $intervention->defect_machine_id  = trim(GETPOST('defect_machine_id_'));
          $intervention->created_by     = $user->id;
            //if(!$intervention->check_mat($intervention->mat)){
                    $interventionID = $intervention->create();
            
                    // If no SQL error we redirect to the request card
                    if ($interventionID > 0) {
                        //header('Location: index.php?id='.$getMarcheID);
                        header('Location: index.php?mid='.$mid);
                        exit;
                    } else {
                        // Otherwise we display the request form with the SQL error message
                        header('Location: card.php?action=request&error=SQL_Create&msg='.$intervention->error);
                        exit;
                    }
               /* }
            else{
                $msg ='Cette marticule '.$intervention->mat.' est deja saisée !';
                 header('Location: card.php?action=request&error=SQL_Create&msg='.$msg);
                        exit;
            }*/
    }
}

if ($action == 'update' && $request_method === 'POST') {
    // If no right to modify a request
    /*if (!$user->rights->marches->write) {
        header('Location: ./card.php?action=request&error=CantUpdate');
        exit;
    }*/

    $intervention_id = (int) GETPOST('intervention_id', 'int');

    if (!$intervention_id || $intervention_id <= 0) {
        header('Location: ./card.php?action=request&error=CantUpdate');
        exit;
    }

    $intervention = new intervention($db);
    $intervention->fetch($intervention_id);

   // $canedit = ($user->rights->marches->write || $user->rights->marches->write_all);
    $canedit = true ; 


    // If this is the requestor or has read/write rights
    if ($canedit) {
        $date_start = '';
        if (isset($_POST['date_start_']) && !empty($_POST['date_start_'])) {
            list($etd, $etm, $ety) = explode("/", $_POST['date_start_']);
            $date_start         = $ety.'-'.$etm.'-'.$etd ;
        }
        if (isset($_POST['date_end_']) && !empty($_POST['date_end_'])) {
            list($etd, $etm, $ety) = explode("/", $_POST['date_end_']);
            $date_end         = $ety.'-'.$etm.'-'.$etd ;
        }
        $data = array(
          'date_start'  =>$date_start,
          'spare_parts'    =>trim(GETPOST('spare_parts_')),
          'cause_failure'    =>trim(GETPOST('cause_failure_')),
          'date_end'    =>$date_end,
          'machine_id'    =>(int)$mid,
          'machine_status' =>trim(GETPOST('machine_status_')),
          'description' =>trim(GETPOST('description_')),
          'defect_machine_id'  =>trim(GETPOST('defect_machine_id_'))
        );

		$getinterventionID = $intervention->update($intervention_id, $data);
        
                if ($getinterventionID > 0) {
                    header('Location: ./index.php?id='.$intervention_id.'&mid='.$mid);
                    exit;
                } else {
                    // Otherwise we display the request form with the SQL error message
                    header('Location: ./card.php?id='. $intervention_id .'&action=edit&error=SQL_Create&msg='.$intervention->error);
                    exit;
                } 
    }
}

// If delete of request
if ($action == 'confirm_delete' && GETPOST('confirm') == 'yes' ) {
	$error=0;

	//$db->begin();

	$event  = new intervention($db);
	//$canedit = ($user->rights->marches->write_all || $user->rights->marches->delete);
    $canedit = true;
	// Si l'utilisateur à le droit de lire ce contrat, il peut le supprimer
	if ($canedit) {
        $event->fetch($id);
		$event->delete();
	}
	else {
		$error = $langs->trans('ErrorCantDelete');
	}

	if (!$error) {
		//$db->commit();
		header('Location: index.php?mid='.$mid);
		exit;
	}
	else {
		
        header('Location: index.php?leftmenu=marches');
        exit;
	}
}

/*
 * View
 */

$form      = new Form($db);
$intervention     = new intervention($db);
$machine     = new machine($db);
$defect_machine     = new defect_machine($db);
$morejs  = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.js", "/btp/js/jquery/timepicker/timepicker-fr.js","/btp/js/fuel_consoma.js");
$morecss = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.css");

llxHeader(array(), $langs->trans('intervention'),'','','','',$morejs,$morecss,0,0);
$machine->fetch($mid);
        $head = material_prepare_head($machine);
        dol_fiche_head($head, 'intervention', $langs->trans('intervention'), 0, '');
        $html .= '<table class="border" width="100%">';
        $html .= '<tr><td width="25%">'.$langs->trans("code").'</td>';
        $html .= '<td colspan="2">'. $machine->code .'</td></tr>';
        $html .= '<tr><td width="25%">'.$langs->trans("regigster_num").'</td>';
        $html .= '<td colspan="2">'. $machine->regigster_num .'</td></tr>';
    $html .= '</table><br />';
    echo $html;

if (empty($id) || $action == 'add' || $action == 'request' || $action == 'create') {
	// Si l'utilisateur n'a pas le droit de créer un marché
    /*if (empty($user->rights->marches->write) || empty($user->rights->marches->write_all)) {
        $errors[]=$langs->trans('CantCreate');
    }
    else {*/
        // Formulaire appel d'offre
        print_fiche_titre($langs->trans('Addintervention'));

        // Si il y a une erreur
        if (GETPOST('error')) {
            switch(GETPOST('error')) {
                case 'nobudget' :
                    $errors[] = $langs->trans('errorNoBudget');
                    break;
                case 'SQL_Create' :
                    $errors[] = $langs->trans('ErrorSQLCreateCP').' <b>'.htmlentities($_GET['msg']).'</b>';
                    break;
                case 'CantCreate' :
                    $errors[] = $langs->trans('CantCreateCP');
                    break;
                case 'nouser' :
                    $errors[] = $langs->trans('errorNoUser');
                    break;
                case 'nodatedebut' :
                    $errors[] = $langs->trans('NoDateDebut');
                    break;
                case 'nobank' :
                    $errors[] = $langs->trans('errorNoBank');
                    break;
                case 'noqc' :
                    $errors[] = $langs->trans('errorNoQc');
                    break;
                case 'alreadyExists' :
                    $errors[] = $langs->trans('alreadyExistAO');
                    break;
                case 'noref' :
                    $errors[] = $langs->trans('errorNoRef');
                    break;
            }

	        setEventMessage($errors, 'errors');
        }

        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'?mid='.$mid.'">'."\n";
        print '<input type="hidden" name="action" value="create" />'."\n";

        print '<table class="border" width="100%">';
        print '<tbody>';

        //engin
        /*print '<tr><td class="fieldrequired">'.$langs->trans("machine").'</td><td>';
         $machines = $machine->getMats();
        print $form->selectarray('machine_id_', $machines,(GETPOST('machine_id_') ? GETPOST('machine_id_') : null), 0, 0, 0, 'required="required"');
        print '</td></tr>';*/

       //date start
        print '<tr><td class="fieldrequired">'.$langs->trans("date_start").'</td><td>';
        print '<input type="text" class="datepicker" autocomplete="off"  name="date_start_" required="required" readonly="readonly" /> ';
        print '</td></tr>';

        //date start
        print '<tr><td class="fieldrequired">'.$langs->trans("date_end").'</td><td>';
        print '<input type="text" class="datepicker" autocomplete="off"  name="date_end_" required="required" readonly="readonly" /> ';
        print '</td></tr>';

        //spare_parts
        print '<tr><td class="fieldrequired">'.$langs->trans("spare_parts").'</td><td>';
        print '<input type="text" value="" name="spare_parts_" required="required" />';
        print '</td></tr>';

        //cause_failure
        print '<tr><td class="fieldrequired">'.$langs->trans("cause_failure").'</td><td>';
        print '<input type="text" value="" name="cause_failure_" required="required" />';
        print '</td></tr>';

        //description
        print '<tr><td class="fieldrequired">'.$langs->trans("description").'</td><td>';
        print '<input type="text" value="" name="description_" required="required" />';
        print '</td></tr>';

        
        //chantier 
        print '<tr><td>'.$langs->trans("machine_status").'</td><td>'; 
        print '<input type="text" value="" name="machine_status_" required="required" />';
        print '</td></tr>';

        //$defect_machine 
        print '<tr><td>'.$langs->trans("claim_defect_engine").'</td><td>'; 
        print $form->selectarray('defect_machine_id_', $defect_machine->getNames(),(GETPOST('defect_machine_id_') ? GETPOST('defect_machine_id_') : null), 0, 0, 0, 'required="required"');
        print '</td></tr>';

        print '</tbody>';
        print '</table>';

        print '<div class="center">';
        print '<input type="submit" value="'. $langs->trans("Createintervention") .'" name="bouton" class="butAction">';
        print '&nbsp; &nbsp; ';
        print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
        print '</div>';
        print '</form>';
    //}
}
else {
    if ($error) {
        print '<div class="tabBar">';
        print $error;
        print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
        print '</div>';
    }
    else {
        // Affichage de la fiche d'une demande de congés payés

        if ($id > 0) {
            $intervention->fetch($id);

			//$canedit = ($user->rights->marches->delete || $user->rights->marches->write_all);

            // Si il y a une erreur
            if (GETPOST('error')) {
                switch(GETPOST('error')) {
                    case 'datefin' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorEnddate_startP');
                        break;
                    case 'SQL_Create' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorSQLCreateCP').' '.$_GET['msg'];
                        break;
                    case 'CantCreate' :
                        $errors[] = $langs->transnoentitiesnoconv('CantCreateCP');
                        break;
                    case 'Valideur' :
                        $errors[] = $langs->transnoentitiesnoconv('InvalidValidatorCP');
                        break;
                    case 'nodatedebut' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateDebut');
                        break;
                    case 'nodatefin' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateFin');
                        break;
                    case 'DureeHoliday' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorDureeCP');
                        break;
                    case 'NoMotifRefuse' :
                        $errors[] = $langs->transnoentitiesnoconv('NoMotifRefuseCP');
                        break;
                    case 'mail' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorMailNotSend')."\n".$_GET['error_content'];
                        break;
                }

	            setEventMessage($errors, 'errors');
            }

            // On vérifie si l'utilisateur à le droit de lire cette demande
           // if ($canedit) {

                // Si annulation de la demande
                if ($action == 'cancel') {
                    print $form->formconfirm("card.php?id=".$id, $langs->trans("TitleCancelSC"), $langs->trans("ConfirmCancelSC"),"confirm_cancel", '', 1, 1);
                }

                dol_fiche_head('', 'interventions', $langs->trans("intervention"), 0, '');

                if ($action == 'edit') {
                    $edit = true;
                    print '<form method="post" action="'.$_SERVER['PHP_SELF'].'?id='.$id.'&mid='.$mid.'">'."\n";
                    print '<input type="hidden" name="action" value="update" />'."\n";
                    print '<input type="hidden" name="intervention_id" value="'.$id.'" />'."\n";

                    print '<table class="border" width="100%">';
                    print '<tbody>';

        //engin
       /* print '<tr><td class="fieldrequired">'.$langs->trans("machine").'</td><td>';
         $machines = $machine->getMats();
        print $form->selectarray('machine_id_', $machines,(GETPOST('machine_id_') ? GETPOST('machine_id_') : $intervention->machine_id), 0, 0, 0, 'required="required"');
        print '</td></tr>';
*/
        //date
        print '<tr><td class="fieldrequired">'.$langs->trans("date_start").'</td><td>';
        print '<input type="text" value="'.dol_print_date($intervention->date_start,'day').'" class="datepicker" autocomplete="off"  name="date_start_" required="required" readonly="readonly" /> ';
        print '</td></tr>';

        //date
        print '<tr><td class="fieldrequired">'.$langs->trans("date_end").'</td><td>';
        print '<input type="text" value="'.dol_print_date($intervention->date_end,'day').'" class="datepicker" autocomplete="off"  name="date_end_" required="required" readonly="readonly" /> ';
        print '</td></tr>';


        //spare_parts
        print '<tr><td class="fieldrequired">'.$langs->trans("spare_parts").'</td><td>';
        print '<input type="text" value="'.$intervention->spare_parts.'" name="spare_parts_" required="required" />';
        print '</td></tr>';

        //date_end
        print '<tr><td class="fieldrequired">'.$langs->trans("description").'</td><td>';
        print '<input type="text" value="'.$intervention->description.'" name="description_" required="required" />';
        print '</td></tr>';

        //date_end
        print '<tr><td class="fieldrequired">'.$langs->trans("cause_failure").'</td><td>';
        print '<input type="text" value="'.$intervention->cause_failure.'" name="cause_failure_" required="required" />';
        print '</td></tr>';

        //chantier 
        print '<tr><td>'.$langs->trans("machine_status").'</td><td>'; 
        print '<input type="text" value="'.$intervention->machine_status.'" name="machine_status_" required="required" />';
        print '</td></tr>';


       //claim_defect_engine 
        print '<tr><td>'.$langs->trans("claim_defect_engine").'</td><td>'; 
        print $form->selectarray('defect_machine_id_', $defect_machine->getNames(),(GETPOST('defect_machine_id_') ? GETPOST('defect_machine_id_') : $intervention->defect_machine_id), 0, 0, 0, 'required="required"');
        print '</td></tr>';



                    print '</tbody>';
                    print '</table>';

                    print '<div class="center">';
                    print '<input type="submit" value="'. $langs->trans("Modify") .'" name="bouton" class="butAction">';
                    print '&nbsp; &nbsp; ';
                    print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
                    print '</div>';
                    print '</table>';
                }

                dol_fiche_end();

                if (!$edit) {
		            print '<div class="tabsAction">';

                    // Boutons d'actions
                    //if ($canedit) {
                        print '<a href="card.php?id='.$_GET['id'].'&action=edit" class="butAction">'.$langs->trans("Modify").'</a>';
                    //}

                    // If draft
                   // if ($user->rights->marches->delete)	{
                    	print '<a href="card.php?id='.$_GET['id'].'&action=delete" class="butActionDelete">'.$langs->trans("Delete").'</a>';
                   // }

                    print '</div>';
                }

        } else {
                
                print '<div class="tabBar">';
                print $langs->trans('ErrorUserViewSC');
                print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
                print '</div>';
            }

        /*} else {
            print '<div class="tabBar">';
            print $langs->trans('ErrorIDFicheSC');
            print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
            print '</div>';
        }*/

    }

}

// End of page
llxFooter();

if (is_object($db)) $db->close();

?>