<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file       appeloffres/index.php
 * \ingroup    list
 * \brief      List of markets
 */
require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/material/intervention/class/intervention.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/material/machine/class/machine.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/material/defect_machine/class/defect_machine.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/machine.lib.php';

$form 		= new Form($db);
$intervention   = new intervention($db);
$machine     = new machine($db);
$defect_machine     = new defect_machine($db);

$procedures  = array('1' => 'engin 1', '2' => 'engin 2' );

$var = false;
$filter = '';
$td_travaux =  array(1 => 'Travaux 1', 2 => 'Travaux 2' );
$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
if (! $sortfield) $sortfield = "rowid";
if (! $sortorder) $sortorder = "DESC";
$action  = GETPOST('action', 'alpha');
$mid 	  = GETPOST('mid', 'int');
$id 	  = GETPOST('id','int');
$search_machine      		= GETPOST('search_machine');
$search_date_start      		= "";
if (GETPOST('search_date_start') !=="") {
    list($etd, $etm, $ety) = explode("/", GETPOST('search_date_start'));
    $search_date_start         = $ety.'-'.$etm.'-'.$etd ;
}
$search_date_end      		= "";
if (GETPOST('search_date_end') !=="") {
    list($etd, $etm, $ety) = explode("/", GETPOST('search_date_end'));
    $search_date_end         = $ety.'-'.$etm.'-'.$etd ;
}
$search_spare_parts    		= GETPOST('search_spare_parts');
$search_machine_status    		= GETPOST('search_machine_status');
$search_cause_failure    		= GETPOST('search_cause_failure');
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
$search_machine      		= '';
$search_date_start      		= '';
$search_date_end      		= '';
$search_spare_parts    		= '';
$search_machine_status    		= '';
$search_cause_failure    		= '';
}
$filter .= " AND machine_id = ".$mid;
$filter .= (!empty($search_date_start) && $search_date_start != -1) ? " AND date_start = '".$db->escape($search_date_start)."'\n" :"";
$filter .= (!empty($search_date_end) && $search_date_end != -1) ? " AND date_end = '".$db->escape($search_date_end)."'\n" :"";
$filter .= (!empty($search_spare_parts) && $search_spare_parts != -1) ? " AND spare_parts = '".$db->escape($search_spare_parts)."'\n" : "";
$filter .= (!empty($search_machine_status) && $search_machine_status != -1) ? " AND machine_status = '".$db->escape($search_machine_status)."'\n" : "";
$filter .= (!empty($search_cause_failure) && $search_cause_failure != -1) ? " AND cause_failure = '".$db->escape($search_cause_failure)."'\n" : "";


// Si erreur SQL
if ($getinterventions == '-1') {
    print_fiche_titre($langs->trans('ListOfintervention'), '', 'title_project.png');

    dol_print_error($db, $langs->trans('Error').' '.$intervention->error);
    exit();
}
if ($id > 0) {
	$intervention->fetch($id);
	//llxHeader('', $langs->trans('intervention'));
	$machine->fetch($intervention->machine_id);
	llxHeader('', $langs->trans('intervention'));
	print_fiche_titre($langs->trans("intervention"));
	$head  		= material_prepare_head($machine);
	dol_fiche_head($head, 'intervention', $langs->trans('intervention'), 0, '');
	//print_fiche_titre($langs->trans("intervention"));

	$intervent  = intervention_prepare_head($intervention);
	dol_fiche_head($intervent, 'intervention', $langs->trans("intervention"), 0, '');
	$html .= '<table class="border" width="100%">';
       $html .= '<tr><td width="25%">'.$langs->trans("code").'</td>';
        $html .= '<td colspan="2">'. $machine->code .'</td></tr>';
        $html .= '<tr><td width="25%">'.$langs->trans("regigster_num").'</td>';
        $html .= '<td colspan="2">'. $machine->regigster_num .'</td></tr>';
    $html .= '</table><br />';
    echo $html;
    print '<table class="border" width="100%">';
	
	// engin
	/*print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("machine").'</td>';
	$machine->fetch($intervention->machine_id);
	print '<td colspan="2">'. $machine->getNomUrl(1)  .'</td></tr>';
	*/// spare_parts
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("spare_parts").'</td>';
	print '<td colspan="2">'. $intervention->spare_parts .'</td></tr>';
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("date_start").'</td>';
	print '<td colspan="2">'. dol_print_date($intervention->date_start,'day') .'</td></tr>';
	// date_end
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("date_end").'</td>';
	print '<td colspan="2">'. dol_print_date($intervention->date_end,'day') .'</td></tr>';
	// date
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("description").'</td>';
	print '<td colspan="2">'. $intervention->description.'</td></tr>';
	// date
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("cause_failure").'</td>';
	print '<td colspan="2">'. $intervention->cause_failure.'</td></tr>';
	// chantier
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("machine_status").'</td>';
	print '<td colspan="2">'. $intervention->machine_status .'</td></tr>';
	//travaux
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("claim_defect_engine").'</td>';
	$defect_machine->fetch($intervention->defect_machine_id);
	print '<td colspan="2">'. $defect_machine->getNomUrl(1,$defect_machine->id,$mid) .'</td></tr>';
	
	print '</table>';
	print '<br>';
	print '<div style="float: right; margin-top: 8px;">';
	print '<a href="./index.php?mid='. $mid .'" class="butAction">'.$langs->trans('Cancel').'</a>';
		print '<a href="./card.php?action=edit&id='. $id .'&mid='.$mid.'" class="butAction">'.$langs->trans('Modify').'</a>';
		print '<a href="./index.php?action=delete&id='. $id .'&mid='.$mid.'" class="butAction" >'.$langs->trans('Delete').'</a>';
	print '</div>';
	 if ($action == 'delete') {
       print $form->formconfirm("card.php?id=".$id."&mid=".$mid, $langs->trans("TitleDelete"),$langs->trans("ConfirmDelete"),"confirm_delete", '', 0, 1);
        }
}
else {
$getinterventions = $intervention->fetchAll($sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter);

 // Both test are required to be compatible with all browsers
$morejs  = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.js", "/btp/js/jquery/timepicker/timepicker-fr.js","/btp/js/fuel_consoma.js");
$morecss = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.css");

llxHeader('', $langs->trans('intervention'),'','','','',$morejs,$morecss,0,0);
print_fiche_titre($langs->trans("ListOfintervention"));
$machine->fetch($mid);
	$head = material_prepare_head($machine);
   	dol_fiche_head($head, 'intervention', $langs->trans('ListOfintervention'), 1, '');
   	$moreparam = '&mid='.$mid;
   	$html .= '<table class="border" width="100%">';
   	$html .= '<tr><td width="25%">'.$langs->trans("code").'</td>';
        $html .= '<td colspan="2">'. $machine->code .'</td></tr>';
        $html .= '<tr><td width="25%">'.$langs->trans("regigster_num").'</td>';
        $html .= '<td colspan="2">'. $machine->regigster_num .'</td></tr>';
    $html .= '</table><br />';
    echo $html;
	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	print '<input name="id" value="'. $id .'" type="hidden" />';
	print '<input name="mid" value="'. $mid .'" type="hidden" />';
	print '<table class="noborder" width="100%;">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("ref"),$_SERVER["PHP_SELF"],"rowid", '',$moreparam,'align="center"',$sortfield,$sortorder);
	//print_liste_field_titre($langs->trans("machine"),$_SERVER["PHP_SELF"],"machine_id", '','','align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("date_start"), $_SERVER["PHP_SELF"], 'date_start', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("date_end"),$_SERVER["PHP_SELF"],"date_end", '',$moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("spare_parts"),$_SERVER["PHP_SELF"],"spare_parts", '',$moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("machine_status"), $_SERVER["PHP_SELF"], 'machine_status', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("cause_failure"), $_SERVER["PHP_SELF"], 'cause_failure', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("description"), $_SERVER["PHP_SELF"], 'description', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("claim_defect_engine"), $_SERVER["PHP_SELF"], 'defect_machine_id', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'',$moreparam,'',$sortfield,$sortorder,'maxwidthsearch ');
	print "</tr>\n";

	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';
	// id
	print '<td class="liste_titre" olspan="1" align="center">';
	print '</td>';
	// engin
	/*print '<td class="liste_titre" olspan="1" align="center">';
	print $form->selectarray('search_machine', $machine->getMats(), $search_machine, 1, 0, 0, 'required="required"');
	print '</td>';*/
	//date_start
	print '<td class="liste_titre" olspan="1" align="center">';
    print '<input type="text" value="'.dol_print_date($search_date_start,'day').'" class="datepicker" autocomplete="off"  name="search_date_start"  readonly="readonly" /> ';
    print '</td>';
    //date_end
	print '<td class="liste_titre" olspan="1" align="center">';
    print '<input type="text" value="'.dol_print_date($search_date_end,'day').'" class="datepicker" autocomplete="off"  name="search_date_end"  readonly="readonly" /> ';
    print '</td>';
	// spare_parts
	print '<td class="liste_titre" olspan="1" align="center">';
	print '<input class="flat" style="width: 85px"  type="text"  name="search_spare_parts" value="'.$search_spare_parts.'">';
	print '</td>';
// machine_status
	print '<td class="liste_titre" olspan="1" align="center">';
	print '<input class="flat" style="width: 85px"  type="text"  name="search_machine_status" value="'.$search_machine_status.'">';
	print '</td>';
	// cause_failure
	print '<td class="liste_titre" olspan="1" align="center">';
	print '<input class="flat" style="width: 85px"  type="text"  name="search_cause_failure" value="'.$search_cause_failure.'">';
	print '</td>';
	//description
	print '<td class="liste_titre" colspan="1" align="center">';
	print '</td>';
	// claim_defect_engine
	print '<td class="liste_titre" colspan="1" align="center">';
	print '</td>';
	

	// ACTION
	print '<td align="right" style="min-width:62px;">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';

	print "</tr>\n";

	// Lines
	if (count($intervention->rows)) {
		//$createdBy = new User($db);
		foreach($intervention->rows as $obj) {
			  $cause_failure 				= $obj->cause_failure ;
			  $spare_parts 				= $obj->spare_parts ;
			  $date_start 			= dol_print_date($obj->date_start,'day') ;
			  $date_end 			= dol_print_date($obj->date_end,'day') ;
			  //$machine->fetch($obj->machine_id) ;
			  $machine_status         			= $obj->machine_status ;
			  $description         			= $obj->description ;
			  $defect_machine->fetch($obj->defect_machine_id);
	
			

			print '<tr '.$bc[$var].'>';
			print '<td align="left" style ="white-space: nowrap;">';
				print $intervention->getNomUrl(1,  $obj->id,$mid, $obj->id);
			print '</td>';
			 
			//print '<td align="center">'. $machine->getNomUrl(1) .'</td>';
			print '<td align="center">'. $date_start .'</td>';
			print '<td align="center">'. $date_end .'</td>';
			print '<td align="center">'. $spare_parts .'</td>';
			print '<td align="center">'. $machine_status .'</td>';
			print '<td align="center">'. $cause_failure .'</td>';
			print '<td align="center">'. $description .'</td>';
			print '<td align="center">'. $defect_machine->getNomUrl(1,$defect_machine->id,$mid) .'</td>';

			print '</tr>'."\n";

		}
	} else {
		print '<tr>';
	    print '<td colspan="9" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';
	}

	print '</table>';
	print '</form>';


		print '<br>';
		print '<div style="float: right; margin-top: 8px;">';
		print '<a href="./card.php?action=add&mid='.$mid.'" class="butAction">'.$langs->trans('Addintervention').'</a>';
		print '</div>';


}

llxFooter();

$db->close();


?>