<?php
require_once DOL_DOCUMENT_ROOT . '/core/class/commonobject.class.php';

class lubricant_consom extends Commonobject{

	/**
	 * @var string Error code (or message)
	 * @deprecated
	 * @see test::errors
	 */
	public $error;
	/**
	 * @var string[] Error codes (or messages)
	 */
	public $errors = array();

  public $datec;
  public $num;
  public $price;
  public $qty;
  public $lubricant_id 	;
  public $machine_id ;
  public $const_site_id	 ;
  public $created_by ;
  public $created_at ;
  public $updated_at ;
  public $rows = array();
  public $dates=array();
  public $machines=array();

	public $now;
	/**
	 * Constructor
	 *
	 * @param DoliDb $db Database handler
	 */
	public function __construct(DoliDBMysqli $db)
	{
		$this->db 		 = $db;
		$this->now 		 = new \DateTime("now");
		$this->now 		 = $this->now->format('Y-m-d');
		return 1;
	}


	/**
     *	Return clicable mat (with picto eventually)
     *
     *  @author Yassine Belkaid <y.belkaid@nextconcept.ma>
     *	@param		int			$withpicto		0=_No picto, 1=Includes the picto in the linkn, 2=Picto only
     *	@return		string						String with URL
     */
    public function getNomUrl($withpicto = 0,  $id = null,$mid, $ref = null)
    {
        global $langs;
         if (!$mid) return false;
        $result	= '';
        $setRef = (null !== $ref) ? $ref : '';
        $id  	= ($id  ?: '');
        $label  = $langs->trans("Show").': '. $setRef;

        $link 	 = '<a href="'.DOL_URL_ROOT.'/btp/material/lubricant_consom/index.php?id='. $id .'&mid='.$mid.'" title="'.dol_escape_htmltag($label, 1).'" class="classfortooltip">';
        $linkend ='</a>';
        $picto   = '';

        if ($withpicto) $result.=($link.img_object($label, $picto, 'class="classfortooltip"').$linkend);
        if ($withpicto && $withpicto != 2) $result.=' ';
        if ($withpicto != 2) $result.=$link.$setRef.$linkend;
        return $result;
    }

    /**
	 * Create object into database
	 *
	 * @return int   id of last inserted id, otherwise -1 if error arised 
	 */
	public function create()
	{
		global $conf;
		dol_syslog(__METHOD__, LOG_DEBUG);

		// Clean parameters
	  $this->datec= $this->datec ? $this->db->escape($this->datec): null;
	  $this->num = $this->num ? $this->db->escape($this->num): null;
	  $this->price = $this->price ? $this->db->escape($this->price): null;
	  $this->qty = $this->qty ? $this->db->escape($this->qty): null;
	  $this->lubricant_id = $this->lubricant_id ? $this->db->escape($this->lubricant_id): null;
	  $this->machine_id = $this->machine_id ? $this->db->escape($this->machine_id): null;
	  $this->const_site_id	= $this->const_site_id ? $this->db->escape($this->const_site_id): null;
	  $this->created_by = $this->created_by ? $this->db->escape($this->created_by): null;
	  $this->created_at = $this->now;
	// Insert request
	$sql = 'INSERT INTO ' . MAIN_DB_PREFIX . 'lubricant_consom' . ' (datec,entity,num,price,qty,';
	$sql .= 'lubricant_id,machine_id,const_site_id,created_by,created_at,updated_at) ';
	$sql .= 'VALUES ("'.$this->datec.'",'.$conf->entity.','.$this->num.', "'.$this->price.'", ';
	$sql .=	 $this->qty.','.$this->lubricant_id.', '.$this->machine_id.', ';
	$sql .=	 $this->const_site_id.', '.$this->created_by.','.$this->created_at.',NULL)';
	//die($sql);
	$this->db->begin();
		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error lubricant_consom ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);
			var_dump($errors);
			die();
			return -1;
		} else {
			$this->db->commit();
			return 1;
			//return $this->getLasInsrtedId();
		}
	}

/**
	 * Load object in memory from the database
	 *
	 * @param int    $id  Id object
	 * @param string $ref Ref
	 *
	 * @return int <0 if KO, 0 if not found, >0 if OK
	 */
	public function fetch($id, $ref = null)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . 'lubricant_consom';
		
		if (null !== $ref) {
			$sql .= ' WHERE ref = ' . '\'' . $ref . '\'';
		} else {
			$sql .= ' WHERE rowid = ' . $id;
		}

		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			if ($numrows) {
			  $obj 					= $this->db->fetch_object($resql);
			  $this->datec 			= $this->db->jdate($obj->datec); ;
			  $this->num 			= $obj->num ;
			  $this->id 			= $obj->rowid ;
			  $this->price 	        = $obj->price ;
			  $this->qty            = $obj->qty ;
			  $this->lubricant_id   = $obj->lubricant_id ;
			  $this->machine_id 	= $obj->machine_id ;
			  $this->const_site_id	= $obj->const_site_id ;
			  $this->created_by 	= $obj->created_by ;
			  $this->created_at 	= $this->db->jdate($obj->created_at);

			}

			$this->db->free($resql);

			if ($numrows) {
				return 1;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}


	/**
	 * Load object in memory from the database
	 *
	 * @param string $sortorder Sort Order
	 * @param string $sortfield Sort field
	 * @param int    $limit     offset limit
	 * @param int    $offset    offset limit
	 * @param array  $filter    filter array
	 * @param string $filtermode filter mode (AND or OR)
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function fetchAll($sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '', $filtermode = 'AND')
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM '. MAIN_DB_PREFIX . 'lubricant_consom';

		if (!empty($filter)) {
			$sql .= ' WHERE '. substr($filter, 4);
		}
		
		if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}
      // echo $sql;
		$this->rows = array();
		$resql 		 = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;
				  $line->id 			= $obj->rowid;
				  $line->datec 			= $this->db->jdate($obj->datec); ;
				  $line->num 			= $obj->num ;
				  $line->price         	= $obj->price ;
				  $line->qty            = $obj->qty ;
				  $line->lubricant_id 	= $obj->lubricant_id ;
				  $line->machine_id 	= $obj->machine_id ;
				  $line->const_site_id	= $obj->const_site_id ;
				  $line->created_by 	= $obj->created_by ;
				  $line->created_at 	= $this->db->jdate($obj->created_at);

				$this->rows[] = $line;

    				$dt = new stdClass;	
			   	 	$dt->datec =$line->datec;
					if(!in_array($dt, $this->dates)){	
					$lt = new stdClass;
					$lt->datec =$line->datec;
					$this->dates[]=$lt;

					}
					$sl = new stdClass;	
						$sl->machine_id =$line->machine_id;
					if(!in_array($sl, $this->machines)){	
						$ln = new stdClass;
						$ln->machine_id =$line->machine_id;
						$this->machines[]=$ln;
					}


			}
			$this->db->free($resql);

			return $num;
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}



	/**
	 * Update object into database
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function update($id, array $data)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$id || $id <= 0)
			return false;

		// Update request
		$sql = 'UPDATE ' . MAIN_DB_PREFIX . 'lubricant_consom' . ' SET ';

		if (count($data) && is_array($data))
			foreach ($data as $key => $val) {
				$val = is_numeric($val) ? $val : '"'. $val .'"';
				$sql .= '`'. $key. '` = '. $val .',';
			}
			$now = new \DateTime("now");
			$now 		 = $now->format('Y-m-d');
			$sql .= '`updated_at` = '. $now ;

		//$sql  = substr($sql, 0, -1);
		$sql .= ' WHERE rowid = ' . $id;

		$this->db->begin();

		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();
			
			$this->error 	= 'Error ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}


	/**
	 * Delete object in database
	 *
	 * @param User $user      User that deletes
	 * @param bool $notrigger false=launch triggers after, true=disable triggers
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function delete()
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$this->db->begin();

		$sql 	= 'DELETE FROM ' . MAIN_DB_PREFIX . 'lubricant_consom' .' WHERE rowid = ' . $this->id;
		$resql 	= $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}



    public function check_mat($mat)
    {
    	$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . 'lubricant_consom WHERE mat ="'.$mat.'"';
    	$resql 		 = $this->db->query($sql);
		if ($resql) {
			$num = $this->db->num_rows($resql);
			if($num > 0)
				return true;
			$this->db->free($resql);
    	}

    	return false;
    }

    public function getMat($id)
    {
    	$sql = 'SELECT mat FROM ' . MAIN_DB_PREFIX . 'lubricant_consom WHERE rowid='.$id;
    	$resql = $this->db->query($sql);
    	$mat = '';
		if ($resql) {
			while ($obj = $this->db->fetch_object($resql)) {
				$mat = $obj->mat;
			}
			$this->db->free($resql);
    	}

    	return $mat;
    }

    public function getDataByYear($year)
	    {
	    	global $conf;
	    	$sql = 'SELECT MONTH(datec) as month, SUM(qty*price) as total FROM ' . MAIN_DB_PREFIX . 'lubricant_consom WHERE YEAR(datec)='.$year;
	    	$sql .= ' AND entity ='.$conf->entity.' ';
	    	$sql .=' GROUP BY MONTH(datec)';
	    	$resql = $this->db->query($sql);
	    	$data = array();
			if ($resql) {
				while ($obj = $this->db->fetch_object($resql)) {
					$data[$obj->month] = $obj->total;
				}
				$this->db->free($resql);
	    	}

	    	return $data;
	    }
//tous les dates
	    public function fetchAllDate()
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT distinct(datec) FROM ' . MAIN_DB_PREFIX .'lubricant_consom order by datec';
		$this->lines = array();
		$resql 		 = $this->db->query($sql);
		if ($resql) {
			echo $sql;

			$num = $this->db->num_rows($resql);
			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;
			$line->datec = $this->db->jdate($obj->datec);
			$this->rows[] 		 = $line;
			}
			$this->db->free($resql);
			return $num;
		} else {
			$this->error 	= 'Error ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

// selection tous les machines
	public function fetchAllMachine()
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT distinct(machine_id)FROM ' . MAIN_DB_PREFIX .'lubricant_consom order by machine_id';
		$this->lines = array();
		$resql 		 = $this->db->query($sql);
		if ($resql) {
			$num = $this->db->num_rows($resql);
			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;
				$line->machine_id= $obj->machine_id;
				$this->machines[]= $line;
			}
			
			$this->db->free($resql);

			return $num;
		} else {
			/*$this->error 	= 'Error ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);
*/
			return -1;
		}
	}













}
?>