<?php 
/* Copyright (C) 2016		Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *   	\file       marches/list.php
 *		\ingroup    list
 *		\brief      Gestion des marches
 */

require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/material/machine/class/machine.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/settings/unit_type/class/unitType.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/material/constraction_site/class/constraction_site.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/settings/machine_categories/class/MachineCategories.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/settings/machine_mark/class/MachineMark.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/settings/counter_type/class/CounterType.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/machine.lib.php';


// Get parameters
$action  = GETPOST('action', 'alpha');
$id 	 = GETPOST('id', 'int');
$tpmch    = GETPOST('tpmch','int');
$request_method = $_SERVER['REQUEST_METHOD'];

//$langs->load('marches');
// Protection if external user
if ($user->societe_id > 0) accessforbidden();

$now 	= new DateTime('now');
$form       = new Form($db);
$error 	= false;

if ($action == 'create' && $request_method === 'POST') {
	$machine = new machine($db);

    if (!$error) {
         $machine->code            = trim(GETPOST('code_'));
          $machine->type           = trim(GETPOST('type_'));
          if (!$tpmch)
            $machine->type_machine   = trim(GETPOST('type_machine_'));
          else
            $machine->type_machine   = (int)$tpmch;

          $machine->serie          = trim(GETPOST('serie_'));
          $machine->regigster_num  = trim(GETPOST('regigster_num_'));
          $machine->year           = trim(GETPOST('year_'));
          $machine->chassis_num    = trim(GETPOST('chassis_num_'));
          $machine->avg_consomation = trim(GETPOST('avg_consomation_'));
          $machine->location_rate  = trim(GETPOST('location_rate_'));
          $machine->immo_rate      = trim(GETPOST('immo_rate_'));
          $machine->couthoraireengin      = trim(GETPOST('couthoraireengin_'));
          $machine->machine_mark_id = trim(GETPOST('machine_mark_id_'));
          $machine->machine_cat_id = trim(GETPOST('machine_cat_id_'));
          $machine->counter_type_id = trim(GETPOST('counter_type_id_'));
          $machine->unit_type_id   = trim(GETPOST('unit_type_id_'));
          $machine->driver_id      = trim(GETPOST('driver_id_'));
          $machine->const_site_id  = trim(GETPOST('const_site_id_'));
          $machine->created_by     = trim(GETPOST('created_by_'));
            //if(!$machine->check_mat($machine->mat)){
                    $machineID = $machine->create();
            
                    // If no SQL error we redirect to the request card
                    if ($machineID > 0) {
                        //header('Location: index.php?id='.$getMarcheID);
                        header('Location: index.php?tpmch='.$machine->type_machine);
                        exit;
                    } else {
                        // Otherwise we display the request form with the SQL error message
                        header('Location: card.php?action=request&error=SQL_Create&msg='.$machine->error);
                        exit;
                    }
               /* }
            else{
                $msg ='Cette marticule '.$machine->mat.' est deja saisée !';
                 header('Location: card.php?action=request&error=SQL_Create&msg='.$msg);
                        exit;
            }*/
    }
}

if ($action == 'update' && $request_method === 'POST') {
    // If no right to modify a request
    /*if (!$user->rights->marches->write) {
        header('Location: ./card.php?action=request&error=CantUpdate');
        exit;
    }*/

    $machine_id = (int) GETPOST('machine_id', 'int');

    if (!$machine_id || $machine_id <= 0) {
        header('Location: ./card.php?action=request&error=CantUpdate');
        exit;
    }

    $machine = new machine($db);
    $type_machine = 0;
    $machine->fetch($machine_id);
     if (!$tpmch)
            $type_machine   = trim(GETPOST('type_machine_'));
          else
            $type_machine   = (int)$tpmch;

   // $canedit = ($user->rights->marches->write || $user->rights->marches->write_all);
    $canedit = true ; 


    // If this is the requestor or has read/write rights
    if ($canedit) {
        $data = array(
          'code'           =>trim(GETPOST('code_')),
          'type'           =>trim(GETPOST('type_')),
          'type_machine'   =>$type_machine,
          'serie'          =>trim(GETPOST('serie_')),
          'regigster_num'  =>trim(GETPOST('regigster_num_')),
          'year'           =>trim(GETPOST('year_')),
          'chassis_num'    =>trim(GETPOST('chassis_num_')),
          'avg_consomation' =>trim(GETPOST('avg_consomation_')),
          'location_rate'  =>trim(GETPOST('location_rate_')),
          'immo_rate'      =>trim(GETPOST('immo_rate_')),
          'couthoraireengin'      =>trim(GETPOST('couthoraireengin_')),
          'machine_mark_id' =>trim(GETPOST('machine_mark_id_')),
          'machine_cat_id' =>trim(GETPOST('machine_cat_id_')),
          'counter_type_id' =>trim(GETPOST('counter_type_id_')),
          'unit_type_id'   =>trim(GETPOST('unit_type_id_')),
          'driver_id'     =>trim(GETPOST('driver_id_')),
          'const_site_id'  =>trim(GETPOST('const_site_id_')),
          'created_by'    =>trim(GETPOST('created_by_'))
        );

		$getmachineID = $machine->update($machine_id, $data);
        
                if ($getmachineID > 0) {
                    header('Location: ./index.php?id='.$machine_id);
                    exit;
                } else {
                    // Otherwise we display the request form with the SQL error message
                    header('Location: ./card.php?id='. $machine_id .'&action=edit&error=SQL_Create&msg='.$machine->error);
                    exit;
                } 
    }
}

// If delete of request
if ($action == 'confirm_delete' && GETPOST('confirm') == 'yes' ) {
	$error=0;

	//$db->begin();
	$event  = new machine($db);
	//$canedit = ($user->rights->marches->write_all || $user->rights->marches->delete);
    $canedit = true;
	// Si l'utilisateur à le droit de lire ce contrat, il peut le supprimer
	if ($canedit) {
        $event->fetch($id);
		$event->delete();
	}
	else {
		$error = $langs->trans('ErrorCantDelete');
	}

	if (!$error) {
		//$db->commit();
		header('Location: index.php?tpmch='.$tpmch);
		exit;
	}
	else {
		
        header('Location: index.php?leftmenu=marches');
        exit;
	}
}

/*
 * View
 */

$form      = new Form($db);
$machine     = new machine($db);
$unit_type = new unitType($db);
$constraction_site = new constraction_site($db);
$machineCategories     = new MachineCategories($db);
$machineMark     = new MachineMark($db);
$counterType     = new CounterType($db);
$morejs  = array(DOL_MAIN_URL_ROOT."/btp/js/btp.js");
$morecss = array("");

llxHeader(array(), $langs->trans('machine'),'','','','',$morejs,$morecss,0,0);
if ($tpmch)
        {
            if($tpmch == 1 )
                print_fiche_titre($langs->trans("machineIntern"));
            else if($tpmch == 2 )
                print_fiche_titre($langs->trans("machineExtern"));
            
        }
  else      
    print_fiche_titre($langs->trans("machine"));

if (empty($id) || $action == 'add' || $action == 'request' || $action == 'create') {
	// Si l'utilisateur n'a pas le droit de créer un marché
    /*if (empty($user->rights->marches->write) || empty($user->rights->marches->write_all)) {
        $errors[]=$langs->trans('CantCreate');
    }
    else {*/
        // Formulaire appel d'offre
        //print_fiche_titre($langs->trans('Addmachine'));

        // Si il y a une erreur
        if (GETPOST('error')) {
            switch(GETPOST('error')) {
                case 'nobudget' :
                    $errors[] = $langs->trans('errorNoBudget');
                    break;
                case 'SQL_Create' :
                    $errors[] = $langs->trans('ErrorSQLCreateCP').' <b>'.htmlentities($_GET['msg']).'</b>';
                    break;
                case 'CantCreate' :
                    $errors[] = $langs->trans('CantCreateCP');
                    break;
                case 'nouser' :
                    $errors[] = $langs->trans('errorNoUser');
                    break;
                case 'nodatedebut' :
                    $errors[] = $langs->trans('NoDateDebut');
                    break;
                case 'nobank' :
                    $errors[] = $langs->trans('errorNoBank');
                    break;
                case 'noqc' :
                    $errors[] = $langs->trans('errorNoQc');
                    break;
                case 'alreadyExists' :
                    $errors[] = $langs->trans('alreadyExistAO');
                    break;
                case 'noref' :
                    $errors[] = $langs->trans('errorNoRef');
                    break;
            }

	        setEventMessage($errors, 'errors');
        }

        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">'."\n";
        print '<input type="hidden" name="action" value="create" />'."\n";

        print '<table class="border" width="100%">';
        print '<tbody>';


        // code
        print '<tr><td class="fieldrequired">'.$langs->trans("Code").'</td><td>';
        print '<input type="text" value="" name="code_" required="required" />';
        print '</td></tr>';

        //type_machine
        if (!$tpmch){
                print '<tr><td>'.$langs->trans("type_machine").'</td><td>'; 
                $type_machines = array( 1 => 'interne'  , 2 => 'externe' );;
                print $form->selectarray('type_machine_', $type_machines,(GETPOST('type_machine_') ? GETPOST('type_machine_') : null), 0, 0, 0, 'required="required"');
                print '</td></tr>';}
        else{
            print '<input type="hidden" value="'.$tpmch.'" name="tpmch" required="required" />';
        
        }

        //catégorie
        print '<tr><td>'.$langs->trans("machine_cat").'</td><td>'; 
        $cat_machines = $machineCategories->getNames();
        print $form->selectarray('machine_cat_id_', $cat_machines,(GETPOST('machine_cat_id_') ? GETPOST('machine_cat_id_') : null), 0, 0, 0, 'required="required"');
        print '</td></tr>';

        //MARQUE
        print '<tr><td>'.$langs->trans("machine_mark").'</td><td>'; 
        $mark_machines = $machineMark->getNames();
        print $form->selectarray('machine_mark_id_', $mark_machines,(GETPOST('machine_mark_id_') ? GETPOST('machine_mark_id_') : null), 0, 0, 0, 'required="required"');
        print '</td></tr>';

        //type
        print '<tr><td class="fieldrequired">'.$langs->trans("Type").'</td><td>';
         print '<input type="text" value="" name="type_" required="required" />';
        print '</td></tr>';

        //serie
        print '<tr><td class="fieldrequired">'.$langs->trans("Serie").'</td><td>';
        print '<input type="text" value="" name="serie_" required="required" />';
        print '</td></tr>';

        //matricule
        print '<tr><td class="fieldrequired">'.$langs->trans("regigster_num").'</td><td>';
        print '<input type="text" value="" name="regigster_num_" required="required" />';
        print '</td></tr>';

        //année
        print '<tr><td class="fieldrequired">'.$langs->trans("year").'</td><td>';
        print '<input type="number" value="" max="9999" min="0" name="year_" required="required" />';
        print '</td></tr>';

        //N° chassis
        print '<tr><td class="fieldrequired">'.$langs->trans("chassis_num").'</td><td>';
        print '<input type="text" value="" name="chassis_num_" required="required" />';
        print '</td></tr>';

        //Type compteur 
        print '<tr><td class="fieldrequired">'.$langs->trans("counter_type").'</td><td>'; 
        $mark_machines = $counterType->getNames();
        print $form->selectarray('counter_type_id_', $mark_machines,(GETPOST('counter_type_id_') ? GETPOST('counter_type_id_') : null), 0, 0, 0, 'required="required"');
        print '</td></tr>';

       //Moyenne de consommation estimée 
        print '<tr><td class="fieldrequired">'.$langs->trans("avg_consomation").'</td><td>';
        print '<input type="number" value="" min="0" step="0.01" name="avg_consomation_" required="required" />';
        print '</td></tr>';

        //Tarif de Location  
        print '<tr><td class="fieldrequired">'.$langs->trans("location_rate").'</td><td>';
        print '<input type="number" value="" min="0" step="0.01" name="location_rate_" required="required" />';
        print '</td></tr>';

        //Tarif d'immobilisation   
        print '<tr><td class="fieldrequired">'.$langs->trans("immo_rate").'</td><td>';
        print '<input type="number" value="" min="0" step="0.01" name="immo_rate_" required="required" />';
        print '   /    ';
        $units = $unit_type->getNames();
        print $form->selectarray('unit_type_id_', $units,(GETPOST('unit_type_id_') ? GETPOST('unit_type_id_') : null), 0, 0, 0, 'required="required"');
        
        print '</td></tr>';

        //Coût horaire de l'engin
        print '<tr><td class="">'.$langs->trans("Coût horaire de l'engin").'</td><td>';
        print '<input type="number" value="" min="0" step="0.01" name="couthoraireengin_"/>';
        print '</td></tr>';

        //Conducteur 
        print '<tr><td>'.$langs->trans("driver").'</td><td>'; 
        print $form->select_dolusers(null,'driver_id_');
        print '</td></tr>';

        //Chantier 
        print '<tr><td>'.$langs->trans("const_site").'</td><td>'; 
        $const_sites = $constraction_site->getNames() ;
        print $form->selectarray('const_site_id_', $const_sites,(GETPOST('const_site_id_') ? GETPOST('const_site_id_') : null), 0, 0, 0, 'required="required"');
        print '</td></tr>';

        print '<input type="number" hidden="hidden" value="1" name="created_by_" required="required" />';

        print '</tbody>';
        print '</table>';

        print '<div class="center">';
        print '<input type="submit" value="'. $langs->trans("Createmachine") .'" name="bouton" class="butAction">';
        print '&nbsp; &nbsp; ';
        print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
        print '</div>';
        print '</form>';
    //}
}
else {
    if ($error) {
        print '<div class="tabBar">';
        print $error;
        print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
        print '</div>';
    }
    else {
        // Affichage de la fiche d'une demande de congés payés

        if ($id > 0) {
            $machine->fetch($id);

			//$canedit = ($user->rights->marches->delete || $user->rights->marches->write_all);

            // Si il y a une erreur
            if (GETPOST('error')) {
                switch(GETPOST('error')) {
                    case 'datefin' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorEndDateCP');
                        break;
                    case 'SQL_Create' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorSQLCreateCP').' '.$_GET['msg'];
                        break;
                    case 'CantCreate' :
                        $errors[] = $langs->transnoentitiesnoconv('CantCreateCP');
                        break;
                    case 'Valideur' :
                        $errors[] = $langs->transnoentitiesnoconv('InvalidValidatorCP');
                        break;
                    case 'nodatedebut' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateDebut');
                        break;
                    case 'nodatefin' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateFin');
                        break;
                    case 'DureeHoliday' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorDureeCP');
                        break;
                    case 'NoMotifRefuse' :
                        $errors[] = $langs->transnoentitiesnoconv('NoMotifRefuseCP');
                        break;
                    case 'mail' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorMailNotSend')."\n".$_GET['error_content'];
                        break;
                }

	            setEventMessage($errors, 'errors');
            }

            // On vérifie si l'utilisateur à le droit de lire cette demande
           // if ($canedit) {
                
                // Si annulation de la demande
                if ($action == 'cancel') {
                    print $form->formconfirm("card.php?id=".$id, $langs->trans("TitleCancelSC"), $langs->trans("ConfirmCancelSC"),"confirm_cancel", '', 1, 1);
                }

                // dol_fiche_head('', 'machines', $langs->trans("machine"), 0, '');

                if ($action == 'edit') {
                    $head = material_prepare_head($machine);
                    dol_fiche_head($head, 'machine', $langs->trans("machine"), 0, '');
                    $edit = true;
                    print '<form method="post" action="'.$_SERVER['PHP_SELF'].'?id='.$id.'">'."\n";
                    print '<input type="hidden" name="action" value="update" />'."\n";
                    print '<input type="hidden" name="machine_id" value="'.$id.'" />'."\n";

                    print '<table class="border" width="100%">';
                    print '<tbody>';

                   // code
        print '<tr><td class="fieldrequired">'.$langs->trans("Code").'</td><td>';
        print '<input type="text" value="'.$machine->code.'" name="code_" required="required" />';
        print '</td></tr>';

         //type_machine
        if ($tpmch)
        {print '<tr><td>'.$langs->trans("type_machine").'</td><td>'; 
                $type_machines = array( 1 => 'interne'  , 2 => 'externe' );;
                print $form->selectarray('type_machine_', $type_machines,(GETPOST('type_machine_') ? GETPOST('type_machine_') : $machine->type_machine), 0, 0, 0, 'required="required"');
                print '</td></tr>';}

        //catégorie
        print '<tr><td>'.$langs->trans("machine_cat").'</td><td>'; 
        $cat_machines = $machineCategories->getNames();
        print $form->selectarray('machine_cat_id_', $cat_machines,(GETPOST('machine_cat_id_') ? GETPOST('machine_cat_id_') : $machine->machine_cat_id), 0, 0, 0, 'required="required"');
        print '</td></tr>';

        //MARQUE
        print '<tr><td>'.$langs->trans("machine_mark").'</td><td>'; 
        $mark_machines = $machineMark->getNames();
        print $form->selectarray('machine_mark_id_', $mark_machines,(GETPOST('machine_mark_id_') ? GETPOST('machine_mark_id_') : $machine->machine_mark_id), 0, 0, 0, 'required="required"');
        print '</td></tr>';

        //type
        print '<tr><td class="fieldrequired">'.$langs->trans("Type").'</td><td>';
         print '<input type="text" value="'.$machine->type.'" name="type_" required="required" />';
        print '</td></tr>';

        //serie
        print '<tr><td class="fieldrequired">'.$langs->trans("Serie").'</td><td>';
        print '<input type="text" value="'.$machine->serie.'" name="serie_" required="required" />';
        print '</td></tr>';

        //matricule
        print '<tr><td class="fieldrequired">'.$langs->trans("regigster_num").'</td><td>';
        print '<input type="text" value="'.$machine->regigster_num.'" name="regigster_num_" required="required" />';
        print '</td></tr>';

        //année
        print '<tr><td class="fieldrequired">'.$langs->trans("year").'</td><td>';
        print '<input type="number" max="9999" min="0" value="'.$machine->year.'" name="year_" required="required" />';
        print '</td></tr>';

        //N° chassis
        print '<tr><td class="fieldrequired">'.$langs->trans("chassis_num").'</td><td>';
        print '<input type="text" value="'.$machine->chassis_num.'" name="chassis_num_" required="required" />';
        print '</td></tr>';

        //Type compteur 
        print '<tr><td class="fieldrequired">'.$langs->trans("counter_type").'</td><td>'; 
        $mark_machines = $counterType->getNames();
        print $form->selectarray('counter_type_id_', $mark_machines,(GETPOST('counter_type_id_') ? GETPOST('counter_type_id_') : $machine->counter_type_id), 0, 0, 0, 'required="required"');
        print '</td></tr>';

       //Moyenne de consommation estimée 
        print '<tr><td class="fieldrequired">'.$langs->trans("avg_consomation").'</td><td>';
        print '<input type="number" min="0" step="0.01" value="'.$machine->avg_consomation.'" name="avg_consomation_" required="required" />';
        print '</td></tr>';

        //Tarif de Location  
        print '<tr><td class="fieldrequired">'.$langs->trans("location_rate").'</td><td>';
        print '<input type="number" min="0" step="0.01" value="'.$machine->location_rate.'" name="location_rate_" required="required" />';
        print '</td></tr>';

        //Tarif d'immobilisation   
        print '<tr><td class="fieldrequired">'.$langs->trans("immo_rate").'</td><td>';
        print '<input type="number" min="0" step="0.01" value="'.$machine->immo_rate.'" name="immo_rate_" required="required" />';
        print '   /    ';
        $units = $unit_type->getNames();
        print $form->selectarray('unit_type_id_', $units,(GETPOST('unit_type_id_') ? GETPOST('unit_type_id_') : $machine->unit_type_id), 0, 0, 0, 'required="required"');
        
        print '</td></tr>';

        //Coût horaire de l'engin
        print '<tr><td class="">'.$langs->trans("Coût horaire de l'engin").'</td><td>';
        print '<input type="number" value="'.$machine->couthoraireengin.'" min="0" step="0.01" name="couthoraireengin_"/>';
        print '</td></tr>';

        //Conducteur 
        print '<tr><td>'.$langs->trans("driver").'</td><td>'; 
        print $form->select_dolusers($machine->driver_id,'driver_id_');
        print '</td></tr>';

        //Chantier 
        print '<tr><td>'.$langs->trans("const_site").'</td><td>'; 
        $const_sites = $constraction_site->getNames();
        print $form->selectarray('const_site_id_', $const_sites,(GETPOST('const_site_id_') ? GETPOST('const_site_id_') : $machine->const_site_id), 0, 0, 0, 'required="required"');
        print '</td></tr>';

        print '<input type="number" hidden="hidden" value="'.$machine->created_by.'" name="created_by_" required="required" />';



                    print '</tbody>';
                    print '</table>';

                    print '<div class="center">';
                    print '<input type="submit" value="'. $langs->trans("Modify") .'" name="bouton" class="butAction">';
                    print '&nbsp; &nbsp; ';
                    print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
                    print '</div>';
                    print '</table>';
                }

                dol_fiche_end();

                if (!$edit) {
		            print '<div class="tabsAction">';

                    // Boutons d'actions
                    //if ($canedit) {
                        print '<a href="card.php?id='.$_GET['id'].'&action=edit" class="butAction">'.$langs->trans("Modify").'</a>';
                    //}

                    // If draft
                   // if ($user->rights->marches->delete)	{
                    	print '<a href="card.php?id='.$_GET['id'].'&action=delete" class="butActionDelete">'.$langs->trans("Delete").'</a>';
                   // }

                    print '</div>';
                }

        } else {
                
                print '<div class="tabBar">';
                print $langs->trans('ErrorUserViewSC');
                print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
                print '</div>';
            }

        /*} else {
            print '<div class="tabBar">';
            print $langs->trans('ErrorIDFicheSC');
            print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
            print '</div>';
        }*/

    }

}

// End of page
llxFooter();

if (is_object($db)) $db->close();

?>