<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file       appeloffres/index.php
 * \ingroup    list
 * \brief      List of markets
 */
require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/material/machine/class/machine.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/settings/unit_type/class/unitType.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/settings/machine_categories/class/MachineCategories.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/settings/machine_mark/class/MachineMark.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/settings/counter_type/class/CounterType.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/machine.lib.php';



$form 		= new Form($db);
$machine     = new machine($db);
$unit_type     = new unitType($db);
$machineCategories     = new MachineCategories($db);
$machineMark     = new MachineMark($db);
$counterType     = new CounterType($db);
$var = false;
$filter = '';
$type_machines = array(1 => 'interne', 2 => 'externe');
$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
if (! $sortfield) $sortfield = "rowid";
if (! $sortorder) $sortorder = "DESC";
$id 	  = GETPOST('id','int');
$tpmch 	  = GETPOST('tpmch','int');
$action   = GETPOST('action','alpha');
$search_code     		= GETPOST('search_code');
$search_type      		=  GETPOST('search_type');
$search_type_machine      		=  GETPOST('search_type_machine');
$search_serie    		= GETPOST('search_serie');
$search_regigster_num    		= GETPOST('search_regigster_num');
$search_year    		= GETPOST('search_year');
$search_chassis_num    		= GETPOST('search_chassis_num');
$search_location_rate    		= GETPOST('search_location_rate');
$search_avg_consomation    		= GETPOST('search_avg_consomation');
$search_immo_rate    		= GETPOST('search_immo_rate');
$search_unit_type    		= GETPOST('search_unit_type');
$search_const_site    		= GETPOST('search_const_site');

if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
$search_code      		= '';
$search_type      		= '';
$search_type_machine      		= '';
$search_serie    		= '';
$search_regigster_num    		= '';
$search_year    		= '';
$search_chassis_num    		= '';
$search_location_rate    		= '';
$search_avg_consomation    		= '';
$search_immo_rate   		= '';
$search_unit_type    		= '';
$search_const_site    		= '';
}
if(!$tpmch)
$tpmch=1;
$filter .= (!empty($search_code) && $search_code != -1) ? " AND code = '". $db->escape($search_code)."'\n" : "";
$filter .= (!empty($search_type) && $search_type != -1) ? " AND type = '". $db->escape($search_type)."'\n" : "";
$filter .= " AND type_machine = ". $tpmch;
$filter .= (!empty($search_serie) && $search_serie != -1) ? " AND serie = '".$db->escape($search_serie)."'\n" :"";
$filter .= (!empty($search_regigster_num) && $search_regigster_num != -1) ? " AND regigster_num = '".$db->escape($search_regigster_num)."'\n" : "";
$filter .= (!empty($search_year) && $search_year != -1) ? " AND year = ".$db->escape($search_year) : "";
$filter .= (!empty($search_chassis_num) && $search_chassis_num != -1) ? " AND chassis_num = '".$db->escape($search_chassis_num)."'\n" : "";
$filter .= (!empty($search_location_rate) && $search_location_rate != -1) ? " AND location_rate = ".$db->escape($search_location_rate) : "";
$filter .= (!empty($search_avg_consomation) && $search_avg_consomation != -1) ? " AND avg_consomation = ".$db->escape($search_avg_consomation) : "";
$filter .= (!empty($search_immo_rate) && $search_immo_rate != -1) ? " AND immo_rate = ".$db->escape($search_immo_rate) : "";
$filter .= (!empty($search_unit_type) && $search_unit_type != -1) ? " AND unit_type_id = ".$db->escape($search_unit_type) : "";

$getMachines = $machine->fetchAll($sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter);
if (!empty($getMachines)  && $action == "xsl" ) {

$filename="engins.xls";
      require_once DOL_DOCUMENT_ROOT.'/btp/material/machine/tpl/engins_xsl.php';
 die();
 
}

llxHeader('', $langs->trans('Machines'));
// Si erreur SQL
if ($getMachines == '-1') {
    print_fiche_titre($langs->trans('ListOfmachine'), '', 'title_project.png');

    dol_print_error($db, $langs->trans('Error').' '.$machine->error);
    exit();
}
if ($id > 0) {
	$machine->fetch($id);
	
            if($machine->type_machine == 1 )
                print_fiche_titre($langs->trans("machineIntern"));
            else if($machine->type_machine == 2 )
                print_fiche_titre($langs->trans("machineExtern"));
	$head = material_prepare_head($machine);
	dol_fiche_head($head, 'machine', $langs->trans("machine"), 0, '');

	/*llxHeader('', $langs->trans('machine'));
	print_fiche_titre($langs->trans("machine"));*/

	// print_barre_liste($langs->trans("machine"), '', '', '', '', '', "", "", "", 'title_project.png');
	
	print '<table class="border" width="100%">';
	// code
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("name").'</td>';
	print '<td colspan="2">'. $machine->code .'</td></tr>';
	// type_machine
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("type_machine").'</td>';
	print '<td colspan="2">'. $type_machines[$machine->type_machine] .'</td></tr>';
	// type
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Type").'</td>';
	print '<td colspan="2">'. $machine->type .'</td></tr>';
	// serie
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Serie").'</td>';
	print '<td colspan="2">'. $machine->serie .'</td></tr>';
	// matricule
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("regigster_num").'</td>';
	print '<td colspan="2">'. $machine->regigster_num .'</td></tr>';
	// année
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("year").'</td>';
	print '<td colspan="2">'. $machine->year .'</td></tr>';
	// N° chassis
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("chassis_num").'</td>';
	print '<td colspan="2">'. $machine->chassis_num .'</td></tr>';
	// Moyenne de consommation estimée
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("avg_consomation").'</td>';
	print '<td colspan="2">'. $machine->avg_consomation .'</td></tr>';
	// Tarif d'immobilisation 
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("location_rate").'</td>';
	print '<td colspan="2">'. $machine->location_rate .' '.$langs->getCurrencySymbol($conf->currency).'</td></tr>';
	// unité 
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("unit_type").'</td>';
	$unit_type->fetch($machine->unit_type_id);
	print '<td colspan="2">'. $unit_type->getNomUrl('1') .'</td></tr>';
	// Engin Categorie 
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("machine_cat").'</td>';
	$machineCategories->fetch($machine->machine_cat_id);
	print '<td colspan="2">'. $machineCategories->getNomUrl('1').'</td></tr>';
	// Engin marque 
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("machine_mark").'</td>';
	$machineMark->fetch($machine->machine_mark_id);
	print '<td colspan="2">'. $machineMark->getNomUrl('1') .'</td></tr>';
	 // type compteur 
    print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("counter_type").'</td>';
    $counterType->fetch($machine->counter_type_id);
    print '<td colspan="2">'. $counterType->getNomUrl('1') .'</td></tr>';
	// Tarif de Location
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("immo_rate");
	print '   /    ';
	print '<span style="font-size:10px;">'.$unit_type->name.'</span>';
	print '</td>';
	print '<td colspan="2">'. $machine->immo_rate .' '.$langs->getCurrencySymbol($conf->currency);
	print '</td></tr>';

	// Coût horaire de l'engin
	print '<tr><td width="25%" class="">'.$langs->trans("Coût horaire de l'engin").'</td>';
	print '<td colspan="2">'. $machine->couthoraireengin .' '.$langs->getCurrencySymbol($conf->currency).'</td></tr>';
	
	print '</table>';
	print '<br>';
	print '<div style="float: right; margin-top: 8px;">';
	print '<a href="./index.php?tpmch='. $machine->type_machine .'" class="butAction">'.$langs->trans('Cancel').'</a>';
		print '<a href="./card.php?action=edit&id='. $id .'&tpmch='. $machine->type_machine .'" class="butAction">'.$langs->trans('Modify').'</a>';
		print '<a href="./index.php?action=delete&id='. $id .'&tpmch='. $machine->type_machine .'" class="butAction" >'.$langs->trans('Delete').'</a>';	
	print '</div>';
	if ($action == 'delete') {
		 print $form->formconfirm("card.php?id=".$id.'&tpmch='. $machine->type_machine , $langs->trans("TitleDelete"),$langs->trans("ConfirmDelete"),"confirm_delete", '', 0, 1);
                }
}
else {

if($tpmch == 1)
print_fiche_titre($langs->trans("ListOfmachine_intern"));
else if($tpmch == 2)
print_fiche_titre($langs->trans("ListOfmachine_extern"));


	dol_fiche_head('', 'machines', $langs->trans("Listmachine"), 1, '');
if($tpmch == 1)
		{print '<br>';
				print '<div style="float: right; margin-bottom: 6px;">';
				print '<a href="./card.php?action=add&tpmch=1" class="butAction">'.$langs->trans('AddmachineIntrn').'</a>';
				print '</div>';
		}
	else if($tpmch == 2)
		{print '<br>';
				print '<div style="float: right; margin-bottom: 6px;">';
				print '<a href="./card.php?action=add&tpmch=2" class="butAction">'.$langs->trans('AddmachineExtrn').'</a>';
				print '</div>';
		}
 print '<div style="float: right; ">';
       print '<form method="post" action="'.$_SERVER["PHP_SELF"].'?tpmch='.$tpmch.'">'."\n";

print '<input name="search_code" value="'. $search_code .'" type="hidden" />';
print '<input name="search_type" value="'. $search_type .'" type="hidden" />';
print '<input name="search_type_machine" value="'. $search_type_machine .'" type="hidden" />';
print '<input name="search_serie" value="'. $search_serie .'" type="hidden" />';
print '<input name="search_regigster_num" value="'. $search_regigster_num .'" type="hidden" />';
print '<input name="search_year" value="'. $search_year .'" type="hidden" />';
print '<input name="search_chassis_num" value="'. $search_chassis_num .'" type="hidden" />';
print '<input name="search_location_rate" value="'. $search_location_rate .'" type="hidden" />';
print '<input name="search_avg_consomation" value="'. $search_avg_consomation .'" type="hidden" />';
print '<input name="search_immo_rate" value="'. $search_immo_rate .'" type="hidden" />';
print '<input name="search_unit_type" value="'. $search_unit_type .'" type="hidden" />';
print '<input name="search_const_site" value="'. $search_const_site .'" type="hidden" />';
print '<input name="action" value="xsl" type="hidden" />';

        print '<button style="margin-bottom: 8px;" class="butAction" name="submit" value="Exporter Excel">'.$langs->trans('Exporter Excel').'</button>';
       print '</form>'."\n";
        print '</div>'; 
	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	print '<input name="id" value="'. $id .'" type="hidden" />';
	print '<input name="tpmch" value="'. $tpmch .'" type="hidden" />';
	print '<table class="noborder" width="100%;">';
	print "<tr class=\"liste_titre\">";
	$moreparam = '&tpmch='.$tpmch;
	print_liste_field_titre($langs->trans("name"),$_SERVER["PHP_SELF"], "code", '', $moreparam, 'align="center"', $sortfield, $sortorder);
	//print_liste_field_titre($langs->trans("type_machine"),$_SERVER["PHP_SELF"],"type_machine", '','','align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("Type"),$_SERVER["PHP_SELF"],"type", '',$moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("Serie"),$_SERVER["PHP_SELF"],"serie", '',$moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("regigster_num"), $_SERVER["PHP_SELF"],'regigster_num','', $moreparam,'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("year"), $_SERVER["PHP_SELF"], 'year', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("chassis_num"),$_SERVER["PHP_SELF"], "chassis_num", '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("avg_consomation"),$_SERVER["PHP_SELF"],"avg_consomation",'',$moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("location_rate"), $_SERVER["PHP_SELF"], 'location_rate','',$moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("immo_rate"), $_SERVER["PHP_SELF"], 'immo_rate', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("unit_type"), $_SERVER["PHP_SELF"], 'unit_type_id', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'',$moreparam,'',$sortfield,$sortorder,'maxwidthsearch ');
	print "</tr>\n";

	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';
	// code
	print '<td class="liste_titre" olspan="1" align="center">';
	print '<input class="flat" style="width: 85px"  type="text"  name="search_code" value="'.$search_code.'">';
	print '</td>';
	// type_machine
	/*print '<td class="liste_titre" olspan="1" align="center">';
	print $form->selectarray('search_type_machine', $type_machines, $search_type_machine, 1, 0, 0, 'required="required"');
	print '</td>';*/
	//type
	print '<td class="liste_titre" olspan="1" align="center">';
    print '<input type="text" value="'.$search_type.'"  name="search_type"   /> ';
    print '</td>';
    // serie
	print '<td class="liste_titre" olspan="1" align="center">';
	print '<input class="flat" style="width: 85px"  type="text"  name="search_serie" value="'.$search_serie.'">';
	print '</td>';
	// regigster_num
	print '<td class="liste_titre" olspan="1" align="center">';
	print '<input class="flat" style="width: 85px"  type="text" name="search_regigster_num" value="'.$search_regigster_num.'">';
	print '</td>';
	// year
	print '<td class="liste_titre" olspan="1" align="center">';
	print '<input class="flat" style="width: 85px"  type="number" max="9999" min="0" name="search_year" value="'.$search_year.'">';
	print '</td>';
    // chassis_num
	print '<td class="liste_titre" olspan="1" align="center">';
	print '<input class="flat" style="width: 85px"  type="text" name="search_chassis_num" value="'.$search_chassis_num.'">';
	print '</td>';
	// avg_consomation
	print '<td class="liste_titre" olspan="1" align="center">';
	print '<input class="flat" style="width: 85px"  type="number" min="0" step="0.01" name="search_avg_consomation" value="'.$search_avg_consomation.'">';
	print '</td>';
	// location_rate
	print '<td class="liste_titre" olspan="1" align="center">';
	print '<input class="flat" style="width: 85px"  type="number" step="0.01" min="0" name="search_location_rate" value="'.$search_location_rate.'">';
	print '</td>';
	// engin
	print '<td class="liste_titre" olspan="1" align="center">';
	print '<input class="flat" style="width: 85px"  type="number" step="0.01" min="0" name="search_immo_rate" value="'.$search_immo_rate.'">';
	print '</td>';
	// unit_type
	print '<td class="liste_titre" olspan="1" align="center">';
	print $form->selectarray('search_unit_type', $unit_type->getNames(), $search_unit_type, 1, 0, 0, 'required="required"');
	print '</td>';

	// ACTION
	print '<td align="right" style="min-width:62px;">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';

	print "</tr>\n";

	// Lines
	if (count($machine->rows)) {
		//$createdBy = new User($db);
		foreach($machine->rows as $obj) {
			  $code 			= $obj->code ;
			  $type 			= $obj->type ;
			 // $type_machine 	= $type_machines[$obj->type_machine] ;
			  $serie 			= $obj->serie ;
			  $regigster_num 	= $obj->regigster_num ;
			  $year 			= $obj->year ;
			  $chassis_num 	    = $obj->chassis_num ;
			  $avg_consomation  = $obj->avg_consomation ;
			  $location_rate 	= $obj->location_rate ;
			  $immo_rate 		= $obj->immo_rate ;
			  $unit_type->fetch($obj->unit_type_id) ;
			

			print '<tr '.$bc[$var].'>';
			print '<td align="left" style ="white-space: nowrap;">';
				print $machine->getNomUrl(1,  $obj->id, $code);
			print '</td>';
			 
			//print '<td align="center">'.$type_machine.'</td>';
			print '<td align="center">'.$type.'</td>';
			print '<td align="center">'. $serie .'</td>';
			print '<td align="center">'. $regigster_num .'</td>';
			print '<td align="center">'. $year .'</td>';
			print '<td align="center">'. $chassis_num .'</td>';
			print '<td align="center">'. $avg_consomation .'</td>';
			print '<td align="center">'. $location_rate .'</td>';
			print '<td align="center">'. $immo_rate .'</td>';
			print '<td align="center">'. $unit_type->getNomUrl('1') .'</td>';
			print '<td align="center"></td>';

			print '</tr>'."\n";

		}
	} else {
		print '<tr>';
	    print '<td colspan="9" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';
	}

	print '</table>';
	print '</form>';

	

}

llxFooter();

$db->close();


?>