<?php 
/* Copyright (C) 2016		Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *   	\file       marches/list.php
 *		\ingroup    list
 *		\brief      Gestion des marches
 */

require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/material/oc_cats/class/oc_cats.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/material/intern_orders/class/intern_orders.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/settings/unit_type/class/unitType.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/material/oc_cats_items/class/oc_cats_items.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/machine.lib.php';

// Get parameters
$action  = GETPOST('action', 'alpha');
$id      = GETPOST('id', 'int');
$did 	 = GETPOST('did', 'int');
$request_method = $_SERVER['REQUEST_METHOD'];

//$langs->load('marches');
// Protection if external user
if ($user->societe_id > 0) accessforbidden();

$now 	= new DateTime('now');
$now       = $now->format('Y-m-d');
$form       = new Form($db);
$error 	= false;

if ($action == 'create' && $request_method === 'POST') {
	$oc_cats = new oc_cats($db);

    if (!$error) {
          $oc_cats->name            = trim(GETPOST('name_'));
          $oc_cats->qty            = trim(GETPOST('qty_'));
          $oc_cats->inten_order_id   = (int)$did;
          $oc_cats->unit_type_id     = trim(GETPOST('unit_type_id_'));
          $oc_cats->oc_cat_item_id     = trim(GETPOST('oc_cat_item_id_'));
          $oc_cats->created_by     = $user->id;
            //if(!$oc_cats->check_mat($oc_cats->mat)){
                    $oc_catsID = $oc_cats->create();
            
                    // If no SQL error we redirect to the request card
                    if ($oc_catsID > 0) {
                        //header('Location: index.php?id='.$getMarcheID);
                        header('Location: index.php?did='.$did);
                        exit;
                    } else {
                        // Otherwise we display the request form with the SQL error message
                        header('Location: card.php?action=request&error=SQL_Create&msg='.$oc_cats->error);
                        exit;
                    }
               /* }
            else{
                $msg ='Cette marticule '.$oc_cats->mat.' est deja saisée !';
                 header('Location: card.php?action=request&error=SQL_Create&msg='.$msg);
                        exit;
            }*/
    }
}

if ($action == 'update' && $request_method === 'POST') {
    // If no right to modify a request
    /*if (!$user->rights->marches->write) {
        header('Location: ./card.php?action=request&error=CantUpdate');
        exit;
    }*/

    $oc_cats_id = (int) GETPOST('oc_cats_id', 'int');

    if (!$oc_cats_id || $oc_cats_id <= 0) {
        header('Location: ./card.php?action=request&error=CantUpdate');
        exit;
    }

    $oc_cats = new oc_cats($db);
    $oc_cats->fetch($oc_cats_id);

   // $canedit = ($user->rights->marches->write || $user->rights->marches->write_all);
    $canedit = true ; 


    // If this is the requestor or has read/write rights
    if ($canedit) {
        
        $data = array(
          'name'  =>trim(GETPOST('name_')),
          'qty'  =>trim(GETPOST('qty_')),
          'inten_order_id' =>(int)$did,
          'unit_type_id' =>trim(GETPOST('unit_type_id_')),
          'oc_cat_item_id' =>trim(GETPOST('oc_cat_item_id_')),
          'updated_at'    =>$now
        );

		$getoc_catsID = $oc_cats->update($oc_cats_id, $data);
        
                if ($getoc_catsID > 0) {
                    header('Location: ./index.php?id='.$oc_cats_id.'&did='.$did);
                    exit;
                } else {
                    // Otherwise we display the request form with the SQL error message
                    header('Location: ./card.php?id='. $oc_cats_id .'&action=edit&error=SQL_Create&msg='.$oc_cats->error);
                    exit;
                } 
    }
}

// If delete of request
if ($action == 'confirm_delete' && GETPOST('confirm') == 'yes' ) {
	$error=0;

	//$db->begin();

	$event  = new oc_cats($db);
	//$canedit = ($user->rights->marches->write_all || $user->rights->marches->delete);
    $canedit = true;
	// Si l'utilisateur à le droit de lire ce contrat, il peut le supprimer
	if ($canedit) {
        $event->fetch($id);
		$event->delete();
	}
	else {
		$error = $langs->trans('ErrorCantDelete');
	}

	if (!$error) {
		//$db->commit();
		header('Location: index.php?did='.$did);
		exit;
	}
	else {
		
        header('Location: index.php?leftmenu=marches');
        exit;
	}
}

/*
 * View
 */

$form      = new Form($db);
$oc_cats     = new oc_cats($db);
$intern_orders     = new intern_orders($db);
$unit_type     = new UnitType($db);
$oc_cat_item     = new oc_cats_items($db);

$morejs  = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.js", "/btp/js/jquery/timepicker/timepicker-fr.js","/btp/js/fuel_consoma.js");
$morecss = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.css");

llxHeader(array(), $langs->trans('oc_cats'),'','','','',$morejs,$morecss,0,0);
$intern_orders->fetch($did);
    $intern  = demande_prepare_head($intern_orders);
    dol_fiche_head($intern, 'oc_cats', $langs->trans("oc_cats"), 0, '');
if (empty($id) || $action == 'add' || $action == 'request' || $action == 'create') {
	// Si l'utilisateur n'a pas le droit de créer un marché
    /*if (empty($user->rights->marches->write) || empty($user->rights->marches->write_all)) {
        $errors[]=$langs->trans('CantCreate');
    }
    else {*/
        // Formulaire appel d'offre
        print_fiche_titre($langs->trans('Addoc_cats'));

        // Si il y a une erreur
        if (GETPOST('error')) {
            switch(GETPOST('error')) {
                case 'nobudget' :
                    $errors[] = $langs->trans('errorNoBudget');
                    break;
                case 'SQL_Create' :
                    $errors[] = $langs->trans('ErrorSQLCreateCP').' <b>'.htmlentities($_GET['msg']).'</b>';
                    break;
                case 'CantCreate' :
                    $errors[] = $langs->trans('CantCreateCP');
                    break;
                case 'nouser' :
                    $errors[] = $langs->trans('errorNoUser');
                    break;
                case 'nodatedebut' :
                    $errors[] = $langs->trans('NoDateDebut');
                    break;
                case 'nobank' :
                    $errors[] = $langs->trans('errorNoBank');
                    break;
                case 'noqc' :
                    $errors[] = $langs->trans('errorNoQc');
                    break;
                case 'alreadyExists' :
                    $errors[] = $langs->trans('alreadyExistAO');
                    break;
                case 'noref' :
                    $errors[] = $langs->trans('errorNoRef');
                    break;
            }

	        setEventMessage($errors, 'errors');
        }

        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'?did='.$did.'">'."\n";
        print '<input type="hidden" name="action" value="create" />'."\n";

        print '<table class="border" width="100%">';
        print '<tbody>';

         //nom  
        print '<tr><td class="fieldrequired">'.$langs->trans("name").'</td><td>';
        print '<input type="text" value="" name="name_" required="required" />';
        print '</td></tr>';

        //produit
        print '<tr><td>'.$langs->trans("oc_cats_items").'</td><td>'; 
        $const_sites = $oc_cat_item->getNames();
        print $form->selectarray('oc_cat_item_id_', $const_sites,(GETPOST('oc_cat_item_id_') ? GETPOST('oc_cat_item_id_') : null), 0, 0, 0, 'required="required"');
        print '</td></tr>';
       
        //unité 
        print '<tr><td>'.$langs->trans("unit_type").'</td><td>'; 
        $mark_oc_catss = $unit_type->getNames();
        print $form->selectarray('unit_type_id_', $mark_oc_catss,(GETPOST('unit_type_id_') ? GETPOST('unit_type_id_') : null), 0, 0, 0, 'required="required"');
        print '</td></tr>';


        //Quantité  
        print '<tr><td class="fieldrequired">'.$langs->trans("qty").'</td><td>';
        print '<input type="number" min="0" value="" name="qty_" required="required" />';
        print '</td></tr>';


        
        print '</tbody>';
        print '</table>';

        print '<div class="center">';
        print '<input type="submit" value="'. $langs->trans("Createoc_cats") .'" name="bouton" class="butAction">';
        print '&nbsp; &nbsp; ';
        print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
        print '</div>';
        print '</form>';
    //}
}
else {
    if ($error) {
        print '<div class="tabBar">';
        print $error;
        print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
        print '</div>';
    }
    else {
        // Affichage de la fiche d'une demande de congés payés

        if ($id > 0) {
            $oc_cats->fetch($id);

			//$canedit = ($user->rights->marches->delete || $user->rights->marches->write_all);

            // Si il y a une erreur
            if (GETPOST('error')) {
                switch(GETPOST('error')) {
                    case 'datefin' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorEndDateCP');
                        break;
                    case 'SQL_Create' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorSQLCreateCP').' '.$_GET['msg'];
                        break;
                    case 'CantCreate' :
                        $errors[] = $langs->transnoentitiesnoconv('CantCreateCP');
                        break;
                    case 'Valideur' :
                        $errors[] = $langs->transnoentitiesnoconv('InvalidValidatorCP');
                        break;
                    case 'nodatedebut' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateDebut');
                        break;
                    case 'nodatefin' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateFin');
                        break;
                    case 'DureeHoliday' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorDureeCP');
                        break;
                    case 'NoMotifRefuse' :
                        $errors[] = $langs->transnoentitiesnoconv('NoMotifRefuseCP');
                        break;
                    case 'mail' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorMailNotSend')."\n".$_GET['error_content'];
                        break;
                }

	            setEventMessage($errors, 'errors');
            }

            // On vérifie si l'utilisateur à le droit de lire cette demande
           // if ($canedit) {

                // Si annulation de la demande
                if ($action == 'cancel') {
                    print $form->formconfirm("card.php?id=".$id, $langs->trans("TitleCancelSC"), $langs->trans("ConfirmCancelSC"),"confirm_cancel", '', 1, 1);
                }

                dol_fiche_head('', 'oc_catss', $langs->trans("oc_cats"), 0, '');

                if ($action == 'edit') {
                    $edit = true;
                    print '<form method="post" action="'.$_SERVER['PHP_SELF'].'?id='.$id.'&did='.$did.'">'."\n";
                    print '<input type="hidden" name="action" value="update" />'."\n";
                    print '<input type="hidden" name="oc_cats_id" value="'.$id.'" />'."\n";

                    print '<table class="border" width="100%">';
                    print '<tbody>';

        //nom  
        print '<tr><td class="fieldrequired">'.$langs->trans("name").'</td><td>';
        print '<input type="text" value="'.$oc_cats->name.'" name="name_" required="required" />';
        print '</td></tr>';


        //produit
        print '<tr><td>'.$langs->trans("oc_cats_items").'</td><td>'; 
        $const_sites = $oc_cat_item->getNames();
        print $form->selectarray('oc_cat_item_id_', $const_sites,(GETPOST('oc_cat_item_id_') ? GETPOST('oc_cat_item_id_') : $oc_cats->oc_cat_item_id), 0, 0, 0, 'required="required"');
       print '</td></tr>';

        //Engin 
        print '<tr><td>'.$langs->trans("unit_type").'</td><td>'; 
        $mark_oc_catss = $unit_type->getNames();
        print $form->selectarray('unit_type_id_', $mark_oc_catss,(GETPOST('unit_type_id_') ? GETPOST('unit_type_id_') : $oc_cats->unit_type_id), 0, 0, 0, 'required="required"');
        print '</td></tr>';

        //Quantité  
        print '<tr><td class="fieldrequired">'.$langs->trans("qty").'</td><td>';
        print '<input type="number" min="0" value="'.$oc_cats->qty.'" name="qty_" required="required" />';
        print '</td></tr>';



                    print '</tbody>';
                    print '</table>';

                    print '<div class="center">';
                    print '<input type="submit" value="'. $langs->trans("Modify") .'" name="bouton" class="butAction">';
                    print '&nbsp; &nbsp; ';
                    print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
                    print '</div>';
                    print '</table>';
                }

                dol_fiche_end();

                if (!$edit) {
		            print '<div class="tabsAction">';

                    // Boutons d'actions
                    //if ($canedit) {
                        print '<a href="card.php?id='.$_GET['id'].'&action=edit" class="butAction">'.$langs->trans("Modify").'</a>';
                    //}

                    // If draft
                   // if ($user->rights->marches->delete)	{
                    	print '<a href="card.php?id='.$_GET['id'].'&action=delete" class="butActionDelete">'.$langs->trans("Delete").'</a>';
                   // }

                    print '</div>';
                }

        } else {
                
                print '<div class="tabBar">';
                print $langs->trans('ErrorUserViewSC');
                print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
                print '</div>';
            }

        /*} else {
            print '<div class="tabBar">';
            print $langs->trans('ErrorIDFicheSC');
            print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
            print '</div>';
        }*/

    }

}

// End of page
llxFooter();

if (is_object($db)) $db->close();

?>