<?php 
/* Copyright (C) 2016		Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *   	\file       marches/list.php
 *		\ingroup    list
 *		\brief      Gestion des marches
 */

require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/material/reception_products/class/reception_products.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/material/receptions/class/receptions.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/settings/unit_type/class/unitType.class.php';
include_once DOL_DOCUMENT_ROOT.'/product/class/product.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/machine.lib.php';


// Get parameters
$action  = GETPOST('action', 'alpha');
$id 	 = GETPOST('id', 'int');
$rid      = GETPOST('rid','int');
$request_method = $_SERVER['REQUEST_METHOD'];

//$langs->load('marches');
// Protection if external user
if ($user->societe_id > 0) accessforbidden();

$now 	= new DateTime('now');
$now       = $now->format('Y-m-d');
$form       = new Form($db);
$error 	= false;

if ($action == 'create' && $request_method === 'POST') {
	$reception_products = new reception_products($db);

    if (!$error) {
          $reception_products->designation            = trim(GETPOST('designation_'));
          $reception_products->price            = trim(GETPOST('price_'));
          $reception_products->discount            = trim(GETPOST('discount_'));
          $reception_products->qty            = trim(GETPOST('qty_'));
          $reception_products->product_id   = trim(GETPOST('product_id_'));
          $reception_products->unit_type_id     = trim(GETPOST('unit_type_id_'));
          $reception_products->reception_id  = (int)$rid;
          $reception_products->created_by     = $user->id;
            //if(!$reception_products->check_mat($reception_products->mat)){
                    $reception_productsID = $reception_products->create();
            
                    // If no SQL error we redirect to the request card
                    if ($reception_productsID > 0) {
                        //header('Location: index.php?id='.$getMarcheID);
                        header('Location: index.php?rid='.$rid);
                        exit;
                    } else {
                        // Otherwise we display the request form with the SQL error message
                        header('Location: card.php?action=request&error=SQL_Create&msg='.$reception_products->error);
                        exit;
                    }
               /* }
            else{
                $msg ='Cette marticule '.$reception_products->mat.' est deja saisée !';
                 header('Location: card.php?action=request&error=SQL_Create&msg='.$msg);
                        exit;
            }*/
    }
}

if ($action == 'update' && $request_method === 'POST') {
    // If no right to modify a request
    /*if (!$user->rights->marches->write) {
        header('Location: ./card.php?action=request&error=CantUpdate');
        exit;
    }*/

    $reception_products_id = (int) GETPOST('reception_products_id', 'int');

    if (!$reception_products_id || $reception_products_id <= 0) {
        header('Location: ./card.php?action=request&error=CantUpdate');
        exit;
    }

    $reception_products = new reception_products($db);
    $reception_products->fetch($reception_products_id);

   // $canedit = ($user->rights->marches->write || $user->rights->marches->write_all);
    $canedit = true ; 


    // If this is the requestor or has read/write rights
    if ($canedit) {
        $designation = '';
        $data = array(
          'designation'  =>trim(GETPOST('designation_')),
          'price'    =>trim(GETPOST('price_')),
          'discount'    =>trim(GETPOST('discount_')),
          'qty'  =>trim(GETPOST('qty_')),
          'product_id' =>trim(GETPOST('product_id_')),
          'unit_type_id' =>trim(GETPOST('unit_type_id_')),
          'reception_id'  =>(int)$rid,
          'updated_at'    =>$now
        );

		$getreception_productsID = $reception_products->update($reception_products_id, $data);
        
                if ($getreception_productsID > 0) {
                    header('Location: ./index.php?id='.$reception_products_id.'&rid='.$rid);
                    exit;
                } else {
                    // Otherwise we display the request form with the SQL error message
                    header('Location: ./card.php?id='. $reception_products_id .'&action=edit&error=SQL_Create&msg='.$reception_products->error);
                    exit;
                } 
    }
}

// If delete of request
if ($action == 'confirm_delete' && GETPOST('confirm') == 'yes' ) {
	$error=0;

	//$db->begin();

	$event  = new reception_products($db);
	//$canedit = ($user->rights->marches->write_all || $user->rights->marches->delete);
    $canedit = true;
	// Si l'utilisateur à le droit de lire ce contrat, il peut le supprimer
	if ($canedit) {
        $event->fetch($id);
		$event->delete();
	}
	else {
		$error = $langs->trans('ErrorCantDelete');
	}

	if (!$error) {
		//$db->commit();
		header('Location: index.php?rid='.$rid);
		exit;
	}
	else {
		
        header('Location: index.php?leftmenu=marches');
        exit;
	}
}

/*
 * View
 */

$form      = new Form($db);
$reception_products     = new reception_products($db);
$receptions     = new receptions($db);
$unit_type     = new UnitType($db);
$produit   = new product($db);

$morejs  = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.js", "/btp/js/jquery/timepicker/timepicker-fr.js","/btp/js/fuel_consoma.js");
$morecss = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.css");

llxHeader(array(), $langs->trans('reception_products'),'','','','',$morejs,$morecss,0,0);
$receptions->fetch($rid);
    $reception  = receptions_prepare_head($receptions);
    dol_fiche_head($reception, 'reception_products', $langs->trans("reception_products"), 0, '');
if (empty($id) || $action == 'add' || $action == 'request' || $action == 'create') {
	// Si l'utilisateur n'a pas le droit de créer un marché
    /*if (empty($user->rights->marches->write) || empty($user->rights->marches->write_all)) {
        $errors[]=$langs->trans('CantCreate');
    }
    else {*/
        // Formulaire appel d'offre
        print_fiche_titre($langs->trans('Addreception_products'));

        // Si il y a une erreur
        if (GETPOST('error')) {
            switch(GETPOST('error')) {
                case 'nobudget' :
                    $errors[] = $langs->trans('errorNoBudget');
                    break;
                case 'SQL_Create' :
                    $errors[] = $langs->trans('ErrorSQLCreateCP').' <b>'.htmlentities($_GET['msg']).'</b>';
                    break;
                case 'CantCreate' :
                    $errors[] = $langs->trans('CantCreateCP');
                    break;
                case 'nouser' :
                    $errors[] = $langs->trans('errorNoUser');
                    break;
                case 'nodatedebut' :
                    $errors[] = $langs->trans('NoDateDebut');
                    break;
                case 'nobank' :
                    $errors[] = $langs->trans('errorNoBank');
                    break;
                case 'noqc' :
                    $errors[] = $langs->trans('errorNoQc');
                    break;
                case 'alreadyExists' :
                    $errors[] = $langs->trans('alreadyExistAO');
                    break;
                case 'noref' :
                    $errors[] = $langs->trans('errorNoRef');
                    break;
            }

	        setEventMessage($errors, 'errors');
        }

        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'?rid='.$rid.'">'."\n";
        print '<input type="hidden" name="action" value="create" />'."\n";

        print '<table class="border" width="100%">';
        print '<tbody>';

        //designation
        print '<tr><td class="fieldrequired">'.$langs->trans("designation").'</td><td>';
        print '<input type="text" name="designation_" required="required" /> ';
        print '</td></tr>';

        //produit
        print '<tr><td>'.$langs->trans("product").'</td><td>'; 
        print $form->select_produits_list(null,'product_id_', 0, 30, 0, '', -1, 2);
        print '</td></tr>';
       
         //Numéro
        print '<tr><td class="fieldrequired">'.$langs->trans("price").'</td><td>';
        print '<input type="number" value="" name="price_" required="required" />';
        print '</td></tr>';

//Numéro
        print '<tr><td class="fieldrequired">'.$langs->trans("discount").'</td><td>';
        print '<input type="number" min="0" max="99" value="" name="discount_" required="required" />%';
        print '</td></tr>';


        //unité 
        print '<tr><td>'.$langs->trans("unit_type").'</td><td>'; 
        $mark_reception_productss = $unit_type->getNames();
        print $form->selectarray('unit_type_id_', $mark_reception_productss,(GETPOST('unit_type_id_') ? GETPOST('unit_type_id_') : null), 0, 0, 0, 'required="required"');
        print '</td></tr>';


        //Quantité  
        print '<tr><td class="fieldrequired">'.$langs->trans("qty").'</td><td>';
        print '<input type="number" value="" name="qty_" required="required" />';
        print '</td></tr>';


        //Chantier 
       /* print '<tr><td>'.$langs->trans("receptions").'</td><td>'; 
        $const_sites = $receptions->getNames();
        print $form->selectarray('reception_id_', $const_sites,(GETPOST('reception_id_') ? GETPOST('reception_id_') : null), 0, 0, 0, 'required="required"');
        print '</td></tr>';*/

        
        print '</tbody>';
        print '</table>';

        print '<div class="center">';
        print '<input type="submit" value="'. $langs->trans("Createreception_products") .'" name="bouton" class="butAction">';
        print '&nbsp; &nbsp; ';
        print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
        print '</div>';
        print '</form>';
    //}
}
else {
    if ($error) {
        print '<div class="tabBar">';
        print $error;
        print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
        print '</div>';
    }
    else {
        // Affichage de la fiche d'une demande de congés payés

        if ($id > 0) {
            $reception_products->fetch($id);

			//$canedit = ($user->rights->marches->delete || $user->rights->marches->write_all);

            // Si il y a une erreur
            if (GETPOST('error')) {
                switch(GETPOST('error')) {
                    case 'datefin' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorEnddesignationP');
                        break;
                    case 'SQL_Create' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorSQLCreateCP').' '.$_GET['msg'];
                        break;
                    case 'CantCreate' :
                        $errors[] = $langs->transnoentitiesnoconv('CantCreateCP');
                        break;
                    case 'Valideur' :
                        $errors[] = $langs->transnoentitiesnoconv('InvalidValidatorCP');
                        break;
                    case 'nodatedebut' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateDebut');
                        break;
                    case 'nodatefin' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateFin');
                        break;
                    case 'DureeHoliday' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorDureeCP');
                        break;
                    case 'NoMotifRefuse' :
                        $errors[] = $langs->transnoentitiesnoconv('NoMotifRefuseCP');
                        break;
                    case 'mail' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorMailNotSend')."\n".$_GET['error_content'];
                        break;
                }

	            setEventMessage($errors, 'errors');
            }

            // On vérifie si l'utilisateur à le droit de lire cette demande
           // if ($canedit) {

                // Si annulation de la demande
                if ($action == 'cancel') {
                    print $form->formconfirm("card.php?id=".$id, $langs->trans("TitleCancelSC"), $langs->trans("ConfirmCancelSC"),"confirm_cancel", '', 1, 1);
                }

                dol_fiche_head('', 'reception_productss', $langs->trans("reception_products"), 0, '');

                if ($action == 'edit') {
                    $edit = true;
                    print '<form method="post" action="'.$_SERVER['PHP_SELF'].'?id='.$id.'&rid='.$rid.'">'."\n";
                    print '<input type="hidden" name="action" value="update" />'."\n";
                    print '<input type="hidden" name="reception_products_id" value="'.$id.'" />'."\n";

                    print '<table class="border" width="100%">';
                    print '<tbody>';

        //designation
        print '<tr><td class="fieldrequired">'.$langs->trans("designation").'</td><td>';
        print '<input type="text" value="'.$reception_products->designation.'"  name="designation_" required="required" /> ';
        print '</td></tr>';

        //produit
        print '<tr><td>'.$langs->trans("product").'</td><td>'; 
        print $form->select_produits_list($reception_products->product_id,'product_id_', 0, 30, 0, '', -1, 2);
        print '</td></tr>';

        //Numéro
        print '<tr><td class="fieldrequired">'.$langs->trans("price").'</td><td>';
        print '<input type="number" value="'.$reception_products->price.'" name="price_" required="required" />';
        print '</td></tr>';
            
        //Numéro
        print '<tr><td class="fieldrequired">'.$langs->trans("discount").'</td><td>';
        print '<input type="number" min="0" max="99" value="'.$reception_products->discount.'" name="discount_" required="required" />%';
        print '</td></tr>';
            


        //Engin 
        print '<tr><td>'.$langs->trans("unit_type").'</td><td>'; 
        $mark_reception_productss = $unit_type->getNames();
        print $form->selectarray('unit_type_id_', $mark_reception_productss,(GETPOST('unit_type_id_') ? GETPOST('unit_type_id_') : $reception_products->unit_type_id), 0, 0, 0, 'required="required"');
        print '</td></tr>';

        //Quantité  
        print '<tr><td class="fieldrequired">'.$langs->trans("qty").'</td><td>';
        print '<input type="number" value="'.$reception_products->qty.'" name="qty_" required="required" />';
        print '</td></tr>';


        //Chantier 
       /* print '<tr><td>'.$langs->trans("receptions").'</td><td>'; 
        $const_sites =  $receptions->getNames();
        print $form->selectarray('reception_id_', $const_sites,(GETPOST('reception_id_') ? GETPOST('reception_id_') : $reception_products->reception_id), 0, 0, 0, 'required="required"');
        print '</td></tr>';*/

       


                    print '</tbody>';
                    print '</table>';

                    print '<div class="center">';
                    print '<input type="submit" value="'. $langs->trans("Modify") .'" name="bouton" class="butAction">';
                    print '&nbsp; &nbsp; ';
                    print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
                    print '</div>';
                    print '</table>';
                }

                dol_fiche_end();

                if (!$edit) {
		            print '<div class="tabsAction">';

                    // Boutons d'actions
                    //if ($canedit) {
                        print '<a href="card.php?id='.$_GET['id'].'&action=edit" class="butAction">'.$langs->trans("Modify").'</a>';
                    //}

                    // If draft
                   // if ($user->rights->marches->delete)	{
                    	print '<a href="card.php?id='.$_GET['id'].'&action=delete" class="butActionDelete">'.$langs->trans("Delete").'</a>';
                   // }

                    print '</div>';
                }

        } else {
                
                print '<div class="tabBar">';
                print $langs->trans('ErrorUserViewSC');
                print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
                print '</div>';
            }

        /*} else {
            print '<div class="tabBar">';
            print $langs->trans('ErrorIDFicheSC');
            print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
            print '</div>';
        }*/

    }

}

// End of page
llxFooter();

if (is_object($db)) $db->close();

?>