<?php
require_once DOL_DOCUMENT_ROOT . '/core/class/commonobject.class.php';

class reception_products extends Commonobject{

	/**
	 * @var string Error code (or message)
	 * @deprecated
	 * @see test::errors
	 */
	public $error;
	/**
	 * @var string[] Error codes (or messages)
	 */
	public $errors = array();

  public $designation;
  public $price;
  public $discount;
  public $qty;
  public $product_id 	;
  public $unit_type_id ;
  public $reception_id	 ;
  public $created_by ;
  public $created_at ;
  public $updated_at ;
  public $rows = array();

	public $now;
	/**
	 * Constructor
	 *
	 * @param DoliDb $db Database handler
	 */
	public function __construct(DoliDBMysqli $db)
	{
		$this->db 		 = $db;
		$this->now 		 = new \DateTime("now");
		$this->now 		 = $this->now->format('Y-m-d');
		return 1;
	}


	/**
     *	Return clicable mat (with picto eventually)
     *
     *  @author Yassine Belkaid <y.belkaid@nextconcept.ma>
     *	@param		int			$withpicto		0=_No picto, 1=Includes the picto in the linkn, 2=Picto only
     *	@return		string						String with URL
     */
    public function getNomUrl($withpicto = 0,  $id = null,$rid, $ref = null)
    {
        global $langs;
        if(!$rid) return false;
        $result	= '';
        $setRef = (null !== $ref) ? $ref : '';
        $id  	= ($id  ?: '');
        $label  = $langs->trans("Show").': '. $setRef;

        $link 	 = '<a href="'.DOL_URL_ROOT.'/btp/material/reception_products/index.php?id='. $id .'&rid='.$rid.'" title="'.dol_escape_htmltag($label, 1).'" class="classfortooltip">';
        $linkend ='</a>';
        $picto   = '';

        if ($withpicto) $result.=($link.img_object($label, $picto, 'class="classfortooltip"').$linkend);
        if ($withpicto && $withpicto != 2) $result.=' ';
        if ($withpicto != 2) $result.=$link.$setRef.$linkend;
        return $result;
    }

    /**
	 * Create object into database
	 *
	 * @return int   id of last inserted id, otherwise -1 if error arised 
	 */
	public function create()
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		// Clean parameters
	  $this->designation= $this->designation ? $this->db->escape($this->designation): null;
	  $this->price = $this->price ? $this->db->escape($this->price): null;
	  $this->discount = $this->discount ? $this->db->escape($this->discount): null;
	  $this->qty = $this->qty ? $this->db->escape($this->qty): null;
	  $this->product_id = $this->product_id ? $this->db->escape($this->product_id): null;
	  $this->unit_type_id = $this->unit_type_id ? $this->db->escape($this->unit_type_id): null;
	  $this->reception_id	= $this->reception_id ? $this->db->escape($this->reception_id): null;
	  $this->created_by = $this->created_by ? $this->db->escape($this->created_by): null;
	  $this->created_at = $this->now;
	// Insert request
	$sql = 'INSERT INTO ' . MAIN_DB_PREFIX . 'reception_products' . ' (designation,price,discount,qty,';
	$sql .= 'product_id,unit_type_id,reception_id,created_by,created_at,updated_at) ';
	$sql .= 'VALUES ("'.$this->designation.'",'.$this->price.', '.$this->discount.', ';
	$sql .=	 $this->qty.','.$this->product_id.', '.$this->unit_type_id.', ';
	$sql .=	 $this->reception_id.', '.$this->created_by.','.$this->created_at.',NULL)';
	//die($sql);
	$this->db->begin();
		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error reception_products ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);
			var_dump($errors);
			die();
			return -1;
		} else {
			$this->db->commit();
			return 1;
			//return $this->getLasInsrtedId();
		}
	}

/**
	 * Load object in memory from the database
	 *
	 * @param int    $id  Id object
	 * @param string $ref Ref
	 *
	 * @return int <0 if KO, 0 if not found, >0 if OK
	 */
	public function fetch($id, $ref = null)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . 'reception_products';
		
		if (null !== $ref) {
			$sql .= ' WHERE ref = ' . '\'' . $ref . '\'';
		} else {
			$sql .= ' WHERE rowid = ' . $id;
		}

		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			if ($numrows) {
			  $obj 					= $this->db->fetch_object($resql);
			  $this->id 			= $obj->rowid ;
			  $this->designation 			= $obj->designation ;
			  $this->price 			= $obj->price ;
			  $this->discount 			= $obj->discount ;
			  $this->qty            = $obj->qty ;
			  $this->product_id   = $obj->product_id ;
			  $this->unit_type_id 	= $obj->unit_type_id ;
			  $this->reception_id	= $obj->reception_id ;
			  $this->created_by 	= $obj->created_by ;
			  $this->created_at 	= $this->db->jdate($obj->created_at);

			}

			$this->db->free($resql);

			if ($numrows) {
				return 1;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}


	/**
	 * Load object in memory from the database
	 *
	 * @param string $sortorder Sort Order
	 * @param string $sortfield Sort field
	 * @param int    $limit     offset limit
	 * @param int    $offset    offset limit
	 * @param array  $filter    filter array
	 * @param string $filtermode filter mode (AND or OR)
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function fetchAll($sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '', $filtermode = 'AND')
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM '. MAIN_DB_PREFIX . 'reception_products';

		if (!empty($filter)) {
			$sql .= ' WHERE '. substr($filter, 4);
		}
		
		if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}

		$this->rows = array();
		$resql 		 = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;
				  $line->id 			= $obj->rowid;
				  $line->designation 			= $obj->designation ;
				  $line->price 			= $obj->price ;
				  $line->discount 			= $obj->discount ;
				  $line->qty            = $obj->qty ;
				  $line->product_id 	= $obj->product_id ;
				  $line->unit_type_id 	= $obj->unit_type_id ;
				  $line->reception_id	= $obj->reception_id ;
				  $line->created_by 	= $obj->created_by ;
				  $line->created_at 	= $this->db->jdate($obj->created_at);
				$this->rows[] = $line;
			}
			$this->db->free($resql);

			return $num;
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}



	/**
	 * Update object into database
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function update($id, array $data)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$id || $id <= 0)
			return false;

		// Update request
		$sql = 'UPDATE ' . MAIN_DB_PREFIX . 'reception_products' . ' SET ';

		if (count($data) && is_array($data))
			foreach ($data as $key => $val) {
				$val = is_numeric($val) ? $val : '"'. $val .'"';
				$sql .= '`'. $key. '` = '. $val .',';
			}
			$now = new \DateTime("now");
			$now 		 = $now->format('Y-m-d');
			$sql .= '`updated_at` = '. $now ;

		//$sql  = substr($sql, 0, -1);
		$sql .= ' WHERE rowid = ' . $id;

		$this->db->begin();

		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();
			
			$this->error 	= 'Error ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}


	/**
	 * Delete object in database
	 *
	 * @param User $user      User that deletes
	 * @param bool $notrigger false=launch triggers after, true=disable triggers
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function delete()
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$this->db->begin();

		$sql 	= 'DELETE FROM ' . MAIN_DB_PREFIX . 'reception_products' .' WHERE rowid = ' . $this->id;
		$resql 	= $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}



    public function check_mat($mat)
    {
    	$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . 'reception_products WHERE mat ="'.$mat.'"';
    	$resql 		 = $this->db->query($sql);
		if ($resql) {
			$num = $this->db->num_rows($resql);
			if($num > 0)
				return true;
			$this->db->free($resql);
    	}

    	return false;
    }

    public function getMat($id)
    {
    	$sql = 'SELECT mat FROM ' . MAIN_DB_PREFIX . 'reception_products WHERE rowid='.$id;
    	$resql = $this->db->query($sql);
    	$mat = '';
		if ($resql) {
			while ($obj = $this->db->fetch_object($resql)) {
				$mat = $obj->mat;
			}
			$this->db->free($resql);
    	}

    	return $mat;
    }

    public function getDataByYear($year)
	    {
	    	$sql = 'SELECT MONTH(r.datec) as month, SUM(p.qty*p.price) as total FROM ' . MAIN_DB_PREFIX . 'reception_products p , '; 
	    	$sql .= MAIN_DB_PREFIX . 'receptions r WHERE YEAR(r.datec)= '.$year.' GROUP BY MONTH(r.datec)';
	    	$resql = $this->db->query($sql);
	    	$data = array();
			if ($resql) {
				while ($obj = $this->db->fetch_object($resql)) {
					$data[$obj->month] = $obj->total;
				}
				$this->db->free($resql);
	    	}

	    	return $data;
	    }




}
?>