<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file       appeloffres/index.php
 * \ingroup    list
 * \brief      List of markets
 */
require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/material/reception_products/class/reception_products.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/material/receptions/class/receptions.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/settings/unit_type/class/unitType.class.php';
include_once DOL_DOCUMENT_ROOT.'/product/class/product.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/machine.lib.php';

$form 		= new Form($db);
$reception_products   = new reception_products($db);
$receptions   = new receptions($db);
$unit_type   = new UnitType($db);
$produit   = new product($db);
$var = false;
$filter = '';
$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
if (! $sortfield) $sortfield = "rowid";
if (! $sortorder) $sortorder = "DESC";
$action  = GETPOST('action', 'alpha');
$id 	  = GETPOST('id','int');
$rid 	  = GETPOST('rid','int');
$search_designation      		= GETPOST('search_designation');
$search_price      		= GETPOST('search_price');
$search_discount    		= GETPOST('search_discount');
$search_product    		= GETPOST('search_product');
$search_qty    		= GETPOST('search_qty');
$search_unit_type    		= GETPOST('search_unit_type');
$search_reception    		= GETPOST('search_reception');
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
$search_designation      		= '';
$search_price      		= '';
$search_type    		= '';
$search_product    		= '';
$search_qty    		= '';
$search_unit_type    		= '';
$search_reception    		= '';
}
$filter .= (!empty($search_designation) && $search_designation != -1) ? " AND designation = '". $db->escape($search_designation)."'\n" : "";
$filter .= (!empty($search_price) && $search_price != -1) ? " AND price = ".$db->escape($search_price):"";
$filter .= (!empty($search_discount) && $search_discount != -1) ? " AND discount = ".$db->escape($search_discount):"";
$filter .= (!empty($search_product) && $search_product != -1) ? " AND product_id = ".$db->escape($search_product):"";
$filter .= (!empty($search_qty) && $search_qty != -1) ? " AND qty = ".$db->escape($search_qty):"";
$filter .= (!empty($search_unit_type) && $search_unit_type != -1) ? " AND unit_type_id = ".$db->escape($search_unit_type):"";
$filter .= " AND reception_id = ".$rid;


$getreception_productss = $reception_products->fetchAll($sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter);

// Si erreur SQL
if ($getreception_productss == '-1') {
    print_fiche_titre($langs->trans('ListOfreception_products'), '', 'title_project.png');

    dol_print_error($db, $langs->trans('Error').' '.$reception_products->error);
    exit();
}
if ($id > 0) {
	$reception_products->fetch($id);
	llxHeader('', $langs->trans('reception_products'));
	print_fiche_titre($langs->trans("reception_products"));
	$receptions->fetch($rid);
	$reception  = receptions_prepare_head($receptions);
	dol_fiche_head($reception, 'reception_products', $langs->trans("reception_products"), 0, '');

	print '<table class="border" width="100%">';
	// date
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("designation").'</td>';
	print '<td colspan="2">'. $reception_products->designation .'</td></tr>';
	// num
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("price").'</td>';
	print '<td colspan="2">'. $reception_products->price .'</td></tr>';
	// num
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("discount").'</td>';
	print '<td colspan="2">'. $reception_products->discount .'</td></tr>';
	// quantité
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("qty").'</td>';
	print '<td colspan="2">'. $reception_products->qty .'</td></tr>';
	// lubricant
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("product").'</td>';
	$produit->fetch($reception_products->product_id);
	print '<td colspan="2">'. $produit->getNomUrl('1') .'</td></tr>';
	// unité
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("unit_type").'</td>';
	$unit_type->fetch($reception_products->unit_type_id);
	print '<td colspan="2">'. $unit_type->getNomUrl('1') .'</td></tr>';
	//chantier
	/*print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("receptions").'</td>';
	$receptions->fetch($reception_products->reception_id);
	print '<td colspan="2">'. $receptions->getNomUrl('1') .'</td></tr>';
	*/
	print '</table>';
	print '<br>';
	print '<div style="float: right; margin-top: 8px;">';
	print '<a href="./index.php?rid='. $rid .'" class="butAction">'.$langs->trans('Cancel').'</a>';
		print '<a href="./card.php?action=edit&id='. $id .'&rid='.$rid.'" class="butAction">'.$langs->trans('Modify').'</a>';
		print '<a href="./index.php?action=delete&id='. $id .'&rid='.$rid.'" class="butAction">'.$langs->trans('Delete').'</a>';
	print '</div>';
	if ($action == 'delete') {
                    print $form->formconfirm("card.php?id=".$id."rid=".$rid, $langs->trans("TitleDelete"),$langs->trans("ConfirmDelete"),"confirm_delete", '', 0, 1);
                }
}
else {

 // Both test are required to be compatible with all browsers

llxHeader('', $langs->trans('reception_products'));
print_fiche_titre($langs->trans("ListOfreception_products"));
	$receptions->fetch($rid);
	$reception  = receptions_prepare_head($receptions);
	dol_fiche_head($reception, 'reception_products', $langs->trans("ListOfreception_products"), 0, '');
	$moreparam = '&rid='.$rid;
   	
	//dol_fiche_head('', 'reception_products', $langs->trans("ListOfreception_products"), 1, '');

	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	print '<input name="id" value="'. $id .'" type="hidden" />';
	print '<input name="rid" value="'. $rid .'" type="hidden" />';
	print '<table class="noborder" width="100%;">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("designation"), $_SERVER["PHP_SELF"], 'designation', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("price"),$_SERVER["PHP_SELF"],"price", '',$moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("discount"),$_SERVER["PHP_SELF"],"discount", '',$moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("product"), $_SERVER["PHP_SELF"], 'product_id', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("qty"),$_SERVER["PHP_SELF"], "qty", '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("unit_type"), $_SERVER["PHP_SELF"], 'unit_type_id', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("total"), $_SERVER["PHP_SELF"], '', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'',$moreparam,'',$sortfield,$sortorder,'maxwidthsearch ');
	print "</tr>\n";

	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';
	// designation
	print '<td class="liste_titre" colspan="1" align="center">';
	print '<input class="flat" type="text" style="width: 85px" name="search_designation" value="'.$search_designation.'">';
	print '</td>';
// price
	print '<td class="liste_titre" colspan="1" align="center">';
	print '<input class="flat" type="number" min="0" step="0.01" style="width: 85px" name="search_price" value="'.$search_price.'">';
	print '</td>';
// discount
	print '<td class="liste_titre" colspan="1" align="center">';
	print '<input class="flat" type="number" min="0" step="0.01" style="width: 85px" name="search_discount" value="'.$search_discount.'">';
	print '</td>';

	// product
	print '<td class="liste_titre" olspan="1" align="center">';
	print $form->select_produits_list($search_product,'search_product', 0, 30, 0, '', 0, 2);
        print '</td>';
// qty
	print '<td class="liste_titre" colspan="1" align="center">';
	print '<input class="flat" type="number" min="0" style="width: 85px" name="search_qty" value="'.$search_qty.'">';
	print '</td>';
	// type
	print '<td class="liste_titre" olspan="1" align="center">';
	print $form->selectarray('search_unit_type', $unit_type->getNames(), $search_unit_type, 1, 0, 0, 'required="required"');
	print '</td>';
// total
	print '<td class="liste_titre" olspan="1" align="center">';
	print '</td>';

	// ACTION
	print '<td align="right" style="min-width:62px;">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';

	print "</tr>\n";

	// Lines
	if (count($reception_products->rows)) {
		//$createdBy = new User($db);
		foreach($reception_products->rows as $obj) {
			  $price 				= $obj->price ;
			  $discount 				= $obj->discount ;
			  $designation 			= $obj->designation;
			  $produit->fetch($obj->product_id) ;
			  $qty 	   		    = $obj->qty ;
			  $unit_type->fetch($obj->unit_type_id) ;
			  //$receptions->fetch($obj->reception_id) ;
			

			print '<tr '.$bc[$var].'>';
			print '<td align="left" style ="white-space: nowrap;">';
				print $reception_products->getNomUrl(1,  $obj->id,$rid, $designation);
			print '</td>';
			 
			print '<td align="center">'. $price .'</td>';
			print '<td align="center">'. $discount .'%</td>';
			print '<td align="center">'. $produit->getNomUrl('1') .'</td>';
			print '<td align="center">'. $qty .'</td>';
			print '<td align="center">'. $unit_type->getNomUrl('1') .'</td>';
			$total = $price-($price*($discount/100));
			$total = $total*$qty;
			print '<td align="center">'. $total .'</td>';

			print '</tr>'."\n";

		}
	} else {
		print '<tr>';
	    print '<td colspan="9" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';
	}

	print '</table>';
	print '</form>';


		print '<br>';
		print '<div style="float: right; margin-top: 8px;">';
		print '<a href="./card.php?action=add&rid='.$rid.'" class="butAction">'.$langs->trans('Addreception_products').'</a>';
		print '</div>';


}

llxFooter();

$db->close();


?>