<?php
/* Copyright (C) 2016   Yassine Belkaid <y.belkaid@nextconcept.ma>
 *
 */

/**
 * \file       appeloffres/index.php
 * \ingroup    list
 * \brief      List of markets
 */
require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/btp/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/construction_site/class/construction_site.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/market/class/market.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/btp.lib.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/tools.lib.php';

require_once DOL_DOCUMENT_ROOT.'/btp/market/stock_const/class/stock_const.class.php';
require_once DOL_DOCUMENT_ROOT.'/product/class/product.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/material/stock/class/nb.class.php';
                    
// Protection if external user
if (!$user) accessforbidden();

// Get parameters
$action  = GETPOST('action', 'alpha');
$id 	 = GETPOST('id', 'int');

$request_method = $_SERVER['REQUEST_METHOD'];


$error 	= false;
$form                 = new FormChild($db);
$constructionSite     = new ConstructionSite($db);
$market               = new Market($db);
$product              = new product($db);
$stock_const          = new stock_const($db);
$nb_btp = new Nb($db);


if ($action == 'add_stock' && $request_method === 'POST' ) {
	
    $product_id   = (int)trim($_POST['product_id_']);
    $qty          = (int)trim($_POST['qty_']);
    $pu        = (float)trim($_POST['pu_']);
    $datec        = '';
    if ( $product_id <= 0   || $qty <= 0 || $pu <= 0 || empty($_POST['datec_']) ) {
           $msg ='Remplir tous les champs';
        header("Location: add_stock.php?action=add&cid=".$cid."&msg=Remplir tous les champs");
         setEventMessage($msg, 'errors');
        exit;
    }


    if (isset($_POST['datec_']) && !empty($_POST['datec_'])) {
            list($vtd, $vtm, $vty) = explode("/", $_POST['datec_']);
            $datec_time = trim(GETPOST('datec_time_'));
            $datec      = $vty.'-'.$vtm.'-'.$vtd .' '. $datec_time;
        }
    
        $product->fetch($product_id);
        $product->load_stock();
        
    require_once DOL_DOCUMENT_ROOT .'/product/stock/class/mouvementstock.class.php';
        $movementstock=new MouvementStock($db);

          $result1=$movementstock->_create($user,$product_id,1,"+".trim($qty),1,0,'Correction du stock pour le produit '.$product->ref,'',$datec);
  /* $result1=$product->correct_stock(
                        $user,
                        1,
                        $qty,
                        1,
                        $market->code.'->'.$constructionSite->name,
                        0,
                        $constructionSite->market_id.'-'.$cid
                    );*/
   

    // If no SQL error we redirect to the request card
   if (! $error && $result1 >= 0 )
            {
                $db->commit();
                 $db->commit();
                 if(!empty(GETPOST("NBC_")) || !empty(GETPOST("NBL_")) ){
                    
                    $nb_btp->_create($result1,$pu,GETPOST("NBC_") , GETPOST("NBL_"));

                }
        header('Location: add_stock.php');
         $msg ='Le stock est ajouté';
            setEventMessage($msg);
        exit;
    } else {
        // Otherwise we display the request form with the SQL error message
         $msg ='vérifier tous les champs';
        header("Location: add_stock.php?action=add&cid=".$cid."&msg=Remplir tous les champs");
         setEventMessage($msg, 'errors');
        exit;
    }
}

if ($action == 'update' && $request_method === 'POST' && !empty($_POST['id'])) {
    // If no right to modify a request
    /*if (!$user->rights->marches->write) {
        header('Location: ./card.php?action=request&error=CantUpdate');
        exit;
    }*/
    // $canedit = ($user->rights->marches->write || $user->rights->marches->write_all);
     $stock_const->fetch($id);
     $nb_btp->fetch($id);
    $canedit = true ; 

    // If this is the requestor or has read/write rights
    if ($canedit) {

        $id           = (int)trim($_POST['id']);
        $product_id   = (int)trim($_POST['product_id_']);
        $qty          = (int)trim($_POST['qty_']);
        $pu        = (float)trim($_POST['pu_']);
        $datec        = trim($_POST['datec_']);

         if ( $product_id <= 0 || $qty <= 0 || $pu < 0 || empty($_POST['datec_'])) {
             $msg ='Remplir tous les champs';
            header("Location: add_stock.php?msg=Remplir tous les champs");
            setEventMessage($msg, 'errors');
          exit;
        }
        if (isset($_POST['datec_']) && !empty($_POST['datec_'])) {
            list($vtd, $vtm, $vty) = explode("/", $_POST['datec_']);
            $datec_time = trim(GETPOST('datec_time_'));
            $datec      = $vty.'-'.$vtm.'-'.$vtd .' '. $datec_time;
        }
        $product->fetch($product_id);
        $product->load_stock();
       

        $data = array(
          'datem'         => $datec,
          'value'           => $qty,
          'inventorycode'    => '',
          'fk_product'    => $product_id
        );

		$getstock_constID = $stock_const->update($id, $data);
        
        if ($getstock_constID > 0) {
            if(!empty(GETPOST("NBC_")) || !empty(GETPOST("NBL_")) || $pu > 0 ){
                    $data = array(
                  'pu'     => $pu,
                  'nbc'    => GETPOST("NBC_"),
                  'nbl'    => GETPOST("NBL_")
                );
                    if($nb_btp->id)
                    $nb_btp->update($nb_btp->id,$data);
                    else{
                        $nb_btp->_create($id,$pu,GETPOST("NBC_") , GETPOST("NBL_")); 
                    }
                }
            header('Location: ./add_stock_list.php?id='.$id);
            exit;
        } else {
            // Otherwise we display the request form with the SQL error message
            header('Location: ./add_stock.php?id='.$id.'&action=edit&error=SQL_Create&msg='.$consumptionsSupplies->error);
            exit;
        }
    }
}

// If delete of request
if ($action == 'confirm_delete' && GETPOST('confirm') == 'yes' ) {
	$error=0;

	if ($id <= 0)
        die('Missing id');
    $stock_const->fetch($id);
	//$canedit = ($user->rights->marches->write_all || $user->rights->marches->delete);
    $canedit = true;
	// Si l'utilisateur à le droit de lire ce contrat, il peut le supprimer
	if ($canedit) {
		$stock_const->delete($id);
	}
	else {
		$error = $langs->trans('ErrorCantDelete');
	}

	if (!$error) {
		//$db->commit();
		header('Location: add_stock_list.php');
		exit;
	}
	else {
        header('Location: add_stock_list.php');
        exit;
	}
}

/*
 * View
 */
$morejs  = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.js", "/btp/js/jquery/timepicker/timepicker-fr.js","/btp/js/btp.js");
$morecss = array();

llxHeader(array(), $langs->trans('stock_const'),'','','','',$morejs,$morecss,0,0);
print_barre_liste($langs->trans("stockadd"), $page, $_SERVER["PHP_SELF"], '', $sortfield, $sortorder, "", $num, "", 'title_project.png');

// Fetch both market and construction site
if ($action == 'edit' && !empty($id) ){
    $stock_const->fetch($id);
     $nb_btp->fetch($stock_const->id);
dol_fiche_head('', 'stock_const', $langs->trans("stock_const"), 0, '');

        // Si il y a une erreur
        if (GETPOST('error')) {
            switch(GETPOST('error')) {
                case 'nobudget' :
                    $errors[] = $langs->trans('errorNoBudget');
                    break;
                case 'SQL_Create' :
                    $errors[] = $langs->trans('ErrorSQLCreateCP').' <b>'.htmlentities($_GET['msg']).'</b>';
                    break;
                case 'CantCreate' :
                    $errors[] = $langs->trans('CantCreateCP');
                    break;
                case 'nouser' :
                    $errors[] = $langs->trans('errorNoUser');
                    break;
                case 'nodatedebut' :
                    $errors[] = $langs->trans('NoDateDebut');
                    break;
                case 'nobank' :
                    $errors[] = $langs->trans('errorNoBank');
                    break;
                case 'noqc' :
                    $errors[] = $langs->trans('errorNoQc');
                    break;
                case 'alreadyExists' :
                    $errors[] = $langs->trans('alreadyExistAO');
                    break;
                case 'noref' :
                    $errors[] = $langs->trans('errorNoRef');
                    break;
            }

            setEventMessage($errors, 'errors');
        }

        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">'."\n";
        print '<input type="hidden" name="action" value="update" />'."\n";
        print '<input type="hidden" name="id" value="'.$id.'" />'."\n";

        print '<table class="border" width="100%">';
        print '<tbody>';

        list($start_date, $start_time) = explode(" ", dol_print_date($stock_const->datem,'dayhoursec'));
         print '<tr><td class="fieldrequired">'.$langs->trans("datec").'</td><td>';
        print '<input type="text" class="datepicker" autocomplete="off"  name="datec_" required="required" readonly="readonly" value="'. $start_date .'" /> ';
        print '<input type="text" class="timepicker" name="datec_time_" readonly="readonly" value="'. $start_time .'" />';
        print '</td></tr>';
        //produit
        print '<tr><td>'.$langs->trans("product").'</td><td>'; 
        print $form->select_produits($stock_const->fk_product,'product_id_', 0, 30, 0, 0, 0, '',1);
        print '</td></tr>';
       

        //Quantité  
        print '<tr><td class="fieldrequired">'.$langs->trans("qty").'</td><td>';
        print '<input type="number" value="'.$stock_const->value.'" min="1" name="qty_" required="required" />';
        
        //PU  
        print '<tr><td class="fieldrequired">'.$langs->trans("pu").'</td><td>';
        print '<input type="number" value="'.$nb_btp->pu.'" min="1" step="0.01" name="pu_" required="required" />';
        
        //Quantité  
        print '<tr><td >'.$langs->trans("NBC").'</td><td>';
        print '<input type="number" value="'.$nb_btp->nbc.'" min="1" name="NBC_"  />';
        //Quantité  
        print '<tr><td >'.$langs->trans("NBL").'</td><td>';
        print '<input type="number" value="'.$nb_btp->nbc.'" min="1" name="NBL_"  />';
        print '</td></tr>';
        
        print '</tbody>';
        print '</table>';

        print '<div class="center">';
        print '<input type="submit" value="'. $langs->trans("updatestock") .'" name="bouton" class="butAction">';
        print '&nbsp; &nbsp; ';
        print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
        print '</div>';
        print '</form>';


}
else{


    // Si l'utilisateur n'a pas le droit de créer un marché
    /*if (empty($user->rights->marches->write) || empty($user->rights->marches->write_all)) {
        $errors[]=$langs->trans('CantCreate');
    }
    else {*/
     
        dol_fiche_head('', 'stock_const', $langs->trans("stock_const"), 0, '');

        // Si il y a une erreur
        if (GETPOST('error')) {
            switch(GETPOST('error')) {
                case 'nobudget' :
                    $errors[] = $langs->trans('errorNoBudget');
                    break;
                case 'SQL_Create' :
                    $errors[] = $langs->trans('ErrorSQLCreateCP').' <b>'.htmlentities($_GET['msg']).'</b>';
                    break;
                case 'CantCreate' :
                    $errors[] = $langs->trans('CantCreateCP');
                    break;
                case 'nouser' :
                    $errors[] = $langs->trans('errorNoUser');
                    break;
                case 'nodatedebut' :
                    $errors[] = $langs->trans('NoDateDebut');
                    break;
                case 'nobank' :
                    $errors[] = $langs->trans('errorNoBank');
                    break;
                case 'noqc' :
                    $errors[] = $langs->trans('errorNoQc');
                    break;
                case 'alreadyExists' :
                    $errors[] = $langs->trans('alreadyExistAO');
                    break;
                case 'noref' :
                    $errors[] = $langs->trans('errorNoRef');
                    break;
            }

            setEventMessage($errors, 'errors');
        }

        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">'."\n";
        print '<input type="hidden" name="action" value="add_stock" />'."\n";
        print '<input type="hidden" name="cid" value="'.$cid.'" />'."\n";

        print '<table class="border" width="100%">';
        print '<tbody>';

        print '<tr><td class="fieldrequired">'.$langs->trans("datec").'</td><td>';
        print '<input type="text" class="datepicker" autocomplete="off"  name="datec_" required="required" readonly="readonly" value="" /> ';
        print '<input type="text" class="timepicker" name="datec_time_" readonly="readonly" value="00:00:00" />';
        print '</td></tr>';
        

        //produit
        print '<tr><td>'.$langs->trans("product").'</td><td>'; 
        print $form->select_produits(null,'product_id_', 0, 30, 0, 0, 0, '',1);
        print '</td></tr>';
       
      

        //Quantité  
        print '<tr><td class="fieldrequired">'.$langs->trans("qty").'</td><td>';
        print '<input type="number" value="" min="1" name="qty_" required="required" />';
        
        //PU  
        print '<tr><td class="fieldrequired">'.$langs->trans("pu").'</td><td>';
        print '<input type="number" value="" min="1" step="0.01" name="pu_" required="required" />';
        
        //Quantité  
        print '<tr><td >'.$langs->trans("NBC").'</td><td>';
        print '<input type="number" value="" min="1" name="NBC_"  />';
        //Quantité  
        print '<tr><td >'.$langs->trans("NBL").'</td><td>';
        print '<input type="number" value="" min="1" name="NBL_"  />';
        print '</td></tr>';
        
        print '</tbody>';
        print '</table>';

        print '<div class="center">';
        print '<input type="submit" value="'. $langs->trans("Createstock_const") .'" name="bouton" class="butAction">';
        print '&nbsp; &nbsp; ';
        print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
        print '</div>';
        print '</form>';
    }

// End of page
llxFooter();

if (is_object($db)) $db->close();

?>