<?php
/* Copyright (C) 2016 Souieh laghdaf <laghdaf.souieh@nextconcept.ma>*/
require_once DOL_DOCUMENT_ROOT . '/core/class/commonobject.class.php';
class Nb extends CommonObject
{
    var $error;
    var $db;

	var $fk_move;
	var $pu;
	var $nbc;
	var $nbl;


    /**
	 *  Constructor
	 *
	 *  @param      DoliDB		$db      Database handler
     */
	function __construct($db)
	{
		$this->db = $db;
	}

	function _create($fk_move,$pu, $nbc, $nbl)
	{
		global $conf;
		$nbc= $nbc ? $this->db->escape($nbc): 0;
		$nbl= $nbl ? $this->db->escape($nbl): 0;
		$sql = 'INSERT INTO ' . MAIN_DB_PREFIX . 'btp_nb' . ' (fk_move,pu, nbc, nbl) ';
		$sql .= 'VALUES ('.$fk_move.','.$pu.','.$nbc.', '. $nbl .')';

		$this->db->begin();
		//die($sql);
		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error stock_const ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);
			//var_dump($errors);
			die();
			return -1;
		} else {
			$this->db->commit();
		
			return 1;
		}

	}


	public function fetch($id, $ref = null)
	{
		global $conf;
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . 'btp_nb';
		
		if (null !== $ref) {
			$sql .= ' WHERE ref = ' . '\'' . $ref . '\'';
		} else {
			$sql .= ' WHERE fk_move = ' . $id;
		}

		//$sql .= ' AND entity = '. $conf->entity;
		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			if ($numrows) {
			  $obj 					= $this->db->fetch_object($resql);
			  $this->id 			= $obj->rowid;
			   $this->pu 			= $obj->pu;
			 $this->nbc 			= ($obj->nbc==0)?'':$obj->nbc;
			  $this->nbl          	= ($obj->nbl==0)?'':$obj->nbl ;
			}

			$this->db->free($resql);

			if ($numrows) {
				return 1;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}


	public function update($id, array $data)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$id || $id <= 0)
			return false;

		// Update request
		$sql = 'UPDATE ' . MAIN_DB_PREFIX . 'btp_nb' . ' SET  ';

		if (count($data) && is_array($data))
			foreach ($data as $key => $val) {
				$val = is_numeric($val) ? $val : '"'. $val .'"';
				$sql .= '`'. $key. '` = '. $val .',';
			}

		$sql  = rtrim($sql, ',');
		$sql .= ' WHERE rowid = ' . $id;

		$this->db->begin();
		//die($sql);
		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();
			
			$this->error 	= 'Error ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();
			return 1;
		}
	}

}
