<?php
/* Copyright (C) 2016	Laghdaf souieh
 *
 */

/**
 * \file       btp/market/index.php
 * \ingroup    market
 * \brief      List of markets
 */
require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/btp/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formother.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/user.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/market/class/market.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/btp.lib.php';
require_once DOL_DOCUMENT_ROOT.'/product/class/product.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/tools.lib.php';




// Protection if external user
if (!$user) accessforbidden();

$langs->load('users');

$id_product = GETPOST("id_product");
$dated = GETPOST("search_dated");
$datef = GETPOST("search_datef");
$id_markets   = GETPOST("id_market");

$market = new Market($db);
$product = new product($db);
$num = $market->StockBydateProduct($id_product, $id_markets, $dated,$datef);

$product->fetch($id_product);

llxHeader(array(), $langs->trans('stock de produit').' '.$product->ref,'','','','',array('/btp/js/btp.js'));



// Show table of stock
$var 		= true;

print_barre_liste($langs->trans("stock").' '.$product->ref, $page, $_SERVER["PHP_SELF"], '', $sortfield, $sortorder, "", $num, "", 'title_project.png');
	$market1 = new Market($db);
	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	print '<table class="border" width="100%;">';
	print "<tr class=\"liste_titre\" >";
	 print '<th > Date/Marchés </th>';
	 print '<th > Entrée </th>';
	 foreach ($id_markets as  $val) {
			$market1->fetch($val);
			 print '<th > '.$market1->code.' </th>';
		}
		print '<th > Stock </th>';
if ($num)  {
		
		$mark=array();
		$stock = 0;
		foreach($market->lines as $line) {
            $var = !$var;
        $idmark= explode("-", $line->inventorycode);
        
        print '<tr '.$bc[$var].'>';
        print '<td style="text-align: center" width="15%">'. dol_print_date($line->datem,'dayhour').'</td>';
        if(empty($line->inventorycode))
        	{
        		$stock += $line->value;
        		print '<td style="text-align: center" width="15%">'. $line->value.'</td>';
    		if(!array_key_exists('entry', $mark)){
					$mark['entry'] =$line->value;
				}
				else
					$mark['entry'] +=$line->value;
			}
        else
        	print '<td style="text-align: center" width="15%"></td>';
			foreach ($id_markets as  $val) {
			if($idmark[0]==$val){
				$qty = -1*$line->value;
				$stock -= $qty;
				if(!array_key_exists($idmark[0], $mark)){
					$mark[$idmark[0]] =$qty;
				}
				else
					$mark[$idmark[0]] +=$qty;
				print '<td style="text-align: center" width="15%">'. $qty.'</td>';}
			 	else
        			print '<td align="centre" width="15%"></td>';
		}
			print '<td style="text-align: center" width="15%">'.$stock.'</td>';
			print '</tr>';
       } 
       $var = !$var;
        print '<tr '.$bc[$var].'>';
        print '<td style="text-align: center" width="15%"><strong>Total</strong></td>';
         print '<td style="text-align: center" width="15%"><strong>'.$mark['entry'].'</strong></td>';
         foreach ($id_markets as  $val) {
		 print '<td style="text-align: center" width="15%"><strong>'.$mark[$val].'</strong></td>';
		}
		print '<td style="text-align: center" width="15%"><strong>'.$stock.'</strong></td>';
		print '</tr>';

	}
	
else{
print '<tr>';
	    print '<td colspan="9" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';

}

print '</table>';

	print '<div style="float: right; margin-top: 8px;">';
	print '<a href="stock_product.php" class="butAction">'.$langs->trans('Cancel').'</a>';
	print '</div>';
 

llxFooter();

$db->close();

?>