<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file       appeloffres/index.php
 * \ingroup    list
 * \brief      List of markets
 */
require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/material/tools_move/class/tools_move.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/construction_site/class/construction_site.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/settings/tools/class/tools.class.php';

$form 		= new Form($db);
$tools_move   = new tools_move($db);
$ConstructionSite   = new ConstructionSite($db);
$tools   = new ToolsSettings($db);

$var = false;
$filter = '';
$types_tools_moves = array(1 => 'Entree', 2 =>'Sortie');
$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
if (! $sortfield) $sortfield = "rowid";
if (! $sortorder) $sortorder = "DESC";
$action  = GETPOST('action', 'alpha');
$id 	  = GETPOST('id','int');
$search_datec      		= "";
if (GETPOST('search_datec') !=="") {
    list($etd, $etm, $ety) = explode("/", GETPOST('search_datec'));
    $search_datec         = $ety.'-'.$etm.'-'.$etd ;
}
$search_qty    		= GETPOST('search_qty');
$search_tools    		= GETPOST('search_tools');
$search_const_site_destin    		= GETPOST('search_const_site_destin');
$search_const_site_sender    		= GETPOST('search_const_site_sender');
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
$search_datec      		= '';
$search_qty    		= '';
$search_tools    		= '';
$search_const_site_destin    		= '';
$search_const_site_sender    		= '';
}
$filter .= (!empty($search_datec) && $search_datec != -1) ? " AND datec = '". $db->escape($search_datec)."'\n" : "";
$filter .= (!empty($search_qty) && $search_qty != -1) ? " AND qty = ".$db->escape($search_qty):"";
$filter .= (!empty($search_tools) && $search_tools != -1) ? " AND tools_id = ".$db->escape($search_tools) : "";
$filter .= (!empty($search_const_site_destin) && $search_const_site_destin != -1) ? " AND const_site_destin_id = ".$db->escape($search_const_site_destin) : "";
$filter .= (!empty($search_const_site_sender) && $search_const_site_sender != -1) ? " AND const_site_sender_id = ".$db->escape($search_const_site_sender) : "";


$gettools_moves = $tools_move->fetchAll($sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter);
if (!empty($gettools_moves) && $action == "xsl" ) {
$filename="liste_mouvement_outillage.xls";
      require_once DOL_DOCUMENT_ROOT.'/btp/material/tools_move/tpl/tools_move_exl.php';
 die();
 
}
// Si erreur SQL
if ($gettools_moves == '-1') {
    print_fiche_titre($langs->trans('ListOftools_move'), '', 'title_project.png');

    dol_print_error($db, $langs->trans('Error').' '.$tools_move->error);
    exit();
}
if ($id > 0) {
	$tools_move->fetch($id);
	llxHeader('', $langs->trans('tools_move'));
	print_fiche_titre($langs->trans("tools_move"));


	print '<table class="border" width="100%">';
	// qty
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("qty").'</td>';
	print '<td colspan="2">'. $tools_move->qty .'</td></tr>';
	// date
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("datec").'</td>';
	print '<td colspan="2">'. dol_print_date($tools_move->datec,'day') .'</td></tr>';
	// note
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("note").'</td>';
	print '<td colspan="2">'. $tools_move->note .'</td></tr>';
	// tools
    print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("tools").'</td>';
    $tools->fetch($tools_move->tools_id);
    print '<td colspan="2">'. $tools->getNomUrl('1').'</td></tr>';
	// chantier destinataire
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("const_site_destin").'</td>';
	$ConstructionSite->fetch($tools_move->const_site_destin_id);
	print '<td colspan="2">'. $ConstructionSite->getNomUrl(1,$ConstructionSite->id,$ConstructionSite->name,$ConstructionSite->market_id) .'</td></tr>';
	//chantier émeteur
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("const_site_sender").'</td>';
	$ConstructionSite->fetch($tools_move->const_site_sender_id);
	print '<td colspan="2">'. $ConstructionSite->getNomUrl(1,$ConstructionSite->id,$ConstructionSite->name,$ConstructionSite->market_id) .'</td></tr>';
	
	print '</table>';
	print '<br>';
	print '<div style="float: right; margin-top: 8px;">';
	print '<a href="./index.php?mid='. $mid .'" class="butAction">'.$langs->trans('Cancel').'</a>';
		print '<a href="./card.php?action=edit&id='. $id .'" class="butAction">'.$langs->trans('Modify').'</a>';
	print '<a href="./index.php?action=delete&id='. $id .'" class="butAction">'.$langs->trans('Delete').'</a>';
	print '</div>';
	 if ($action == 'delete') {
                        print $form->formconfirm("card.php?id=".$id, $langs->trans("TitleDelete"),$langs->trans("ConfirmDelete"),"confirm_delete", '', 0, 1);
                }

}
else {

 // Both test are required to be compatible with all browsers
$morejs  = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.js", "/btp/js/jquery/timepicker/timepicker-fr.js","/btp/js/fuel_consoma.js");
$morecss = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.css");

llxHeader('', $langs->trans('tools_move'),'','','','',$morejs,$morecss,0,0);
print_fiche_titre($langs->trans("ListOftools_move"));


	dol_fiche_head('', 'tools_move', $langs->trans("ListOftools_move"), 1, '');
print '<div style="float: right; margin-bottom: 4px;">';
		print '<a href="./card.php?action=add" class="butAction">'.$langs->trans('Addtools_move').'</a>';
		print '</div>';
print '<div style="float: right; ">';
	   print '<form method="post" action="'.$_SERVER["PHP_SELF"].'">'."\n";
print '<input name="search_datec" value="'. $search_datec .'" type="hidden" />';
print '<input name="search_qty" value="'. $search_qty .'" type="hidden" />';
print '<input name="search_tools" value="'. $search_tools .'" type="hidden" />';
print '<input name="search_const_site_destin" value="'. $search_const_site_destin .'" type="hidden" />';
print '<input name="search_delivery_order" value="'. $search_delivery_order .'" type="hidden" />';
print '<input name="search_const_site_sender" value="'. $search_const_site_sender .'" type="hidden" />';

print '<input name="action" value="xsl" type="hidden" />';
	    print '<button style="margin-bottom: 8px;" class="butAction" name="submit" value="Exporter Excel">'.$langs->trans('Exporter Excel').'</button>';
	   print '</form>'."\n";
		print '</div>';
	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	print '<input name="id" value="'. $id .'" type="hidden" />';
	print '<table class="noborder" width="100%;">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("datec"), $_SERVER["PHP_SELF"], 'datec', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("qty"),$_SERVER["PHP_SELF"],"qty", '','','align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("note"), $_SERVER["PHP_SELF"], 'note', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("tools"), $_SERVER["PHP_SELF"], 'tools_id', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("const_site_destin"), $_SERVER["PHP_SELF"], 'const_site_destin_id', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("const_site_sender"), $_SERVER["PHP_SELF"], 'const_site_sender_id', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'','','',$sortfield,$sortorder,'maxwidthsearch ');
	print "</tr>\n";

	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';
	//datec
	print '<td class="liste_titre" olspan="1" align="center">';
    print '<input type="text" value="'.dol_print_date($search_datec,'day').'" class="datepicker" autocomplete="off"  name="search_datec"  readonly="readonly" /> ';
    print '</td>';
	// qty
	print '<td class="liste_titre" olspan="1" align="center">';
	print '<input class="flat" style="width: 85px"  type="number" min="0" name="search_qty" value="'.$search_qty.'">';
	print '</td>';
	// note
	print '<td class="liste_titre" colspan="1" align="center">';
	print '</td>';
	// tools
	print '<td class="liste_titre" olspan="1" align="center">';
	print $form->selectarray('search_tools', $tools->getNames(), $search_tools, 1, 0, 0, 'required="required"');
	print '</td>';
	// const_site_destin
	print '<td class="liste_titre" olspan="1" align="center">';
	print $form->selectarray('search_const_site_destin', $ConstructionSite->getNames(), $search_const_site_destin, 1, 0, 0, 'required="required"');
	print '</td>';
	// const_site_sender
	print '<td class="liste_titre" olspan="1" align="center">';
	print $form->selectarray('search_const_site_sender', $ConstructionSite->getNames(), $search_const_site_sender, 1, 0, 0, 'required="required"');
	print '</td>';

	// ACTION
	print '<td align="right" style="min-width:62px;">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';

	print "</tr>\n";

	// Lines
	if (count($tools_move->rows)) {
		//$createdBy = new User($db);
		foreach($tools_move->rows as $obj) {
			  $qty 				= $obj->qty ;
			  $datec 			= dol_print_date($obj->datec,'day') ;
			  $note 				= $obj->note ;
			  $tools->fetch($obj->tools_id) ;
			

			print '<tr '.$bc[$var].'>';
			print '<td align="left" style ="white-space: nowrap;">';
				print $tools_move->getNomUrl(1,  $obj->id, $datec);
			print '</td>';
			 
			print '<td align="center">'. $qty .'</td>';
			print '<td align="center">'. $note .'</td>';
			print '<td align="center">'. $tools->getNomUrl('1') .'</td>';
			$ConstructionSite->fetch($obj->const_site_destin_id) ;
			print '<td align="center">'. $ConstructionSite->getNomUrl(1,$ConstructionSite->id,$ConstructionSite->name,$ConstructionSite->market_id) .'</td>';
			$ConstructionSite->fetch($obj->const_site_sender_id);
			print '<td align="center">'. $ConstructionSite->getNomUrl(1,$ConstructionSite->id,$ConstructionSite->name,$ConstructionSite->market_id) .'</td>';
			print '<td align="center"></td>';
			print '</tr>'."\n";

		}
	} else {
		print '<tr>';
	    print '<td colspan="9" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';
	}

	print '</table>';
	print '</form>';


}

llxFooter();

$db->close();


?>