<?php
/* Copyright (C) 2016	Souieh Laghdaf	<laghdaf.souieh@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file       /material/work_advances_noslip/index.php
 * \ingroup    list
 * \brief      List of location expensess
 */
require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/btp/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/material/work_advances_noslip/class/work_advances_noslip.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/material/constraction_site/class/constraction_site.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/settings/unit_type/class/unitType.class.php';
include_once DOL_DOCUMENT_ROOT.'/product/class/product.class.php';

$form      = new FormChild($db);
$work_advances_noslip     = new work_advances_noslip($db);
$constraction_site   = new constraction_site($db);
$unit_type = new unitType($db);
$produit   = new product($db);

$var = false;
$filter = '';
$sortorder = GETPOST("sortorder",'alpha');
if (! $sortfield) $sortfield = "rowid";
if (! $sortorder) $sortorder = "DESC";
$id 	  = GETPOST('id','int');
$search_works_nature      		= GETPOST('search_works_nature');
$search_datec      		= "";
if (GETPOST('search_datec') !=="") {
    list($etd, $etm, $ety) = explode("/", GETPOST('search_datec'));
    $search_datec         = $ety.'-'.$etm.'-'.$etd ;
}
$search_works_place    		= GETPOST('search_works_place');
$search_qty    		= GETPOST('search_qty');
$search_unit_type    		= GETPOST('search_unit_type');
$search_salaries_num    		= GETPOST('search_salaries_num');
$search_amount    		= GETPOST('search_amount');
$search_supply    		= GETPOST('search_supply');
$search_const_site    		= GETPOST('search_const_site');
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
$search_works_nature      		= '';
$search_datec      		= '';
$search_works_place    		= '';
$search_qty    		= '';
$search_unit_type    		= '';
$search_salaries_num    		= '';
$search_amount    		= '';
$search_supply    		= '';
$search_const_site    		= '';
}
$filter .= (!empty($search_datec) && $search_datec != -1) ? " AND datec = '". $db->escape($search_datec)."'\n" : "";
$filter .= (!empty($search_works_nature) && $search_works_nature != -1) ? " AND works_nature = '". $db->escape($search_works_nature)."'\n" : "";
$filter .= (!empty($search_works_place) && $search_works_place != -1) ? " AND works_place = '".$db->escape($search_works_place)."'\n" :"";
$filter .= (!empty($search_qty) && $search_qty != -1) ? " AND qty = ".$db->escape($search_qty): "";
$filter .= (!empty($search_unit_type) && $search_unit_type != -1) ? " AND unit_type_id = '".$db->escape($search_unit_type): "";
$filter .= (!empty($search_salaries_num) && $search_salaries_num != -1) ? " AND salaries_num = ".$db->escape($search_salaries_num): "";
$filter .= (!empty($search_amount) && $search_amount != -1) ? " AND amount = ".$db->escape($search_amount): "";
$filter .= (!empty($search_supply) && $search_supply != -1) ? " AND supply_id = ".$db->escape($search_supply): "";
$filter .= (!empty($search_const_site) && $search_const_site != -1) ? " AND const_site_id = ".$db->escape($search_const_site): "";


$getwork_advances_noslips = $work_advances_noslip->fetchAll($sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter);

// Si erreur SQL
if ($getwork_advances_noslips == '-1') {
    print_fiche_titre($langs->trans('ListOfwork_advances_noslip'), '', 'title_project.png');

    dol_print_error($db, $langs->trans('Error').' '.$work_advances_noslip->error);
    exit();
}
if ($id > 0) {
	$work_advances_noslip->fetch($id);
	llxHeader('', $langs->trans('work_advances_noslip'));
	print_fiche_titre($langs->trans("work_advances_noslip"));


	print '<table class="border" width="100%">';
	// works_place
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("works_place").'</td>';
	print '<td colspan="2">'. $work_advances_noslip->works_place .'</td></tr>';
	// datec
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("datec").'</td>';
	print '<td colspan="2">'. dol_print_date($work_advances_noslip->datec,'day') .'</td></tr>';
	// matricule
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("works_nature").'</td>';
	print '<td colspan="2">'. $work_advances_noslip->works_nature .'</td></tr>';
	// année
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("qty").'</td>';
	print '<td colspan="2">'. $work_advances_noslip->qty .'</td></tr>';
	// unit_type
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("unit_type").'</td>';
	$unit_type->fetch($work_advances_noslip->unit_type_id);
	print '<td colspan="2">'. $unit_type->getNomUrl('1') .'</td></tr>';
	// Tarif d'immobilisation 
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("salaries_num").'</td>';
	print '<td colspan="2">'. $work_advances_noslip->salaries_num .'</td></tr>';
	// Tarif de Location
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("amount").'</td>';
	print '<td colspan="2">'. $work_advances_noslip->amount .'</td></tr>';
	// Engin
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("supply").'</td>';
	$produit->fetch($work_advances_noslip->supply_id);
	print '<td colspan="2">'. $produit->getNomUrl('1').'</td></tr>';
	//chantier
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("constraction_site").'</td>';
	$constraction_site->fetch($work_advances_noslip->const_site_id);
	print '<td colspan="2">'. $constraction_site->getNomUrl('1') .'</td></tr>';
	
	
	print '</table>';
	print '<br>';
	print '<div style="float: right; margin-top: 8px;">';
	print '<a href="./index.php?mid='. $mid .'" class="butAction">'.$langs->trans('Cancel').'</a>';
		print '<a href="./card.php?action=edit&id='. $id .'" class="butAction">'.$langs->trans('Modify').'</a>';
	print '</div>';
}
else {

 // Both test are required to be compatible with all browsers
$morejs  = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.js", "/btp/js/jquery/timepicker/timepicker-fr.js","/btp/js/fuel_consoma.js");
$morecss = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.css");

llxHeader('', $langs->trans('work_advances_noslips'),'','','','',$morejs,$morecss,0,0);
print_fiche_titre($langs->trans("ListOfwork_advances_noslip"));


	dol_fiche_head('', 'work_advances_noslips', $langs->trans("Listwork_advances_noslip"), 1, '');

	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	print '<input name="id" value="'. $id .'" type="hidden" />';
	print '<table class="noborder" width="100%;">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("datec"),$_SERVER["PHP_SELF"],"datec", '','','align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("works_nature"), $_SERVER["PHP_SELF"], 'works_nature', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("works_place"), $_SERVER["PHP_SELF"], 'works_place', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("qty"), $_SERVER["PHP_SELF"], 'qty', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("unit_type"), $_SERVER["PHP_SELF"], 'unit_type_id', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("salaries_num"), $_SERVER["PHP_SELF"], 'salaries_num', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("amount"), $_SERVER["PHP_SELF"], 'amount', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("supply"), $_SERVER["PHP_SELF"], 'supply_id', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("constraction_site"), $_SERVER["PHP_SELF"], 'const_site_id', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'','','',$sortfield,$sortorder,'maxwidthsearch ');
	print "</tr>\n";

	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';
	//datec
	print '<td class="liste_titre" olspan="1" align="center">';
    print '<input type="text" value="'.dol_print_date($search_datec,'day').'" class="datepicker" autocomplete="off"  name="search_datec"  readonly="readonly" /> ';
    print '</td>';
	// works_nature
	print '<td class="liste_titre" colspan="1" align="center">';
	print '<input class="flat" type="text" size="14" name="search_works_nature" value="'.$search_works_nature.'">';
	print '</td>';

	// works_place
	print '<td class="liste_titre" colspan="1" align="center">';
	print '<input class="flat" type="text" size="14" name="search_works_place" value="'.$search_works_place.'">';
	print '</td>';
	// qty
	print '<td class="liste_titre" olspan="1" align="center">';
	print '<input class="flat" style="width: 85px"  type="number" min="0" name="search_qty" value="'.$search_qty.'">';
	print '</td>';
	// unit_type
	print '<td class="liste_titre" olspan="1" align="center">';
	print $form->selectarray('search_unit_type', $unit_type->getNames(), $search_unit_type, 1, 0, 0, 'required="required"');
	print '</td>';
	// salaries_num
	print '<td class="liste_titre" olspan="1" align="center">';
	print '<input class="flat" style="width: 85px"  type="number" min="0" name="search_salaries_num" value="'.$search_salaries_num.'">';
	print '</td>';
	// amount
	print '<td class="liste_titre" olspan="1" align="center">';
	print '<input class="flat" style="width: 85px"  type="number" step="0.01" min="0" name="search_amount" value="'.$search_amount.'">';
	print '</td>';
	// supplie
	print '<td class="liste_titre" olspan="1" align="center">';
	print $form->select_produits_list($search_supply,'search_supply', 0, 30, 0, '', 0, 2);
	print '</td>';
	// const_site
	print '<td class="liste_titre" olspan="1" align="center">';
	print $form->selectarray('search_const_site', $constraction_site->getNames(), $search_const_site, 1, 0, 0, 'required="required"');
	print '</td>';
	// ACTION
	print '<td align="right" style="min-width:62px;">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';

	print "</tr>\n";

	// Lines
	if (count($work_advances_noslip->rows)) {
		//$createdBy = new User($db);
		foreach($work_advances_noslip->rows as $obj) {
			  $works_place 			= $obj->works_place ;
			  $datec 			= dol_print_date($obj->datec,'day') ;
			  $works_nature 	= $obj->works_nature ;
			  $qty 	= $obj->qty ;
			  $salaries_num 	= $obj->salaries_num ;
			  $amount 	= $obj->amount ;
			  $produit->fetch($obj->supply_id);
			  $constraction_site->fetch($obj->const_site_id) ;
			  $unit_type->fetch($obj->unit_type_id) ;
			  
			

			print '<tr '.$bc[$var].'>';
			print '<td align="left" style ="white-space: nowrap;">';
				print $work_advances_noslip->getNomUrl(1,  $obj->id, $datec);
			print '</td>';
			 
			print '<td align="center">'. $works_nature .'</td>';
			print '<td align="center">'. $works_place .'</td>';
			print '<td align="center">'. $qty .'</td>';
			print '<td align="center">'. $unit_type->getNomUrl('1')	 .'</td>';
			print '<td align="center">'. $salaries_num .'</td>';
			print '<td align="center">'. $amount .'</td>';
			print '<td align="center">'. $produit->getNomUrl('1') .'</td>';
			print '<td align="center">'. $constraction_site->getNomUrl('1') .'</td>';

			print '<td><div style="float: right; margin-top: 8px;">';
			print '<a href="./card.php?action=delete&id='. $obj->id .'" >'.$langs->trans('Delete').'</a>';
			print '</div></td>';
			print '</tr>'."\n";

		}
	} else {
		print '<tr>';
	    print '<td colspan="9" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';
	}

	print '</table>';
	print '</form>';


		print '<br>';
		print '<div style="float: right; margin-top: 8px;">';
		print '<a href="./card.php?action=add" class="butAction">'.$langs->trans('Addwork_advances_noslip').'</a>';
		print '</div>';


}

llxFooter();

$db->close();


?>