<?php 
/* Copyright (C) 2016		Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *   	\file       marches/list.php
 *		\ingroup    list
 *		\brief      Gestion des marches
 */

require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/usergroup.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formfile.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/CMailFile.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formmail.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php';
require_once DOL_DOCUMENT_ROOT.'/btp/nc_under_modules/marches/class/appeloffre.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/nc_under_modules/marches/lib/marches.lib.php';
require_once DOL_DOCUMENT_ROOT.'/btp/nc_under_modules/marches/common.inc.php';
require_once DOL_DOCUMENT_ROOT.'/btp/nc_under_modules/marches/qualifications/class/qualification.class.php';
require_once DOL_DOCUMENT_ROOT.'/compta/bank/class/account.class.php';


// Get parameters
$myparam = GETPOST("myparam");
$action  = GETPOST('action', 'alpha');
$id 	 = GETPOST('id', 'int');
$userid  = GETPOST('userid') ? GETPOST('userid') : $user->id;
$request_method = $_SERVER['REQUEST_METHOD'];

$langs->load('marches');
// Protection if external user
if ($user->societe_id > 0) accessforbidden();

$now 	= new DateTime('now');
$error 	= false;

if ($action == 'create' && $request_method === 'POST') {
	$appeloffre = new AppelOffre($db);

    // If no right to create a request
    if (empty($user->rights->marches->write) || empty($user->rights->marches->write_all)) {
    	$error++;
    	setEventMessage($langs->trans('CantCreateSC'));
    	$action='request';
    }
    
    $start_date = GETPOST('start_date_');
    $p_bank     = GETPOST('bank_', 'int');
    $qc         = GETPOST('qc', 'int');
    $socid      = GETPOST('socid', 'int');
    $ref        = trim(GETPOST('ref_'));
    $budget     = trim(GETPOST('budget_'));
    $city       = trim(GETPOST('city'));
    $province   = trim(GETPOST('province'));
    $region     = trim(GETPOST('region'));

    // If no start date
    if (empty($start_date)) {
        header('Location: card.php?action=request&error=nodatedebut');
        die();
    }
    // If no budget
    if (empty($budget)) {
        header('Location: card.php?action=request&error=nobudget');
        die();
    }

    // If no bank
    if (empty($p_bank) || $p_bank <= 0) {
        header('Location: card.php?action=request&error=nobank');
        die();
    }
    // If no qc
    if (empty($qc) || $qc <= 0) {
        header('Location: card.php?action=request&error=noqc');
        die();
    }
    // If no ref
    if (empty($ref) || !isset($ref)) {
        header('Location: card.php?action=request&error=noref');
        die();
    }

    // Check if there is already same ref in db
    $doesExist = $appeloffre->fetch(0, $ref);
    if ($doesExist) {
        header('Location: card.php?action=request&error=alreadyExistAO');
        die();
    }

    if (!$error) {
        // Dates
        $end_date   = null;
        $visit_date = null;
        $prov_date  = null;
        list($std, $stm, $sty) = explode("/", $start_date);
        $start_date_time = trim(GETPOST('start_date_time_'));

        if (isset($_POST['end_date_']) && !empty($_POST['end_date_'])) {
            list($etd, $etm, $ety) = explode("/", $_POST['end_date_']);
            $end_date_time   = trim(GETPOST('end_date_time_'));
            $end_date        = $ety.'-'.$etm.'-'.$etd .' '. $end_date_time;
        }

        if (isset($_POST['visit_date_']) && !empty($_POST['visit_date_'])) {
            list($vtd, $vtm, $vty) = explode("/", $_POST['visit_date_']);
            $visit_date_time = trim(GETPOST('visit_date_time_'));
            $visit_date      = $vty.'-'.$vtm.'-'.$vtd .' '. $visit_date_time;
        }

        if (isset($_POST['prov_date_']) && !empty($_POST['prov_date_'])) {
            list($ptd, $ptm, $pty) = explode("/", $_POST['prov_date_']);
            $prov_date_time  = trim(GETPOST('prov_date_time_'));
            $prov_date 	     = $pty.'-'.$ptm.'-'.$ptd .' '. $prov_date_time;
        }

        // Vars
        $start_date = $sty.'-'.$stm.'-'.$std .' '. $start_date_time;
        $label      = trim(GETPOST('label_'));
        $subject    = trim(GETPOST('subject_'));
	    $prov_amount= trim(GETPOST('prov_amount_'));
        $type       = (int)trim(GETPOST('type'));

	    $appeloffre->fk_created_by 	 	= $user->id;
        $appeloffre->fk_classification  = $qc;
	    $appeloffre->fk_third_party     = $socid;
	    $appeloffre->fk_bank		    = $p_bank;
        $appeloffre->ref                = $ref;
	    $appeloffre->start_date 		= $start_date;
	    $appeloffre->end_date  		    = $end_date;
	    $appeloffre->date_visit 	 	= $visit_date;
		$appeloffre->label 	            = $label;
        $appeloffre->subject            = $subject;
        $appeloffre->city               = $city;
        $appeloffre->province           = $province;
		$appeloffre->region             = $region;
		$appeloffre->budget 			= $budget;
		$appeloffre->provisional_amount = $prov_amount;
        $appeloffre->provisional_date   = $prov_date;
	    $appeloffre->type               = $type;
		$getMarcheID = $appeloffre->create();

	    // If no SQL error we redirect to the request card
	    if ($getMarcheID > 0) {
	    	header('Location: index.php?id='.$getMarcheID);
	        exit;
	    } else {
	        // Otherwise we display the request form with the SQL error message
	        header('Location: card.php?action=request&error=SQL_Create&msg='.$appeloffre->error);
	        exit;
	    }
    }
}

if ($action == 'update' && $request_method === 'POST') {
    // If no right to modify a request
    if (!$user->rights->marches->write) {
        header('Location: ./card.php?action=request&error=CantUpdate');
        exit;
    }

    $appeloffre_id = (int) GETPOST('appeloffre_id', 'int');

    if (!$appeloffre_id || $appeloffre_id <= 0) {
        header('Location: ./card.php?action=request&error=CantUpdate');
        exit;
    }

    $appeloffre = new AppelOffre($db);
    $appeloffre->fetch($appeloffre_id);

    $canedit = ($user->rights->marches->write || $user->rights->marches->write_all);

    $start_date = GETPOST('start_date_');
    $p_bank     = GETPOST('bank_', 'int');
    $qc         = GETPOST('qc', 'int');
    $socid      = GETPOST('socid', 'int');
    $ref        = trim(GETPOST('ref_'));
    $budget     = trim(GETPOST('budget_'));
    $city       = trim(GETPOST('city'));
    $province   = trim(GETPOST('province'));
    $region     = trim(GETPOST('region'));

    // If no start date
    if (empty($start_date)) {
        header('Location: card.php?action=request&error=nodatedebut');
        die();
    }
    // If no budget
    if (empty($budget)) {
        header('Location: ./card.php?action=request&error=nobudget');
        die();
    }

    // If no bank
    if (empty($p_bank) || $p_bank <= 0) {
        header('Location: ./card.php?action=request&error=nobank');
        die();
    }
    // If no qc
    if (empty($qc) || $qc <= 0) {
        header('Location: ./card.php?action=request&error=noqc');
        die();
    }
    // If no ref
    if (empty($ref) || !isset($ref) || !$appeloffre->id) {
        header('Location: ./card.php?action=request&error=noref');
        die();
    }

    // If this is the requestor or has read/write rights
    if ($canedit) {
        // Dates
        $end_date   = null;
        $visit_date = null;
        $prov_date  = null;
        list($std, $stm, $sty) = explode("/", $start_date);
        $start_date_time = trim(GETPOST('start_date_time_'));

        if (isset($_POST['end_date_']) && !empty($_POST['end_date_'])) {
            list($etd, $etm, $ety) = explode("/", $_POST['end_date_']);
            $end_date_time   = trim(GETPOST('end_date_time_'));
            $end_date        = $ety.'-'.$etm.'-'.$etd .' '. $end_date_time;
        }
        
        if (isset($_POST['visit_date_']) && !empty($_POST['visit_date_'])) {
            list($vtd, $vtm, $vty) = explode("/", $_POST['visit_date_']);
            $visit_date_time = trim(GETPOST('visit_date_time_'));
            $visit_date      = $vty.'-'.$vtm.'-'.$vtd .' '. $visit_date_time;
        }
        
        if (isset($_POST['prov_date_']) && !empty($_POST['prov_date_'])) {
            list($ptd, $ptm, $pty) = explode("/", $_POST['prov_date_']);
            $prov_date_time  = trim(GETPOST('prov_date_time_'));
            $prov_date       = $pty.'-'.$ptm.'-'.$ptd .' '. $prov_date_time;
        }
        
        // Vars
        $start_date = $sty.'-'.$stm.'-'.$std .' '. $start_date_time;
        $label      = trim(GETPOST('label_'));
        $subject    = trim(GETPOST('subject_'));
        $prov_amount= trim(GETPOST('prov_amount_'));

        $data = array(
            'fk_bank'             => $p_bank,
            'fk_classification'   => $qc,
            'fk_third_party'      => $socid,
            'ref'                 => $ref,
            'start_date'          => $start_date,
            'end_date'            => $end_date,
            'date_visit'          => $visit_date,
            'label'               => $label,
            'subject'             => $subject,
            'city'                => $city,
            'province'            => $province,
            'region'              => $region,
            'budget'              => $budget,
            'provisional_amount'  => $prov_amount,
            'provisional_date'    => $prov_date
        );

        if ($appeloffre->type == 1) {
            $data['type'] = (int)trim(GETPOST('type'));
        }

		// Update
		$getMarcheID = $appeloffre->update($appeloffre_id, $data);

        if ($getMarcheID > 0) {
            header('Location: ./index.php?id='.$appeloffre_id);
            exit;
        } else {
            // Otherwise we display the request form with the SQL error message
            header('Location: ./card.php?id='. $appeloffre_id .'&action=edit&error=SQL_Create&msg='.$appeloffre->error);
            exit;
        }
    }
}

// If delete of request
if ($action == 'confirm_delete' && GETPOST('confirm') == 'yes' && $user->rights->marches->delete) {
	$error=0;

	$db->begin();

	$appeloffre  = new AppelOffre($db);
	$canedit = ($user->rights->marches->write_all || $user->rights->marches->delete);

	// Si l'utilisateur à le droit de lire ce contrat, il peut le supprimer
	if ($canedit) {
        $data = array('statut' => 10);
		$result = $appeloffre->update($id, $data);
	}
	else {
		$error = $langs->trans('ErrorCantDelete');
	}

	if (!$error) {
		$db->commit();
		header('Location: index.php?leftmenu=marches');
		exit;
	}
	else {
		$db->rollback();
        header('Location: index.php?leftmenu=marches');
        exit;
	}
}

/*
 * View
 */

$form           = new Form($db);
$appeloffre     = new AppelOffre($db);
$qualification  = new Qualifications($db);

$morejs  = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.js", "/marches/js/jquery/timepicker/timepicker-fr.js", "/marches/js/marches.js");
$morecss = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.css");

llxHeader(array(), $langs->trans('ListOfAO'),'','','','',$morejs,$morecss,0,0);

if (empty($id) || $action == 'add' || $action == 'request' || $action == 'create') {
	// Si l'utilisateur n'a pas le droit de créer un marché
    if (empty($user->rights->marches->write) || empty($user->rights->marches->write_all)) {
        $errors[]=$langs->trans('CantCreate');
    }
    else {
        // Formulaire appel d'offre
        print_fiche_titre($langs->trans('AddAO'), '', 'object_');

        // Si il y a une erreur
        if (GETPOST('error')) {
            switch(GETPOST('error')) {
                case 'nobudget' :
                    $errors[] = $langs->trans('errorNoBudget');
                    break;
                case 'SQL_Create' :
                    $errors[] = $langs->trans('ErrorSQLCreateCP').' <b>'.htmlentities($_GET['msg']).'</b>';
                    break;
                case 'CantCreate' :
                    $errors[] = $langs->trans('CantCreateCP');
                    break;
                case 'nouser' :
                    $errors[] = $langs->trans('errorNoUser');
                    break;
                case 'nodatedebut' :
                    $errors[] = $langs->trans('NoDateDebut');
                    break;
                case 'nobank' :
                    $errors[] = $langs->trans('errorNoBank');
                    break;
                case 'noqc' :
                    $errors[] = $langs->trans('errorNoQc');
                    break;
                case 'alreadyExists' :
                    $errors[] = $langs->trans('alreadyExistAO');
                    break;
                case 'noref' :
                    $errors[] = $langs->trans('errorNoRef');
                    break;
            }

	        setEventMessage($errors, 'errors');
        }

        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">'."\n";
        print '<input type="hidden" name="action" value="create" />'."\n";

        print '<table class="border" width="100%">';
        print '<tbody>';

        // Bank
        print '<tr><td class="fieldrequired">'.$langs->trans("Bank").'</td><td>';
        print $form->select_comptes((GETPOST('bank_') ? GETPOST('bank_') : ''), 'bank_',0,'',1,'required="required"') . "<span class='bank_number'></span>";
        print '</td></tr>';

        // Qualification/Classification
        print '<tr><td class="fieldrequired">'.$langs->trans("EntrepriseQC").'</td><td>';
        print $form->selectarray('qc', $qualification->getQualifications(), (GETPOST('qc') ? GETPOST('qc') : ''), 1, 0, 0, 'required="required"');
        print '</td></tr>';

        // Thirdparty
        print '<tr><td>'.$langs->trans("ThirdPartyMarket").'</td><td>';
        $filteronlist='';
        if (! empty($conf->global->PROJECT_FILTER_FOR_THIRDPARTY_LIST)) $filteronlist=$conf->global->PROJECT_FILTER_FOR_THIRDPARTY_LIST;
        $text=$form->select_thirdparty_list(GETPOST('socid','int'),'socid',$filteronlist,1,1);
        if (empty($conf->global->PROJECT_CAN_ALWAYS_LINK_TO_ALL_SUPPLIERS) && empty($conf->dol_use_jmobile))
        {
            $texthelp=$langs->trans("IfNeedToUseOhterObjectKeepEmpty");
            print $form->textwithtooltip($text.' '.img_help(),$texthelp,1);
        }
        else print $text;

        $dircustom = DOL_DOCUMENT_ROOT.'/societe/soc.php';
        $createsoci = "soc.php";
        if (!is_dir($dircustom)) {
            $createsoci = "card.php";
        }
        print ' <a href="'.DOL_URL_ROOT.'/societe/'.$createsoci.'?action=create&backtopage='.urlencode($_SERVER["PHP_SELF"].'?action=create').'">'.$langs->trans("AddThirdParty").'</a>';
        print '</td></tr>';

        // Label
        print '<tr><td>'.$langs->trans("Label").'</td><td>';
        print '<input type="text" value="" name="label_" />';
        print '</td></tr>';

        // Ref
        print '<tr><td class="fieldrequired">'.$langs->trans("Ref").'</td><td>';
        print '<input type="text" value="" name="ref_" required="required" />';
        print '</td></tr>';

        // Subject
        print '<tr><td>'.$langs->trans("Subject").'</td><td>';
        print '<textarea name="subject_" row="10" cols="60"></textarea>';
        print '</td></tr>';

        // type
        print '<tr><td class="fieldrequired">'.$langs->trans("Type").'</td><td>';
         print $form->selectarray('type', AppelOffre::getMarcheTypes(), (GETPOST('type') ? GETPOST('type') : 1), 0, 0, 0, 'required="required"');
        print '</td></tr>';

        // City
        print '<tr><td class="">'.$langs->trans("City").'</td><td>';
        print '<input type="text" value="" name="city" />';
        print '</td></tr>';
        // Province
        print '<tr><td class="">'.$langs->trans("Province").'</td><td>';
        print '<input type="text" value="" name="province" />';
        print '</td></tr>';
        // Region
        print '<tr><td class="">'.$langs->trans("Region").'</td><td>';
        print '<input type="text" value="" name="region" />';
        print '</td></tr>';

        // Date start
        print '<tr><td class="fieldrequired">'.$langs->trans("ReleaseDate").'</td><td>';
        print '<input type="text" class="datepicker" autocomplete="off"  name="start_date_" required="required" readonly="readonly" /> ';
        print '<input type="text" class="timepicker" name="start_date_time_" readonly="readonly" value="00:00:00" />';
        print '</td></tr>';

        // Date end
        print '<tr><td class="">'.$langs->trans("OpeningDate").'</td><td>';
        print '<input type="text" class="datepicker" autocomplete="off"  name="end_date_" readonly="readonly" /> ';
        print '<input type="text" class="timepicker" name="end_date_time_" readonly="readonly" value="00:00:00" />';
        print '</td></tr>';

         // Visit date
        print '<tr><td class="">'.$langs->trans("VisitDate").'</td><td>';
        print '<input type="text" class="datepicker" autocomplete="off"  name="visit_date_" readonly="readonly" /> ';
        print '<input type="text" class="timepicker" name="visit_date_time_" readonly="readonly" value="00:00:00" />';
        print '</td></tr>';

        // Budget
        print '<tr><td class="fieldrequired">'.$langs->trans("Budget").'</td><td>';
        print '<input type="text" value="" name="budget_" required="required" />';
        print '</td></tr>';

        // provisional date
        print '<tr><td class="">'.$langs->trans("ProvDate").'</td><td>';
        print '<input type="text" class="datepicker" autocomplete="off"  name="prov_date_" readonly="readonly" /> ';
        print '<input type="text" class="timepicker" name="prov_date_time_" readonly="readonly" value="00:00:00" />';
        print '</td></tr>';

        // provisional amount
        print '<tr><td>'.$langs->trans("ProvAmount").'TTC</td><td>';
        print '<input type="text" value="" name="prov_amount_" />';
        print '</td></tr>';

        print '</tbody>';
        print '</table>';

        print '<div class="center">';
        print '<input type="submit" value="'. $langs->trans("CreateAO") .'" name="bouton" class="butAction">';
        print '&nbsp; &nbsp; ';
        print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
        print '</div>';
        print '</form>';
    }
}
else {
    if ($error) {
        print '<div class="tabBar">';
        print $error;
        print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
        print '</div>';
    }
    else {
        // Affichage de la fiche d'une demande de congés payés
        if ($id > 0) {
            $appeloffre->fetch($id);

			$canedit = ($user->rights->marches->delete || $user->rights->marches->write_all);

            // Si il y a une erreur
            if (GETPOST('error')) {
                switch(GETPOST('error')) {
                    case 'datefin' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorOpeningDateCP');
                        break;
                    case 'SQL_Create' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorSQLCreateCP').' '.$_GET['msg'];
                        break;
                    case 'CantCreate' :
                        $errors[] = $langs->transnoentitiesnoconv('CantCreateCP');
                        break;
                    case 'Valideur' :
                        $errors[] = $langs->transnoentitiesnoconv('InvalidValidatorCP');
                        break;
                    case 'nodatedebut' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateDebut');
                        break;
                    case 'nodatefin' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateFin');
                        break;
                    case 'DureeHoliday' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorDureeCP');
                        break;
                    case 'NoMotifRefuse' :
                        $errors[] = $langs->transnoentitiesnoconv('NoMotifRefuseCP');
                        break;
                    case 'mail' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorMailNotSend')."\n".$_GET['error_content'];
                        break;
                }

	            setEventMessage($errors, 'errors');
            }

            // On vérifie si l'utilisateur à le droit de lire cette demande
            if ($canedit) {
                if ($action == 'delete') {
                    if($user->rights->marches->delete) {
                        print $form->formconfirm("card.php?id=".$id, $langs->trans("TitleDeleteMarket"),$langs->trans("ConfirmDeleteMarket"),"confirm_delete", '', 0, 1);
                    }
                }

                // Si annulation de la demande
                if ($action == 'cancel') {
                    print $form->formconfirm("card.php?id=".$id, $langs->trans("TitleCancelSC"), $langs->trans("ConfirmCancelSC"),"confirm_cancel", '', 1, 1);
                }

                $head = appeloffre_prepare_head($appeloffre);
                dol_fiche_head($head, 'appeloffre', $langs->trans("AOs"), 0, '');

                if ($action == 'edit') {
                    $bank       = new Account($db);
                    $getBank = $bank->fetch($appeloffre->fk_bank);
                    $number = '';
                    if ($getBank) {
                        $number = "<span class='bank_number'> &nbsp;&nbsp;( <b><u>". $bank->number ."</u></b> )</span>";
                    }
                    $edit = true;
                    print '<form method="post" action="'.$_SERVER['PHP_SELF'].'?id='.$id.'">'."\n";
                    print '<input type="hidden" name="action" value="update" />'."\n";
                    print '<input type="hidden" name="appeloffre_id" value="'.$id.'" />'."\n";

                    print '<table class="border" width="100%">';
                    print '<tbody>';

                    // Bank
                    print '<tr><td class="fieldrequired">'.$langs->trans("Bank").'</td><td>';
                    print $form->select_comptes($appeloffre->fk_bank, 'bank_',0,'',1,'required="required"') . $number;
                    print '</td></tr>';

                    // Qualification/Classification
                    print '<tr><td class="fieldrequired">'.$langs->trans("EntrepriseQC").'</td><td>';
                    print $form->selectarray('qc', $qualification->getQualifications(), (GETPOST('qc') ? GETPOST('qc') : $appeloffre->fk_classification), 1, 0, 0, 'required="required"');
                    print '</td></tr>';

                    // Thirdparty
                    print '<tr><td>'.$langs->trans("ThirdPartyMarket").'</td><td>';
                    $filteronlist='';
                    if (! empty($conf->global->PROJECT_FILTER_FOR_THIRDPARTY_LIST)) $filteronlist=$conf->global->PROJECT_FILTER_FOR_THIRDPARTY_LIST;
                    $text=$form->select_thirdparty_list($appeloffre->fk_third_party,'socid',$filteronlist,1,1);
                    if (empty($conf->global->PROJECT_CAN_ALWAYS_LINK_TO_ALL_SUPPLIERS) && empty($conf->dol_use_jmobile))
                    {
                        $texthelp=$langs->trans("IfNeedToUseOhterObjectKeepEmpty");
                        print $form->textwithtooltip($text.' '.img_help(),$texthelp,1);
                    }
                    else print $text;
                    print ' <a href="'.DOL_URL_ROOT.'/societe/soc.php?action=create&backtopage='.urlencode($_SERVER["PHP_SELF"].'?action=create').'">'.$langs->trans("AddThirdParty").'</a>';
                    print '</td></tr>';

                    // Label
                    print '<tr><td>'.$langs->trans("Label").'</td><td>';
                    print '<input type="text" value="'. $appeloffre->label .'" name="label_" />';
                    print '</td></tr>';

                    // Ref
                    print '<tr><td class="fieldrequired">'.$langs->trans("Ref").'</td><td>';
                    print '<input type="text" value="'. $appeloffre->ref .'" name="ref_" required="required" />';
                    print '</td></tr>';

                    // Subject
                    print '<tr><td>'.$langs->trans("Subject").'</td><td>';
                    print '<textarea name="subject_" row="10" cols="60">'. strip_tags(nl2br($appeloffre->subject)) .'</textarea>';
                    print '</td></tr>';

                    // type
                    print '<tr><td class="fieldrequired">'.$langs->trans("Type").'</td><td>';
                     print $form->selectarray('type', AppelOffre::getMarcheTypes(), (GETPOST('type') ? GETPOST('type') : $appeloffre->type), 0, 0, 0, 'required="required"', 0, 0, ($appeloffre->type == 2 ? 1 : 0), '', ' select2');
                    print '</td></tr>';

                    // City
                    print '<tr><td class="">'.$langs->trans("City").'</td><td>';
                    print '<input type="text" value="'. $appeloffre->city .'" name="city" />';
                    print '</td></tr>';
                    // Province
                    print '<tr><td class="">'.$langs->trans("Province").'</td><td>';
                    print '<input type="text" value="'. $appeloffre->province .'" name="province" />';
                    print '</td></tr>';
                    // Region
                    print '<tr><td class="">'.$langs->trans("Region").'</td><td>';
                    print '<input type="text" value="'. $appeloffre->region .'" name="region" />';
                    print '</td></tr>';

                    list($start_date, $start_time) = explode(" ", dol_print_date($appeloffre->start_date,'dayhoursec'));
                    // Date start
                    print '<tr><td class="fieldrequired">'.$langs->trans("ReleaseDate").'</td><td>';
                    print '<input type="text" class="datepicker" autocomplete="off"  name="start_date_" required="required" readonly="readonly" value="'. $start_date .'" /> ';
                    print '<input type="text" class="timepicker" name="start_date_time_" value="'. $start_time .'" />';
                    print '</td></tr>';

                    list($end_date, $end_time) = explode(" ", dol_print_date($appeloffre->end_date,'dayhoursec'));
                    // Date end
                    print '<tr><td class="">'.$langs->trans("OpeningDate").'</td><td>';
                    print '<input type="text" class="datepicker" autocomplete="off"  name="end_date_" readonly="readonly" value="'. $end_date .'" /> ';
                    print '<input type="text" class="timepicker" name="end_date_time_" readonly="readonly" value="'. $end_time .'" />';
                    print '</td></tr>';

                    list($visit_date, $visit_time) = explode(" ", dol_print_date($appeloffre->date_visit,'dayhoursec'));
                     // Visit date
                    print '<tr><td class="">'.$langs->trans("VisitDate").'</td><td>';
                    print '<input type="text" class="datepicker" autocomplete="off"  name="visit_date_" readonly="readonly" value="'. $visit_date .'" /> ';
                    print '<input type="text" class="timepicker" name="visit_date_time_" readonly="readonly" value="'. $visit_time .'" />';
                    print '</td></tr>';

                    // Budget
                    print '<tr><td class="fieldrequired">'.$langs->trans("Budget").'</td><td>';
                    print '<input type="text" value="'. $appeloffre->budget .'" name="budget_" required="required" />';
                    print '</td></tr>';

                    list($prov_date, $prov_time) = explode(" ", dol_print_date($appeloffre->provisional_date, 'dayhoursec'));
                    // provisional date
                    print '<tr><td class="">'.$langs->trans("ProvDate").'</td><td>';
                    print '<input type="text" class="datepicker" autocomplete="off"  name="prov_date_" readonly="readonly" value="'. $prov_date .'" /> ';
                    print '<input type="text" class="timepicker" name="prov_date_time_" readonly="readonly" value="'. $prov_time .'" />';
                    print '</td></tr>';

                    // provisional amount
                    print '<tr><td>'.$langs->trans("ProvAmount").'TTC</td><td>';
                    print '<input type="text" value="'. $appeloffre->provisional_amount .'" name="prov_amount_" />';
                    print '</td></tr>';

                    print '</tbody>';
                    print '</table>';

                    print '<div class="center">';
                    print '<input type="submit" value="'. $langs->trans("Modify") .'" name="bouton" class="butAction">';
                    print '&nbsp; &nbsp; ';
                    print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
                    print '</div>';
                    print '</table>';
                }

                dol_fiche_end();

                if (!$edit) {
		            print '<div class="tabsAction">';

                    // Boutons d'actions
                    if ($canedit) {
                        print '<a href="card.php?id='.$_GET['id'].'&action=edit" class="butAction">'.$langs->trans("Modify").'</a>';
                    }

                    // If draft
                    if ($user->rights->marches->delete)	{
                    	print '<a href="card.php?id='.$_GET['id'].'&action=delete" class="butActionDelete">'.$langs->trans("Delete").'</a>';
                    }

                    print '</div>';
                }

            } else {
                print '<div class="tabBar">';
                print $langs->trans('ErrorUserViewSC');
                print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
                print '</div>';
            }

        } else {
            print '<div class="tabBar">';
            print $langs->trans('ErrorIDFicheSC');
            print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
            print '</div>';
        }

    }

}

// End of page
llxFooter();

if (is_object($db)) $db->close();

?>