<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file       appeloffres/index.php
 * \ingroup    list
 * \brief      List of markets
 */
require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formother.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/user.class.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/usergroup.class.php';
require_once DOL_DOCUMENT_ROOT.'/compta/bank/class/account.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/nc_under_modules/marches/class/appeloffre.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/nc_under_modules/marches/lib/marches.lib.php';
require_once DOL_DOCUMENT_ROOT.'/btp/nc_under_modules/marches/common.inc.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/functions2.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/usergroups.lib.php';
require_once DOL_DOCUMENT_ROOT.'/btp/nc_under_modules/marches/qualifications/class/qualification.class.php';


$langs->load('users');
$langs->load('marches');

// Protection if external user
if ($user->societe_id > 0) $socid=$user->societe_id;

$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
$page = GETPOST("page",'int');
$page = is_numeric($page) ? $page : 0;
$page = $page == -1 ? 0 : $page;
$filter = '';
if (! $sortfield) $sortfield = "rowid";
if (! $sortorder) $sortorder = "DESC";

$offset   = $conf->liste_limit * $page;
$pageprev = $page - 1;
$pagenext = $page + 1;
$id 	  = GETPOST('id','int');

$search_ref      			= GETPOST('search_ref');
$search_created_by      	= GETPOST('search_created_by');
$search_subject      		= GETPOST('search_subject');
$search_start_date    		= GETPOST('search_start_date');
$search_end_date     		= GETPOST('search_end_date');
$search_date_visit     		= GETPOST('search_date_visit');
$search_budget  			= GETPOST('search_budget');
$search_provisional_amount  = GETPOST('search_provisional_amount');
$search_provisional_date  	= GETPOST('search_provisional_date');
$search_status  			= GETPOST('search_status');

 // Both test are required to be compatible with all browsers
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
	$search_ref   				= "";
	$search_created_by 			= "";
	$search_subject  			= "";
    $search_start_date  		= "";
	$search_end_date   			= "";
	$search_date_visit 	  		= "";
	$search_budget 	  			= "";
	$search_provisional_amount 	= "";
	$search_provisional_date  	= "";
	$search_status  			= "";
}

/**
 * Actions
 */

// None

/**
 * View
 */

$appeloffres 	  = new AppelOffre($db);
$appeloffrestatic = new AppelOffre($db);
$fuser 	      	  = new User($db);
$qualification    = new Qualifications($db);
$socstatic 		  = new Societe($db);
$max_year 	= 5;
$min_year 	= 10;
$filter 	= '';

llxHeader('', $langs->trans('ListOfAO'),'','','','',array('/btp/nc_under_modules/marches/js/marches.js'));
print_fiche_titre($langs->trans('ListOfAO'), '', 'title_project.png');

// Filter
$filter .= (!empty($search_ref) && $search_ref != -1) ? " AND ref = '". $db->escape($search_ref) ."'\n" : "";

if (isset($search_start_date) && !empty($search_start_date)) {
	list($sd, $sm, $sy)  = explode("/", $search_start_date);
	$filter .=  " AND date_format(start_date, '%Y-%m-%d') = '". $db->escape($sy.'-'.$sm.'-'.$sd) ."'";
}
if (isset($search_end_date) && !empty($search_end_date)) {
	list($ed, $em, $ey)  = explode("/", $search_end_date);
	$filter .=  " AND date_format(end_date, '%Y-%m-%d') = '". $db->escape($ey.'-'.$em.'-'.$ed) ."'";
}
if (isset($search_provisional_date) && !empty($search_provisional_date)) {
	list($ed, $em, $ey)  = explode("/", $search_provisional_date);
	$filter .=  " AND date_format(provisional_date, '%Y-%m-%d') = '". $db->escape($ey.'-'.$em.'-'.$ed) ."'";
}

$filter .= (isset($search_date_visit) && !empty($search_date_visit)) ? " AND date_visit = '". $db->idate($search_date_visit).'"' : "";
$filter .= (!empty($search_created_by) && $search_created_by != -1) ? " AND fk_created_by = ". $db->escape($search_created_by) : "";
$filter .= (!empty($search_subject) && $search_subject != -1) ? " AND (subject like '%".$db->escape($search_subject)."%' OR label like '%".$db->escape($search_subject)."%')\n" : "";
$filter .= (!empty($search_budget) && $search_budget != -1) ? " AND budget = ".$db->escape($search_budget) : "";
$filter .= (!empty($search_provisional_amount) && $search_provisional_amount != -1) ? " AND provisional_amount = ". $db->escape($search_provisional_amount) : "";

if (!empty($search_status) && $search_status == 9) { // Draft
	$filter .= " AND statut = 0";
} else if (!empty($search_status) && $search_status == 1)
	$filter .= " AND statut = 1";
else if (!empty($search_status) && $search_status == 2)
	$filter .= " AND statut = 2";
elseif ($search_status == -1) {
	$filter .= " AND statut in (0,1,2)";
}

/*************************************
 * Fin des filtres de recherche
*************************************/

// Récupération de l'ID de l'utilisateur
$user_id 		= $user->id;
$getAppelOffreList = $appeloffres->fetchAll($sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter);

// Si erreur SQL
if ($getAppelOffreList == '-1') {
    print_fiche_titre($langs->trans('ListOfAO'), '', 'title_project.png');

    dol_print_error($db, $langs->trans('Error').' '.$appeloffres->error);
    exit();
}

// Show table of vacations
$var 		= true;
$num 		= count($appeloffres->lines);
$form 		= new Form($db);
$formother 	= new FormOther($db);

if ($id > 0) {
	$appeloffres->fetch($id);
	$title = $langs->trans("AOs");
	$head  = appeloffre_prepare_head($appeloffres);
	dol_fiche_head($head, 'appeloffre', $title, 0, '');

	$bank  		= new Account($db);
	$bank->fetch($appeloffres->fk_bank);
	$createdBy  = new User($db);
	$createdBy->fetch($db->escape($appeloffres->fk_created_by));
	$qualification->fetch($appeloffres->fk_classification);
	
	$end_date 			= null !== $appeloffres->end_date ? dol_print_date($appeloffres->end_date,'dayhoursec') : '';
	$date_visit			= null !== $appeloffres->date_visit ? dol_print_date($appeloffres->date_visit,'dayhoursec') : '';
	$provisional_date 	= null !== $appeloffres->provisional_date ? dol_print_date($appeloffres->provisional_date,'dayhoursec') : '';
	$provisional_amount = null !== $appeloffres->provisional_amount ? number_format($appeloffres->provisional_amount, 2, ',', '.') : 0;
	if ($appeloffres->fk_third_party) {
		$socstatic->fetch($appeloffres->fk_third_party);
	}

	print '<table class="border" width="100%">';
	// Ref
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Ref").'</td>';
	print '<td colspan="2">'. $appeloffres->ref .'</td></tr>';
	// Created By
	print '<tr><td width="25%">'.$langs->trans("CreatedBy").'</td>';
	print '<td colspan="2">'. $createdBy->getNomUrl('1') .'</td></tr>';
	// Classification
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("EntrepriseQC").'</td>';
	print '<td colspan="2">'. $qualification->num .'</td></tr>';
	// Third party
	print '<tr><td width="25%">'.$langs->trans("ThirdPartyMarket").'</td>';
	print '<td colspan="2">';
	if ($appeloffres->fk_third_party)
		print $socstatic->getNomUrl(1);
	print '</td></tr>';
	// Bank
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Bank").'</td>';
	print '<td colspan="2">'. $bank->getNomUrl(1) . ($bank->number ? " &nbsp;&nbsp;( <b><u>". $bank->number ."</u></b> )" : "") .'</td></tr>';
	// Start date
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("ReleaseDate").'</td>';
	print '<td colspan="2">'. dol_print_date($appeloffres->start_date,'dayhoursec') .'</td></tr>';
	// End date
	print '<tr><td width="25%">'.$langs->trans("OpeningDate").'</td>';
	print '<td colspan="2">'. $end_date .'</td></tr>';
	// Visit date
	print '<tr><td width="25%">'.$langs->trans("VisitDate").'</td>';
	print '<td colspan="2">'. $date_visit .'</td></tr>';
	// Label
	print '<tr><td width="25%">'.$langs->trans("Label").'</td>';
	print '<td colspan="2">'. $appeloffres->label .'</td></tr>';
	// subject
	print '<tr><td width="25%">'.$langs->trans("Subject").'</td>';
	print '<td colspan="2">'. nl2br($appeloffres->subject) .'</td></tr>';
	// type
	print '<tr><td width="25%">'.$langs->trans("Type").'</td>';
	print '<td colspan="2">'. ucwords(AppelOffre::getMarcheType($appeloffres->type)) .'</td></tr>';
	// City
	print '<tr><td width="25%">'.$langs->trans("City").'</td>';
	print '<td colspan="2">'. ucfirst($appeloffres->city) .'</td></tr>';
	// Province
	print '<tr><td width="25%">'.$langs->trans("Province").'</td>';
	print '<td colspan="2">'. ucfirst($appeloffres->province) .'</td></tr>';
	// Region
	print '<tr><td width="25%">'.$langs->trans("Region").'</td>';
	print '<td colspan="2">'. ucwords($appeloffres->region) .'</td></tr>';
	// Budget
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Budget").'</td>';
	print '<td colspan="2">'. number_format($appeloffres->budget, 2, ',', '.').' '.$langs->getCurrencySymbol($conf->currency).'</td></tr>';
	// ProvAmount
	print '<tr><td width="25%" >'.$langs->trans("ProvAmount").'TTC</td>';
	print '<td colspan="2">'. $provisional_amount.' '.$langs->getCurrencySymbol($conf->currency).'</td></tr>';
	// ProvDate
	print '<tr><td width="25%">'.$langs->trans("ProvDate").'</td>';
	print '<td colspan="2">'. $provisional_date .'</td></tr>';
	print '</table>';

	print '<br>';
	print '<div style="float: right; margin-top: 8px;">';
	print '<a href="./index.php?mid='. $mid .'" class="butAction">'.$langs->trans('Cancel').'</a>';
	if ($user->id && $user->rights->marches->write_all) {
		print '<a href="./card.php?action=edit&id='. $id .'" class="butAction">'.$langs->trans('Modify').'</a>';
	}
	print '</div>';
}
else {

   	dol_fiche_head('', 'appeloffre', $langs->trans("ListOfAO"), 1, '');

	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	print '<input name="id" value="'. $id .'" type="hidden" />';
	print '<table class="noborder" width="100%;">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("Ref"),$_SERVER["PHP_SELF"], "ref", '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("CreatedBy"),$_SERVER["PHP_SELF"],"fk_created_by", '','','align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("Subject"), $_SERVER["PHP_SELF"], 'subject', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("Budget"),$_SERVER["PHP_SELF"], 'budget', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("ReleaseDate"), $_SERVER["PHP_SELF"],"start_date","",'','align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("OpeningDate"),$_SERVER["PHP_SELF"],"end_date","",'','align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("ProvAmount"),$_SERVER["PHP_SELF"],"provisional_amount","",'','align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("Status"),$_SERVER["PHP_SELF"],"statut","",'','align="center"',$sortfield,$sortorder);
	print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'','','',$sortfield,$sortorder,'maxwidthsearch ');
	print "</tr>\n";

	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';
	print '<td class="liste_titre" align="left" width="50">';
	print '<input class="flat" size="14" type="text" name="search_ref" value="'.dol_escape_htmltag($search_ref).'">';
	print '</td>';

	// UTILISATEUR
	if ($user->rights->marches->write_all) {
	    print '<td class="liste_titre" align="left">';
	    print $form->select_dolusers($search_created_by,"search_created_by",1,"",0,'','',0,32);
	    print '</td>';
	}
	else {
	    //print '<td class="liste_titre">&nbsp;</td>';
	    print '<td class="liste_titre" align="left">';
	    print $form->select_dolusers($user->id,"search_created_by",1,"",1,'','',0,32);
	    print '</td>';
	}

	// Label
	print '<td class="liste_titre" colspan="1" align="center">';
	print '<input class="flat" type="text" size="14" name="search_subject" value="'.$search_subject.'">';
	print '</td>';

	// Budget
	print '<td class="liste_titre" colspan="1" align="center"><input class="flat" type="text" size="14" name="search_budget" value="'.$search_budget.'"></td>';
	// Start Date
	print '<td class="liste_titre" colspan="1" align="center"><input class="flat datepicker" autocomplete="off"  type="text" size="14" name="search_start_date" value="'.$search_start_date.'"></td>';
	// End Date
	print '<td class="liste_titre" colspan="1" align="center"><input class="flat datepicker" autocomplete="off"  type="text" size="14" name="search_end_date" value="'.$search_end_date.'"></td>';
	// Prov Amount
	print '<td class="liste_titre" colspan="1" align="center"><input class="flat" type="text" size="14" name="search_provisional_amount" value="'.$search_provisional_amount.'"></td>';
	// Statut
	print '<td class="liste_titre" colspan="1" align="center">';
	// <input class="flat" type="text" size="14" name="search_status" value="'.$search_status.'">
	$statuts = array(9 => $langs->trans('Draft'), 1 => $langs->trans('Approved'), 2 => $langs->trans('NotApproved'));
	print $form->selectarray('search_status', $statuts, (GETPOST('search_status') ? GETPOST('search_status') : $search_status), 1, 0, 0, '');
	print '</td>';

	// ACTION
	print '<td align="right">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';

	print "</tr>\n";

	// Lines
	if (count($appeloffres->lines)) {
		$createdBy = new User($db);

		foreach($appeloffres->lines as $line) {
			$var = !$var;
			$createdBy->fetch($db->escape($line->fk_created_by));
			$ref 				= $line->ref;
			$start_date 		= $line->start_date ? dol_print_date($line->start_date,'day') : '';
			$end_date 			= $line->end_date ? dol_print_date($line->end_date,'day') : '';
			$provisional_date 	= $line->provisional_date ? dol_print_date($line->provisional_date,'dayhoursec') : '';
			$provisional_amount = $line->provisional_amount ? number_format($line->provisional_amount, 2, ',', '.') : 0;
			$subject = '';
			$fullSubject = '';
			if (null !== $line->subject) {
				$fullSubject = str_replace(array("\r\n", "\n"), "", nl2br(strip_tags($line->subject)));
				$subject = substr($line->subject, 0, 100);
				$subject = strlen($line->subject) > 100 ? $subject.'...' : $subject;
			}

			print '<tr '.$bc[$var].'>';
			print '<td align="left" width="125px">';
				print $appeloffres->getNomUrl(1,  $line->id, $ref);
			print '</td>';
			print '<td align="center">'.$createdBy->getNomUrl('1').'</td>';
			print '<td align="center"><span class="classfortooltip" title="'. $fullSubject .'">'. $subject .'</span></td>';
			print '<td align="center">'. number_format($line->budget, 2, ',', '.').' '.$langs->getCurrencySymbol($conf->currency).'</td>';
			// print '<td>'. $appeloffres->getContractTypeById($line->type) .'</td>';
			print '<td align="center">'. $start_date .'</td>';
			print '<td align="center">'. $end_date .'</td>';
			// print '<td align="center">'.dol_print_date($line->start_visit,'dayhoursec').'</td>';
			print '<td align="center">'. $provisional_amount.' '.$langs->getCurrencySymbol($conf->currency).'</td>';
			// print '<td align="center">'. $provisional_date .'</td>';
			print '<td align="center">'. $appeloffres->statusLevel($line->statut) .'</td>';

			print '<td></td>';
			print '</tr>'."\n";

		}
	} else {
		print '<tr>';
	    print '<td colspan="9" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';
	}

	print '</table>';
	print '</form>';

	if ($user->id && $user->rights->marches->write) {
		print '<br>';
		print '<div style="float: right; margin-top: 8px;">';
		print '<a href="./card.php?action=add" class="butAction">'.$langs->trans('AddAO').'</a>';
		print '</div>';
	}

}

llxFooter();

$db->close();

?>