<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file       marches/marche/index.php
 * \ingroup    marche
 * \brief      List of markets
 */
require_once('../../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formother.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/user.class.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/usergroup.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/nc_under_modules/marches/class/appeloffre.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/nc_under_modules/marches/marche/class/marche.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/nc_under_modules/marches/lib/marches.lib.php';
require_once DOL_DOCUMENT_ROOT.'/compta/bank/class/account.class.php';

$langs->load('users');
$langs->load('marches');

// Protection if external user
if ($user->societe_id > 0)  $socid = $user->societe_id;

$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
$tasktab   = GETPOST("tasktab",'int');
$page = GETPOST("page",'int');
$page = is_numeric($page) ? $page : 0;
$page = $page == -1 ? 0 : $page;
$filter = '';
if (! $sortfield) $sortfield = "m.rowid";
if (! $sortorder) $sortorder = "DESC";

$offset   = $conf->liste_limit * $page;
$pageprev = $page - 1;
$pagenext = $page + 1;
$id 	  = GETPOST('id','int');

$search_ref_marche = GETPOST('search_ref_marche');
$search_created_by = GETPOST('search_created_by');
$search_label      = GETPOST('search_label');
$search_budget     = GETPOST('search_budget');
$search_status     = GETPOST('search_status');
$search_type       = GETPOST('search_type');

 // Both test are required to be compatible with all browsers
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
	$search_ref_marche = "";
	$search_created_by = "";
	$search_label  	   = "";
    $search_budget     = "";
    $search_status     = "";
    $search_type       = "";
}

/**
 * Actions
 */

// None

/**
 * View
 */

$marches = new Marches($db);
$filter  = '';

llxHeader(array(), $langs->trans('ListOfMarkets'));

// Filter
$filter .= (!empty($search_ref_marche) && $search_ref_marche != -1) ? " AND m.ref_marche = '". $db->escape($search_ref_marche) ."'\n" : "";
$filter .= (!empty($search_created_by) && $search_created_by != -1) ? " AND m.fk_created_by = '".$db->escape($search_created_by)."'\n" : "";
$filter .= (!empty($search_label) && $search_label != -1) ? " AND m.label like '%".$db->escape($search_label)."%'\n" : "";
$filter .= (!empty($search_budget) && $search_budget != -1) ? " AND m.budget = ". $db->escape($search_budget) : "";
$filterStatus = (!empty($search_status) && $search_status != -1 ? ($search_status == 0 ? " m.statut = 0" : " m.statut <> 0") : '');
/*************************************
 * Fin des filtres de recherche
*************************************/

// Récupération de l'ID de l'utilisateur
$user_id 		= $user->id;
$getMarchesList = $marches->fetchAll($sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter, $filterStatus, $search_type, $id);

// Si erreur SQL
if ($getMarchesList == '-1') {
    print_fiche_titre($langs->trans('ListOfMarkets'), '', 'title_project.png');

    dol_print_error($db, $langs->trans('Error').' '.$marches->error);
    exit();
}

// Show table of vacations
$var 		= true;
$num 		= count($marches->lines);
$form 		= new Form($db);
$formother 	= new FormOther($db);

if ($id > 0) {
		$title = $langs->trans("MarketDetail");
	print_fiche_titre($title,'','');
	$marches->fetch($id);

/*	$headTask  = marches_cadre_prepare_head();
	dol_fiche_head($headTask, 'task_'.$tasktab, 'Task '.$tasktab, 0, '');*/

	$head = marches_prepare_head($marches);
	dol_fiche_head($head, 'marche', $langs->trans("MarketDetail"), 0, '');
	$appel_offre = $marches->appel_offre;
	$winner      = $marches->winner;
	// $approval    = $marches->approval;
	$thirdParty = '';

	if ($tier = $appel_offre['tier']) {
		$socstatic = new Societe($db);
		$socstatic->fetch($tier);
		$thirdParty = $socstatic->getNomUrl(1);
	}

	$createdBy  = new User($db);
	$createdBy->fetch($marches->fk_created_by);
	$ref 				  = $marches->ref_marche ?: $marches->id;
	$label 				  = $marches->label ?: '';

	echo $marches->marchesDropDown($id);

	print_barre_liste($langs->trans("AOs"), '', '', '', '', '', "", 0, 0, 'title.gif');
	// Appel Offre
	print '<table class="border" width="100%">';
	// subject
	print '<tr><td width="25%">'.$langs->trans("Subject").'</td>';
	print '<td colspan="2">'. $appel_offre['subject'] .'</td></tr>';
	print '<tr><td width="25%">'.$langs->trans("Label").'</td>';
	print '<td colspan="2">'. $appel_offre['label'] .'</td></tr>';
	print '<tr><td width="25%">'.$langs->trans("ThirdPartyMarket").'</td>';
	print '<td colspan="2">'. $thirdParty .'</td></tr>';
	print '<tr><td width="25%">'.$langs->trans("Ref").'</td>';
	print '<td colspan="2">'. $appel_offre['ref'] .' &nbsp;&nbsp;&nbsp;&nbsp;'. $langs->trans("MonitoringDate").': '. $appel_offre['start_date'] .'</td></tr>';
	print '<tr><td width="25%">'.$langs->trans("ProvAmount").' TTC</td>';
	print '<td colspan="2">'. number_format($appel_offre['provisional_amount'], 2) .' '.$langs->getCurrencySymbol($conf->currency).'&nbsp;&nbsp;&nbsp;&nbsp;'. $langs->trans("ProvDate").': '. dol_print_date($appel_offre['provisional_date'], 'day') .'</td></tr>';
	print '</table><br />';

	print_barre_liste($langs->trans("EstimatedAmountTitle"), '', '', '', '', '', "", 0, 0, 'title_bank.png');
	// Approbation
	print '<table class="border" width="100%">';
	print '<tr><td width="25%">'.$langs->trans("ApprovalAmountHT").'</td>';
	print '<td colspan="2">'. number_format($winner['amount_ht'], 2).' '.$langs->getCurrencySymbol($conf->currency).'</td></tr>';
	print '<tr><td width="25%">'.$langs->trans("ApprovalAmountTva").'</td>';
	print '<td colspan="2">'. number_format($winner['tva'], 2).' '.$langs->getCurrencySymbol($conf->currency).'</td></tr>';
	print '<tr><td width="25%">'.$langs->trans("ApprovalAmountTTC").'</td>';
	print '<td colspan="2">'. number_format($winner['amount_ttc'], 2).' '.$langs->getCurrencySymbol($conf->currency).'</td></tr>';
	print '</table><br />';

	print_barre_liste($langs->trans("MarketDetail"), '', '', '', '', '', "", "", "", 'title_project.png');
	$tva_info = Tools::getTva($marches->budget);
	print '<table class="border" width="100%">';
	print '<tr><td width="25%">'.$langs->trans("MarketRef").'</td>';
	print '<td colspan="2">'. $marches->ref_marche .'</td></tr>';
	print '<tr><td width="25%">'.$langs->trans("MarketLabel").'</td>';
	print '<td colspan="2">'. $marches->label .'</td></tr>';
	print '<tr><td width="25%">'.$langs->trans("MarketDate").'</td>';
	print '<td colspan="2">'. dol_print_date($marches->sig_date, 'day') .'</td></tr>';
	print '<tr><td width="25%">'.$langs->trans("MarketAmount").'</td>';
	print '<td colspan="2">'. number_format($marches->budget, 2).' '.$langs->getCurrencySymbol($conf->currency).'</td></tr>';
	print '<tr><td width="25%">'.$langs->trans("ApprovalAmountTva").'</td>';
	print '<td colspan="2">'. number_format($tva_info['tva'], 2).' '.$langs->getCurrencySymbol($conf->currency).'</td></tr>';
	print '<tr><td width="25%">'.$langs->trans("ApprovalAmountTTC").'</td>';
	print '<td colspan="2">'. number_format($tva_info['amount_ttc'], 2).' '.$langs->getCurrencySymbol($conf->currency).'</td></tr>';
	print '</table><br />';

	if ($user->id && $user->rights->marches->write_all) {
		print '<br>';
		print '<div style="float: right; margin-top: 8px;">';
		print '<a href="./card.php?action=edit&id='.$id.'" class="butAction">'.$langs->trans('Modify').'</a>';
		print '</div>';
	}
}
else {
	print_barre_liste($langs->trans("ListOfMarkets"), $page, $_SERVER["PHP_SELF"], '', $sortfield, $sortorder, "", $num, "", 'title_project.png');

	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	print '<table class="noborder" width="100%;">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("Ref"),$_SERVER["PHP_SELF"], "m.ref_marche", '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("CreatedBy"),$_SERVER["PHP_SELF"],"m.fk_created_by", '','','align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("Type"),$_SERVER["PHP_SELF"],"a.type", '','','align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("Label"), $_SERVER["PHP_SELF"], 'm.label', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("BudgetM"),$_SERVER["PHP_SELF"], 'm.budget', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("Status"),$_SERVER["PHP_SELF"], 'm.statut', '', '', 'align="center"', $sortfield, $sortorder);
	
	print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'','','',$sortfield,$sortorder,'maxwidthsearch ');
	print "</tr>\n";

	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';
	print '<td class="liste_titre" align="left">';
	print '<input class="flat" size="14" type="text" name="search_ref_marche" value="'.dol_escape_htmltag($search_ref_marche).'">';
	print '</td>';

	// UTILISATEUR
	if ($user->rights->marches->write_all) {
	    print '<td class="liste_titre" align="center">';
	    print $form->select_dolusers($search_created_by,"search_created_by",1,"",0,'','',0,32);
	    print '</td>';
	}
	else {
	    print '<td class="liste_titre" align="center">';
	    print $form->select_dolusers($user->id,"search_created_by",1,"",1,'','',0,32);
	    print '</td>';
	}

	// type
	print '<td class="liste_titre" colspan="1" align="center">';
	print $form->selectarray('search_type', AppelOffre::getMarcheTypes(), (GETPOST('search_type') ? GETPOST('search_type') : $search_type), 1, 0, 0, '');
	print '</td>';

	// Label
	print '<td class="liste_titre" colspan="1" align="center">';
	print '<input class="flat" type="text" size="14" name="search_label" value="'.$search_label.'">';
	print '</td>';

	// Budget
	print '<td class="liste_titre" colspan="1" align="center"><input class="flat" type="text" size="14" name="search_budget" value="'.$search_budget.'"></td>';
	// Status
	print '<td class="liste_titre" colspan="1" align="center">';
	$statuts = array(0 => $langs->trans('Still'), 1 => $langs->trans('Archived'));
	print $form->selectarray('search_status', $statuts, (GETPOST('search_status') ? GETPOST('search_status') : $search_status), 1, 0, 0, '');
	print '</td>';

	// ACTION
	print '<td align="right">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';

	print "</tr>\n";

	// Lines
	if (!empty($marches->lines)) {
		$createdBy = new User($db);

		foreach($marches->lines as $line) {
			$var = !$var;
			$createdBy->fetch($db->escape($line->fk_created_by));
			$ref 				  = $line->ref_marche ?: $line->id;
			$label 				  = $line->label ?: '';

			print '<tr '.$bc[$var].'>';
			print '<td align="left" width="15%">';
				print $marches->getNomUrl(1,  $line->id, $ref);
			print '</td>';
			print '<td align="center">'. $createdBy->getNomUrl('1') .'</td>';
			print '<td align="center">'. ucwords(AppelOffre::getMarcheType($line->marche_type)) .'</td>';
			print '<td align="center">'. $label .'</td>';
			print '<td align="center">'. number_format($line->budget, 2, ',', '.').' '.$langs->getCurrencySymbol($conf->currency).'</td>';
			print '<td align="center">'. $marches->statusLevel($line->statut) .'</td>';
			print '<td></td>';
			print '</tr>'."\n";

		}
	}

	print '</table>';
	print '</form>';
}

llxFooter();

$db->close();

?>