<?php 
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *   	\file       marches/provisionalbail/card.php
 *		\ingroup    card
 *		\brief      Gestion des concurrents
 */

require_once('../../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/nc_under_modules/marches/class/appeloffre.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/nc_under_modules/marches/marche/class/marche.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/nc_under_modules/marches/provisionalbail/class/provisionalbail.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/nc_under_modules/marches/lib/marches.lib.php';

// Get parameters
$myparam = GETPOST("myparam");
$action  = GETPOST('action', 'alpha');
$ao 	 = GETPOST('ao', 'int');
$id 	 = GETPOST('id', 'int');
$request_method = $_SERVER['REQUEST_METHOD'];

if (!$ao && $request_method !== 'POST')
	die('ID Appel offre n\'existe pas!');

$langs->load('marches');

// Protection if external user
if ($user->societe_id > 0) accessforbidden();

$error 	    	 = false;
$provisionalbail = new ProvisionalBail($db);
$appeloffre 	 = new AppelOffre($db);
$marches    	 = new Marches($db);

if ($_POST['action'] == 'create' && $request_method === 'POST') {

    // If no right to create a request
    if (empty($user->rights->marches->write) || empty($user->rights->marches->write_all)) {
    	$error++;
    	setEventMessage($langs->trans('CantCreate'));
    	$action='request';
    }

   	$bail_date 		= '';
    $bail_amount	= '';
    $ao 			= trim(GETPOST('ao', 'int'));
    $bail_amount	= trim(GETPOST('bail_amount'));

    if (isset($_POST['bail_date']) && !empty($_POST['bail_date'])) {
        list($btd, $btm, $bty) = explode("/", $_POST['bail_date']);
        $bail_date 			   = $bty.'-'.$btm.'-'.$btd;
    }

    if (!$ao || !$bail_amount || !$bail_date)
    	return;

    $provisionalbail->fk_created_by  = $user->id;
    $provisionalbail->fk_appel_offre = $ao;
    $provisionalbail->bail_amount 	 = $bail_amount;
	$provisionalbail->bail_date 	 = $bail_date;
	
	$getprovisionalbailId = $provisionalbail->create();

    // If no SQL error we redirect to the request card
    header('Location: ./index.php?ao='.$ao.'&id='.$getprovisionalbailId);
    die();
}

if ($_POST['action'] == 'update' && $_POST['id'] > 0 && $_POST['ao'] > 0 && $request_method === 'POST') {
	// If no right to create a request
    if (empty($user->rights->marches->write) || empty($user->rights->marches->write_all)) {
    	$error++;
    	setEventMessage($langs->trans('CantCreate'));
    	$action='add';
    } else {
	    $signature_date = '';
	    $provisionalbail_date	= '';
	    $visa_date		= '';

	    $ao 		  = trim(GETPOST('ao', 'int'));
	    $id  		  = trim(GETPOST('id', 'int'));
	    $bail_amount  = trim(GETPOST('bail_amount'));
	  	$bail_date 	  = '';

	    if (isset($_POST['bail_date']) && !empty($_POST['bail_date'])) {
	        list($btd, $btm, $bty) = explode("/", $_POST['bail_date']);
	        $bail_date 			   = $bty.'-'.$btm.'-'.$btd;
	    }
	  

	   	if (!$ao || !$bail_amount || !$bail_date)
    		return;

	    $data = array(
		    'bail_amount' => $bail_amount,
			'bail_date'   => $bail_date
		);

		$provisionalbail->update($id, $ao, $data);

    	header('Location: ./index.php?ao='.$ao.'&id='.$id);
        die();
	}
}
/*
if ($action == 'confirm_delete' && $_GET['confirm'] == 'yes' && $user->rights->marches->delete) {
	$error = 0;
	$ao = GETPOST('ao', 'int');
	$id = GETPOST('id', 'int');
	
	if (!$ao || !$id)
		return;

	$db->begin();

	$canedit = ($user->rights->marches->write_all || $user->rights->marches->delete);

	// Si l'utilisateur à le droit de lire ce contrat, il peut le supprimer
	if ($canedit) {
        $provisionalbail->id = (int) $id;
        $provisionalbail->fk_appel_offre = (int) $ao;
		$provisionalbail->delete();
	} else {
		$error = $langs->trans('ErrorCantDelete');
	}

	if (!$error) {
		$db->commit();
		header('Location: ./index.php?leftmenu=marches&ao='.$ao);
		exit;
	} else {
		$db->rollback();
        header('Location: ./index.php?leftmenu=marches&ao='.$ao);
        exit;
	}
}*/

$form 	 = new Form($db);
$morejs  = array("/btp/nc_under_modules/marches/js/marches.js");
$morecss = array("/btp/nc_under_modules/marches/css/marches.css");

llxHeader(array(), $langs->trans('ListOfprovisionalbail'),'','','','',$morejs,$morecss,0,0);

if (empty($ao) || $action == 'add' || $action == 'request' || $action == 'create') {
	// Si l'utilisateur n'a pas le droit de créer un marché
    if (empty($user->rights->marches->write) || empty($user->rights->marches->write_all)) {
        $errors[] = $langs->trans('CantCreateMarche');
    } else {
        // Formulaire de concurrents
		$appeloffre->fetch($ao);
		$head = appeloffre_prepare_head($appeloffre);
		dol_fiche_head($head, 'provisionalbail', $langs->trans('AddProvisionalbail'), 0, '');

		echo $appeloffre->getAppelOffreHeader();

        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">'."\n";
        print '<input type="hidden" name="action" value="create" />'."\n";
        print '<input type="hidden" name="ao" value="'. $ao .'" />'."\n";

        print '<table class="border" width="100%" data-row-id="0">';
        print '<tbody>';

        print '<tr><td class="fieldrequired" width="25%">'.$langs->trans("ProvAmount").'TTC</td><td>';
        print '<input type="text" class="amount" value="" name="bail_amount" required="required" /></td></tr>';
        
        print '<tr><td class="fieldrequired">'.$langs->trans("ReturnedAt").'</td><td>';
        print '<input type="text" class="datepicker" autocomplete="off"  value="" name="bail_date" required="required" /></td></tr>';

        print '</tbody>';
        print '</table>';

		dol_fiche_end();

        print '<div class="center"  style="margin-top: 28px;">';
        print '<input type="submit" value="'. $langs->trans("CreateProvisionalbail") .'" name="bouton" class="butAction">';
        print '&nbsp; &nbsp; ';
        print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
        print '</div>';

        print '</form>';
    }
} else {
	if ($id > 0 && $ao > 0) {
		$provisionalbail->fetch($id, $ao);
		$appeloffre->fetch($ao);
		$head  = appeloffre_prepare_head($appeloffre);
		$canedit = ($user->rights->marches->delete || $user->rights->marches->write_all);

		if ($canedit) {
            if ($action == 'delete') {
                if($user->rights->marches->delete) {
                    print $form->formconfirm("./card.php?ao=".$ao."&id=".$id, $langs->trans("TitleDeleteMonitoring"),$langs->trans("ConfirmDeleteMonitoring"),"confirm_delete", '', 0, 1);
                }
            }

			if ($action == 'edit' || $action == 'delete') {
				dol_fiche_head($head, 'provisionalbail', $langs->trans('Addprovisionalbail'), 0, '');

				echo $appeloffre->getAppelOffreHeader();

		        print '<form method="POST" action="'.$_SERVER['PHP_SELF'].'" class="sub_form_prt">'."\n";
		        print '<input type="hidden" name="action" value="update" />'."\n";
		        print '<input type="hidden" name="ao" value="'. $ao .'" />'."\n";
		        print '<input type="hidden" name="id" value="'. $id .'" />'."\n";

				$bail_amount = $provisionalbail->bail_amount ? number_format($provisionalbail->bail_amount, 2) : '';
				$bail_date	 = $provisionalbail->bail_date ? dol_print_date($provisionalbail->bail_date, 'day') : '';

		        print '<table class="border" width="100%" data-row-id="0">';
		        print '<tbody>';

		        print '<tr><td class="fieldrequired" width="25%">'.$langs->trans("ProvAmount").'TTC</td><td>';
		        print '<input type="text" class="amount" value="'. $bail_amount .'" name="bail_amount" required="required" /> </td></tr>';
		        
		        print '<tr><td class="fieldrequired">'.$langs->trans("ReturnedAt").'</td><td>';
		        print '<input type="text" class="datepicker" autocomplete="off"  value="'. $bail_date .'" name="bail_date" required="required" /></td></tr>';

		        print '</tbody>';
		        print '</table>';

				dol_fiche_end();

		        print '<div class="tabsAction">';
                    // Boutons d'actions
		        	print '<input type="submit" value="'. $langs->trans("Modify") .'" name="bouton" class="butAction '. $addMoreBtns .'">';
                    print '<a onclick="history.go(-1)" class="butAction">'.$langs->trans("Cancel").'</a>';
                print '</div>';

		        print '</form>';
			}
        }
	}
}



llxFooter();

$db->close();

?>