<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file       marches/purchaseorder/index.php
 * \ingroup    purchaseorder
 * \brief      List of purchaseorder
 */
require_once('../../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/nc_under_modules/marches/purchaseorder/class/purchaseorder.class.php';
require_once DOL_DOCUMENT_ROOT.'/compta/bank/class/account.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/nc_under_modules/marches/lib/marches.lib.php';
require_once DOL_DOCUMENT_ROOT.'/btp/nc_under_modules/marches/lib/tools.lib.php';

// Get parameters
$myparam = GETPOST("myparam");
$action  = GETPOST('action', 'alpha');
$id 	 = GETPOST('id', 'int');
$request_method = $_SERVER['REQUEST_METHOD'];

// Protection if external user
if ($user->societe_id > 0) accessforbidden();

$error 	= false;
$object = new PurchaseOrder($db);

if ($_POST['action'] == 'create' && $request_method === 'POST') {

    $action='request';
	// If no right to create a request
    if (empty($user->rights->marches->write) || empty($user->rights->marches->write_all)) {
    	$error++;
    	setEventMessage($langs->trans('CantCreateBC'));
    	header("Location: ./index.php"); die();
    } else {
	    $num   = trim(GETPOST('num'));
	    $ref   = trim(GETPOST('ref'));
	    $label = trim(GETPOST('label'));
	    $_socid = trim(GETPOST('socid', 'int'));

	    if (!$num || !$_socid || !$ref || !$label)
			return;

	    $subject 		= trim(GETPOST('subject', 'alpha'));
	    $country 		= trim(GETPOST('country', 'alpha'));
	    $state   		= trim(GETPOST('state', 'alpha'));
	    $city 			= trim(GETPOST('city', 'alpha'));
	    $budget  		= trim($_POST['budget']);
		$creation_date 	= Tools::convertDateTo($_POST['creation_date'], 'sql');
		$date_etabli 	= Tools::convertDateTo($_POST['date_etabli'], 'sql');
		$reception_date = Tools::convertDateTo($_POST['reception_date'], 'sql');
		$deadline 		= Tools::convertDateTo($_POST['deadline'], 'sql');

	    $object->fk_created_by	= $user->id;
	    $object->fk_third_party = $_socid;
	    $object->ref 		 	= $ref;
	    $object->subject 	 	= $subject;
	    $object->label 			= $label;
	    $object->num 			= $num;
	    $object->creation_date 	= $creation_date;
	    $object->date_etabli 	= $date_etabli;
	    $object->budget 		= $budget;
	    $object->reception_date = $reception_date;
	    $object->deadline 		= $deadline;
	    $object->country 		= $country;
	    $object->state 			= $state;
	    $object->city 			= $city;

		$getId = $object->create();

		if ($getId) {
		    header('Location: ./index.php?id='. $getId);
		    die();
		} else {
			header('Location: ./index.php');
		    die();
		}
    }
}

if ($_POST['action'] == 'update' && $_POST['id'] > 0 && $request_method === 'POST') {

	 if (empty($user->rights->marches->write) || empty($user->rights->marches->write_all)) {
    	$error++;
    	setEventMessage($langs->trans('CantCreate'));
    } else {
    	$num   = trim(GETPOST('num'));
	    $ref   = trim(GETPOST('ref'));
	    $label = trim(GETPOST('label'));
	    $_socid = trim(GETPOST('socid', 'int'));

	    if (!$num || !$_socid || !$ref || !$label)
			return;

	    $subject 		= trim(GETPOST('subject', 'alpha'));
	    $country 		= trim(GETPOST('country', 'alpha'));
	    $state   		= trim(GETPOST('state', 'alpha'));
	    $city 			= trim(GETPOST('city', 'alpha'));
	    $budget  		= trim($_POST['budget']);
		$creation_date 	= Tools::convertDateTo($_POST['creation_date'], 'sql');
		$date_etabli 	= Tools::convertDateTo($_POST['date_etabli'], 'sql');
		$reception_date = Tools::convertDateTo($_POST['reception_date'], 'sql');
		$deadline 		= Tools::convertDateTo($_POST['deadline'], 'sql');
		$id = (int)trim($_POST['id']);

	    $data = array(
	    	'ref' 			=> $ref,
	    	'subject' 		=> $subject,
	    	'fk_third_party'=> $_socid,
		    'label' 		=> $label,
		    'num' 			=> $num,
		    'creation_date' => $creation_date,
		    'date_etabli' 	=> $date_etabli,
		    'budget' 		=> $budget,
		    'reception_date'=> $reception_date,
		    'deadline' 		=> $deadline,
		    'country' 		=> $country,
		    'state' 		=> $state,
		    'city' 			=> $city
	    );

		$object->update($id, $data);
		header('Location: ./index.php?id='. $id);
	    die();
	}

	$action = "edit";
}

if ($action == 'confirm_delete' && $_GET['confirm'] == 'yes' && $user->rights->marches->delete) {
	$error 	= 0;
	$id 	= GETPOST('id', 'int');
	
	if (!$id)
		return;

	$db->begin();

	$canedit = ($user->rights->marches->write_all || $user->rights->marches->delete);

	// Si l'utilisateur à le droit de lire ce contrat, il peut le supprimer
	if ($canedit) {
		$object->delete((int) $id);
	} else {
		$error = $langs->trans('ErrorCantDelete');
	}

	if (!$error) {
		$db->commit();
		header('Location: ./index.php');
		exit;
	} else {
		$db->rollback();
        header('Location: ./index.php');
        exit;
	}
}

$form = new Form($db);

llxHeader(array(), $langs->trans('ListOfPurchaseOrder'),'','','','',array('/btp/nc_under_modules/marches/js/marches.js'),array(),0,0);

if (empty($id) || $action == 'add' || $action == 'request' || $action == 'create') {
	if (empty($user->rights->marches->write) || empty($user->rights->marches->write_all)) {
        $errors[] = $langs->trans('CantCreateMarche');
    } else {
        print_fiche_titre($langs->trans('CreateBC'), '', '');

        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">'."\n";
        print '<input type="hidden" name="action" value="create" />'."\n";

        print '<table class="border" width="100%" data-row-id="0">';
        print '<tbody>';

        print '<tr><td class="fieldrequired" width="25%">'.$langs->trans("PONum").'</td><td>';
        print '<input type="text" class="" value="" name="num" required="required" />';
        print '</td></tr>';

        print '<tr><td>'.$langs->trans("Subject").'</td><td>';
        print ' <textarea cols="49" rows="6" name="subject"></textarea>';
        print '</td></tr>';

		print '<tr><td class="fieldrequired">'.$langs->trans("Label").'</td><td>';
        print '<input type="text" class="" value="" name="label" required="required" />';
        print '</td></tr>';

        // Thirdparty
        print '<tr><td>'.$langs->trans("ThirdPartyMarket").'</td><td>';
        $filteronlist='';
        if (! empty($conf->global->PROJECT_FILTER_FOR_THIRDPARTY_LIST)) $filteronlist=$conf->global->PROJECT_FILTER_FOR_THIRDPARTY_LIST;
        $text=$form->select_thirdparty_list(GETPOST('socid','int'),'socid',$filteronlist,1,1);
        if (empty($conf->global->PROJECT_CAN_ALWAYS_LINK_TO_ALL_SUPPLIERS) && empty($conf->dol_use_jmobile))
        {
            $texthelp=$langs->trans("IfNeedToUseOhterObjectKeepEmpty");
            print $form->textwithtooltip($text.' '.img_help(),$texthelp,1);
        }
        else print $text;

        $dircustom = DOL_DOCUMENT_ROOT.'/societe/soc.php';
        $createsoci = "soc.php";
        if (!is_dir($dircustom)) {
            $createsoci = "card.php";
        }
        print ' <a href="'.DOL_URL_ROOT.'/societe/'.$createsoci.'?action=create&backtopage='.urlencode($_SERVER["PHP_SELF"].'?action=create').'">'.$langs->trans("AddThirdParty").'</a>';
        print '</td></tr>';

        print '<tr><td class="">'.$langs->trans("Ref").'</td><td>';
        print '<input type="text" class="" value="" name="ref" />';
        print '</td></tr>';

        print '<tr><td>'.$langs->trans("CreationDate").'</td><td>';
        print '<input type="text" class="datepicker" autocomplete="off"  value="" name="creation_date" /></td></tr>';

        print '<tr><td class="">'.$langs->trans("Country").'</td><td>';
        print '<input type="text" class="" value="" name="country" /></td></tr>';

        print '<tr><td class="">'.$langs->trans("Province").'</td><td>';
        print '<input type="text" class="" value="" name="state" /></td></tr>';

        print '<tr><td class="">'.$langs->trans("City").'</td><td>';
        print '<input type="text" class="" value="" name="city" /></td></tr>';

        print '</tbody>';
        print '</table>';

		print_barre_liste($langs->trans("BCDetail"), '', '', '', '', '', "", "", "", '');

        print '<table class="border" width="100%" data-row-id="0">';
        print '<tbody>';

        print '<tr><td class="" width="25%">'.$langs->trans("BCDateEtab").'</td><td>';
        print '<input type="text" class="datepicker" autocomplete="off"  value="" name="date_etabli" />';
        print '</td></tr>';

        print '<tr><td>'.$langs->trans("AmountTTC").'</td><td>';
        print '<input type="text" class="" value="" name="budget" />';
        print '</td></tr>';

         print '</tbody>';
        print '</table>';

        print_barre_liste($langs->trans("BCInfoConsLetter"), '', '', '', '', '', "", "", "", '');

        print '<table class="border" width="100%" data-row-id="0">';
        print '<tbody>';

        print '<tr><td class="" width="25%">'.$langs->trans("StartDate").'</td><td>';
        print '<input type="text" class="datepicker" autocomplete="off"  value="" name="reception_date" />';
        print '</td></tr>';

        print '<tr><td>'.$langs->trans("EndDate").'</td><td>';
        print '<input type="text" class="datepicker" autocomplete="off"  value="" name="deadline" />';
        print '</td></tr>';

         print '</tbody>';
        print '</table>';

		// dol_fiche_end();

        print '<div class="center"  style="margin-top: 28px;">';
        print '<input type="submit" value="'. $langs->trans("CreateBC") .'" name="bouton" class="butAction">';
        print '&nbsp; &nbsp; ';
        print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
        print '</div>';

        print '</form>';
    }
} else {
	if ($id) {
		$object->fetch($id);
		$head  = purchaseorder_prepare_head($object);
		$canedit = ($user->rights->marches->delete || $user->rights->marches->write_all);

		if ($canedit) {
            if ($action == 'delete') {
                if($user->rights->marches->delete) {
                    print $form->formconfirm("./card.php?id=".$id, $langs->trans("TitleDeleteNotif"),$langs->trans("ConfirmDeleteNotif"),"confirm_delete", '', 0, 1);
                }
            }

			if ($action == 'edit' || $action == 'delete') {
				dol_fiche_head($head, 'purchaseorder', $langs->trans('EditBC'), 0, '');

		        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">'."\n";
		        print '<input type="hidden" name="action" value="update" />'."\n";
		        print '<input type="hidden" name="id" value="'. $id .'" />'."\n";

				print '<table class="border" width="100%" data-row-id="0">';
		        print '<tbody>';

		        print '<tr><td class="fieldrequired" width="25%">'.$langs->trans("PONum").'</td><td>';
		        print '<input type="text" class="" value="'. $object->num .'" name="num" required="required" />';
		        print '</td></tr>';

		        print '<tr><td>'.$langs->trans("Subject").'</td><td>';
		        print ' <textarea cols="49" rows="6" name="subject">'. $object->subject .'</textarea>';
		        print '</td></tr>';

				print '<tr><td class="fieldrequired">'.$langs->trans("Label").'</td><td>';
		        print '<input type="text" class="" value="'. $object->label .'" name="label" required="required" />';
		        print '</td></tr>';

		        // Thirdparty
		        print '<tr><td>'.$langs->trans("ThirdPartyMarket").'</td><td>';
		        $filteronlist='';
		        if (! empty($conf->global->PROJECT_FILTER_FOR_THIRDPARTY_LIST)) $filteronlist=$conf->global->PROJECT_FILTER_FOR_THIRDPARTY_LIST;
		        $text=$form->select_thirdparty_list(($object->fk_third_party ?: GETPOST('socid','int')),'socid',$filteronlist,1,1);
		        if (empty($conf->global->PROJECT_CAN_ALWAYS_LINK_TO_ALL_SUPPLIERS) && empty($conf->dol_use_jmobile))
		        {
		            $texthelp=$langs->trans("IfNeedToUseOhterObjectKeepEmpty");
		            print $form->textwithtooltip($text.' '.img_help(),$texthelp,1);
		        }
		        else print $text;
		        print ' <a href="'.DOL_URL_ROOT.'/societe/soc.php?action=create&backtopage='.urlencode($_SERVER["PHP_SELF"].'?action=create').'">'.$langs->trans("AddThirdParty").'</a>';
		        print '</td></tr>';

		        print '<tr><td class="">'.$langs->trans("Ref").'</td><td>';
		        print '<input type="text" class="" value="'. $object->ref .'" name="ref" />';
		        print '</td></tr>';

		        print '<tr><td>'.$langs->trans("CreationDate").'</td><td>';
		        print '<input type="text" class="datepicker" autocomplete="off"  value="'. dol_print_date($object->creation_date, 'day') .'" name="creation_date" /></td></tr>';

		        print '<tr><td class="">'.$langs->trans("Country").'</td><td>';
		        print '<input type="text" class="" value="'. $object->country .'" name="country" /></td></tr>';

		        print '<tr><td class="">'.$langs->trans("Province").'</td><td>';
		        print '<input type="text" class="" value="'. $object->state .'" name="state" /></td></tr>';

		        print '<tr><td class="">'.$langs->trans("City").'</td><td>';
		        print '<input type="text" class="" value="'. $object->city .'" name="city" /></td></tr>';

		        print '</tbody>';
		        print '</table>';

				print_barre_liste($langs->trans("BCDetail"), '', '', '', '', '', "", "", "", '');

		        print '<table class="border" width="100%" data-row-id="0">';
		        print '<tbody>';

		        print '<tr><td class="" width="25%">'.$langs->trans("BCDateEtab").'</td><td>';
		        print '<input type="text" class="datepicker" autocomplete="off"  value="'. dol_print_date($object->date_etabli, 'day') .'" name="date_etabli" />';
		        print '</td></tr>';

		        print '<tr><td>'.$langs->trans("Amount").'</td><td>';
		        print '<input type="text" class="" value="'. $object->budget .'" name="budget" />';
		        print '</td></tr>';

		         print '</tbody>';
		        print '</table>';

		        print_barre_liste($langs->trans("BCInfoConsLetter"), '', '', '', '', '', "", "", "", '');

		        print '<table class="border" width="100%" data-row-id="0">';
		        print '<tbody>';

		        print '<tr><td class="" width="25%">'.$langs->trans("StartDate").'</td><td>';
		        print '<input type="text" class="datepicker" autocomplete="off"  value="'. dol_print_date($object->reception_date, 'day') .'" name="reception_date" />';
		        print '</td></tr>';

		        print '<tr><td>'.$langs->trans("EndDate").'</td><td>';
		        print '<input type="text" class="datepicker" autocomplete="off"  value="'. dol_print_date($object->deadline, 'day') .'" name="deadline" />';
		        print '</td></tr>';

		         print '</tbody>';
		        print '</table>';

				dol_fiche_end();

		        print '<div class="tabsAction">';
                    // Boutons d'actions
		        	print '<input type="submit" value="'. $langs->trans("Modify") .'" name="bouton" class="butAction">';
                    print '<a onclick="history.go(-1)" class="butAction">'.$langs->trans("Cancel").'</a>';
                    if ($user->rights->marches->delete)	{
                    	print '<a href="./card.php?id='.$id.'&action=delete" class="butActionDelete">'.$langs->trans("Delete").'</a>';
                    }
                print '</div>';

		        print '</form>';
			}
        }
	}
}

llxFooter();

$db->close();

?>
