<?php
require_once DOL_DOCUMENT_ROOT .'/btp/db/nxdb.class.php';

class AdvanceUser extends NXdb{

	/**
	 * @var string Error code (or message)
	 * @deprecated
	 * @see test::errors
	 */
	public $error;
	/**
	 * @var string[] Error codes (or messages)
	 */
	public $errors = array();
 /**
	 * @var string Id to identify managed objects
	 */
	public $element = 'advance_user';
	/**
	 * @var string Name of table without prefix where object is stored
	 */
	public $table_element = 'advance_user';
	
	public $advancefor_id;
	public $advanceby_id;
	public $datec ;
	public $amount;
	public $fk_createdby;
	public $rows = array();
	public $now;
    public $rowid;
    public $id;
	public function __construct(DoliDBMysqli $db)
	{
		$this->db 		 = $db;
		$this->now 		 = new \DateTime("now");
		$this->now 		 = $this->now->format('Y-m-d H:i:s');
		return 1;
	}

	public function create()
	{
 		dol_syslog(__METHOD__, LOG_DEBUG);

		// Clean parameters
		$this->fk_createdby 			    = $this->fk_createdby ? $this->db->escape($this->fk_createdby): null;
		$this->advancefor_id			= $this->advancefor_id ? $this->db->escape($this->advancefor_id): null;
		$this->datec 			    = $this->datec ? $this->db->escape($this->datec): null;
		$this->advanceby_id 			    = $this->advanceby_id ? $this->db->escape($this->advanceby_id): null;
		$this->amount			    = $this->amount ? $this->db->escape($this->amount): 0;
		// Insert request
		$sql = 'INSERT INTO ' . MAIN_DB_PREFIX . $this->table_element .'(created_by,advancefor_id,advanceby_id,datec,amount,created_at,updated_at) VALUES (';
		$sql .= ''.$this->fk_createdby.', '.$this->advancefor_id.','.$this->advanceby_id.',"'.$this->datec.'",
		'.$this->amount.',"'.$this->now.'","'.$this->now.'")';
		
		$this->db->begin();
		$resql = $this->db->query($sql);
		if (!$resql) {
			$this->db->rollback();
			$this->errors[] = 'Error Evenement ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);
			var_dump($errors);
			return -1;
		} else {
			$this->db->commit();
	return $this->getLasInsrtedId();
		}
	}
public function fetch($id, $ref = null)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . $this->table_element ;
		
		if (null !== $ref) {
			$sql .= ' WHERE ref = ' . '\'' . $ref . '\'';
		} else {
			$sql .= ' WHERE rowid = ' . $id;
		}

		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			if ($numrows) {
				$obj 			    = $this->db->fetch_object($resql);
				$this->rowid 		= $obj->rowid;
				$this->fk_createdby = $obj->fk_createdby;
				$this->advancefor_id= $obj->advancefor_id;
				$this->advanceby_id = $obj->advanceby_id ;
				$this->datec 		= $obj->datec ;
				$this->amount		= $obj->amount ;
			}

			$this->db->free($resql);

			if ($numrows) {
				return 1;
			} else {
				return 0;
			}
		} else {
	
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	public function getNomUrl($withpicto = 0,  $id = null, $ref = null)
    {
        global $langs;

        $result	= '';
        $setRef = (null !== $ref) ? $ref : '';
        $id  	= ($id  ?: '');
        $label  = $langs->trans("Show").': '. $setRef;

        $link 	 = '<a href="'.DOL_URL_ROOT.'/btp/rh/advance_user/index.php?id='. $id .'" title="'.dol_escape_htmltag($label, 1).'" class="classfortooltip">';
        $linkend ='</a>';
        $picto   = '';

        if ($withpicto) $result.=($link.img_object($label, $picto, 'class="classfortooltip"').$linkend);
        if ($withpicto && $withpicto != 2) $result.=' ';
        if ($withpicto != 2) $result.=$link.$setRef.$linkend;

        if ($setRef != "") {
        	$result = $link."<div class='icon-empty_folder mainvmenu'></div>  ".$setRef.$linkend;
        }else{
        	$result = "-";
        }
        return $result;
    }
	
	public function delete()
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$this->db->begin();

		$sql 	= 'DELETE FROM ' . MAIN_DB_PREFIX . $this->table_element  .' WHERE  rowid = ' . $this->rowid;
		$resql 	= $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}
	public function update($id, array $data)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$id || $id <= 0)
			return false;

		// Update request
		$sql = 'UPDATE ' . MAIN_DB_PREFIX . $this->table_element  . ' SET ';
		if (count($data) && is_array($data))
			foreach ($data as $key => $val) {
				$val = is_numeric($val) ? $val : '"'. $val .'"';
				$sql .= '`'. $key. '` = '. $val .',';
			}
		$sql  = substr($sql, 0, -1);
		$sql .= ' WHERE  rowid = ' . $id;

		$this->db->begin();
		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();
			
			$this->error 	= 'Error ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}
	//search
	public function fetchAll($sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '', $id = '')
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX .$this->table_element;

		if (!empty($filter)) {
			$sql .= ' WHERE '. substr($filter, 4);
		}
		
		if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}

		$this->rows = array();
		$resql 		 = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;
     	        $line->rowid 			= $obj->rowid;
				$line->advancefor_id    = $obj->advancefor_id;
				$line->advanceby_id	    = $obj->advanceby_id;
				$line->datec		    = $obj->datec;
				$line->amount	    	= $obj->amount;
				$line->fk_createdby     = $obj->fk_createdby;
				$this->rows[] 		    = $line;
			}

			$this->db->free($resql);

			return $num;
		} else {
			echo 'erreur';

			die();
			$this->error 	= 'Error ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	public function getStatData()
    {
    	global $langs;
    	$this->fetchAll();
    	$countAmount = 0;

    	foreach ($this->rows as $key => $obj)
    		$countAmount += $obj->amount;

    	$object 		= new stdClass();
    	$object->number = count($this->rows);
    	$object->cost 	= $countAmount;
    	$object->label 	= $langs->trans('advance_user');
    	$object->url 	= DOL_URL_ROOT.'/btp/rh/advance_user/index.php';

    	return $object;
    }

	/**
     * Load indicators for dashboard (this->nbtodo and this->nbtodolate)
     *
     * @param	User	$user   Objet user
     * @return WorkboardResponse|int <0 if KO, WorkboardResponse if OK
     */
    public function load_board()
    {
        global $conf, $user, $langs;

		require_once DOL_DOCUMENT_ROOT . '/btp/rh/integration/class/integration.class.php';

		$integration = new Integration($this->db);

        return array($this->getStatData(), $integration->getStatData());
    }
}
