<?php 
/* Copyright (C) 2016		Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *   	\file       marches/list.php
 *		\ingroup    list
 *		\brief      Gestion de type des compteurs
 */

require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/btp/settings/counter_type/class/CounterType.class.php';
// Get parameters
$myparam = GETPOST("myparam");
$action  = GETPOST('action', 'alpha');
$id 	 = GETPOST('id', 'int');
$request_method = $_SERVER['REQUEST_METHOD'];
$langs->load('btp');
if ($user->societe_id > 0) accessforbidden();
$now 	= new DateTime('now');
$error 	= false;
if ($action == 'update' && $request_method === 'POST') {
    $count_type_id = (int) GETPOST('count_type_id', 'int');

    if (!$count_type_id || $count_type_id <= 0) {
        header('Location: ./card.php?action=request&error=CantUpdate');
        exit;
    }
    $count_type = new CounterType($db);
    $count_type->fetch($count_type_id);
    $canedit = true ; 
    $name  = trim(GETPOST('name'));
    // If this is the requestor or has read/write rights
    if ($canedit) {
        $name   = trim(GETPOST('name'));
		// Update
        $data = array(
            'name'             => $name,

        );
        if(empty($name)){
            header('Location: ./card.php?id='. $count_type_id .'&action=edit&error=SQL_Create&msg="Veuillez renseigner tout les champs"');
                die(); 
             }
       
        $getMarcheID = $count_type->update($count_type_id, $data);
 
        if ($getMarcheID > 0) {
        header('Location: ./index.php?id='.$count_type_id);
            exit;
        } else {
            // Otherwise we display the request form with the SQL error message
            header('Location: ./card.php?id='. $count_type_id .'&action=edit&error=SQL_Create&msg=Veuillez renseigner tout les champs');
            exit;
        }
    }
}
// If delete of request
if ($action == 'confirm_delete' && GETPOST('confirm') == 'yes' ) {
	$error=0;
	$count_type  = new CounterType($db);
	 $canedit = true;
	// Si l'utilisateur à le droit de lire ce contrat, il peut le supprimer
	if ($canedit) {
        $count_type->fetch($id);
		$count_type->delete();
	}
	else {
		$error = $langs->trans('ErrorCantDelete');
	}
	if (!$error) {
		header('Location: index.php');
		exit;
	}
	else {
		
        header('Location: index.php?leftmenu=marches');
        exit;
	}
}

/*
 * View
 */

$form           = new Form($db);
$count_type     = new CounterType($db);
//insertion d'un type de compteur
if ($action == 'create' && $request_method === 'POST') {
    $count_type = new CounterType($db);
    $name     = GETPOST('name');
        // Vars
        $count_type->name                = trim(GETPOST('name'));
        $count_type->fk_createdby                = $user->id;
            if(!empty($name)){
           $getMarcheID = $count_type->create();
       }
        else
        {
        header('Location: card.php?action=request&error=SQL_Create&msg="Veuillez renseigner tout les champs"');
                   exit();
        }
 if ($getMarcheID > 0) {
            header('Location: index.php?id='.$getMarcheID);
            exit;
        } else {
            // Otherwise we display the request form with the SQL error message
  header('Location: card.php?action=request&error=SQL_Create&msg="Veuillez renseigner tout les champs"');
      exit(); 
        }
}
llxHeader(array(), $langs->trans('counter_type'),'','','','',$morejs,$morecss,0,0);

if (empty($id) || $action == 'add' || $action == 'request' || $action == 'create') {
	// Si l'utilisateur n'a pas le droit de créer un marché
    /*if (empty($user->rights->marches->write) || empty($user->rights->marches->write_all)) {
        $errors[]=$langs->trans('CantCreate');
    }
    else {*/
        // Formulaire appel d'offre
        print_fiche_titre($langs->trans('addtypecounter'));

        // Si il y a une erreur
        if (GETPOST('error')) {
            switch(GETPOST('error')) {
                case 'nobudget' :
                    $errors[] = $langs->trans('errorNoBudget');
                    break;
                case 'SQL_Create' :
                    $errors[] = $langs->trans('ErrorSQLCreateCP').' <b>'.htmlentities($_GET['msg']).'</b>';
                    break;
                case 'CantCreate' :
                    $errors[] = $langs->trans('CantCreateCP');
                    break;
                case 'nouser' :
                    $errors[] = $langs->trans('errorNoUser');
                    break;
                case 'nodatedebut' :
                    $errors[] = $langs->trans('NoDateDebut');
                    break;
                case 'nobank' :
                    $errors[] = $langs->trans('errorNoBank');
                    break;
                case 'noqc' :
                    $errors[] = $langs->trans('errorNoQc');
                    break;
                case 'alreadyExists' :
                    $errors[] = $langs->trans('alreadyExistAO');
                    break;
                case 'noref' :
                    $errors[] = $langs->trans('errorNoRef');
                    break;
            }

	        setEventMessage($errors, 'errors');
        }
        print '<form method="POST" action="'.$_SERVER['PHP_SELF'].'">'."\n";
        print '<input type="hidden" name="action" value="create" />'."\n";

        print '<table class="border" width="100%">';
        print '<tbody>';
        // Name
        print '<tr><td class="fieldrequired">'.$langs->trans("Name").'</td><td class="fieldrequired">';
        print '<input type=text name="name" required="required">';
        print '</td></tr>';
        print '</tbody>';
        print '</table>';
        print '<div class="center">';
        print '<input type="submit" value="'. $langs->trans("createtypecounter") .'" name="bouton" class="butAction">';
        print '&nbsp; &nbsp; ';
        print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
        print '</div>';
        print '</form>';
}
else {
    print_fiche_titre($langs->trans('Detai_countertype'));
    if ($error) {
        print '<div class="tabBar">';
        print $error;
        print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
        print '</div>';
    }
    else {
        // Affichage 
      if ($id > 0) {
    $count_type->fetch($id);
    // Si il y a une erreur
 if (GETPOST('error')) {
   switch(GETPOST('error')) {
               case 'datefin' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorEndDateCP');
                        break;
                    case 'SQL_Create' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorSQLCreateCP').' '.$_GET['msg'];
                        break;
                    case 'CantCreate' :
                        $errors[] = $langs->transnoentitiesnoconv('CantCreateCP');
                        break;
                    case 'Valideur' :
                        $errors[] = $langs->transnoentitiesnoconv('InvalidValidatorCP');
                        break;
                    case 'nodatedebut' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateDebut');
                        break;
                    case 'nodatefin' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateFin');
                        break;
                    case 'DureeHoliday' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorDureeCP');
                        break;
                    case 'NoMotifRefuse' :
                        $errors[] = $langs->transnoentitiesnoconv('NoMotifRefuseCP');
                        break;
                    case 'mail' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorMailNotSend')."\n".$_GET['error_content'];
                        break;
                }

	            setEventMessage($errors, 'errors');
            }
                if ($action == 'delete') {
   
    print_fiche_titre($langs->trans('Detai_countertype'));

                        print $form->formconfirm("card.php?id=".$id, $langs->trans("TitleDeleteCom"),$langs->trans("ConfirmDeletemCom"),"confirm_delete", '', 0, 1);
                        print '<table class="border" width="100%">';
                // Ref
                 print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Refe").'</td>';
                 print '<td colspan="2">'. $count_type->rowid .'</td></tr>';
                 //Nom
                 print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Nom").'</td>';
                  print '<td colspan="2">'. $count_type->name .'</td></tr>';

                   print '</table>';
                    }
                // Si annulation
                if ($action == 'cancel') {
                    print $form->formconfirm("card.php?id=".$id, $langs->trans("TitleCancelSC"), $langs->trans("ConfirmCancelSC"),"confirm_cancel", '', 1, 1);
                }
                if ($action == 'edit') {
                    $edit = true;
                    $id=$_GET['id'];
                    print '<form method="post" action="'.$_SERVER['PHP_SELF'].'?id='.$id.'">'."\n";
                    print '<input type="hidden" name="action" value="update" />'."\n";
                    print '<input type="hidden" id="h" name="count_type_id" value='.$id.' />'."\n";
                    print '<table class="border" width="100%">';
                    print '<tbody>';
                    // Name
                    print '<tr><td class="fieldrequired">'.$langs->trans("Name").'</td><td>';
                    print '<input name="name"  type=text value="'.$count_type->name.'" " required="required"></td></tr>';
                    print '</tbody>';
                    print '</table>';
                    print '<div class="center">';
                    print '<input type="submit" value="'. $langs->trans("Modify") .'" name="bouton" class="butAction">';
                    print '&nbsp; &nbsp; ';
                    print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
                    print '</div>';
                    print '</table>';
                }

                dol_fiche_end();

                if (!$edit) {
		            print '<div class="tabsAction">';
                        print '<a href="card.php?id='.$_GET['id'].'&action=edit" class="butAction">'.$langs->trans("Modify").'</a>';
                    	print '<a href="card.php?id='.$_GET['id'].'&action=delete" class="butActionDelete">'.$langs->trans("Delete").'</a>';
                    print '</div>';
                }
        } else {
                print '<div class="tabBar">';
                print $langs->trans('ErrorUserViewSC');
                print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
                print '</div>';
            }
    }

}
//confirmation de suppression
if ($action == 'confirm_delete' && GETPOST('confirm') == 'yes' ) {
    $error=0;
    $count_type  = new CounterType($db);
    $canedit = true;
 if ($canedit) {
        $count_type->fetch($id);
        $count_type->delete();
    }
    else {
        $error = $langs->trans('ErrorCantDelete');
    }
    if (!$error) {
      
        header('Location: index.php');
        exit;
    }
    else {
        
        header('Location: index.php?leftmenu=pointage');
        exit;
    }
}
// End of page
llxFooter();llxFooter();

$db->close();


?>