<?php 
/* Copyright (C) 2016		Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *   	\file       marches/list.php
 *		\ingroup    list
 *		\brief      Gestion des maintenance
 */
require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/btp/settings/maintenance_point/class/MaintenancePoint.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/construction_site/class/construction_site.class.php';

// Protection if external user
if (!$user) accessforbidden();

// Get parameters
$myparam = GETPOST("myparam");
$action  = GETPOST('action', 'alpha');
$id 	 = GETPOST('id', 'int');
$request_method = $_SERVER['REQUEST_METHOD'];
$langs->load('btp');
if ($user->societe_id > 0) accessforbidden();
$now 	= new DateTime('now');
$error 	= false;

if ($action == 'update' && $request_method === 'POST') {
      $maintenancepoint_id = (int) GETPOST('maintenancepoint_id', 'int');

    if (!$maintenancepoint_id || $maintenancepoint_id <= 0) {
        header('Location: ./card.php?action=request&error=CantUpdate');
        exit;
    }
    $maintenancepoint = new MaintenancePoint($db);
    $maintenancepoint->fetch($maintenancepoint_id);
    $canedit = true ; 
    $name  = trim(GETPOST('name'));
    // If this is the requestor or has read/write rights
    if ($canedit) {
        $name   = trim(GETPOST('name'));
        $fk_const_site  = (int)trim(GETPOST('fk_const_site'));

		// Update
        $data = array(
            'name'         => $name,
            'fk_const_site'=> $fk_const_site,
        );
        if(empty($name)){
            header('Location: ./card.php?id='. $maintenancepoint_id .'&action=edit&error=SQL_Create&msg="Veuillez renseigner tout les champs"');
                die(); 
             }
       
        $getMarcheID = $maintenancepoint->update($maintenancepoint_id, $data);
 
        if ($getMarcheID > 0) {
        header('Location: ./index.php?id='.$maintenancepoint_id);
            exit;
        } else {
                 header('Location: ./card.php?id='. $maintenancepoint_id .'&action=edit&error=SQL_Create&msg="Veuillez renseigner tout les champs"');
                die(); 
             
        }
    }
}
// If delete of request
if ($action == 'confirm_delete' && GETPOST('confirm') == 'yes' ) {
	$error=0;
	$maintenancepoint  = new MaintenancePoint($db);
	 $canedit = true;
	if ($canedit) {
        $maintenancepoint->fetch($id);
		$maintenancepoint->delete();
	}
	else {
		$error = $langs->trans('ErrorCantDelete');
	}
	if (!$error) {
		header('Location: index.php');
		exit;
	}
	else {
		
        header('Location: index.php?leftmenu=maintenance_point');
        exit;
	}
}

/*
 * View
 */

$form           = new Form($db);
$maintenancepoint     = new MaintenancePoint($db);
$constructionSite = new ConstructionSite($db);

///////////////////////////insertion d'un lrh
if ($action == 'create' && $request_method === 'POST') {
    $maintenancepoint = new MaintenancePoint($db);
    

    // If no right to create a request
    /*if (empty($user->rights->marches->write) || empty($user->rights->marches->write_all)) {
        $error++;
        setEventMessage($langs->trans('CantCreateSC'));
        $action='request';
    }*/
    
    $fk_const_site  = (int)trim(GETPOST('fk_const_site'));

    // Vars
    $maintenancepoint->name          = trim(GETPOST('name'));
    $maintenancepoint->fk_createdby  = $user->id;
    $maintenancepoint->fk_const_site = $fk_const_site;
    
    $getMarcheID = $maintenancepoint->create();
    if ($getMarcheID > 0) {
            header('Location: index.php?id='.$getMarcheID);
            exit;
        } else {
            // Otherwise we display the request form with the SQL error message
            header('Location: card.php?action=request&error=SQL_Create&msg=""');
          exit(); 
        }
}

llxHeader(array(), $langs->trans('listevents'),'','','','',$morejs,$morecss,0,0);

if (empty($id) || $action == 'add' || $action == 'request' || $action == 'create') {
	// Si l'utilisateur n'a pas le droit de créer un marché
    /*if (empty($user->rights->marches->write) || empty($user->rights->marches->write_all)) {
        $errors[]=$langs->trans('CantCreate');
    }
    else {*/
        // Formulaire appel d'offre
        print_fiche_titre($langs->trans('CreateMaintenancePoint'));

        // Si il y a une erreur
        if (GETPOST('error')) {
            switch(GETPOST('error')) {
                case 'nobudget' :
                    $errors[] = $langs->trans('errorNoBudget');
                    break;
                case 'SQL_Create' :
                    $errors[] = $langs->trans('ErrorSQLCreateCP').' <b>'.htmlentities($_GET['msg']).'</b>';
                    break;
                case 'CantCreate' :
                    $errors[] = $langs->trans('CantCreateCP');
                    break;
                case 'nouser' :
                    $errors[] = $langs->trans('errorNoUser');
                    break;
                case 'nodatedebut' :
                    $errors[] = $langs->trans('NoDateDebut');
                    break;
                case 'nobank' :
                    $errors[] = $langs->trans('errorNoBank');
                    break;
                case 'noqc' :
                    $errors[] = $langs->trans('errorNoQc');
                    break;
                case 'alreadyExists' :
                    $errors[] = $langs->trans('alreadyExistAO');
                    break;
                case 'noref' :
                    $errors[] = $langs->trans('errorNoRef');
                    break;
            }

	        setEventMessage($errors, 'errors');
        }

        print '<form method="POST" action="'.$_SERVER['PHP_SELF'].'">'."\n";
        print '<input type="hidden" name="action" value="create" />'."\n";

        print '<table class="border" width="100%">';
        print '<tbody>';

        // Name
         print '<tr><td class="fieldrequired" width="25%">'.$langs->trans("Name").'</td><td class="fieldrequired">';
        print '<input type=text name="name" required="required">';
        print '</td></tr>';
        
        print '<tr><td class="fieldrequired">'.$langs->trans("const_site").'</td><td>';
        $constructions = $constructionSite->getNames();
        print $form->selectarray('fk_const_site', $constructions, '', 0, 0, 0, 'required="required"');
        print '</td><tr>';

        print '</tbody>';
        print '</table>';
        print '<div class="center">';

        print '<input type="submit" value="'. $langs->trans("CreateMaintenancePoint") .'" name="bouton" class="butAction">';
        print '&nbsp; &nbsp; ';
        print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
        print '</div>';
        print '</form>';
}
else {
    print_fiche_titre($langs->trans('detai_point_maint'));
    if ($error) {
        print '<div class="tabBar">';
        print $error;
        print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
        print '</div>';
    }
    else {
        // Affichage 
        if ($id > 0) {
            $maintenancepoint->fetch($id);
            // Si il y a une erreur
            if (GETPOST('error')) {
                switch(GETPOST('error')) {
                    case 'datefin' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorEndDateCP');
                        break;
                    case 'SQL_Create' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorSQLCreateCP').' '.$_GET['msg'];
                        break;
                    case 'CantCreate' :
                        $errors[] = $langs->transnoentitiesnoconv('CantCreateCP');
                        break;
                    case 'Valideur' :
                        $errors[] = $langs->transnoentitiesnoconv('InvalidValidatorCP');
                        break;
                    case 'nodatedebut' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateDebut');
                        break;
                    case 'nodatefin' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateFin');
                        break;
                    case 'DureeHoliday' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorDureeCP');
                        break;
                    case 'NoMotifRefuse' :
                        $errors[] = $langs->transnoentitiesnoconv('NoMotifRefuseCP');
                        break;
                    case 'mail' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorMailNotSend')."\n".$_GET['error_content'];
                        break;
                }

	            setEventMessage($errors, 'errors');
            }
             if ($action == 'delete') {
                        print $form->formconfirm("card.php?id=".$id, $langs->trans("TitleDeletepointmaintenance"),$langs->trans("ConfirmDeletepointmaintenance"),"confirm_delete", '', 0, 1);
print_fiche_titre($langs->trans('detai_point_maint'));
            
print '<table class="border" width="100%">';
    // Ref
    print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Refe").'</td>';
    print '<td colspan="2">'. $maintenancepoint->rowid .'</td></tr>';
    //Nom
    print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Name").'</td>';
    print '<td colspan="2">'. $maintenancepoint->name .'</td></tr>';
    print '</table>';
                }
    if ($action == 'cancel') {
                    print $form->formconfirm("card.php?id=".$id, $langs->trans("TitleCancelSC"), $langs->trans("ConfirmCancelSC"),"confirm_cancel", '', 1, 1);
                }

                 if ($action == 'edit') {
                    $edit = true;
                    $id=$_GET['id'];
                    print '<form method="post" action="'.$_SERVER['PHP_SELF'].'?id='.$id.'">'."\n";
                    print '<input type="hidden" name="action" value="update" />'."\n";
                    print '<input type="hidden" id="h" name="maintenancepoint_id" value='.$id.' />'."\n";
                    print '<table class="border" width="100%">';
                    print '<tbody>';
                    // Name
                    print '<tr><td class="fieldrequired">'.$langs->trans("Name").'</td><td>';
                    print '<input name="name"  type=text value="'.$maintenancepoint->name.'"   required="required"></td></tr>';

                    print '<tr><td class="fieldrequired">'.$langs->trans("const_site").'</td><td>';
                    $constructions = $constructionSite->getNames();
                    print $form->selectarray('fk_const_site', $constructions, (GETPOST('fk_const_site') ? GETPOST('fk_const_site') : $maintenancepoint->fk_const_site), 0, 0, 0, 'required="required"');
                    print '</td><tr>';

                    print '</tbody>';
                    print '</table>';
                    print '<div class="center">';
                    print '<input type="submit" value="'. $langs->trans("Modify") .'" name="bouton" class="butAction">';
                    print '&nbsp; &nbsp; ';
                    print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
                    print '</div>';
                    print '</table>';
                }

                dol_fiche_end();

                if (!$edit) {
		            print '<div class="tabsAction">';
                    // Boutons d'actions
                       print '<a href="card.php?id='.$_GET['id'].'&action=edit" class="butAction">'.$langs->trans("Modify").'</a>';
                    	print '<a href="card.php?id='.$_GET['id'].'&action=delete" class="butActionDelete">'.$langs->trans("Delete").'</a>';

                    print '</div>';
                }

        } else {  
                print '<div class="tabBar">';
                print $langs->trans('ErrorUserViewSC');
                print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
                print '</div>';
            }

    }

}

// End of page
llxFooter();llxFooter();

$db->close();


?>
