<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 */

/**
 * \file       appeloffres/index.php
 * \ingroup    list
 * \brief      List of maintenance point
 */
require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/btp/settings/maintenance_point/class/MaintenancePoint.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/construction_site/class/construction_site.class.php';

// Protection if external user
if (!$user) accessforbidden();

$point_mainte 	  = new MaintenancePoint($db);
$constructionSite = new ConstructionSite($db);
$form = new Form($db);

$var = false;
$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
$action  = GETPOST('action', 'alpha');
if (! $sortfield) $sortfield = "rowid";
if (! $sortorder) $sortorder = "";

$search_ref			= GETPOST('search_ref');
$search_nom 		= GETPOST('search_nom');
$search_const_site 	= GETPOST('search_const_site');
$id 	    = GETPOST('id','int');

 // Both test are required to be compatible with all browsers
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
	$search_ref			= "";
	$search_nom      	= "";
	$search_const_site	= "";
}


$filter='';
$filter .= (!empty($search_ref) && $search_ref != -1) ? " and  rowid = ". $db->escape((int)$search_ref) ."\n" : "";
$filter .= (!empty($search_const_site) && $search_const_site != -1) ? " and  fk_const_site = ". $db->escape((int)$search_const_site) ."\n" : "";
$filter .= (!empty($search_nom) && $search_nom != -1) ? " AND name = '".$db->escape($search_nom)."'\n" : "";

$getpoint_mainte=$point_mainte->fetchAll($sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter);
if (!empty($getpoint_mainte) && $action == "xsl" ) {
$filename="liste_maintenance.xls";
      require_once DOL_DOCUMENT_ROOT.'/btp/settings/maintenance_point/tpl/maintenance_point_exl.php';
 die();
 
}
if ($id > 0) {
	llxHeader('', $langs->trans('point_mainte'));
	print_fiche_titre($langs->trans('detai_point_maint'));
	dol_fiche_head('', 'point_maintes', $langs->trans("point_mainte"), 0, '');

	$point_mainte->fetch($id);
	$constructionSite->fetch($point_mainte->fk_const_site);

	print '<table class="border" width="100%">';
	// Ref
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Refe").'</td>';
	print '<td colspan="2">'. $point_mainte->rowid .'</td></tr>';
	//Nom
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Name").'</td>';
	print '<td colspan="2">'. $point_mainte->name .'</td></tr>';

	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("const_site").'</td>';
	print '<td colspan="2">'. $constructionSite->getNomUrl(1, $constructionSite->id, $constructionSite->name, $constructionSite->market_id) .'</td></tr>';	

	print '</table>';
	print '<br>';
	print '<div style="float: right; margin-top: 8px;">';
	print '<a href="./index.php?mid='. $mid .'" class="butAction">'.$langs->trans('Cancel').'</a>';
	print '<a href="./card.php?action=edit&id='. $id .'" class="butAction">'.$langs->trans('Modify').'</a>';
	print '<a href="./card.php?action=delete&id='. $id .'" class="butAction">'.$langs->trans('Delete').'</a>';


	print '</div>';	
}
else {
	llxHeader('', $langs->trans('liste_pointmaintenance'));
	print_fiche_titre($langs->trans('liste_pointmaintenance'));
print '<div style="float: right; margin-bottom: 4px;">';
	print '<a href="./card.php?action=add" class="butAction">'.$langs->trans('AddMaintenancePoint').'</a>';
	print '</div>';
print '<div style="float: right; ">';
	   print '<form method="post" action="'.$_SERVER["PHP_SELF"].'">'."\n";
print '<input name="search_ref" value="'. $search_ref .'" type="hidden" />';
print '<input name="search_nom" value="'. $search_nom .'" type="hidden" />';
print '<input name="search_const_site" value="'. $search_const_site .'" type="hidden" />';
print '<input name="action" value="xsl" type="hidden" />';
	    print '<button style="margin-bottom: 8px;" class="butAction" name="submit" value="Exporter Excel">'.$langs->trans('Exporter Excel').'</button>';
	   print '</form>'."\n";
		print '</div>';
	print '<form method="GET" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	;
	print '<table class="noborder" width="100%;">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("Refe"),$_SERVER["PHP_SELF"], "rowid", '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("Name"),$_SERVER["PHP_SELF"],"name", '','','align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("const_site"), $_SERVER["PHP_SELF"], 'fk_const_site', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'','','',$sortfield,$sortorder,'maxwidthsearch ');
	print "</tr>\n";

	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';
	print '<td class="liste_titre" align="left" width="50">';
	print '<input class="flat" size="14" type="text" name="search_ref" value="'.dol_escape_htmltag($search_ref).'">';
	print '</td>';

	// name
	print '<td class="liste_titre" align="center">';
	print '<input class="flat" type="text" size="14" name="search_nom" value="'.$search_nom.'">';
	print '</td>';

	print '<td class="liste_titre" align="center">';
	$constructions = $constructionSite->getNames();
    print $form->selectarray('search_const_site', $constructions,(GETPOST('search_const_site') ? GETPOST('search_const_site') : ''), 1, 0, 0, 'required="required"');
	print '</td>';

	// ACTION
	print '<td align="right" style="min-width:62px;">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';
	print "</tr>\n";

	// Lines
	if (count($point_mainte->rows)) {
		//$createdBy = new User($db);
		foreach($point_mainte->rows as $line) {
			$var = !$var;
			$rowid 				= $line->rowid;
			$name 		        = $line->name;
			$constructionSite->fetch($line->fk_const_site);

			print '<tr '.$bc[$var].'>';
			print '<td align="left" width="125px">';
				print $point_mainte->getNomUrl(1,  $line->rowid, $rowid);
			print '</td>';
			// print '<td>'. $appeloffres->getContractTypeById($line->type) .'</td>';
			print '<td align="center">'. $name .'</td>';
			print '<td align="center">'.  $constructionSite->getNomUrl(1, $constructionSite->id, $constructionSite->name, $constructionSite->market_id) .'</td>';

			print '<td><div style="float: right; margin-top: 8px;">';
			print '</div></td>';
			print '</tr>'."\n";
		}
	} else {
		print '<tr>';
	    print '<td colspan="4" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';
	}

	print '</table>';
	print '</form>';
	
}

llxFooter();
$db->close();
?>