<?php 
/* Copyright (C) 2016		Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *   	\file       marches/list.php
 *		\ingroup    list
 *		\brief      Gestion des marches
 */

require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/btp/settings/rental_equipment/class/RentalEquipment.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/settings/machine_categories/class/MachineCategories.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/settings/machine_mark/class/MachineMark.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/settings/counter_type/class/CounterType.class.php';
// Get parameters
$myparam = GETPOST("myparam");
$action  = GETPOST('action', 'alpha');
$id 	 = GETPOST('id', 'int');
$request_method = $_SERVER['REQUEST_METHOD'];
$form= new Form($db);
$langs->load('btp');
if ($user->societe_id > 0) accessforbidden();
$now 	= new DateTime('now');
$error 	= false;
if ($action == 'update' && $request_method === 'POST') {
    $rental_equipement_id = (int) GETPOST('rental_equipement_id', 'int');
    if (!$rental_equipement_id || $rental_equipement_id <= 0) {
        header('Location: ./card.php?action=request&error=CantUpdate');
        exit;
    }
    $rental_equipement = new RentalEquipment($db);
    $rental_equipement->fetch($rental_equipement_id);
    $canedit = true ; 
    $name  = trim(GETPOST('names'));
    $tenant = GETPOST('tenant');
    $categ     = GETPOST('categ');
    $compteur         = GETPOST('compteur');$marque = GETPOST('marque');
    $driver     = GETPOST('driver');
    $num         = GETPOST('num');
    $type = GETPOST('type');
    $rate     = GETPOST('rate');
    $stat          = GETPOST('stat');
  
    // If this is the requestor or has read/write rights
    
    if ($canedit) {
    $tenant = (int)GETPOST('tenant');
    $categ     = (int)GETPOST('categ');
    $compteur         =(int) GETPOST('compteur');
    $marque = (int)GETPOST('marque');
    $driver     = (int)GETPOST('driver');
    $num         = GETPOST('num');
    $type = GETPOST('type');
    $rate     = (float)GETPOST('rate');
    $stat          = (int)GETPOST('stat');
        
		// Update
	  $vider="";
    $vider.=($tenant==-1)?"erreur":"";
    $vider.=($driver==-1)?"erreur":"";
    $vider.=($compteur==0)?"erreur":"";
    $vider.=($categ==0)?"erreur":"";
    $vider.=($num=='')?"erreur":"";

                /*if(!$tenant || !$driver|| !$compteur || !$marque || !$type || !$rate){
            header('Location: ./card.php?id='. $rental_equipement_id .'&action=edit&error=SQL_Create&msg='.$rental_equipement->error);
            die();
                }*/
        $data = array(
         'fk_tenant'     => $tenant,
         'fk_machine_cat'=>$categ,
         'fk_machine_mark'=>$marque,
         'fk_counter_type'=>$compteur,
         'fk_driver'      =>$driver,
         'register_num'   =>$num,
         'type'           =>$type,
         'rate'           =>$rate,
         //'statut'         =>$stat,
        );
       if($vider==""){
        $getMarcheID = $rental_equipement->update($rental_equipement_id, $data);
    }
    else{
            $getMarcheID=-1;
        }
 
        if ($getMarcheID > 0) {
        header('Location: ./index.php?id='.$rental_equipement_id);
            exit;
        } else {
            // Otherwise we display the request form with the SQL error message
            header('Location: ./card.php?id='. $rental_equipement_id .'&action=edit&error=SQL_Create&msg='.$rental_equipement->error);
            exit;
        }
    }
}

// If delete of request
if ($action == 'confirm_delete' && GETPOST('confirm') == 'yes' ) {
	$error=0;
	$rental_equipement  = new RentalEquipment($db);
	 $canedit = true;
		if ($canedit) {
        $rental_equipement->fetch($id);
		$rental_equipement->delete();
	}
	else {
		$error = $langs->trans('ErrorCantDelete');
	}

	if (!$error) {
		//$db->commit();
		header('Location: index.php');
		exit;
	}
	else {
		
        header('Location: index.php?leftmenu=marches');
        exit;
	}
}

/*
 * View
 */

$form           = new Form($db);
$rental_equipement     = new RentalEquipment($db);
///////////////////////////insertion
if ($action == 'create' && $request_method === 'POST') {
   $tenant = (int)GETPOST('tenant');
    $categ     = (int)GETPOST('categ');
    $compteur         =(int) GETPOST('compteur');$marque = GETPOST('marque');
    $driver     =(int) GETPOST('driver');
    $num         = GETPOST('num');
    $type = GETPOST('type');
    $rate     = (float)GETPOST('rate');
    $stat          = GETPOST('stat');
        // Vars
    $vid="";
    $vid.=($tenant==-1)?"erreur":"";
    $vid.=($driver==-1)?"erreur":"";
    $vid.=($compteur==0)?"erreur":"";
    $vid.=($categ==0)?"erreur":"";
    $vid.=($num=="")?"erreur":"";
       $rental_equipement->fk_createdby  = $user->id;
       $rental_equipement->fk_tenant = $tenant;
       $rental_equipement->fk_machine_cat =  $categ ;
       $rental_equipement->fk_machine_mark = $marque;
       $rental_equipement->fk_counter_type =$compteur ;
       $rental_equipement->fk_driver =  $driver  ;  
       $rental_equipement->register_num  = $num;
       $rental_equipement->type =  $type;
       $rental_equipement->rate =  $rate ;
      $rental_equipement->statut = $stat ;

       if($vid==""){
           $getMarcheID = $rental_equipement->create();
       }
        else{
            $getMarcheID=-1;
        }
 if ($getMarcheID > 0) {
        header('Location: index.php?id='.$getMarcheID);
            exit;
        } else {
            // Otherwise we display the request form with the SQL error message
           
header("Location:card.php?action=request&error=SQL_Create");

        }
       
}
llxHeader(array(), $langs->trans('rental'),'','','','',$morejs,$morecss,0,0);

if (empty($id) || $action == 'add' || $action == 'request' || $action == 'create') {
        // Formulaire 
        print_fiche_titre($langs->trans('Addlocation'));

        // Si il y a une erreur
        if (GETPOST('error')) {
            switch(GETPOST('error')) {
                case 'nobudget' :
                    $errors[] = $langs->trans('errorNoBudget');
                    break;
                case 'SQL_Create' :
                    $errors[] = $langs->trans('ErrorSQLCreateCP').' <b>'.htmlentities($_GET['msg']).'</b>';
                    break;
                case 'CantCreate' :
                    $errors[] = $langs->trans('CantCreateCP');
                    break;
                case 'nouser' :
                    $errors[] = $langs->trans('errorNoUser');
                    break;
                case 'nodatedebut' :
                    $errors[] = $langs->trans('NoDateDebut');
                    break;
                case 'nobank' :
                    $errors[] = $langs->trans('errorNoBank');
                    break;
                case 'noqc' :
                    $errors[] = $langs->trans('errorNoQc');
                    break;
                case 'alreadyExists' :
                    $errors[] = $langs->trans('alreadyExistAO');
                    break;
                case 'noref' :
                    $errors[] = $langs->trans('errorNoRef');
                    break;
            }

	        setEventMessage($errors, 'errors');
        }

        print '<form method="POST" action="'.$_SERVER['PHP_SELF'].'">'."\n";
        print '<input type="hidden" name="action" value="create" />'."\n";

        print '<table class="border" width="100%">';
        print '<tbody>';
        //locataire
         print '<tr><td class="fieldrequired">'.$langs->trans("tenant").'</td><td class="fieldrequired">';
         print $form->select_dolusers('',"tenant",1);
 
         print '</td></tr>';
         print '<tr><td class="fieldrequired">'.$langs->trans("machine_categorie").'</td><td class="fieldrequired">';
         print '<select name="categ" required="required"  id="nomer"/>';
         $catege  = new MachineCategories($db);
         $catege->fetchAll(); 
         print '<option></option>';
          if (count($catege->rows)) {
         foreach($catege->rows as $line) {
          print '<option  value="'.$line->rowid.'">'.$line->name.'</option>';
        }
       }
         print '</select>';
         print '</td></tr>';
         print '<tr><td class="fieldrequired">'.$langs->trans("counter_type").'</td><td class="fieldrequired">';
         print '<select name="compteur" required="required"     id="nomer"/>';
       
        $comp   = new CounterType($db);
        $comp->fetchAll();  print '<option></option>';
        if (count($comp->rows)) {
      
        foreach($comp->rows as $line) {
       print '<option  value="'.$line->rowid.'">'.$line->name.'</option>';
      
        }
    }
   print '</select>';
        print '</td></tr>';
         print '<tr><td class="fieldrequired">'.$langs->trans("machine_mark").'</td><td class="fieldrequired">';
        print '<select name="marque" required="required"     id="nomer"/>';
       
        $mark  = new MachineMark($db);
        $mark->fetchAll();  print '<option></option>';
        if (count($mark->rows)) {
      
        foreach($mark->rows as $line) {
       print '<option  value="'.$line->rowid.'">'.$line->name.'</option>';
      
        }
    }
        print '</select>';
        print '</td></tr>';

        print '<tr><td class="fieldrequired">'.$langs->trans("driver").'</td><td class="fieldrequired">';
        print $form->select_dolusers('',"driver",1);
       
        print '</td></tr>';
        print '<tr><td class="fieldrequired">'.$langs->trans("regigster_num").'</td><td class="fieldrequired">';
        print '<input type=text name="num" required="required">';
        print '</td></tr>';
       print '<tr><td class="fieldrequired">'.$langs->trans("type").'</td><td class="fieldrequired">';
        print '<input type=text name="type" required="required">';
        print '</td></tr>';
        print '<tr><td class="fieldrequired">'.$langs->trans("rate").'</td><td class="fieldrequired">';
        print '<input type="number" min="0" step="0.01" name="rate" required="required">';
        print '</td></tr>';
        print '</tbody>';
        print '</table>';
        print '<div class="center">';
        print '<input type="submit" value="'. $langs->trans("Createlocation") .'" name="bouton" class="butAction">';
        print '&nbsp; &nbsp; ';
        print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
        print '</div>';
        print '</form>';
}
else {
    print_fiche_titre($langs->trans('detai_rental_equip'));
    if ($error) {
        print '<div class="tabBar">';
        print $error;
        print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
        print '</div>';
    }
    else {
        // Affichage 
        if ($id > 0) {
            $rental_equipement->fetch($id);
			 // Si il y a une erreur
            if (GETPOST('error')) {
                switch(GETPOST('error')) {
                    case 'datefin' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorEndDateCP');
                        break;
                    case 'SQL_Create' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorSQLCreateCP').' '.$_GET['msg'];
                        break;
                    case 'CantCreate' :
                        $errors[] = $langs->transnoentitiesnoconv('CantCreateCP');
                        break;
                    case 'Valideur' :
                        $errors[] = $langs->transnoentitiesnoconv('InvalidValidatorCP');
                        break;
                    case 'nodatedebut' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateDebut');
                        break;
                    case 'nodatefin' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateFin');
                        break;
                    case 'DureeHoliday' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorDureeCP');
                        break;
                    case 'NoMotifRefuse' :
                        $errors[] = $langs->transnoentitiesnoconv('NoMotifRefuseCP');
                        break;
                    case 'mail' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorMailNotSend')."\n".$_GET['error_content'];
                        break;
                }

	            setEventMessage($errors, 'errors');
            }
                 if ($action == 'delete') {
                        print $form->formconfirm("card.php?id=".$id, $langs->trans("TitleDeletelo"),$langs->trans("ConfirmDeletelo"),"confirm_delete", '', 0, 1);
  print_fiche_titre($langs->trans('detai_rental_equip'));
               
             print '<table class="border" width="100%">';
             // Ref
          print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Refe").'</td>';
          print '<td colspan="2">'. $rental_equipement->rowid .'</td></tr>';
            //locataire
        $user_ten = new User($db);
        $user_ten->fetch($rental_equipement->fk_tenant); 
        $nom=$user_ten->lastname.'  '.$user_ten->firstname;     
    print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("tenant").'</td>';
    print '<td colspan="2">'. $user_ten->getNomUrl(1,$rental_equipement->fk_user,$nom).'</td></tr>';
    print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("machine_categorie").'</td>';
     $categ_machine   = new MachineCategories($db);
       $categ_machine->fetch($rental_equipement->fk_machine_cat);
    print '<td colspan="2">'.$categ_machine->getNomUrl(1,$rental_equipement->fk_machine_cat,$categ_machine->name) .'</td></tr>';
    print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("counter_type").'</td>';
     $type_compteur   = new CounterType($db);
       $type_compteur->fetch($rental_equipement->fk_counter_type);
    print '<td colspan="2">'.$type_compteur->getNomUrl(1,$rental_equipement->fk_counter_type,$type_compteur->name)  .'</td></tr>';
    print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("machine_mark").'</td>';
       $mark_machine   = new MachineMark($db);
       $mark_machine->fetch($rental_equipement->fk_machine_mark);
    print '<td colspan="2">'.  $mark_machine->getNomUrl(1,$rental_equipement->fk_machine_mark,$mark_machine->name ).'</td></tr>';
print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("driver").'</td>';
    $driver = new User($db);
    $driver->fetch($rental_equipement->fk_driver);
    $name= $driver->lastname.'  '.$driver->firstname;  
    print '<td colspan="2">'. $driver->getNomUrl(1,$rental_equipement->fk_driver,$name).'</td></tr>';
    print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("regigster_num").'</td>';
    print '<td colspan="2">'. $rental_equipement->register_num .'</td></tr>';
    print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("type").'</td>';
    print '<td colspan="2">'. $rental_equipement->type .'</td></tr>';
    print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("rate").'</td>';
    print '<td colspan="2">'. $rental_equipement->rate .'</td></tr>';
    print '</table>';
                }
                // Si annulation 
                if ($action == 'cancel') {
                    print $form->formconfirm("card.php?id=".$id, $langs->trans("TitleCancelSC"), $langs->trans("ConfirmCancelSC"),"confirm_cancel", '', 1, 1);
                }
                if ($action == 'edit') {
                    $edit = true;
                    $id=$_GET['id'];
                    print '<form method="post" action="'.$_SERVER['PHP_SELF'].'?id='.$id.'">'."\n";
                    print '<input type="hidden" name="action" value="update" />'."\n";
                    print '<input type="hidden" id="h" name="rental_equipement_id" value='.$id.' />'."\n";
                    print '<table class="border" width="100%">';
                    print '<tbody>';
                    // locataire
                    print '<tr><td class="fieldrequired">'.$langs->trans("tenant").'</td>';
                  
                    print '<td class="liste_titre" align="left" >';    

                    print $form->select_dolusers($rental_equipement->fk_tenant,"tenant",1);
   
                    print '</td></tr>';
                    print '<tr><td class="fieldrequired">'.$langs->trans("machine_categorie").'</td>';
                    print '<td class="liste_titre" align="left" >';  
                    print '<select name="categ" required="required"     id="nomer"/>';
                    $p='';
                   $catege  = new MachineCategories($db);
                $catege->fetchAll(); 
              print '<option></option>';
              $p='';
              if (count($catege->rows)) {
        foreach($catege->rows as $line) {
             if ($rental_equipement->fk_machine_cat==$line->rowid) {
                    $p="selected=selected";  
                   }
               print '<option  value="'.$line->rowid.'"'.$p.'>'.$line->name.'</option>';
                $p='';
                }
               }
      print '</select>';
      print '<tr><td class="fieldrequired">'.$langs->trans("counter_type").'</td>';
      print '<td class="liste_titre" align="left" >';
       print '<select name="compteur" required="required"     id="nomer"/>';
       $p='';
        $comp   = new CounterType($db);
        $comp->fetchAll();  print '<option></option>';
        if (count($comp->rows)) {
      
        foreach($comp->rows as $line) {
             if ($rental_equipement->fk_counter_type==$line->rowid) {
                    $p="selected=selected";  
                   }
       print '<option  value="'.$line->rowid.'"'.$p.'>'.$line->name.'</option>';
      $p='';
        }
    }
   print '</select></td></tr>';
  print '<tr><td class="fieldrequired">'.$langs->trans("machine_mark").'</td>';

print '<td class="liste_titre" align="left" >';
        print '<select name="marque" required="required"     id="nomer"/>';
       $p='';
        $mark  = new MachineMark($db);
        $mark->fetchAll();  print '<option></option>';
        if (count($mark->rows)) {
      
        foreach($mark->rows as $line) {
             if ($rental_equipement->fk_machine_mark==$line->rowid) {
                    $p="selected=selected";  
                   }
       print '<option  value="'.$line->rowid.'"'.$p.'>'.$line->name.'</option>';
      $p='';
        }
    }
      print '</select></td></tr>';
      $p='';
         print '<tr><td class="fieldrequired">'.$langs->trans("driver").'</td>';
print '<td class="liste_titre" align="left" >';
       
        print $form->select_dolusers($rental_equipement->fk_driver,"driver",1);
        print '</td></tr>'; 
        print '<tr><td class="fieldrequired">'.$langs->trans("regigster_num").'</td>';             
        print '<td class="liste_titre" align="left" >';
        print '<input type=text name="num" value="'.$rental_equipement->register_num.'" required="required">';
        print '</td>';    
        print '</td></tr>'; 
       print '<tr><td class="fieldrequired">'.$langs->trans("type").'</td>';             
        print '<td class="liste_titre" align="left" >';
        print '<input type=text name="type" value="'.$rental_equipement->type.'" required="required">';
        print '</td></tr>'; 
      
        print '<tr><td class="fieldrequired">'.$langs->trans("rate").'</td>';             
        print '<td class="liste_titre" align="left" >';
         print '<input type="number" min="0" step="0.01" name="rate" value="'.$rental_equipement->rate.'" required="required">';
        print '</td></tr>'; 
         print '</tbody>';
                    print '</table>';
                    print '<div class="center">';
                    print '<input type="submit" value="'. $langs->trans("Modify") .'" name="bouton" class="butAction">';
                    print '&nbsp; &nbsp; ';
                    print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
                    print '</div>';
                    print '</table>';
                }

                dol_fiche_end();

                if (!$edit) {
		            print '<div class="tabsAction">';
                        print '<a href="card.php?id='.$_GET['id'].'&action=edit" class="butAction">'.$langs->trans("Modify").'</a>';
                    	print '<a href="card.php?id='.$_GET['id'].'&action=delete" class="butActionDelete">'.$langs->trans("Delete").'</a>';

                    print '</div>';
                }

        } else {
                
                print '<div class="tabBar">';
                print $langs->trans('ErrorUserViewSC');
                print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
                print '</div>';
            }  }

}
//////////////////////////////////////confirmation de suppression
if ($action == 'confirm_delete' && GETPOST('confirm') == 'yes' ) {
    $error=0;
    $rental_equipement  = new RentalEquipment($db);
   $canedit = true;
   if ($canedit) {
        $rental_equipement->fetch($id);
        $rental_equipement->delete();
    }
    else {
        $error = $langs->trans('ErrorCantDelete');
    }

    if (!$error) {
       header('Location: index.php');
        exit;
    }
    else {
        
        header('Location: index.php?leftmenu=pointage');
        exit;
    }
}

/////////////////////////////////////suppression

// End of page
llxFooter();llxFooter();

$db->close();


?>