<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file       appeloffres/index.php
 * \ingroup    list
 * \brief      List of type stakeholder
 */
require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/btp/settings/stakeholder_types/class/StakeHolderType.class.php';

$stakeholdertype 	  = new StakeHolderType($db);
$var = false;
$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
$action  = GETPOST('action', 'alpha');	
if (! $sortfield) $sortfield = "rowid";
if (! $sortorder) $sortorder = "";
$search_ref      			= GETPOST('search_ref');
$search_nom      	= GETPOST('search_nom');
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
	$search_ref      			= "";
	$search_nom      	= "";
	
}
$id 	  = GETPOST('id','int');

$filter='';
$filter .= (!empty($search_ref) && $search_ref != -1) ? " and  rowid = ". $db->escape((int)$search_ref) ."\n" : "";
$filter .= (!empty($search_nom) && $search_nom != -1) ? " AND name = '".$db->escape($search_nom)."'\n" : "";
$getstakeholdertype=$stakeholdertype->fetchAll($sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter, $id);
if (!empty($getstakeholdertype) && $action == "xsl" ) {
$filename="liste_types_prenantes.xls";
      require_once DOL_DOCUMENT_ROOT.'/btp/settings/stakeholder_types/tpl/stakeholder_types_exl.php';
 die();
 
}
if ($id > 0) {
	llxHeader('', $langs->trans('event'));
	print_fiche_titre($langs->trans('detail_stack'));
	dol_fiche_head('', 'events', $langs->trans("event"), 0, '');

	$stakeholdertype->fetch($id);

	print '<table class="border" width="100%">';
	// Ref
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Refe").'</td>';
	print '<td colspan="2">'. $stakeholdertype->rowid .'</td></tr>';
	//Nom
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Name").'</td>';
	print '<td colspan="2">'. $stakeholdertype->name .'</td></tr>';
	print '</table>';
	print '<br>';
	print '<div style="float: right; margin-top: 8px;">';
	print '<a href="./index.php?mid='. $mid .'" class="butAction">'.$langs->trans('Cancel').'</a>';
	print '<a href="./card.php?action=edit&id='. $id .'" class="butAction">'.$langs->trans('Modify').'</a>';
	print '<a href="./card.php?action=delete&id='. $id .'"  class="butAction">'.$langs->trans('Delete').'</a>';

	print '</div>';	
}
else {

llxHeader('', $langs->trans('listtype_prenante'));
print_fiche_titre($langs->trans('listtype_prenante'));
	$card="card.php";
print '<div style="float: right; margin-bottom: 4px;">';
		print '<a href="./card.php?action=add" class="butAction">'.$langs->trans('AddType_preante').'</a>';
		print '</div>';
print '<div style="float: right; ">';
	   print '<form method="post" action="'.$_SERVER["PHP_SELF"].'">'."\n";
print '<input name="search_ref" value="'. $search_ref .'" type="hidden" />';
print '<input name="search_nom" value="'. $search_nom .'" type="hidden" />';
print '<input name="action" value="xsl" type="hidden" />';
	    print '<button style="margin-bottom: 8px;" class="butAction" name="submit" value="Exporter Excel">'.$langs->trans('Exporter Excel').'</button>';
	   print '</form>'."\n";
		print '</div>';
	print '<form method="GET" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	;
	print '<table class="noborder" width="100%;">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("Refe"),$_SERVER["PHP_SELF"], "rowid", '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("Name"),$_SERVER["PHP_SELF"],"name", '','','align="center"',$sortfield,$sortorder);
	print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'','','',$sortfield,$sortorder,'maxwidthsearch ');
	print "</tr>\n";

	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';
	print '<td class="liste_titre" align="left" width="50">';
	print '<input class="flat" size="14" type="text" name="search_ref" value="'.dol_escape_htmltag($search_ref).'">';
	print '</td>';
	// name
	print '<td class="liste_titre" colspan="1" align="center">';
	print '<input class="flat" type="text" size="14" name="search_nom" value="'.$search_nom.'">';
	print '</td>';
	// ACTION
	print '<td align="right" style="min-width:62px;">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';

	print "</tr>\n";
	// Lines
	if (count($stakeholdertype->rows)) {
		foreach($stakeholdertype->rows as $line) {
			$var = !$var;
			$rowid 				= $line->rowid;
			$name 		        = $line->name;
			print '<tr '.$bc[$var].'>';
			print '<td align="left" width="125px">';
				print $stakeholdertype->getNomUrl(1,  $line->rowid, $rowid);
			print '</td>';
			// print '<td>'. $appeloffres->getContractTypeById($line->type) .'</td>';
			print '<td align="center">'. $name .'</td>';
			print '<td><div style="float: right; margin-top: 8px;">';
			print '</div></td>';
			print '</tr>'."\n";
		}
	} else {
		print '<tr>';
	    print '<td colspan="9" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';
	}

	print '</table>';
	print '</form>';


}
print '</table>';
print '</form>';

llxFooter();

$db->close();


?>
