<?php 
/* Copyright (C) 2016		Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *   	\file       marches/list.php
 *		\ingroup    list
 *		\brief      Gestion des outils
 */

require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/btp/settings/tools_type/class/ToolsType.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/settings/tools/class/tools.class.php';
// Get parameters
$myparam = GETPOST("myparam");
$action  = GETPOST('action', 'alpha');
$id 	 = GETPOST('id', 'int');
$request_method = $_SERVER['REQUEST_METHOD'];

$langs->load('btp');
// Protection if external user
if ($user->societe_id > 0) accessforbidden();

$now 	= new DateTime('now');
$error 	= false;
if ($action == 'update' && $request_method === 'POST') {
    $tool_id = (int) GETPOST('tool_id', 'int');

    if (!$tool_id || $tool_id <= 0) {
        header('Location: ./card.php?action=request&error=CantUpdate');
        exit;
    }
    $tool = new ToolsSettings($db);
    $tool->fetch($tool_id);
    $canedit = true ; 
    $type  = trim(GETPOST('type'));
    $dsg  = trim(GETPOST('dsg'));
    if ($canedit) {
        $type   = trim(GETPOST('type'));
          $dsg  = trim(GETPOST('dsg'));
            
		// Update
	
        $data = array(
            'designation'             => $dsg,
            'tool_type_id'             => $type,

        );
        if(empty($dsg)|| !$type){
              header('Location: ./card.php?id='. $tool_id .'&action=edit&error=SQL_Create&msg="Veuillez renseigner tous les champs"');
            exit;
        }
        $getMarcheID = $tool->update($tool_id, $data);
 
        if ($getMarcheID > 0) {
        header('Location: ./index.php?id='.$tool_id);
            exit;
        } else {
            // Otherwise we display the request form with the SQL error message
            header('Location: ./card.php?id='. $tool_id .'&action=edit&error=SQL_Create&msg="Veuillez renseigner tous les champs"');
            exit;
        }
    }
}
// If delete of request
if ($action == 'confirm_delete' && GETPOST('confirm') == 'yes' ) {
	$error=0;
	$tool  = new ToolsSettings($db);
	 $canedit = true;
		if ($canedit) {
        $tool->fetch($id);
		$tool->delete();
	}
	else {
		$error = $langs->trans('ErrorCantDelete');
	}

	if (!$error) {
		header('Location: index.php');
		exit;
	}
	else {
        header('Location: index.php?leftmenu=tools');
        exit;
	}
}

/*
 * View
 */

$form           = new Form($db);
$tool     = new ToolsSettings($db);
///////////////////////////insertion d'un outil
if ($action == 'create' && $request_method === 'POST') {
    $tool = new ToolsSettings($db);
    $type     = GETPOST('type');
    $dsg         = GETPOST('dsg');
        //var
        $tool->designation                = trim(GETPOST('dsg'));
        $tool->tool_type_id                = trim(GETPOST('type'));
        $tool->fk_createdby                = $user->id;
        if(empty($tool->designation) || !$tool->tool_type_id){
  header('Location: card.php?action=request&error=SQL_Create&msg="Veuillez renseigner tous les champs"');
exit();
        }
           $getMarcheID = $tool->create();
        
 if ($getMarcheID > 0) {
        header('Location: index.php?id='.$getMarcheID);
            exit;
        } else {
            // Otherwise we display the request form with the SQL error message
            header('Location: card.php?action=request&error=SQL_Create&msg="Veuillez renseigner tous les champs"');
exit(); 
        }   
}
llxHeader(array(), $langs->trans('listevents'),'','','','',$morejs,$morecss,0,0);

if (empty($id) || $action == 'add' || $action == 'request' || $action == 'create') {
        // Formulaire d'outil
        print_fiche_titre($langs->trans('ajoutetools'));

        // Si il y a une erreur
        if (GETPOST('error')) {
            switch(GETPOST('error')) {
                case 'nobudget' :
                    $errors[] = $langs->trans('errorNoBudget');
                    break;
                case 'SQL_Create' :
                    $errors[] = $langs->trans('ErrorSQLCreateCP').' <b>'.htmlentities($_GET['msg']).'</b>';
                    break;
                case 'CantCreate' :
                    $errors[] = $langs->trans('CantCreateCP');
                    break;
                case 'nouser' :
                    $errors[] = $langs->trans('errorNoUser');
                    break;
                case 'nodatedebut' :
                    $errors[] = $langs->trans('NoDateDebut');
                    break;
                case 'nobank' :
                    $errors[] = $langs->trans('errorNoBank');
                    break;
                case 'noqc' :
                    $errors[] = $langs->trans('errorNoQc');
                    break;
                case 'alreadyExists' :
                    $errors[] = $langs->trans('alreadyExistAO');
                    break;
                case 'noref' :
                    $errors[] = $langs->trans('errorNoRef');
                    break;
            }

	        setEventMessage($errors, 'errors');
        }

        print '<form method="POST" action="'.$_SERVER['PHP_SELF'].'">'."\n";
        print '<input type="hidden" name="action" value="create" />'."\n";
        print '<table class="border" width="100%">';
        print '<tbody>';
        // disignation
         print '<tr><td class="fieldrequired">'.$langs->trans("Designation").'</td><td class="fieldrequired">';
        print '<input type=text name="dsg" required="required">';
        print '</td></tr>';
        //type
         print '<tr><td class="fieldrequired">'.$langs->trans("Type").'</td><td class="fieldrequired">';
      
        print '<select name="type" required="required"     id="nomer"/>';
        $tools  = new ToolsType($db);
        $tools->fetchAll(); 
        print '<option></option>';
        if (count($tools->rows)) {
      
        foreach($tools->rows as $line) {
       print '<option  value="'.$line->rowid.'">'.$line->name.'</option>';
      
        }
    }
   print '</select>';
  print '</td></tr>';
        print '</tbody>';
        print '</table>';
        print '<div class="center">';
        print '<input type="submit" value="'. $langs->trans("creeoutli") .'" name="bouton" class="butAction">';
        print '&nbsp; &nbsp; ';
        print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
        print '</div>';
        print '</form>';
}
else {
    print_fiche_titre($langs->trans('detai_tool'));
    if ($error) {
        print '<div class="tabBar">';
        print $error;
        print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
        print '</div>';
    }
    else {
        // Affichage 
        if ($id > 0) {
            $tool->fetch($id);
            // Si il y a une erreur
            if (GETPOST('error')) {
                switch(GETPOST('error')) {
                    case 'datefin' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorEndDateCP');
                        break;
                    case 'SQL_Create' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorSQLCreateCP').' '.$_GET['msg'];
                        break;
                    case 'CantCreate' :
                        $errors[] = $langs->transnoentitiesnoconv('CantCreateCP');
                        break;
                    case 'Valideur' :
                        $errors[] = $langs->transnoentitiesnoconv('InvalidValidatorCP');
                        break;
                    case 'nodatedebut' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateDebut');
                        break;
                    case 'nodatefin' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateFin');
                        break;
                    case 'DureeHoliday' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorDureeCP');
                        break;
                    case 'NoMotifRefuse' :
                        $errors[] = $langs->transnoentitiesnoconv('NoMotifRefuseCP');
                        break;
                    case 'mail' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorMailNotSend')."\n".$_GET['error_content'];
                        break;
                }

	            setEventMessage($errors, 'errors');
            }

            // On vérifie si l'utilisateur à le droit de lire cette demande
           // if ($canedit) {

                // Si annulation de la demande
                if ($action == 'cancel') {
                    print $form->formconfirm("card.php?id=".$id, $langs->trans("TitleCancelSC"), $langs->trans("ConfirmCancelSC"),"confirm_cancel", '', 1, 1);
                }
           
                if ($action == 'edit') {
                    $edit = true;
                    $id=$_GET['id'];

                

                    print '<form method="post" action="'.$_SERVER['PHP_SELF'].'?id='.$id.'">'."\n";
                    print '<input type="hidden" name="action" value="update" />'."\n";
                    print '<input type="hidden" id="h" name="tool_id" value='.$id.' />'."\n";
                  

                    print '<table class="border" width="100%">';
                    print '<tbody>';

                    // Name
                    print '<tr><td class="fieldrequired">'.$langs->trans("Designation").'</td><td>';
                    print '<input name="dsg" required="required" type=text value="'.$tool->designation.'"</td></tr>';
                    print '<tr><td class="fieldrequired">'.$langs->trans("Type").'</td><td>';
                  
                    print '<select name="type"  required="required"   id="nomer"/>';
                   $pa='';
                  $evt   = new ToolsType($db);
                  $evt->fetchall();  print '<option></option>';
                  if (count($evt->rows)) {
      
                 foreach($evt->rows as $line) {
     
               if ($line->rowid==$tool->tool_type_id){ 
                $pa=' selected="selected"';

                 }
                 print '<option  value="'.$line->rowid.'"'.$pa.'>'.$line->name.'</option>';
                 $pa='';
                  }
    }
   print '</select>';
         print '</tbody>';
                    print '</table>';
                    print '<div class="center">';
                    print '<input type="submit" value="'. $langs->trans("Modify") .'" name="bouton" class="butAction">';
                    print '&nbsp; &nbsp; ';
                    print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
                    print '</div>';
                    print '</table>';
                }

                dol_fiche_end();

                if (!$edit) {
		            print '<div class="tabsAction">';
                    // Boutons d'actions
                        print '<a href="card.php?id='.$_GET['id'].'&action=edit" class="butAction">'.$langs->trans("Modify").'</a>';

                    // If draft
                   print '<a href="card.php?id='.$_GET['id'].'&action=delete" class="butActionDelete">'.$langs->trans("Delete").'</a>';

                    print '</div>';
                }

        } else {
                
                print '<div class="tabBar">';
                print $langs->trans('ErrorUserViewSC');
                print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
                print '</div>';
            }
    }

}
//////////////////////////////////////confirmation de suppression
if ($action == 'confirm_delete' && GETPOST('confirm') == 'yes' ) {
    $error=0;
    $tool  = new Tools($db);
     $canedit = true;
       if ($canedit) {
        $tool->fetch($id);
        $tool->delete();
    }
    else {
        $error = $langs->trans('ErrorCantDelete');
    }

    if (!$error) {
         header('Location: index.php');
        exit;
    }
    else {
        
        header('Location: index.php?leftmenu=tools');
        exit;
    }
}
// End of page
llxFooter();llxFooter();

$db->close();


?>
