<?php

$var=true;

// Class file containing the method load_state_board for each line
$includes = array(
    DOL_DOCUMENT_ROOT.'/btp/class/tender.class.php',
    DOL_DOCUMENT_ROOT.'/btp/market/market/class/market.class.php',
    DOL_DOCUMENT_ROOT.'/btp/tresorie/advance_supplier/class/advance_supplier.class.php',
    DOL_DOCUMENT_ROOT.'/btp/tresorie/invoice_location_expenses/class/invoice_location_expenses.class.php',
    DOL_DOCUMENT_ROOT.'/btp/tresorie/invoice_reception/class/invoice_reception.class.php',
    DOL_DOCUMENT_ROOT.'/btp/material/machine/class/machine.class.php',
    DOL_DOCUMENT_ROOT.'/btp/material/machine/class/machine_extern.class.php',
);

// Name class containing the method load_state_board for each line
$classes = array('Tender', 'Market', 'advance_supplier', 'invoice_location_expenses',
 'invoice_reception', 'machine', 'MachineExtern');

// Cle array returned by the method load_state_board for each line
$keys = array('tenders', 'markets', 'advancesuppliers', 'invoicelocationexpenses', 
    'invoicereceptions', 'machineinterns', 'machinexterns');

// Dashboard Icon lines
$icons = array('object_btp');

// Translation keyword
$titres = array('Tenders', 'Markets', 'advance_supplier', 'invoice_location_expenses',
 'invoice_reception', 'MachineInterns', 'MachineExterns');

// Dashboard Link lines
$links = array(
    DOL_URL_ROOT .'/btp/list.php',
    DOL_URL_ROOT .'/btp/market/market/index.php',
    DOL_URL_ROOT .'/btp/tresorie/advance_supplier/index.php',
    DOL_URL_ROOT .'/btp/tresorie/invoice_location_expenses/index.php',
    DOL_URL_ROOT .'/btp/tresorie/invoice_reception/index.php',
    DOL_URL_ROOT .'/btp/material/machine/index.php?tpmch=1',
    DOL_URL_ROOT .'/btp/material/machine/index.php?tpmch=2',
);

// Translation lang files
$langs->load('btp');

$boardloaded = array();

print '<table width="100%" class="notopnoleftnoright stat_separator">';
print '<tr><td>'. $langs->trans('TotalOfPrincipalModules') .'</td></tr>';
print "</table>";

print '<div class="fichecenter">';
print '<table class="noborder" width="100%">';
print '<tr class="liste_titre nc_filtrage_tr">';
print '<th class="liste_titre" colspan="2">'.$langs->trans("DolibarrStateBoard").'</th>';
print '<th class="liste_titre" align="right">&nbsp;</th>';
print '</tr>';
print '<tr class="impair totals_elements"><td colspan="3" class="tdboxstats nohover">';

$icon = img_object("", DOL_URL_ROOT.'/btp/img/'.$icons[0], '', 1);
$icon = str_ireplace('object_/', '/', $icon);

// Loop and displays each line of table
foreach ($keys as $key=>$val) {
    $classe=$classes[$key];
    // Search in cache if load_state_board is already realized
    if (!isset($boardloaded[$classe]) || !is_object($boardloaded[$classe])) {
    	include_once $includes[$key];	// Loading a class cost around 1Mb

        $board=new $classe($db);
        $board->load_state_board($user);
        $boardloaded[$classe]=$board;
    }
    else $board=$boardloaded[$classe];

    $var  = !$var;
    $text = $langs->trans($titres[$key]);

    print '<a href="'.$links[$key].'" class="nobold nounderline">';
    print '<div class="boxstats icon_btp_home">';
    print $icon .' '.$text.'<br>';
    print $board->nb[$val]; 
    print '</div>';
    print '</a>';
}

print '</td></tr>';
print '</table></div>';