<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 */

/**
 * \file       tender/interimbail/index.php
 * \ingroup    list
 * \brief      List of interimbail related to given Tender
 */
require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/btp/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/user.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/class/tender.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/tender/interimbail/class/interimbail.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/btp.lib.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/tools.lib.php';


$langs->load('users');

// Protection if external user
if (!$user) accessforbidden();

$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
$page 	   = GETPOST("page",'int');
$page 	   = is_numeric($page) ? $page : 0;
$page 	   = $page == -1 ? 0 : $page;
$filter    = '';
if (! $sortfield) $sortfield = "rowid";
if (! $sortorder) $sortorder = "DESC";

$offset  = $conf->liste_limit * $page;
$pageprev= $page - 1;
$pagenext= $page + 1;
$action	 = GETPOST('action', 'alpha');
$confirm = GETPOST('confirm', 'alpha');
$td 	 = GETPOST('td', 'int');
$id 	 = GETPOST('id', 'int');

if (!$td)
	die('ID de l\'ppel d\'offre n\'existe pas!');

$interimbail = new InterimBail($db);
$tender 	 = new Tender($db);
$filter 	= '';

/*if ($id > 0 || $td > 0) {
	$interimbail->fetch($id, $td);
		
	if (!$interimbail->id)
		$interimbail->fetch(null, $td);
	$object 	= $interimbail;
    $param 		= '&td='. $td;

	$upload_dir = $conf->btp->dir_output.'/interimbail/'.$interimbail->id;
	$modulepart = 'btp';

	$filearray = array();

	// Construit liste des fichiers
	$filearray = dol_dir_list($upload_dir, "files", 0, '', '(\.meta|_preview\.png)$', $sortfield, (strtolower($sortorder)=='desc'?SORT_DESC:SORT_ASC),1);
	$totalsize=0;
	foreach($filearray as $key => $file) {
		$totalsize+=$file['size'];
	}

	include_once DOL_DOCUMENT_ROOT . '/btp/core/tpl/document_actions_pre_headers.tpl.php';
}*/

llxHeader(array(), $langs->trans('InterimBail'),'','','','',array('/btp/js/btp.js'));

// Récupération de l'ID de l'utilisateur
$getInterimBail = $interimbail->fetchAll($td);

// Si erreur SQL
if ($getInterimBail == '-1') {
    print_fiche_titre($langs->trans('InterimBail'), '', '');

    dol_print_error($db, $langs->trans('Error').' '.$interimbail->error);
    exit();
}

// Show table of vacations
// $form = new FormChild($db);

if (($id || $td) && $getInterimBail) {
	$interimbail->fetch($id, $td);

	if (!$interimbail->id)
		$interimbail->fetch(null, $td);

	$tender->fetch($td);
	// $object 	= $interimbail;
	$title = $langs->trans("InterimBail");
	$head  = tender_prepare_head($tender);
	dol_fiche_head($head, 'interimbail', $title, 0, '');

	echo $tender->getTenderHeader();

	/*$createdBy  = new User($db);
	$createdBy->fetch($interimbail->fk_created_by);*/
	
	$amount  	= $interimbail->amount ? $interimbail->amount : '';
	$num 	 	= $interimbail->num ? $interimbail->num : '';
	$observation= $interimbail->observation ? $interimbail->observation : '';
	$date_bail 	= $interimbail->date_bail ? dol_print_date($interimbail->date_bail,'day') : '';
	$date_withdrawal= $interimbail->date_withdrawal ? dol_print_date($interimbail->date_withdrawal,'day') : '';
	$tva		= Tools::getTva($amount);

	print '<table class="border" width="100%" data-row-id="0">';
        print '<tbody>';
        print '<tr><td>'.$langs->trans("NumBon").'</td><td>'. $num .'</td></tr>';

        print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("ProvAmount").' TTC</td><td>'. number_format($amount, 2) .' '.$langs->getCurrencySymbol($conf->currency).'</td></tr>';
        
        /*print '<tr><td class="fieldrequired">'.$langs->trans("ApprovalAmountTva").'</td><td>'. number_format($tva['tva'], 2) .' '.$langs->getCurrencySymbol($conf->currency).'</td></tr>';
        
        print '<tr><td class="fieldrequired">'.$langs->trans("ApprovalAmountTTC").'</td><td>'. number_format($tva['amount_ttc'], 2) .' '.$langs->getCurrencySymbol($conf->currency).'</td></tr>';*/

        print '<tr><td class="fieldrequired">'.$langs->trans("DateBail").'</td><td>'. $date_bail .'</td></tr>';
        print '<tr><td>'.$langs->trans("DateWithdrawal").'</td><td>'. $date_withdrawal .'</td></tr>';
        
        print '<tr><td>'.$langs->trans("Observation").'</td><td>'. $observation .'</td></tr>';

     	print '</tbody>';
	print '</table>';

	// if ($user->id && $user->rights->btp->write_all) {
		print '<div class="tabsAction">';
        // Boutons d'actions
		print '<a href="./card.php?action=edit&td='. $td .'&id='. $interimbail->id .'" class="butAction">'.$langs->trans('Modify').'</a>';
        print '</div>';
	// }

	/*$modulepart = 'btp';
    $permission = $user->rights->btp->write;
    $param 		            = '&td='. $td;
    $relativepathwithnofile = '/interimbail/'.$interimbail->id.'/';

    include_once DOL_DOCUMENT_ROOT . '/btp/core/tpl/document_actions_post_headers.tpl.php';*/
}

if ($user->id /*&& $user->rights->btp->write*/ && !$getInterimBail) {
	$tender->fetch($td);
	$object 	= $interimbail;
	$title = $langs->trans("InterimBail");
	$head  = tender_prepare_head($tender);
	dol_fiche_head($head, 'interimbail', $title, 0, '');
	print '<br>';
	print '<div style="text-align: center; margin-top: 8px;">';
	print '<a href="./card.php?action=add&td='. $td .'" class="butAction">'.$langs->trans('AddInterimBail').'</a>';
	print '</div>';
}

llxFooter();

$db->close();

?>