<?php 
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 */

/**
 *   	\file       btp/tender/releases/card.php
 *		\ingroup    card
 *		\brief      Releases
 */

require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/usergroup.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formfile.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/CMailFile.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formmail.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php';
require_once DOL_DOCUMENT_ROOT.'/btp/class/tender.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/tender/releases/class/releases.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/btp.lib.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/tools.lib.php';


// Protection if external user
if (!$user) accessforbidden();

// Get parameters
$myparam = GETPOST("myparam");
$action  = GETPOST('action', 'alpha');
$td 	 = GETPOST('td', 'int');
$id 	 = GETPOST('id', 'int');
$httpReq = $_SERVER['REQUEST_METHOD'];

if (!$td && $httpReq !== 'POST')
	die('ID de l\'appel d\'offre n\'existe pas!');


$error 	  = false;
$releases = new Releases($db);

if ($_POST['action'] == 'create' && $httpReq === 'POST') {

    // If no right to create a request
   /* if (empty($user->rights->btp->write) || empty($user->rights->btp->write_all)) {
    	$error++;
    	setEventMessage($langs->trans('CantCreate'));
    	$action='request';
    }*/

    $td 	  = trim(GETPOST('td', 'int'));
    $amount   = trim(GETPOST('amount'));
    $rel_date = trim(GETPOST('rel_date'));

    if (!$td || !$amount || !$rel_date)
    	return;

    $releases->fk_createdby  = $user->id;
    $releases->fk_tender 	 = $td;
    $releases->amount 		 = $amount;
    $releases->rel_date 	 = Tools::convertDateTo($rel_date, 'sql');

	$getRelease = $releases->create();

	if ($getRelease)
	    header('Location: ./index.php?td='.$td.'&id='.$getRelease);
	else
	    header('Location: ./index.php?td='.$td);

    die();
}

if ($_POST['action'] == 'update' && ($_POST['id'] && $_POST['td']) && $httpReq === 'POST') {

	// If no right to create a request
    /*if (empty($user->rights->btp->write) || empty($user->rights->btp->write_all)) {
    	$error++;
    	setEventMessage($langs->trans('CantCreate'));
    	$action='add';
    } else {*/
	    $td 	  = trim(GETPOST('td', 'int'));
	    $id 	  = trim(GETPOST('id', 'int'));
	    $amount   = trim(GETPOST('amount'));
	    $rel_date = trim(GETPOST('rel_date'));

	    if (!$td || !$id || !$amount || !$rel_date)
	    	return;

	    $data = array(
		    'amount' 		 => $amount,
		    'rel_date' 		 => Tools::convertDateTo($rel_date, 'sql'),
		);

		$releases->update($id, $td, $data);

    	header('Location: ./index.php?td='.$td);
        die();
	// }
}

if ($action == 'confirm_delete' && $_GET['confirm'] == 'yes' /*&& $user->rights->btp->delete*/) {
	$error = 0;
	$td = GETPOST('td', 'int');
	$id = GETPOST('id', 'int');
	
	if (!$td || !$id)
		return;

	$releases->delete((int) $id);

	header('Location: ./index.php?td='.$td);
    exit;
}

$form 	= new Form($db);
$tender = new Tender($db);
$morejs  = array("/btp/js/btp.js");
$morecss = array();

llxHeader(array(), $langs->trans('ListOfReleases'),'','','','',$morejs,$morecss,0,0);

if (empty($td) || $action == 'add' || $action == 'request' || $action == 'create') {
	// Si l'utilisateur n'a pas le droit de créer un marché
    /*if (empty($user->rights->btp->write) || empty($user->rights->btp->write_all)) {
        $errors[] = $langs->trans('CantCreateMarche');
    } else {*/
        // Formulaire de concurrents
		$tender->fetch($td);
		$head = tender_prepare_head($tender);
		dol_fiche_head($head, 'releases', $langs->trans('Addrelease'), 0, '');

		echo $tender->getTenderHeader();

        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">'."\n";
        print '<input type="hidden" name="action" value="create" />'."\n";
        print '<input type="hidden" name="td" value="'. $td .'" />'."\n";

        print '<table class="border" width="100%" data-row-id="0">';
        print '<tbody>';

        print '<tr><td class="fieldrequired" width="25%">'.$langs->trans("Amount").'</td><td>';
        print '<input type="text" class="" value="" name="amount" required="required" /> '.$langs->getCurrencySymbol($conf->currency);
        print '</td></tr>';

        print '<tr><td class="fieldrequired">'. $langs->trans("ReleaseDate") .'</td><td>';
        print '<input type="text" class="datepicker" autocomplete="off"  value="" name="rel_date" required="required" />';
        print '</td></tr>';

        print '</tbody>';
        print '</table>';

		dol_fiche_end();

        print '<div class="center" style="margin-top: 28px;">';
        print '<input type="submit" value="'. $langs->trans("CreateRelease") .'" name="bouton" class="butAction">';
        print '&nbsp; &nbsp; ';
        print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
        print '</div>';

        print '</form>';
    // }
} else {
	if ($id && $td) {
		$releases->fetch($id, $td);
		$tender->fetch($td);
		$head    = tender_prepare_head($tender, $releases);
		$canedit = true;/*($user->rights->btp->delete || $user->rights->btp->write_all);*/

		if ($canedit) {
            if ($action == 'delete') {
                // if($user->rights->btp->delete) {
                    print $form->formconfirm("./card.php?td=".$td."&id=".$id, $langs->trans("DeleteRelease"),$langs->trans("ConfirmDeleteRelease"),"confirm_delete", '', 0, 1);
                // }
            }

			if ($action == 'edit' || $action == 'delete') {
				dol_fiche_head($head, 'releases', $langs->trans('Releases'), 0, '');

				echo $tender->getTenderHeader();

		        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">'."\n";
		        print '<input type="hidden" name="action" value="update" />'."\n";
		        print '<input type="hidden" name="td" value="'. $td .'" />'."\n";
		        print '<input type="hidden" name="id" value="'. $id .'" />'."\n";

				$amount	  = $releases->amount ? $releases->amount : '';
		      	$rel_date = $releases->rel_date ? dol_print_date($releases->rel_date, 'day'): '';

		        print '<table class="border" width="100%" data-row-id="0">';
		        print '<tbody>';

		        print '<tr><td class="fieldrequired" width="25%">'.$langs->trans("Amount").'</td><td>';
		        print '<input type="text" class="" value="'. $amount .'" name="amount" required="required" /> '.$langs->getCurrencySymbol($conf->currency);
		        print '</td></tr>';

		        print '<tr><td  class="fieldrequired">'. $langs->trans("ReleaseDate") .'</td><td>';
		        print '<input type="text" class="datepicker" autocomplete="off"  value="'. $rel_date .'" name="rel_date" required />';
		        print '</td></tr>';

		        print '</tbody>';
		        print '</table>';

				dol_fiche_end();

		        print '<div class="tabsAction">';
                    // Boutons d'actions
		        	print '<input type="submit" value="'. $langs->trans("Modify") .'" name="bouton" class="butAction">';
                    print '<a onclick="history.go(-1)" class="butAction">'.$langs->trans("Cancel").'</a>';

                    // if ($user->rights->btp->delete)	{
                    	print '<a href="./card.php?id='.$id.'&action=delete&td='. $td .'" class="butActionDelete">'.$langs->trans("Delete").'</a>';
                    // }
                print '</div>';

		        print '</form>';
			}
        }
	}
}

llxFooter();

$db->close();

?>