<?php 
/* Copyright (C) 2016		Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *   	\file       marches/list.php
 *		\ingroup    list
 *		\brief      Gestion des marches
 */

require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/tresorie/invoice_location_expenses/class/invoice_location_expenses.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/material/location_expenses/class/location_expenses.class.php';
require_once DOL_DOCUMENT_ROOT . '/fourn/class/fournisseur.facture.class.php';



$User = new User($db);
$facture = new FactureFournisseur($db);

// Get parameters
$action  = GETPOST('action', 'alpha');
$id 	 = GETPOST('id', 'int');
$request_method = $_SERVER['REQUEST_METHOD'];

//$langs->load('marches');
// Protection if external user
if ($user->societe_id > 0) accessforbidden();

$now 	= new DateTime('now');
$now       = $now->format('Y-m-d');
$form       = new Form($db);
$error 	= false;

if ($action == 'create' && $request_method === 'POST') {
	$invoice_location_expenses = new invoice_location_expenses($db);

    if (!$error) {
        
          $invoice_location_expenses->ht           = trim(GETPOST('ht_'));
          $invoice_location_expenses->tva      = trim(GETPOST('tva_'));
          $invoice_location_expenses->invoice_id = trim(GETPOST('invoice_id_'));
          $invoice_location_expenses->location_expenses_id   = trim(GETPOST('location_expenses_id_'));
          $invoice_location_expenses->user_id      = trim(GETPOST('user_id_'));
          $invoice_location_expenses->created_by     = $user->id;
            //if(!$invoice_location_expenses->check_mat($invoice_location_expenses->mat)){
                    $invoice_location_expensesID = $invoice_location_expenses->create();
            
                    // If no SQL error we redirect to the request card
                    if ($invoice_location_expensesID > 0) {
                        //header('Location: index.php?id='.$getMarcheID);
                        header('Location: index.php');
                        exit;
                    } else {
                        // Otherwise we display the request form with the SQL error message
                        header('Location: card.php?action=request&error=SQL_Create&msg='.$invoice_location_expenses->error);
                        exit;
                    }
               /* }
            else{
                $msg ='Cette marticule '.$invoice_location_expenses->mat.' est deja saisée !';
                 header('Location: card.php?action=request&error=SQL_Create&msg='.$msg);
                        exit;
            }*/
    }
}

if ($action == 'update' && $request_method === 'POST') {
    // If no right to modify a request
    /*if (!$user->rights->marches->write) {
        header('Location: ./card.php?action=request&error=CantUpdate');
        exit;
    }*/

    $invoice_location_expenses_id = (int) GETPOST('invoice_location_expenses_id', 'int');

    if (!$invoice_location_expenses_id || $invoice_location_expenses_id <= 0) {
        header('Location: ./card.php?action=request&error=CantUpdate');
        exit;
    }

    $invoice_location_expenses = new invoice_location_expenses($db);
    $invoice_location_expenses->fetch($invoice_location_expenses_id);

   // $canedit = ($user->rights->marches->write || $user->rights->marches->write_all);
    $canedit = true ; 


    // If this is the requestor or has read/write rights
    if ($canedit) {
        
        $data = array(
          'ht'           =>trim(GETPOST('ht_')),
          'tva'      =>trim(GETPOST('tva_')),
          'invoice_id' =>trim(GETPOST('invoice_id_')),
          'location_expenses_id'   =>trim(GETPOST('location_expenses_id_')),
          'user_id'     =>trim(GETPOST('user_id_')),
          'updated_at'    =>$now
        );

		$getinvoice_location_expensesID = $invoice_location_expenses->update($invoice_location_expenses_id, $data);
        
                if ($getinvoice_location_expensesID > 0) {
                    header('Location: ./index.php?id='.$invoice_location_expenses_id);
                    exit;
                } else {
                    // Otherwise we display the request form with the SQL error message
                    header('Location: ./card.php?id='. $invoice_location_expenses_id .'&action=edit&error=SQL_Create&msg='.$invoice_location_expenses->error);
                    exit;
                } 
    }
}

// If delete of request
if ($action == 'confirm_delete' && GETPOST('confirm') == 'yes' ) {
	$error=0;

	//$db->begin();

	$event  = new invoice_location_expenses($db);
	//$canedit = ($user->rights->marches->write_all || $user->rights->marches->delete);
    $canedit = true;
	// Si l'utilisateur à le droit de lire ce contrat, il peut le supprimer
	if ($canedit) {
        $event->fetch($id);
		$event->delete();
	}
	else {
		$error = $langs->trans('ErrorCantDelete');
	}

	if (!$error) {
		//$db->commit();
		header('Location: index.php');
		exit;
	}
	else {
		
        header('Location: index.php?leftmenu=marches');
        exit;
	}
}

/*
 * View
 */

$form      = new Form($db);
$invoice_location_expenses     = new invoice_location_expenses($db);
$location_expenses     = new location_expenses($db);

$morejs  = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.js", "/btp/js/jquery/timepicker/timepicker-fr.js","/btp/js/fuel_consoma.js");
$morecss = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.css");

llxHeader(array(), $langs->trans('invoice_location_expenses'),'','','','',$morejs,$morecss,0,0);

if (empty($id) || $action == 'add' || $action == 'request' || $action == 'create') {
	// Si l'utilisateur n'a pas le droit de créer un marché
    /*if (empty($user->rights->marches->write) || empty($user->rights->marches->write_all)) {
        $errors[]=$langs->trans('CantCreate');
    }
    else {*/
        // Formulaire appel d'offre
        print_fiche_titre($langs->trans('Addinvoice_location_expenses'));

        // Si il y a une erreur
        if (GETPOST('error')) {
            switch(GETPOST('error')) {
                case 'nobudget' :
                    $errors[] = $langs->trans('errorNoBudget');
                    break;
                case 'SQL_Create' :
                    $errors[] = $langs->trans('ErrorSQLCreateCP').' <b>'.htmlentities($_GET['msg']).'</b>';
                    break;
                case 'CantCreate' :
                    $errors[] = $langs->trans('CantCreateCP');
                    break;
                case 'nouser' :
                    $errors[] = $langs->trans('errorNoUser');
                    break;
                case 'nodatedebut' :
                    $errors[] = $langs->trans('NoDateDebut');
                    break;
                case 'nobank' :
                    $errors[] = $langs->trans('errorNoBank');
                    break;
                case 'noqc' :
                    $errors[] = $langs->trans('errorNoQc');
                    break;
                case 'alreadyExists' :
                    $errors[] = $langs->trans('alreadyExistAO');
                    break;
                case 'noref' :
                    $errors[] = $langs->trans('errorNoRef');
                    break;
            }

	        setEventMessage($errors, 'errors');
        }

        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">'."\n";
        print '<input type="hidden" name="action" value="create" />'."\n";

        print '<table class="border" width="100%">';
        print '<tbody>';
        //invoice
        print '<tr><td>'.$langs->trans("invoice").'</td><td>'; 
        print $form->selectarray('invoice_id_', $invoice_location_expenses->getInvoices(),(GETPOST('invoice_id_') ? GETPOST('invoice_id_') : null), 0, 0, 0, 'required="required"');
        print '</td></tr>';
        //location_expenses
        print '<tr><td>'.$langs->trans("location_expenses").'</td><td>'; 
        print $form->selectarray('location_expenses_id_', $location_expenses->getMats(),(GETPOST('location_expenses_id_') ? GETPOST('location_expenses_id_') : null), 0, 0, 0, 'required="required"');
        print '</td></tr>';
        //ht
        print '<tr><td class="fieldrequired">'.$langs->trans("ht").'</td><td>';
        print '<input type="number" value="" min="0" step="0.01" name="ht_" required="required" />';
        print '</td></tr>';
        //Quantité de Location  
        print '<tr><td class="fieldrequired">'.$langs->trans("tva").'</td><td>';
        print '<input type="number" min="0" step="0.01"  value="" name="tva_" required="required" />';
        print '</td></tr>';

        //locataire 
         print '<tr><td>'.$langs->trans("user").'</td><td>'; 
         print $form->select_dolusers(null,'user_id_');
         print '</td></tr>';


        print '</tbody>';
        print '</table>';

        print '<div class="center">';
        print '<input type="submit" value="'. $langs->trans("Createinvoice_location_expenses") .'" name="bouton" class="butAction">';
        print '&nbsp; &nbsp; ';
        print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
        print '</div>';
        print '</form>';
    //}
}
else {
    if ($error) {
        print '<div class="tabBar">';
        print $error;
        print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
        print '</div>';
    }
    else {
        // Affichage de la fiche d'une demande de congés payés

        if ($id > 0) {
            $invoice_location_expenses->fetch($id);

			//$canedit = ($user->rights->marches->delete || $user->rights->marches->write_all);

            // Si il y a une erreur
            if (GETPOST('error')) {
                switch(GETPOST('error')) {
                    case 'datefin' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorEndDateCP');
                        break;
                    case 'SQL_Create' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorSQLCreateCP').' '.$_GET['msg'];
                        break;
                    case 'CantCreate' :
                        $errors[] = $langs->transnoentitiesnoconv('CantCreateCP');
                        break;
                    case 'Valideur' :
                        $errors[] = $langs->transnoentitiesnoconv('InvalidValidatorCP');
                        break;
                    case 'nodatedebut' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateDebut');
                        break;
                    case 'nodatefin' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateFin');
                        break;
                    case 'DureeHoliday' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorDureeCP');
                        break;
                    case 'NoMotifRefuse' :
                        $errors[] = $langs->transnoentitiesnoconv('NoMotifRefuseCP');
                        break;
                    case 'mail' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorMailNotSend')."\n".$_GET['error_content'];
                        break;
                }

	            setEventMessage($errors, 'errors');
            }

            // On vérifie si l'utilisateur à le droit de lire cette demande
           // if ($canedit) {

                // Si annulation de la demande
                if ($action == 'cancel') {
                    print $form->formconfirm("card.php?id=".$id, $langs->trans("TitleCancelSC"), $langs->trans("ConfirmCancelSC"),"confirm_cancel", '', 1, 1);
                }

                dol_fiche_head('', 'invoice_location_expenses', $langs->trans("invoice_location_expenses"), 0, '');

                if ($action == 'edit') {
                    $edit = true;
                    print '<form method="post" action="'.$_SERVER['PHP_SELF'].'?id='.$id.'">'."\n";
                    print '<input type="hidden" name="action" value="update" />'."\n";
                    print '<input type="hidden" name="invoice_location_expenses_id" value="'.$id.'" />'."\n";

                    print '<table class="border" width="100%">';
                    print '<tbody>';
          //invoice
        print '<tr><td>'.$langs->trans("invoice").'</td><td>'; 
        print $form->selectarray('invoice_id_', $invoice_location_expenses->getInvoices(),(GETPOST('invoice_id_') ? GETPOST('invoice_id_') : $invoice_location_expenses->invoice_id), 0, 0, 0, 'required="required"');
        print '</td></tr>';
        //location_expenses
        print '<tr><td>'.$langs->trans("location_expenses").'</td><td>'; 
        print $form->selectarray('location_expenses_id_', $location_expenses->getMats(),(GETPOST('location_expenses_id_') ? GETPOST('location_expenses_id_') : $invoice_location_expenses->location_expenses_id), 0, 0, 0, 'required="required"');
        print '</td></tr>';
         //ht
        print '<tr><td class="fieldrequired">'.$langs->trans("ht").'</td><td>';
        print '<input type="number" min ="0" step="0.01" value="'.$invoice_location_expenses->ht.'" name="ht_" required="required" />';
        print '</td></tr>';

        //Quantité location   
        print '<tr><td class="fieldrequired">'.$langs->trans("tva").'</td><td>';
        print '<input type="number" min ="0" step="0.01" value="'.$invoice_location_expenses->tva.'" name="tva_" required="required" />';
        print '</td></tr>';

        //client 
        print '<tr><td>'.$langs->trans("user").'</td><td>'; 
        print $form->select_dolusers($invoice_location_expenses->user_id,'user_id_');
        print '</td></tr>';



                    print '</tbody>';
                    print '</table>';

                    print '<div class="center">';
                    print '<input type="submit" value="'. $langs->trans("Modify") .'" name="bouton" class="butAction">';
                    print '&nbsp; &nbsp; ';
                    print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
                    print '</div>';
                    print '</table>';
                }

                dol_fiche_end();

                if (!$edit) {
		            print '<div class="tabsAction">';

                    // Boutons d'actions
                    //if ($canedit) {
                        print '<a href="card.php?id='.$_GET['id'].'&action=edit" class="butAction">'.$langs->trans("Modify").'</a>';
                    //}

                    // If draft
                   // if ($user->rights->marches->delete)	{
                    	print '<a href="card.php?id='.$_GET['id'].'&action=delete" class="butActionDelete">'.$langs->trans("Delete").'</a>';
                   // }

                    print '</div>';
                }

        } else {
                
                print '<div class="tabBar">';
                print $langs->trans('ErrorUserViewSC');
                print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
                print '</div>';
            }

        /*} else {
            print '<div class="tabBar">';
            print $langs->trans('ErrorIDFicheSC');
            print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
            print '</div>';
        }*/

    }

}

// End of page
llxFooter();

if (is_object($db)) $db->close();

?>