<?php
/* Copyright (C) 2016	Souieh Laghdaf	<laghdaf.souieh@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file       /material/invoice_location_expenses/index.php
 * \ingroup    list
 * \brief      List of location expensess
 */
require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/tresorie/invoice_location_expenses/class/invoice_location_expenses.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/material/location_expenses/class/location_expenses.class.php';
require_once DOL_DOCUMENT_ROOT . '/fourn/class/fournisseur.facture.class.php';



$form 		= new Form($db);
$invoice_location_expenses     = new invoice_location_expenses($db);
$location_expenses   = new location_expenses($db);
$User = new User($db);
$facture = new FactureFournisseur($db);


$var = false;
$filter = '';
        
$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
if (! $sortfield) $sortfield = "rowid";
if (! $sortorder) $sortorder = "DESC";
$action  = GETPOST('action', 'alpha');
$id 	  = GETPOST('id','int');
$search_ht      		= GETPOST('search_ht');
$search_location_expenses    		= GETPOST('search_location_expenses');
$search_tva    		= GETPOST('search_tva');
$search_invoice    		= GETPOST('search_invoice');
$search_user    		= GETPOST('search_user');
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
$search_ht      		= '';
$search_location_expenses    		= '';
$search_tva    		= '';
$search_invoice    		= '';
$search_user    		= '';
}
$filter .= (!empty($search_ht) && $search_ht != -1) ? " AND ht = ". $db->escape($search_ht): "";
$filter .= (!empty($search_location_expenses) && $search_location_expenses != -1) ? " AND location_expenses_id = ".$db->escape($search_location_expenses):"";
$filter .= ( $search_tva != '') ? " AND tva = ".$db->escape($search_tva):"";
$filter .= (!empty($search_invoice) && $search_invoice != -1) ? " AND invoice_id = ".$db->escape($search_invoice):"";
$filter .= (!empty($search_user) && $search_user != -1) ? " AND user_id = ".$db->escape($search_user):"";


$getinvoice_location_expensess = $invoice_location_expenses->fetchAll($sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter);
if (!empty($getinvoice_location_expensess)  && $action == "xsl" ) {
$filename="Liste_factures_depences_location.xls";
      require_once DOL_DOCUMENT_ROOT.'/btp/tresorie/invoice_location_expenses/tpl/invoice_location_expenses_xsl.php';
 die();
 
}
// Si erreur SQL
if ($getinvoice_location_expensess == '-1') {
    print_fiche_titre($langs->trans('ListOfinvoice_location_expenses'), '', 'title_project.png');

    dol_print_error($db, $langs->trans('Error').' '.$invoice_location_expenses->error);
    exit();
}
if ($id > 0) {
	$invoice_location_expenses->fetch($id);
	llxHeader('', $langs->trans('invoice_location_expenses'));
	print_fiche_titre($langs->trans("invoice_location_expenses"));


	print '<table class="border" width="100%">';
	// invoice
    print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("invoice").'</td>';
    $facture->fetch($invoice_location_expenses->invoice_id);
    print '<td colspan="2">'. $facture->getNomUrl(1) .'</td></tr>';
    // location_expenses
    print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("location_expenses").'</td>';
    $location_expenses->fetch($invoice_location_expenses->location_expenses_id);
    print '<td colspan="2">'. $location_expenses->getNomUrl(1) .'</td></tr>';
	// ht
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("ht").'</td>';
	print '<td colspan="2">'. $invoice_location_expenses->ht .'</td></tr>';
	// tva
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("tva").'</td>';
	print '<td colspan="2">'. $invoice_location_expenses->tva .'</td></tr>';
	// user 
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("user").'</td>';
	$User->fetch($invoice_location_expenses->user_id);
	print '<td colspan="2">'. $User->getNomUrl(1).'</td></tr>';
	
	print '</table>';
	print '<br>';
	print '<div style="float: right; margin-top: 8px;">';
	print '<a href="./index.php?mid='. $mid .'" class="butAction">'.$langs->trans('Cancel').'</a>';
		print '<a href="./card.php?action=edit&id='. $id .'" class="butAction">'.$langs->trans('Modify').'</a>';
		print '<a href="./index.php?action=delete&id='. $id .'" class="butAction" >'.$langs->trans('Delete').'</a>';
	print '</div>';
	if ($action == 'delete') {
                        print $form->formconfirm("card.php?id=".$id, $langs->trans("TitleDelete"),$langs->trans("ConfirmDelete"),"confirm_delete", '', 0, 1);
                }
}
else {

 // Both test are required to be compatible with all browsers
$morejs  = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.js", "/btp/js/jquery/timepicker/timepicker-fr.js","/btp/js/fuel_consoma.js");
$morecss = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.css");

llxHeader('', $langs->trans('invoice_location_expensess'),'','','','',$morejs,$morecss,0,0);
print_fiche_titre($langs->trans("ListOfinvoice_location_expenses"));


	// dol_fiche_head('', 'invoice_location_expensess', $langs->trans("Listinvoice_location_expenses"), 1, '');
print '<div style="float: right; margin-bottom: 6px;">';
		print '<a href="./card.php?action=add" class="butAction">'.$langs->trans('Addinvoice_location_expenses').'</a>';
print '</div>';
print '<div style="float: right; ">';
	   print '<form method="post" action="'.$_SERVER["PHP_SELF"].'">'."\n";
print '<input name="search_ht" value="'. $search_ht .'" type="hidden" />';
print '<input name="search_location_expenses" value="'. $search_location_expenses .'" type="hidden" />';
print '<input name="action" value="xsl" type="hidden" />';
print '<input name="search_tva" value="'. $search_tva .'" type="hidden" />';
print '<input name="search_invoice" value="'. $search_invoice .'" type="hidden" />';
print '<input name="search_user" value="'. $search_user .'" type="hidden" />';
	    print '<button style="margin-bottom: 8px;" class="butAction" name="submit" value="Exporter Excel">'.$langs->trans('Exporter Excel').'</button>';
	   print '</form>'."\n";
		print '</div>';
	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	print '<input name="id" value="'. $id .'" type="hidden" />';
	print '<table class="noborder" width="100%;">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("ref"), $_SERVER["PHP_SELF"], 'rowid', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("invoice"), $_SERVER["PHP_SELF"], 'invoice_id', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("ht"), $_SERVER["PHP_SELF"], 'ht', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("tva"), $_SERVER["PHP_SELF"], 'tva', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("location_expenses"), $_SERVER["PHP_SELF"], 'location_expenses_id', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("user"), $_SERVER["PHP_SELF"], 'user_id', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'','','',$sortfield,$sortorder,'maxwidthsearch ');
	print "</tr>\n";

	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';
    // ref
	print '<td class="liste_titre" colspan="1" align="center">';
	print '</td>';
    // invoice
	print '<td class="liste_titre" colspan="1" align="center">';
	print $form->selectarray('search_invoice', $invoice_location_expenses->getInvoices(),$search_invoice, 1, 0, 0);
    print '</td>';
	// ht
	print '<td class="liste_titre" colspan="1" align="center">';
	print '<input class="flat" type="number" min="0" step="0.01"  style="width: 85px" name="search_ht" value="'.$search_ht.'">';
	print '</td>';
	// tva
	print '<td class="liste_titre" olspan="1" align="center">';
	print '<input class="flat" style="width: 85px"  type="number"  min="0" step="0.01"  name="search_tva" value="'.$search_tva.'">';
	print '</td>';
	// location_expenses
	print '<td class="liste_titre" olspan="1" align="center">';
	print $form->selectarray('search_location_expenses', $location_expenses->getMats(), $search_location_expenses, 1, 0, 0);
	print '</td>';
	// user
	print '<td class="liste_titre" colspan="1" align="center">';
	print $form->select_dolusers($search_user,'search_user',1);
    print '</td>';

	// ACTION
	print '<td align="right" style="min-width:62px;">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';

	print "</tr>\n";

	// Lines
	if (count($invoice_location_expenses->rows)) {
		//$createdBy = new User($db);
		foreach($invoice_location_expenses->rows as $obj) {
			  $ht 				= $obj->ht ;
			  $price  			= $obj->price ;
			  $tva 				= $obj->tva ;
			  $facture->fetch($obj->invoice_id);
			  $location_expenses->fetch($obj->location_expenses_id) ;
			  $User->fetch($obj->user_id);
			  
			

			print '<tr '.$bc[$var].'>';
			print '<td align="left" style ="white-space: nowrap;">';
				print $invoice_location_expenses->getNomUrl(1,  $obj->id, $obj->id);
			print '</td>';
			 
			print '<td align="center">'. $facture->getNomUrl(1) .'</td>';
			print '<td align="center">'. $ht .'</td>';
			print '<td align="center">'. $tva .'</td>';
			print '<td align="center">'. $location_expenses->getNomUrl(1)	 .'</td>';
			print '<td align="center">'. $User->getNomUrl(1).'</td>';
			print '<td align="center"></td>';

			print '</tr>'."\n";

		}
	} else {
		print '<tr>';
	    print '<td colspan="9" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';
	}

	print '</table>';
	print '</form>';



}

llxFooter();

$db->close();


?>