<?php
/* Copyright (C) 2014-2019		charlene Benke		<charlie@patas-monkey.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * 	\file	   htdocs/customlink/class/actions_customlink.class.php
 * 	\ingroup	customlink
 * 	\brief	  Fichier de la classe des actions/hooks des customlink
 */

class ActionsCustomlink // extends CommonObject 
{

	/** Overloading the doActions function : replacing the parent's function with the one below 
	 *  @param	  parameters  meta datas of the hook (context, etc...) 
	 *  @param	  object			 the object you want to process 
	 *  @param	  action			 current action (if set). Generally create or edit or null 
	 *  @return	   void 
	 */ 
	function showLinkedObjectBlock($parameters, $object, $action) 
	{ 
		global $conf, $langs;

		$langs->load("customlink@customlink");
		dol_include_once("/customlink/core/lib/customlink.lib.php");

		// If link is http
		if (empty($_SERVER["HTTPS"]) || $_SERVER["HTTPS"] != 'on')	$szhttp	= "http";
		else														$szhttp	= "https";
		print '	<br />
				<table class = "allwidth">
					<tr>
						<td style = "width: 50%;">';
		print_titre($langs->trans('AddNewTag'));
		print '				<form action = "'.dol_buildpath("/customlink", 1).'/addtag.php" method = "POST">
								<input type = "hidden" name = "token" value = "'.$_SESSION['newtoken'].'">
								<input type = "hidden" name = "redirect" value = "'.$szhttp.'://'.$_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'].'">
								<input type = "hidden" name = "type_source" value = "'.$object->element.'">
								<input type = "hidden" name = "fk_source" value = "'.($object->rowid ? $id = $object->rowid : $object->id).'">
								<table class = "noborder">
									<tr class = "liste_titre">
										<td>'.$langs->trans("ElementTags").'</td>
										<td class = "right"><input class = "butAction" type = submit name = join value = '.$langs->trans("Add").'></td>
									</tr>
									<tr>
										<td class = "left" width = "40%"><input type = "text" name = tag value = "" style = "width: 99%;"></td>
										<td>';
		print_tag_list($object->element, ($object->rowid ? $id = $object->rowid : $object->id));
		print '							</td>
									</tr>
								</table>
							</form>
						</td>
						<td>';
		print_titre($langs->trans('AddNewLink'));
		print '				<form action = "'.dol_buildpath("/customlink", 1).'/addlink.php" method = "POST">
								<input type = "hidden" name = "token" value = "'.$_SESSION['newtoken'].'">
								<input type = "hidden" name = "redirect" value = "'.$szhttp.'://'.$_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'].'">
								<input type = "hidden" name = "type_source" value = "'.$object->element.'">
								<input type = "hidden" name = "fk_source" value = "'.($object->rowid ? $id = $object->rowid : $object->id).'">
								<table class = "noborder">
									<tr class = "liste_titre">
										<td>'.$langs->trans("Element").'</td>
										<td>'.$langs->trans("Ref").'</td>
										<td class = "right"><input class = "butAction" type = submit name = join value = '.$langs->trans("JoinElement").'></td>
									</tr>
									<tr>
										<td>';
		select_element_type("", 'type_target', 0, 1);
		print '							</td>
										<td colspan = "2" class = "left"><input type = "text" name = ref_target value = "" style = "width: 99%;"></td>
									</tr>
								</table>
							</form>
						</td>
					</tr>
				</table>';
		$num				= count($object->linkedObjects);
		$this->resprints	= $num;
		return 0;
	}
	
	
	function addSearchEntry ($parameters, $object, $action) 
	{
		global $confg, $langs;
		$resArray=array();
		$resArray['searchintocustomlink']=array(
						'position'=>231, 'img'=>'object_customlink@customlink', 
						'label'=>$langs->trans("CustomLink", $search_boxvalue), 
						'text'=>img_picto('', 'object_customlink@customlink').' '.$langs->trans("CustomLink", GETPOST('q')), 
						'url'=>dol_buildpath('/customlink/listetag.php?sall='.urlencode(GETPOST('q')), 1)
		);
		$this->results = $resArray;
		return 0;
	}
}