<?php 
/* Copyright (C) 2015 Oscss-Shop Team <support@oscss-shop.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */


require_once(DOL_DOCUMENT_ROOT . "/comm/action/class/cactioncomm.class.php");
require_once(DOL_DOCUMENT_ROOT . "/comm/action/class/actioncomm.class.php");




class ActionCommDolMessage 
	Extends ActionComm {
	
	
	/**
		@brief add event in calendar 
		@param $user Object Dolibarr User 
		@param $societe Object Dolibarr Societe 
		@param $DolMessage Object DolMessage Module 
		@return none 
		
	*/
	public function SetEvent(User $user, Societe $societe, DolMessage $DolMessage, DMessage $Message ){
		global $conf, $langs; 
		

			$cactioncomm = new CActionComm($this->db);

			// Initialisation objet actioncomm
			$usertodo = $user;
			$this->usertodo = $usertodo;
			$this->userownerid = $usertodo->id ;
			$this->userdoneid = $usertodo->id ;


			if ($conf->global->CODE_ACTIONCOMM_DOLMESSAGE)
					$cactioncomm_code = $conf->global->CODE_ACTIONCOMM_DOLMESSAGE;
			else
					$cactioncomm_code = "AC_EMAIL";

			$cactioncomm->fetch($cactioncomm_code);

			$this->type_id = $cactioncomm->id;
			$this->type_code = $cactioncomm->code;
			$this->priority = 0;
			$this->fulldayevent = 0;
            $this->percentage =100;
			$this->location = '';
			$this->label = $langs->trans('MessageReceived') . ' ' . $Message->GetSubject();
			$this->fk_project = 0;
			$this->datep = strtotime($Message->GetDate());
			
			$n = ''; 
			
			$n .= $langs->trans('DolmessageTo').': '.$Message->GetToMail()."\n\r"; 
			$n .= $langs->trans('DolmessageFrom').': '.$Message->GetFromMail()."\n\r";
			$n .= $langs->trans('DolmessagelObject').': '.$Message->GetSubject()."\n\r"; 
			$n .= $langs->trans('DolmessageMessage').': '."\n<br />"; 
			$n .= $Message->GetPlainMsg(); 
			
			
			$this->note = nl2br($n); 
			$this->fk_element = $DolMessage->id;
			$this->elementtype = 'dolmessage';

			if (isset($societe->id) && $societe->id > 0)
					$this->societe = $societe;
					$this->socid = $societe->id;

			if (!$error) {
					$this->db->begin();

					// On cree l'action
					$idaction = $this->add($user);

					if ($idaction > 0) {
							if (!$actioncomm->error) {
									$this->db->commit();
							}
					}
			}
	}
	
}

