<?php
/* Copyright (C) 2015 Oscss-Shop Team <support@oscss-shop.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
  @file    class/actions_dolmessage.class.php
  @ingroup dolmessage
  @brief   Hook for dolmessage
  Support of Greffons
 */
//  	var_dump(__file__); 
dol_include_once('/framework/class/hookgreffon.class.php');

/**
  @class ActionsDolMessage
  @brief
 */
class ActionsDolMessage Extends HookGreffon
{
    public $greffon = array();

    /** Overloading the doActions function : replacing the parent's function with the one below 
     *  @param      parameters  meta datas of the hook (context, etc...) 
     *  @param      object             the object you want to process (an invoice if you are in invoice module, a propale in propale's module, etc...) 
     *  @param      action             current action (if set). Generally create or edit or null 
     *  @return       void 
     */
    function printSearchForm($parameters, &$object, &$action, $hookmanager)
    {
        global $langs, $conf;

// 				  $parameters=array('searchform'=>$searchform);
// 			return $this->{'___'.__FUNCTION__}($parameters, $object, $action, $hookmanager); 
        if (!empty($conf->global->MAIN_USE_OLD_SEARCH_FORM)) {
            $langs->load("dolmessage@dolmessage");
            $this->resprints .= printSearchForm(dol_buildpath('/dolmessage/synchro.php', 1).'',
                dol_buildpath('/dolmessage/synchro.php', 1), $langs->trans("Dolmessage"), 'maxwidth100', 'sall', 'M',
                'search', img_object('', 'dolmessage@dolmessage'));

            return 0;
        }
    }

    /** Overloading the doActions function : replacing the parent's function with the one below 
     *  @param      parameters  meta datas of the hook (context, etc...) 
     *  @param      object             the object you want to process (an invoice if you are in invoice module, a propale in propale's module, etc...) 
     *  @param      action             current action (if set). Generally create or edit or null 
     *  @return       void 
     */
    function addSearchEntry($parameters, &$object, &$action, $hookmanager)
    {
        global $langs, $conf;

// 				  $parameters=array('searchform'=>$searchform);
// 			return $this->{'___'.__FUNCTION__}($parameters, $object, $action, $hookmanager); 
// 		$arrayresult['searchintocontact']=array('img'=>'object_contact', 'label'=>$langs->trans("SearchIntoContacts", $search_boxvalue), 'text'=>img_picto('','object_contact').' '.$langs->trans("SearchIntoContacts", $search_boxvalue), 'url'=>DOL_URL_ROOT.'/contact/list.php?sall='.urlencode($search_boxvalue));


        $langs->load("dolmessage@dolmessage");
        $this->results = array('dolmessage' => array('img' => 'object_dolmessage', 'label' => $langs->trans("SearchIntoMessage",
                    $search_boxvalue), 'text' => img_picto('', 'dolmessage@dolmessage').' '.$langs->trans("SearchIntoMessage",
                    $search_boxvalue), 'url' => dol_buildpath('/dolmessage/synchro.php', 1).'?search='.urlencode($search_boxvalue)));

        return 0;
    }

    /** Overloading the doActions function : replacing the parent's function with the one below 
     *  @param      parameters  meta datas of the hook (context, etc...) 
     *  @param      object             the object you want to process (an invoice if you are in invoice module, a propale in propale's module, etc...) 
     *  @param      action             current action (if set). Generally create or edit or null 
     *  @return       void 
     */
    function doActions($parameters, &$object, &$action, $hookmanager)
    {
        global $langs, $db;

        $langs->load('mails');

// 				var_dump($action); 
        if ($action == "send") {
// 					include_once(DOL_DOCUMENT_ROOT . '/core/class/html.formmail.class.php');
// 					require_once DOL_DOCUMENT_ROOT.'/core/class/CMailFile.class.php';
// 					dol_include_once('/dolmessage/class/dolCMailFile.class.php');

            switch ($parameters['currentcontext']) {
                case 'propalcard':
                case 'ordercard':
                case 'invoicecard':

                case 'ordersuppliercard':
                case 'invoicesuppliercard':

                    if (!@$_POST['addfile'] && !@$_POST['removedfile'] && !@$_POST['cancel']) {
                        $langs->load('mails');

                        $result = $object->fetch($_POST["id"]);
                        $result = $object->fetch_thirdparty();

                        if ($result > 0) {
                            if ($_POST['sendto']) {
                                // Le destinataire a ete fourni via le champ libre
                                $sendto   = $_POST['sendto'];
                                $sendtoid = 0;
                            } elseif ($_POST['receiver'] != '-1') {
                                // Recipient was provided from combo list
                                if ($_POST['receiver'] == 'thirdparty') { // Id of third party
                                    $sendto   = $object->client->email;
                                    $sendtoid = 0;
                                } else {// Id du contact ou du thirdparty
                                    if (isset($object->client)) {
                                        $objectthird = $object->client;
                                    } else {
                                        $objectthird = $object->thirdparty;
                                    }
                                    $sendto   = $objectthird->contact_get_property($_POST['receiver'], 'email');
                                    $sendtoid = $_POST['receiver'];
                                }
                            }

                            if (dol_strlen($sendto)) {
                                $langs->load("commercial");

                                $from            = $_POST['fromname'].' <'.$_POST['frommail'].'>';
                                $replyto         = $_POST['replytoname'].' <'.$_POST['replytomail'].'>';
                                $message         = $_POST['message'];
                                $sendtocc        = $_POST['sendtocc'];
                                $deliveryreceipt = $_POST['deliveryreceipt'];

                                if ($_POST['action'] == 'send') {
                                    if (dol_strlen($_POST['subject'])) $subject        = $_POST['subject'];
                                    else $subject        = $langs->transnoentities('Propal').' '.$object->ref;
                                    $actiontypecode = 'AC_PROP';
                                    $actionmsg      = $langs->transnoentities('MailSentBy').' '.$from.' '.$langs->transnoentities('To').' '.$sendto.".\n";
                                    if ($message) {
                                        $actionmsg .= $langs->transnoentities('MailTopic').": ".$subject."\n";
                                        $actionmsg .= $langs->transnoentities('TextUsedInTheMessageBody').":\n";
                                        $actionmsg .= $message;
                                    }
                                    $actionmsg2 = $langs->transnoentities('Action'.$actiontypecode);
                                }

                                // Create form object
                                /* 										$formmail = new FormMail($db);

                                  $attachedfiles = $formmail->get_attached_files();
                                  $filepath = $attachedfiles['paths'];
                                  $filename = $attachedfiles['names'];
                                  $mimetype = $attachedfiles['mimes'];

                                  // Envoi de la propal
                                  $mailfile = new CMailFile($subject, $sendto, $from, $message, $filepath, $mimetype, $filename, $sendtocc, '', $deliveryreceipt);

                                 */
// 										if (!$mailfile->error)
// 											setEventMessages($langs->trans($langs->trans('MailSuccessfulySent',$mailfile->getValidAddress($from,2),$mailfile->getValidAddress($sendto,2)),$sendto,$object->name), null, 'mesgs');
// 										else
// 											setEventMessages($langs->trans('ErrorFailedToFindSocieteRecord',$sendto), null, 'errors');
                            }
                        }
                    }
                    break;
            }
        } else {


            $return = 0;

            $contexts = explode(':', $parameters['context']);
            $this->initGreffon($contexts);


            if (is_array($this->greffon['dolmessage']))
                    if (isset($this->greffon) && !empty($this->greffon)) {
                    foreach ($this->greffon['dolmessage'] as $k => $r) {

                        if (method_exists(get_class($r), 'doActions')) {
                            $res    = $r->doActions($parameters, $object, $action, $hookmanager);
                            if ($res) $return = $res;
                        }
                    }
                }
            return $return;
        }

        return 0;
    }

    /** Overloading the doActions function : replacing the parent's function with the one below
     *  @param      parameters  meta datas of the hook (context, etc...)
     *  @param      object             the object you want to process (an invoice if you are in invoice module, a propale in propale's module, etc...)
     *  @param      action             current action (if set). Generally create or edit or null
     *  @return       void
     */
    function printFieldListTitle($parameters, &$object, &$action, $hookmanager)
    {
        return $this->{'___'.__FUNCTION__}($parameters, $object, $action, $hookmanager);
    }

    /** Overloading the doActions function : replacing the parent's function with the one below
     *  @param      parameters  meta datas of the hook (context, etc...)
     *  @param      object             the object you want to process (an invoice if you are in invoice module, a propale in propale's module, etc...)
     *  @param      action             current action (if set). Generally create or edit or null
     *  @return       void
     */
    function printGreffonGED($parameters, &$object, &$action, $hookmanager)
    {
        return $this->{'_'.__FUNCTION__}($parameters, $object, $action, $hookmanager);
    }

    /** Overloading the doActions function : replacing the parent's function with the one below 
     *  @param      parameters  meta datas of the hook (context, etc...) 
     *  @param      object             the object you want to process (an invoice if you are in invoice module, a propale in propale's module, etc...) 
     *  @param      action             current action (if set). Generally create or edit or null 
     *  @return       void 
     */
    function printActionAddLinkTo($parameters, &$object, &$action, $hookmanager)
    {
        return $this->{'_'.__FUNCTION__}($parameters, $object, $action, $hookmanager);
    }

    public function printLeftBlock($parameters, &$object, &$action, $hookmanager)
    {

        $parameters['context'] .= ':dolmessage:greffon';
        return $this->{'_'.__FUNCTION__}($parameters, $object, $action, $hookmanager);
    }

    /** Overloading the doActions function : replacing the parent's function with the one below 
     *  @param      parameters  meta datas of the hook (context, etc...) 
     *  @param      object             the object you want to process (an invoice if you are in invoice module, a propale in propale's module, etc...) 
     *  @param      action             current action (if set). Generally create or edit or null 
     *  @return       void 
     */
    function addArrayFields($parameters, &$object, &$action, $hookmanager)
    {
        return $this->{'_'.__FUNCTION__}($parameters, $object, $action, $hookmanager);
    }

    /** Overloading the doActions function : replacing the parent's function with the one below 
     *  @param      parameters  meta datas of the hook (context, etc...) 
     *  @param      object             the object you want to process (an invoice if you are in invoice module, a propale in propale's module, etc...) 
     *  @param      action             current action (if set). Generally create or edit or null 
     *  @return       void 
     */
    function printFieldListValue($parameters, &$object, &$action, $hookmanager)
    {
        global $langs, $db;
// var_dump('printFieldListValue');
        $contexts = explode(':', $parameters['context']);

        if (is_array($contexts) && in_array('greffon', $contexts) && in_array('dolmessage', $contexts)) {

            $this->initGreffon($contexts);

            if (isset($this->greffon) && !empty($this->greffon)) {
                foreach ($this->greffon['dolmessage'] as $k => $r) {

                    if (method_exists(get_class($r), 'printFieldListValue')) {
                        $res = $r->printFieldListValue($parameters, $object, $action, $hookmanager);
// 			var_dump(get_class($r),$res); 

                        if ($res) {
                            $return        = 1;
                            $this->results = $r->results;
                        }
                    }
                }
            }
// 			print_r($this->results); 
// var_dump($return); 
            return $return;
        }

        return 0;
    }
// 	

    /**
      @fn  __call($name, $args)
      @brief
     */
    public function __call($name, $args)
    {

//  var_dump($name);


        if (substr($name, 0, 3) === '___') {
            $name = substr($name, 3);

// var_dump($name);
            $return   = 0;
            $contexts = explode(':', $args[0]['context']);


            $this->initGreffon($contexts);

            if (is_array($contexts) && in_array('greffon', $contexts) && in_array('dolmessage', $contexts)) {

                if (isset($this->greffon) && !empty($this->greffon)) {
                    foreach ($this->greffon['dolmessage'] as $k => $r) {
                        if (method_exists(get_class($r), $name)) {
                            $result = $r->$name($args[0], $args[1], $args[2], $args[3]);

                            foreach ($r->results as $key => $v)
                                $res[$key] = $v;
                        }
                    }
                }

// 					
                $this->resprints = '';
                foreach ($args[0]['titles'] as $k => $arr) {

                    if (isset($res[$k])) {
                        $this->resprints .= $res[$k];
                    } else $this->resprints .= $arr;
                }

                return 1;
            }

            return false;
        }
        elseif (substr($name, 1, 5) === 'print') {
            $name = substr($name, 1);
// 			var_dump(__function__, $name); 

            $return   = 0;
            $contexts = explode(':', $args[0]['context']);


            $this->initGreffon($contexts);

            if (is_array($contexts) && in_array('greffon', $contexts) && in_array('dolmessage', $contexts)) {

                if (isset($this->greffon) && !empty($this->greffon)) {
                    foreach ($this->greffon['dolmessage'] as $k => $r) {

                        if (method_exists(get_class($r), $name)) {
                            $result = $r->$name($args[0], $args[1], $args[2], $args[3]);

                            foreach ($r->results as $key => $v)
                                $this->resprints .= $v;
                        }
                    }
                }
                return 1;
            }
        } elseif (substr($name, 1, 3) === 'add') {
            $name     = substr($name, 1);
            $return   = 0;
            $contexts = explode(':', $args[0]['context']);

// print_r($args); 
// exit; 
            $this->initGreffon($contexts);

            if (is_array($contexts) && in_array('greffon', $contexts) && in_array('dolmessage', $contexts)) {

                if (isset($this->greffon) && !empty($this->greffon)) {
                    foreach ($this->greffon['dolmessage'] as $k => $r) {

                        if (method_exists(get_class($r), $name)) {
                            $result = $r->$name($args[0], $args[1], $args[2], $args[3]);


                            foreach ($r->results as $key => $v)
                                $this->results[$key] = $v;
                        }
                    }
                }


                return 1;
            }
        }

        return $return;
    }

    function addMoreActionsButtons($parameters, &$object, &$action, $hookmanager)
    {



        global $langs, $db, $conf;
        $showEmailLink = false;
        $contexts      = explode(':', $parameters['context']);
        if (
            is_array($contexts) && ( in_array('thirdpartycard', $contexts) || in_array('thirdpartycard', $contexts) ) && !empty($object->email)) { // si on a un email sur le contact
            print '<div class="inline-block divButAction"><a class="butAction" href="'.dol_buildpath('/dolmessage/compose.php?action=presend&to=',
                    2).$object->email.'">'.$langs->trans('DolMessageSendMail').'</a></div>';
        } elseif (is_array($contexts) && in_array('greffon', $contexts) && in_array('dolmessage', $contexts)) {
            $res = array();

            $this->initGreffon($contexts);

            if (is_array($this->greffon['dolmessage'])) {
                if (isset($this->greffon) && !empty($this->greffon)) {
                    foreach ($this->greffon['dolmessage'] as $k => $r) {

                        if (method_exists(get_class($r), 'addMoreActionsButtons'))
                                $r->addMoreActionsButtons($parameters, $object, $action, $hookmanager);

                        foreach ($r->results as $key => $v)
                            $res[$key] = $v;
                    }
                }
            }

            $this->resprints = '';
            foreach ($parameters['buttons'] as $k => $arr) {
                if (isset($res[$k]) && $res[$k]['return']) $this->resprints .= $res[$k]['print'];
                elseif (isset($res[$k]) && !$res[$k]['return']) $this->resprints .= $arr['print'].$res[$k]['print'];
                else $this->resprints .= $arr['print'];
            }

            return 1;
        }

        return 0;
    }

    public function updateSession($parameters, &$object, &$action, $hookmanager)
    {

        $contexts[] = 'dolmessage';
        $contexts[] = 'greffon';

        $this->initGreffon($contexts);


        $name = 'updateSession';
        if (is_array($contexts) && in_array('greffon', $contexts) && in_array('dolmessage', $contexts)) {
            if (isset($this->greffon) && !empty($this->greffon)) {
                foreach ($this->greffon['dolmessage'] as $k => $r) {
                    if (method_exists(get_class($r), $name)) {
                        $result = $r->$name($parameters, $object, $action, $hookmanager);
                    }
                }
            }
            return 1;
        }
    }

    /**
     * \brief       brief
     * \details     details
     * \param       string  param         desc
     * \return      bool  true si vrai
     */
    function emailElementlist($parameters, &$object, &$action, $hookmanager)
    {
        global $langs;
        $langs->load('dolmessage@dolmessage');
        if (isset($parameters['elementList'])) {
            $this->results   = array("dolmessage" => $langs->trans('forSendMailWithDolmessage'));
            $this->resprints = 0;
        }
    }
}