<?php
/* Copyright (C) 2014 Oscim 	<support@oscim.fr>
 * Copyright (C) 2015 Oscss-Shop Team <support@oscss-shop.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */


dol_include_once('/dolmessage/class/user.mailconfig.class.php');
dol_include_once('/dolmessage/class/usergroup.mailconfig.class.php');

dol_include_once('/dolmessage/class/dolmessage.class.php');
dol_include_once('/dolmessage/class/dmessage.class.php');

dol_include_once('/dolmessage/class/connector/dolmessfields.class.php');
dol_include_once('/dolmessage/class/connector/dolimapmessage.class.php');

// dol_include_once('/dolmessage/class/connector/structuremessage.listener.php');


dol_include_once('/dolmessage/class/mimeparser-2014-04-30/rfc822_addresses.php');
dol_include_once('/dolmessage/class/mimeparser-2014-04-30/mime_parser.php');

// class for cache
dol_include_once('/dolmessage/class/cronDolmessage.class.php');

// lib for decode
dol_include_once('/dolmessage/core/lib/message.lib.php');

class dolimap Extends DolMessFields
{
    /**
      @var object
     */
    public $db;

    /**
      @var object
     */
    public $user;

    /**
      @var object
     */
    public $group;

    /**
      @var object
     */
    public $mbox;

    /**
      @var object
     */
    public $check;

    /**
      @var list error
     */
    public $listerror = array();

    /**
     */
    public function __construct($db, $user)
    {
        global $conf;

        $this->db   = $db;
        $this->user = $user;


        imap_timeout(IMAP_OPENTIMEOUT, (!empty($conf->global->TIMEOUTNEGO) ?: 1));
        imap_timeout(IMAP_READTIMEOUT, (!empty($conf->global->TIMEOUTREAD) ?: 5));
        imap_timeout(IMAP_WRITETIMEOUT, (!empty($conf->global->TIMEOUTNEGO) ?: 1));
        imap_timeout(IMAP_CLOSETIMEOUT, (!empty($conf->global->TIMEOUTNEGO) ?: 1));
    }

    /**
      @brief Open Connection
      @param string
     */
    public function Open($folder = '')
    {
        $this->mbox = @imap_open($this->user->imap_connector_url.$this->CleanFolder($folder), $this->user->imap_login,
                $this->user->imap_password);
        if ($this->mbox === false) {
            $this->mbox = @imap_open($this->user->imap_connector_url, $this->user->imap_login,
                    $this->user->imap_password);
            if ($this->mbox === false) {
                $exception = "Impossible to connect to {$this->user->imap_connector_url} \n<br>"
                    ."Folder ".$this->CleanFolder($folder)."\n<br>"
                    ."User ".$this->user->imap_login."\n<br>"
                    ."Password with ".strlen($this->user->imap_password)." caracters\n<br>";

                $this->mbox = imap_open('{'.$this->user->imap_host.':'.$this->user->imap_port.'/pop3/ssl/novalidate-cert}',
                    $this->user->imap_login, $this->user->imap_password);
                if ($this->mbox !== false) {
                    $exception .= "This server was a POP3 server, please enable IMAP";
                }
                throw new Exception($exception);
            } else {
                $exception = "Folder ".$this->CleanFolder($folder)." does not exist, please create folder";
                throw new Exception($exception);
            }
        }
    }

    public function Send($sendto, $subject, $final, $sendtocc)
    {
        $this->Open();

        return imap_mail($sendto, $subject, $final, /* string $additional_headers = */ NULL,
            $sendtocc/* , string $bcc = NULL [, string $rpath = NULL ]]]] */);
    }

    /**
      @brief Clean param folder
      @param $folder
     */
    public function CleanFolder($folder = '')
    {
        return str_replace('{'.$this->user->imap_host.'}', '', $folder);
    }

    /**
      @brief Vérifie la boîte aux lettres courante
      @return object check ;
      object(stdClass)(5) {
      ["Date"]=>
      string(37) "Wed, 10 Dec 2003 17:56:54 +0100 (CET)"
      ["Driver"]=>
      string(4) "imap"
      ["Mailbox"]=>
      string(54)
      "{www.example.com:143/imap/user="foo@example.com"}INBOX"
      ["Nmsgs"]=>
      int(1)
      ["Recent"]=>
      int(0)
      }
     */
    public function Check()
    {
        if ($this->mbox) {
            $this->check = imap_check($this->mbox);
            return $this->check;
        } else {
            return false;
        }
    }

    /**
      @brief  Lit la liste des boîtes (dir) aux lettres
      @return list mails array ;
     */
    public function ListFolder($search = '*')
    {

        $myMenuList = imap_getmailboxes($this->mbox, $this->user->imap_ref, $search.'*');

        foreach ($myMenuList as $key => $val) {
            $myMenuList[$key]->name = mb_convert_encoding($val->name, 'UTF-8', "UTF7-IMAP");
        }

        return $myMenuList;
    }

    /**
      @brief search in current my box
     */
    public function CountMessage($flag)
    {

        $count = (int) @imap_num_msg($this->mbox);

        for ($msgno = 1; $msgno <= $count; $msgno++) {
            $headers = imap_headerinfo($this->mbox, $msgno);
            if ($headers->Unseen == 'U') {
                
            }
        }
    }

    /**
      @brief search in current my box
     */
    public function SearchMessage($flag)
    {

        $count = (int) @imap_num_msg($this->mbox);

        for ($msgno = 1; $msgno <= $count; $msgno++) {

            $headers = imap_headerinfo($this->mbox, $msgno);
            if ($headers->Unseen == 'U') {
                
            }
        }
    }

    public function search($string)
    {

        $args = explode(' ', $string);

        $from         = $to           = $subject      = $body         = '';
        $modeAdvanced = false;
        foreach ($args as $arg) {
            $arg   = $this->wd_remove_accents($arg); // yes it works !!!
            $count = 0;
            $tmp   = preg_replace('/^from:(.*)/i', 'FROM "$1"', addslashes($arg), -1, $count);
            if ($count) {
                $from         = $tmp;
                $modeAdvanced = true;
            }
            $count = 0;
            $tmp   = preg_replace('/^to:(.*)/i', 'TO "$1"', addslashes($arg), -1, $count);
            if ($count) {
                $to           = $tmp;
                $modeAdvanced = true;
            }
            $count = 0;
            $tmp   = preg_replace('/^subject:(.*)/i', 'SUBJECT "$1"', addslashes($arg), -1, $count);
            if ($count) {
                $subject      = $tmp;
                $modeAdvanced = true;
            }
            $count = 0;
            $tmp   = preg_replace('/^body:(.*)/i', 'BODY "$1"', addslashes($arg), -1, $count);
            if ($count) {
                $body         = $tmp;
                $modeAdvanced = true;
            }
            $count = 0;
            $tmp   = preg_replace('/^UNSEEN/', 'UNSEEN', addslashes($arg), -1, $count);
            if ($count) {
                $unseen         = $tmp;
                $modeAdvanced = true;
            }
            $count = 0;
            $tmp   = preg_replace('/^NEW/', 'NEW', addslashes($arg), -1, $count);
            if ($count) {
                $new          = $tmp;
                $modeAdvanced = true;
            }
        }

        if ($modeAdvanced) {
            $st = trim("$from $to $subject $body $unseen $new");
        } else {
            $st = 'TEXT "'.$this->wd_remove_accents($string).'"';
        }
        return imap_search($this->mbox, $st, SE_FREE, "UTF-8");
    }

    private function wd_remove_accents($str, $charset = 'utf-8')
    {
        $str = htmlentities($str, ENT_NOQUOTES, $charset);
        $str = preg_replace('#&([A-za-z])(?:acute|cedil|caron|circ|grave|orn|ring|slash|th|tilde|uml);#', '\1', $str);
        $str = preg_replace('#&([A-za-z]{2})(?:lig);#', '\1', $str); // pour les ligatures e.g. '&oelig;'
        $str = preg_replace('#&[^;]+;#', '', $str); // supprime les autres caractères
        return $str;
    }

    /**
      @brief all list of message in current dir
      @param $page int current page
      @param $pagination int result by page
     */
    public function ListMessage($page, $pagination = 50, $group_id = 0, $options = 0)
    {
        global $user;
        $indice_msgend   = $this->check->Nmsgs - ($pagination * ($page - 1) );
        $indice_msgbegin = max(1, $indice_msgend - $pagination + 1);
        if ($options != 0 && is_array($options)) {
//         print_r($options); 
            $indice_msgend   = count($options) - ($pagination * ($page - 1) );
            $indice_msgbegin = max(1, $indice_msgend - $pagination + 1) - 1;

            $lists = implode(',', array_slice($options, $indice_msgbegin, $indice_msgend));
//         var_dump($indice_msgend,$indice_msgbegin, $lists);
            $check = imap_check($this->mbox);
            if ($check->Nmsgs != 0) {
                $mails = array_reverse(imap_fetch_overview($this->mbox, $lists, 0));
            } else {
                $mails = array();
            }
        } elseif ($this->check->Nmsgs > 0 && ($indice_msgbegin > 0 || $indice_msgend > 0 )) {
            $check = imap_check($this->mbox);
            if ($check->Nmsgs > 0 && ($indice_msgbegin > 0 || $indice_msgend > 0 )) {
                // FIX : PHP Notice:  Unknown: Sequence out of range    Generated by imap_fetch_overview
                $indice_msgend   = min($indice_msgend, $check->Nmsgs);
                $indice_msgbegin = min($indice_msgbegin, $check->Nmsgs);
                $mails           = array_reverse(imap_fetch_overview($this->mbox, $indice_msgbegin.':'.$indice_msgend, 0));
            } else {
                $mails = array();
            }
        }


        $return = array();
        if (is_array($mails) && count($mails) > 0) {
            foreach ($mails as $i => $mail) {
                $dolmess = new dolmessage($this->db, $user);

                if ($group_id > 0 && $dolmess->fetch(0, $mail->message_id, false, $this->user->number, $group_id) == false) {
                    $dolmess->specimen();
                    $dolmess->uid = $mails[$i]->uid;
                } elseif ($group_id == 0 && $dolmess->fetch(0, $mail->message_id, false, $this->user->number) == false) {
                    $dolmess->specimen();
                    $dolmess->uid = $mails[$i]->uid;
                }

                $mails[$i]->id            = $dolmess->id;
                $mails[$i]->uid           = $dolmess->uid;
                $mails[$i]->linkedObjects = $dolmess->linkedObjects;

                if (class_exists('cronDolmessage')) {
                    $cd                          = new cronDolmessage($this->db);
                    $mailboxType                 = ($group_id == 0) ? 'user' : 'usergroup';
                    $folder                      = GETPOST('folder');
                    $cacheMsg                    = $cd->loadCacheMsg($this, $mailboxType, $folder, $dolmess->uid);
                    $mails[$i]->cacheattachments = $cacheMsg->attachments;
                }
//             print_r( $mails[$i]);
//             $return[$i] = new StructureMessageListener($mails[$i]);
                $return[$i] = new dolimapmessage($mails[$i]);
            }
        }

        return $return;
    }

    /**
      @brief Get obect Imap Connection opened
      @return $this->mbox;
     */
    public function GetImap()
    {
        return $this->mbox;
    }

    /**
      @brief Close Connection
     */
    public function Close()
    {
        @imap_close($this->mbox);
    }

    /**
      @brief List of errors
     */
    public function ListErrors()
    {
        foreach (imap_errors() as $row)
            $this->listerror[] = $row;

        return $this->listerror;
    }

    /**
      @brief
      @param uid int uid repsonse in imap protocol
     */
    public function GetMessage($uid)
    {

        $headerText = imap_fetchHeader($this->mbox, $uid, FT_UID);
        $header     = imap_rfc822_parse_headers($headerText);

        $message = $this->getmsg($uid);
        $message->SetHeader($header);
        $message->SetAttach($this->getAttachments($uid));

        return $message;
    }    
    
    /**
      @brief
      @param uid int uid repsonse in imap protocol
     */
    public function DownloadMessage($uid)
    {
        $headers = imap_fetchheader($this->mbox, $uid, FT_PREFETCHTEXT && FT_UID);
        $body = imap_body($this->mbox, $uid,FT_UID);
        return $headers . "\n" . $body ;
    }

    /**
      @brief load data user
      @param $id int user id
      @param $number int indice of config for this user
      @return $user
     */
    public function SetUser($id, $number = 1)
    {
        if ($number <= 0) $number = 1;

        $mailboxconfig = new Usermailconfig($this->db);
        $mailboxconfig->fetch_from_user($id, $number);

        $this->user->number                   = $number;
        $this->user->imap_login               = $mailboxconfig->imap_login;
        $this->user->imap_password            = $mailboxconfig->imap_password;
        $this->user->imap_host                = $mailboxconfig->imap_host;
        $this->user->imap_port                = $mailboxconfig->imap_port;
        $this->user->imap_ssl                 = $mailboxconfig->imap_ssl;
        $this->user->imap_ssl_novalidate_cert = $mailboxconfig->imap_ssl_novalidate_cert;
        $this->user->imap_ref                 = $mailboxconfig->get_ref();
        $this->user->imap_connector_url       = $mailboxconfig->get_connector_url();

        return $this->user;
    }

    /**
      @brief load data user
      @param $id int user id
      @param $number int indice of config for this user
      @return $user
     */
    public function SetUserGroup($id, $number = 1)
    {
        if ($number <= 0) $number = 1;

        $mailboxconfig = new UserGroupmailconfig($this->db);
        $mailboxconfig->fetch_from_usergroup($id, $number);

        $this->user->number                   = $number;
        $this->user->group                    = 1;
        $this->user->imap_login               = $mailboxconfig->imap_login;
        $this->user->imap_password            = $mailboxconfig->imap_password;
        $this->user->imap_host                = $mailboxconfig->imap_host;
        $this->user->imap_port                = $mailboxconfig->imap_port;
        $this->user->imap_ssl                 = $mailboxconfig->imap_ssl;
        $this->user->imap_ssl_novalidate_cert = $mailboxconfig->imap_ssl_novalidate_cert;
        $this->user->imap_ref                 = $mailboxconfig->get_ref();
        $this->user->imap_connector_url       = $mailboxconfig->get_connector_url();

        return $this->user;
    }

    /**
      @brief return data user
      @return $user
     */
    public function GetUser()
    {
        return $this->user;
    }

    public function Delete($uid)
    {
        $delete = imap_delete($this->mbox, $uid, FT_UID);
        return imap_expunge($this->mbox);
    }

    /**
     * Récupère les pièces d'un mail donné
     * @param integer $jk numéro du mail
     * @return array type, filename, pos
     */
    public function getAttachments($uid)
    {
        $structure = imap_fetchstructure($this->mbox, $uid, FT_UID);

        $parts       = $this->getParts($structure);
        $fpos        = 2;
        $attachments = array();

        if ($parts && count($parts)) {
            //var_dump($parts);
            for ($i = 1; $i <= count($parts); $i++) {
                $part = $parts[$i];
                if ($part->ifdisposition && (strtolower($part->disposition) == "attachment" || strtolower($part->disposition)
                    == "inline" ) ) {
                    $ext = $part->subtype;

                    $filename               = ($part->dparameters[0]->value) ? $part->dparameters[0]->value : $part->parameters[0]->value;
                    $filename               = imap_utf8($filename);
//                    $attachments[$part->id] = new dattachment($part->type, $filename, $part->encoding,
//                        $this->getAttachment($uid, $fpos, $part->type));
                    $attachments[$i] = new dattachment($part->type, $filename, $part->encoding,
                        $this->getAttachment($uid, $fpos, $part->type));
                }
                $fpos++;
            }
        }
        return $attachments;
    }

    /**
     * Récupère la contenu de la pièce jointe par rapport a sa position dans un mail donné
     * @param integer $jk numéro du mail
     * @param integer $fpos position de la pièce jointe
     * @param integer $type type de la pièce jointe
     * @return mixed data
     */
    public function getAttachment($jk, $fpos, $type)
    {
        $mege = imap_fetchbody($this->mbox, $jk, $fpos, FT_UID);

        $data = $this->getDecodeValue($mege, $type);

        return $data;
    }

    /**
     * Récupère les parties d'un message
     * @param object $structure structure du message
     * @return object|boolean parties du message|false en cas d'erreur
     */
    public function getParts($structure)
    {
        return isset($structure->parts) ? $structure->parts : false;
    }

    /**
     * Décode le contenu du message
     * @param string $message message
     * @param integer $coding type de contenu
     * @return message décodé
     * */
    private function getDecodeValue($message, $coding)
    {
        switch ($coding) {
            case 0: //text
            case 1: //multipart
                $message = imap_8bit($message);
                break;
            case 2: //message
                $message = imap_binary($message);
                break;
            case 3: //application
            case 5: //image
            case 6: //video
            case 7: //other
                $message = imap_base64($message);
                break;
            case 4: //audio
                $message = imap_qprint($message);
                break;
        }

        return $message;
    }
    // private

    /**
     */
    private function getmsg($uid)
    {
        $htmlmsg     = '';
        $plainmsg    = '';
        $charset     = '';
        $attachments = array();

        // add code here to get date, from, to, cc, subject...
        // BODY
        $s = imap_fetchstructure($this->mbox, $uid, FT_UID);

        if (!$s->parts)  // simple
                list($charset, $htmlmsg, $plainmsg, $attachments) = $this->getpart($uid, $s, 0, $charset, $htmlmsg,
                $plainmsg, $attachments);
        else {  // multipart: cycle through each part
            foreach ($s->parts as $partno0 => $p) {
                list($charset, $htmlmsg, $plainmsg, $attachments) = $this->getpart($uid, $p, $partno0 + 1, $charset,
                    $htmlmsg, $plainmsg, $attachments);
            }
        }

        $tmp = new dolimapmessage(new stdclass); //$uid, $charset, $htmlmsg, $plainmsg, $attachments);

        $tmp->SetUid($uid);
        $tmp->SetAttach($attachments);
        $tmp->SetCharset($charset);
        $tmp->SetContent($htmlmsg, ReplaceImap($plainmsg));
        return $tmp;
    }

    /**
     */
    function getpart($mid, $p, $partno, $charset, $htmlmsg, $plainmsg, $attachments)
    {


        $data = ($partno) ?
            imap_fetchbody($this->mbox, $mid, $partno, FT_UID) : // multipart
            imap_body($this->mbox, $mid, FT_UID);  // simple

        $data = $this->getDecodeValue($data, $p->encoding);

        // PARAMETERS
        // get all parameters, like charset, filenames of attachments, etc.
        $params                            = array();
        if ($p->parameters)
                foreach ($p->parameters as $x)
                $params[strtolower($x->attribute)] = $x->value;
        if ($p->dparameters)
                foreach ($p->dparameters as $x)
                $params[strtolower($x->attribute)] = $x->value;


        // ATTACHMENT
        // Any part with a filename is an attachment,
        // so an attached text file (type 0) is not mistaken as the message.
        if ($params['filename'] || $params['name']) {
            // filename may be given as 'Filename' or 'Name' or both
            $filename                      = ($params['filename']) ? $params['filename'] : $params['name'];
            // filename may be encoded, so see imap_mime_header_decode()
            $attachments['file'.$filename] = $data;  // this is a problem if two files have same name
        }

        // TEXT
        if ($p->type == 0 && $data) {

            // Messages may be split in different parts because of inline attachments,
            // so append parts together with blank row.
            if (strtolower($p->subtype) == 'plain') $plainmsg .= trim($data);
            else $htmlmsg  .= $data;
            $charset  = (!isset($params['charset']) ? 'ISO-8859-1' : $params['charset']);  // assume all parts are same charset
        }
        // EMBEDDED MESSAGE
        // Many bounce notifications embed the original message as type 2,
        // but AOL uses type 1 (multipart), which is not handled here.
        // There are no PHP functions to parse embedded messages,
        // so this just appends the raw source to the main message.
        elseif ($p->type == 2 && $data) {
            $plainmsg .= $data;
        }

        // SUBPART RECURSION
        if ($p->parts) {
            foreach ($p->parts as $partno0 => $p2) {
                list($charset, $htmlmsg, $plainmsg, $attachments) = $this->getpart($mid, $p2,
                    $partno.'.'.($partno0 + 1), $charset, $htmlmsg, $plainmsg, $attachments);
            }
        }

        return array($charset, $htmlmsg, $plainmsg, $attachments);
    }
}