<?php
/* Copyright (C) 2014 Oscim 	<support@oscim.fr>
 * Copyright (C) 2015 Oscss-Shop Team <support@oscss-shop.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *   	\file       dev/skeletons/skeleton_page.php
 * 		\ingroup    mymodule othermodule1 othermodule2
 * 		\brief      This file is an example of a php page
 * 					Put here some comments
 */
// Change this following line to use the correct relative path (../, ../../, etc)
$res = false;
if (!$res && file_exists("../main.inc.php")) $res = @include("../main.inc.php");
if (!$res && file_exists("../../main.inc.php")) $res = @include("../../main.inc.php");
if (!$res && file_exists("../../../main.inc.php")) $res = @include("../../../main.inc.php");
if (!$res && file_exists("../../../../main.inc.php")) $res = @include("../../../../main.inc.php");
if (!$res && file_exists("../../../dolibarr/htdocs/main.inc.php"))
        $res = @include("../../../dolibarr/htdocs/main.inc.php");     // Used on dev env only
if (!$res && file_exists("../../../../dolibarr/htdocs/main.inc.php"))
        $res = @include("../../../../dolibarr/htdocs/main.inc.php");   // Used on dev env only
if (!$res && file_exists("../../../../../dolibarr/htdocs/main.inc.php"))
        $res = @include("../../../../../dolibarr/htdocs/main.inc.php");   // Used on dev env only
if (!$res) die("Include of main fails");



dol_include_once('/dolmessage/class/connector/dolimap.class.php');
dol_include_once('dolmessage/class/connector/dollocalmessage.class.php');
dol_include_once('/dolmessage/class/user.mailconfig.class.php');
dol_include_once('/dolmessage/core/lib/message.lib.php');





$langs->load("companies");
$langs->load("other");
$langs->load("dolmessage@dolmessage");

// Get parameters
$num_page   = GETPOST('num_page');
if (empty($num_page)) $num_page   = 1;
$id         = GETPOST('id', 'int');
$uid        = GETPOST('uid', 'int');
$action     = GETPOST('action', 'alpha');
$folder     = urldecode(GETPOST('folder', 'alpha'));
$number     = GETPOST('number', 'int');
$identifiid = GETPOST('identifiid', 'alpha');



// Protection if external user
if ($user->societe_id > 0) {
    //accessforbidden();
}

$dolimap = new dolimap($db, $user);
if (empty($identifiid)) $dolimap->SetUser($user->id, $number);
elseif (!empty($identifiid)) $dolimap->SetUserGroup($identifiid, $number);




/* * *************************************************
 * VIEW
 *
 * Put here all code to build page
 * ************************************************** */
// top_httphead();

switch ($action) {
    case 'imap':
        try {

            $dolimap->Open($folder);
            $mbox = $dolimap->GetImap();

            if (FALSE === $mbox) {
                foreach ($dolimap->ListErrors() as $row)
                    $err .= $row;
            } else {

                $Message = LoadMessage($id, $uid, $dolimap);
//            $Message = $dolimap->GetMessage(GETPOST('uid', 'int'));
            }
            dol_include_once('/dolmessage/tpl/info.message.tpl');
        } catch (Exception $ex) {
            echo $ex->getMessage();
            echo '<br><br><a href="javascript:history.go(0);">Your IMAP serveur does not answer, click here to refresh</a>';
        }
        exit;
        break;

    case 'imapdownload':
        try {

            $dolimap->Open($folder);
            $mbox = $dolimap->GetImap();

            if (FALSE === $mbox) {
                foreach ($dolimap->ListErrors() as $row)
                    $err .= $row;
            } else {
                $Message = $dolimap->DownloadMessage($uid);
                header("Pragma: public");
                header("Expires: 0");
                header('Content-Encoding: UTF-8');
                header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
                header("Content-type: application/vnd.ms-outlook;charset=UTF-8");
                header("Content-Type: application/force-download");
                header("Content-Type: application/octet-stream");
                header("Content-Type: application/download");
                header("Content-Disposition: attachment;filename=Mail$uid.eml");
                header("Content-Transfer-Encoding: binary ");
                echo $Message;
            }
        } catch (Exception $ex) {
            echo $ex->getMessage();
            echo '<br><br><a href="javascript:history.go(0);">Your IMAP serveur does not answer, click here to refresh</a>';
        }
        exit;
        break;

    case 'local':

        $id = GETPOST('id', 'int');


        $DolMsg = new dolmessage($db, $user);
        $DolMsg->fetch($id, '', true, $identifiid);

        $uid = $DolMsg->uid;

        $DolMsg->fetchObjectLinked($DolMsg->id, $DolMsg->element, $DolMsg->id, $DolMsg->element, 'OR');

        foreach ($DolMsg->linkedObjects as $type => $list) {
            foreach ($list as $obj) {
                if ($type == 'societe') {

                    $societe = $obj;

                    $upload_dir = $conf->societe->multidir_output[$societe->entity]."/".$societe->id;

                    if (!file_exists($upload_dir)) dol_mkdir($upload_dir);

                    $upload_dir .= '/message/';
                    if (!file_exists($upload_dir)) dol_mkdir($upload_dir);
                }
            }
        }

        $DolLocal = new dollocalmessage($uid);
        $DolLocal->LoadLocal($upload_dir, $DolMsg->message_id);


        $Message = $DolLocal;
        $Message->SetId($DolMsg->id);

        dol_include_once('/dolmessage/tpl/info.message.tpl');

        exit;
        break;


    case 'attachment':

        if ($user->societe_id > 0) {
            //accessforbidden();
        }

        // if local message
        if ($id > 0) {
            $DolMsg = new dolmessage($db);
            $DolMsg->fetch($id);

            $uid = $DolMsg->uid;

            $DolMsg->fetchObjectLinked($DolMsg->id, $DolMsg->element, $DolMsg->id, $DolMsg->element, 'OR');

            foreach ($DolMsg->linkedObjects as $type => $list) {
                foreach ($list as $obj) {
                    if ($type == 'societe') {
                        $societe    = $obj;
                        $upload_dir = $conf->societe->multidir_output[$societe->entity]."/".$societe->id;

                        if (!file_exists($upload_dir)) dol_mkdir($upload_dir);


                        $upload_dir .= '/message/';

                        if (!file_exists($upload_dir)) dol_mkdir($upload_dir);
                    }
                }
            }


            $DolLocal = new dollocalmessage($uid);
            $DolLocal->LoadLocal($upload_dir, $DolMsg->message_id);

            $Message = $DolLocal;
        }
        else {
            $dolimap->Open($folder);
            $mbox = $dolimap->GetImap();

            if (FALSE === $mbox) {
                foreach ($dolimap->ListErrors() as $row)
                    $err .= $row;
            } else {
                $Message = $dolimap->GetMessage($uid);
            }
        }

        $i = 0;
        foreach ($Message->GetAttach() as $att_name => $obj) {

            if ($i == GETPOST('attach', 'int')) {

                $tabfile   = explode('.', $obj->name);
                $extension = $tabfile[sizeof($tabfile) - 1];


                switch ($obj->GetApplicationType()) {
                    case '2': // .eml ????

                        echo base64_decode($obj->GetData());
                        break;
                    case 'jpg':
                    case 'png':
                    case 'gif':
                        header('Content-type: image/'.$extension);
                        echo $obj->GetData();
                        break;
                    case 3:
                    case 'pdf':
                        header('Content-Type: application/pdf');
                        header('Content-Disposition: attachment; filename="'.$obj->name.'"');
                        header('Cache-Control: private, max-age=0, must-revalidate');
                        header('Pragma: public');
// 								ini_set('zlib.output_compression','0');

                        echo $obj->GetData();
                        //echo substr($obj->GetData(), 0, 1000);
                        break;
                    default:
                        header('Content-Type: application/txt');
                        header('Content-Disposition: inline; filename="'.$obj->name.'"');
                        header('Cache-Control: private, max-age=0, must-revalidate');
                        header('Pragma: public');
                        echo $obj->GetData();
                }
            }

            $i++;
        }
        exit;
        break;



    case 'attachlink':
        if (!empty($_GET['reference_'.$_GET['num_ligne']])) {

            $socid      = GETPOST('socid', 'int');
            $return_arr = array();

            $reference = $_GET['reference_'.$_GET['num_ligne']] ? $_GET['reference_'.$_GET['num_ligne']] : '';
            // Recherche parmis les societes
            $sql       = "SELECT s.rowid as rowid, CONCAT_WS(' - ', s.code_client, s.code_fournisseur) as reference, s.nom as nom_societe, 'societe' as type_element, s.rowid as fk_socid";
            $sql       .= " FROM ".MAIN_DB_PREFIX."societe as s";
            $sql       .= " WHERE 1 ";
            if ($socid > 0) $sql       .= " AND s.rowid = '".$socid."' ";
            else
                    $sql       .= " AND (s.code_client LIKE '%".$db->escape($reference)."%' OR s.nom LIKE '%".$db->escape($reference)."%' OR s.code_fournisseur LIKE '%".$db->escape($reference)."%' OR s.email LIKE '%".$db->escape($reference)."%'  ) ";
            $sql       .= " UNION ";
            $sql       .= "SELECT p.rowid as rowid, p.name as reference, s.nom as nom_societe, 'contact' as type_element, s.rowid as fk_socid";
            $sql       .= " FROM ".MAIN_DB_PREFIX."socpeople as p";
            $sql       .= " LEFT JOIN ".MAIN_DB_PREFIX."societe as s ON s.rowid=p.fk_soc";
            $sql       .= " WHERE ";
            $sql       .= " (p.email LIKE '%".$db->escape($reference)."%' OR p.name LIKE '%".$db->escape($reference)."%' )";
            // Recherche parmis les projets
            $sql       .= " UNION ";
            $sql       .= "SELECT p.rowid as rowid, CONCAT_WS(' - ', p.ref, p.title) as reference, s.nom as nom_societe, 'projet' as type_element, s.rowid as fk_socid";
            $sql       .= " FROM ".MAIN_DB_PREFIX."projet as p";
            $sql       .= " LEFT JOIN ".MAIN_DB_PREFIX."societe as s ON s.rowid=p.fk_soc";
            if ($socid > 0) $sql       .= " AND s.rowid = '".$socid."' ";
            $sql       .= " WHERE ";
            $sql       .= " (p.ref LIKE '%".$db->escape($reference)."%' OR p.title LIKE '%".$db->escape($reference)."%')";
            $sql       .= " UNION ";
            // Recherche parmis les propales clients
            $sql       .= "SELECT p.rowid as rowid, CONCAT_WS(' - ', p.ref, p.ref_client) as reference, s.nom as nom_societe, 'propal' as type_element, s.rowid as fk_socid";
            $sql       .= " FROM ".MAIN_DB_PREFIX."propal as p";
            $sql       .= " LEFT JOIN ".MAIN_DB_PREFIX."societe as s ON s.rowid=p.fk_soc";
            if ($socid > 0) $sql       .= " AND s.rowid = '".$socid."' ";
            $sql       .= " WHERE ";
            $sql       .= " (p.ref LIKE '%".$db->escape($reference)."%' OR p.ref_client LIKE '%".$db->escape($reference)."%')";
            $sql       .= " UNION ";
            // Recherche parmis les commandes clients
            $sql       .= "SELECT c.rowid as rowid, CONCAT_WS(' - ', c.ref, c.ref_client) as reference, s.nom as nom_societe, 'order' as type_element, s.rowid as fk_socid";
            $sql       .= " FROM ".MAIN_DB_PREFIX."commande as c";
            $sql       .= " LEFT JOIN ".MAIN_DB_PREFIX."societe as s ON s.rowid=c.fk_soc";
            if ($socid > 0) $sql       .= " AND s.rowid = '".$socid."' ";
            $sql       .= " WHERE ";
            $sql       .= " (c.ref LIKE '%".$db->escape($reference)."%' OR c.ref_client LIKE '%".$db->escape($reference)."%')";
            $sql       .= " UNION ";
            // Recherche parmis les factures clients
            $sql       .= "SELECT f.rowid as rowid, CONCAT_WS(' - ', f.facnumber, f.ref_client) as reference, s.nom as nom_societe, 'invoice' as type_element, s.rowid as fk_socid";
            $sql       .= " FROM ".MAIN_DB_PREFIX."facture as f";
            $sql       .= " LEFT JOIN ".MAIN_DB_PREFIX."societe as s ON s.rowid=f.fk_soc";
            if ($socid > 0) $sql       .= " AND s.rowid = '".$socid."' ";
            $sql       .= " WHERE ";
            $sql       .= " (f.facnumber LIKE '%".$db->escape($reference)."%' OR f.ref_client LIKE '%".$db->escape($reference)."%')";
            $sql       .= " UNION ";
            // Recherche parmis les commandes fournisseurs
            $sql       .= "SELECT c.rowid as rowid, CONCAT_WS(' - ', c.ref, c.ref_supplier) as reference, s.nom as nom_societe, 'order_supplier' as type_element, s.rowid as fk_socid";
            $sql       .= " FROM ".MAIN_DB_PREFIX."commande_fournisseur as c";
            $sql       .= " LEFT JOIN ".MAIN_DB_PREFIX."societe as s ON s.rowid=c.fk_soc";
            if ($socid > 0) $sql       .= " AND s.rowid = '".$socid."' ";
            $sql       .= " WHERE ";
            $sql       .= " (c.ref LIKE '%".$db->escape($reference)."%' OR c.ref_supplier LIKE '%".$db->escape($reference)."%')";
            $sql       .= " UNION ";
            // Recherche parmis les factures fournisseurs
            $sql       .= "SELECT f.rowid as rowid, f.facnumber as reference, s.nom as nom_societe, 'invoice_supplier' as type_element, s.rowid as fk_socid";
            $sql       .= " FROM ".MAIN_DB_PREFIX."facture_fourn as f";
            $sql       .= " LEFT JOIN ".MAIN_DB_PREFIX."societe as s ON s.rowid=f.fk_soc";
            if ($socid > 0) $sql       .= " AND s.rowid = '".$socid."' ";
            $sql       .= " WHERE ";
            $sql       .= " (f.facnumber LIKE '%".$db->escape($reference)."%')";

            $sql .= $db->plimit(50); // Avoid pb with bad criteria

            $resql = $db->query($sql);

            if ($resql) {
                while ($row = $db->fetch_array($resql)) {
// 							print_r($row);
                    if (!empty($row['fk_socid'])) {
                        $row_array['label']                                      = $row['type_element'].' '.$row['reference'].' : '.$row['nom_societe'];
                        $row_array['value']                                      = (!empty($row['reference']) ? $row['reference']
                                : $row['nom_societe'] );
                        $row_array['reference_rowid_'.$_GET['num_ligne']]        = $row['rowid'];
                        $row_array['reference_type_element_'.$_GET['num_ligne']] = $row['type_element'];
                        $row_array['reference_fk_socid_'.$_GET['num_ligne']]     = $row['fk_socid'];

                        array_push($return_arr, $row_array);
                    } else {
                        $row_array['label']                                      = $row['type_element'].' '.$row['reference'].' : '.$row['nom_societe'];
                        $row_array['value']                                      = (!empty($row['reference']) ? $row['reference']
                                : $row['nom_societe'] );
                        $row_array['reference_rowid_'.$_GET['num_ligne']]        = $row['rowid'];
                        $row_array['reference_type_element_'.$_GET['num_ligne']] = $row['type_element'];
                        $row_array['reference_fk_socid_'.$_GET['num_ligne']]     = $row['fk_socid'];

                        array_push($return_arr, $row_array);
                    }
                }
            }

            header('Content-Type: application/json');
            echo json_encode($return_arr);
        }

        break;


    case 'ownerlink':

        if (!empty($_GET['reference_'.$_GET['num_ligne']])) {
            $return_arr = array();

            $reference = $_GET['reference_'.$_GET['num_ligne']] ? $_GET['reference_'.$_GET['num_ligne']] : '';
            // Recherche parmis les societes
            $sql       = "SELECT s.rowid as rowid, CONCAT_WS(' - ', s.code_client, s.code_fournisseur) as reference, s.nom as nom_societe, 'societe' as type_element, s.rowid as fk_socid";
            $sql       .= " FROM ".MAIN_DB_PREFIX."societe as s";
            $sql       .= " WHERE ";
            $sql       .= " (s.code_client LIKE '%".$db->escape($reference)."%' OR s.nom LIKE '%".$db->escape($reference)."%' OR s.code_fournisseur LIKE '%".$db->escape($reference)."%' OR s.email LIKE '%".$db->escape($reference)."%'  )";
            $sql       .= " UNION ";
            $sql       .= "SELECT p.rowid as rowid, p.firstname as reference, s.nom as nom_societe, 'contact' as type_element, s.rowid as fk_socid";
            $sql       .= " FROM ".MAIN_DB_PREFIX."socpeople as p";
            $sql       .= " LEFT JOIN ".MAIN_DB_PREFIX."societe as s ON s.rowid=p.fk_soc";
            $sql       .= " WHERE ";
            $sql       .= " (p.email LIKE '%".$db->escape($reference)."%' OR p.firstname LIKE '%".$db->escape($reference)."%' )";

            if ($conf->global->MAIN_MODULE_PROJET == 1) {
                $sql .= " UNION ";
                $sql .= "SELECT pr.rowid as rowid, pr.ref as reference, pr.title as nom_societe, 'projet' as type_element, s.rowid as fk_socid ";
                $sql .= " FROM ".MAIN_DB_PREFIX."projet as pr";
                $sql .= " LEFT JOIN ".MAIN_DB_PREFIX."societe as s on pr.fk_soc = s.rowid";
                $sql .= " WHERE ";
                $sql .= " (pr.title LIKE '%".$db->escape($reference)."%' OR pr.description LIKE '%".$db->escape($reference)."%' OR pr.ref LIKE '%".$db->escape($reference)."%' )";
            }
// 					echo $sql ;
//					exit;
            $sql .= $db->plimit(50); // Avoid pb with bad criteria

            $resql = $db->query($sql);

            if ($resql) {
                while ($row = $db->fetch_array($resql)) {
                    $row_array['label']                                      = $row['type_element'].' '.$row['reference'].' : '.$row['nom_societe'];
                    $row_array['value']                                      = (!empty($row['reference']) ? $row['reference']
                            : $row['nom_societe'] );
                    $row_array['reference_rowid_'.$_GET['num_ligne']]        = $row['rowid'];
                    $row_array['reference_type_element_'.$_GET['num_ligne']] = $row['type_element'];
                    $row_array['reference_fk_socid_'.$_GET['num_ligne']]     = $row['fk_socid'];

                    array_push($return_arr, $row_array);
                }
            }

            header('Content-Type: application/json');
            echo json_encode($return_arr);
        }
        break;


    /**
      @brief Construct list of folder in mailbox
      @return json array
     */
    case 'listfolderimap':

        global $conf, $db, $user;

        $object  = $dolimap = new dolimap($db, $user);
        if (empty($identifiid)) $dolimap->SetUser($user->id, $number);
        elseif (!empty($identifiid)) $dolimap->SetUserGroup($identifiid, $number);

        if (empty($conf->global->DOLMESSAGE_DISPLAYINLISTING)) $pagination = 25; // $conf->global->PAGINATION_WEBMAIL;
        else $pagination = 10;

        $menus = array();
        //$folder = $Fol;

        dol_include_once('/dolmessage/class/cronDolmessage.class.php');
        if (class_exists('cronDolmessage')) {
            $cd          = new cronDolmessage($db);
            $mailboxType = (empty($identifiid)) ? 'user' : 'usergroup';
            $menus       = $cd->loadCacheDir($dolimap, $mailboxType);
        }

        if (empty($menus)) {
            try {
                $mbox = FALSE;
                if ($folder != '{:}') $dolimap->Open($folder);
                $mbox = $dolimap->GetImap();
                if ($mbox === FALSE) {
                    $info = FALSE;
                } else {
                    $info = $dolimap->Check();

                    if (FALSE !== $info) {
                        $option = 0;
                        $menus  = $dolimap->ListFolder();
                        sort($menus);
                    }
                }
            } catch (Exception $ex) {
                echo $ex->getMessage();
                echo '<br><br><a href="javascript:history.go(0);">Your IMAP serveur does not answer, click here to refresh</a>';
                break;
            }
        }
// 				$lbl_folder = array_reverse(explode('/', $folder));
// 				$lbl_folder = str_replace($user->imap_ref, '', str_replace('INBOX.', '', $lbl_folder[0]));
// print_r($menus);
// 				
        $res           = array();
        $res['result'] = array();
        foreach ($menus as $k => $o) {

            $ex = explode('/', $o->name);

            $m = '';
            while (count($ex) > 1) {
                $p = array_shift($ex);
                $m .= '&nbsp;&nbsp;&raquo;&nbsp;&nbsp;';
            }
            // extract name
            $n = $ex[sizeof($ex) - 1];
            // recover accent
            // hide server {server_adress} in folder name
            $n = preg_replace('/\\{.*\\}/', '', $n);



            $CIBL = str_replace($user->imap_ref, '', $o->name);
            $cibl = strtolower($CIBL);


            $cible = $cibl;
            if (strpos($n, ' ') === false) $title = $langs->trans($n);
            else $title = $n;


            # Subfolders
            if ((strtolower($folder) == 'inbox' && 'INBOX' == $n) || strtolower($folder) == $cibl) {
                $classAdd = 'tabactive';
            } else {
                $classAdd = '';
            }


            if (!isset($info)) {
                $info = $dolimap->Check();
            }
//            if ($classAdd != '') {
//                $title .= "&nbsp;({$o->Nmsgs})";
//            }


            $res['result'][] = array(
                'href' => dol_buildpath('/dolmessage/synchro.php', 1)."?number=".GETPOST('number').'&identifiid='.GETPOST('identifiid')."&folder=".urlencode($CIBL),
                'title' => $title,
                'class' => $classAdd,
                'decal' => $m,
                'unseen' => (isset($o->unseen)) ? $o->unseen : false,
                'Nmsgs' => (isset($o->Nmsgs)) ? $o->Nmsgs : false
            );
        }

        header('Content-Type: application/json');
        echo json_encode($res);
        break;

    /**
      @brief Construct list message in mailbox
      @return json array
     */
    case 'listimap':

        global $conf;
        if (empty($conf->global->DOLMESSAGE_DISPLAYINLISTING)) $pagination = 25; // $conf->global->PAGINATION_WEBMAIL;
        else $pagination = 10;


        // Protection if external user
        if ($user->societe_id > 0) {
            //accessforbidden();
        }
        $hookmanager->initHooks(array('dolmessage', 'greffon'));



        $object  = $dolimap = new dolimap($db, $user);
        if (empty($identifiid)) $dolimap->SetUser($user->id, $number);
        elseif (!empty($identifiid)) $dolimap->SetUserGroup($identifiid, $number);

        $form = new Form($db);




        // Definition of fields for list
        $arrayfields = $sort        = array();
        foreach ($dolimap->fields as $key => $val) {
            // If $val['visible']==0, then we never show the field
            if (!empty($val['visible'])) {
                $arrayfields[$key]        = array(
                    'label' => $val['label']
                    , 'checked' => (($val['visible'] < 0) ? 0 : 1)
                    , 'enabled' => $val['enabled']
                    , 'grp' => $val['grp']
                );
                $sort[$val['position']][] = $key;
            }
        }
        // Extra fields
        // if (is_array($extrafields->attribute_label) && count($extrafields->attribute_label))
        // {
        //     foreach($extrafields->attribute_label as $key => $val)
        //     {
        //         $arrayfields["ef.".$key]=array('label'=>$extrafields->attribute_label[$key], 'checked'=>$extrafields->attribute_list[$key], 'position'=>$extrafields->attribute_pos[$key], 'enabled'=>$extrafields->attribute_perms[$key]);
        //     }
        // }
        $parameters = array('arrayfields' => $arrayfields);
        $reshook    = $hookmanager->executeHooks('addArrayFields', $parameters);    // Note that $action and $object may have been modified by hook



        foreach ($hookmanager->resArray as $k => $val)
            if (!empty($val['visible'])) {
                $arrayfields[$k]          = array(
                    'label' => $val['label']
                    , 'checked' => (($val['visible'] < 0) ? 0 : 1)
                    , 'enabled' => $val['enabled']
                    , 'grp' => $val['grp']
                    , 'css' => $val['css']
                );
                $sort[$val['position']][] = $k;
            }


        $arrayfieldsold  = $arrayfields;
        $arrayfields     = array();
        // sort array
        foreach ($sort as $g => $s)
            foreach ($s as $p => $k)
                $arrayfields[$k] = $arrayfieldsold[$k];


        $folder = mb_convert_encoding($folder, "UTF7-IMAP", 'UTF-8');

        $mbox = FALSE;
        if ($folder != '{:}') $dolimap->Open($folder);



        $mbox = $dolimap->GetImap();

        if ($mbox === FALSE) {
            $info    = FALSE;
            foreach ($dolimap->ListErrors() as $row)
                $message .= $row."<br>";
        } else {
            $info = $dolimap->Check();


            if (FALSE !== $info) {

                $option = 0;
                if (GETPOST('search') && GETPOST('search') != '') $option = $dolimap->search(GETPOST('search'));

                $mails = $dolimap->ListMessage(GETPOST('num_page'), $pagination, $identifiid, $option);
// pas utile ici ????????????
//                $menus = $dolimap->ListFolder();
//
//                sort($menus);
            } else {
                foreach ($dolimap->ListErrors() as $row)
                    $message .= $row."<br>";
            }
        }


        $hookmanager->initHooks(array('dolmessage', 'greffon'));
        $knownEmails = getKnownEmails(true);

        $output               = array();
        $output['total']      = 0;
        $output['page']       = (int) $num_page;
        $output['pagination'] = $pagination;
        $output['result']     = array();

        $nbr_mess = 0;
        if (is_array($mails)) {
            foreach ($mails as $i => $mail) {

                if ($mail->GetDeleted() == 0 || (int) $mail->GetId() <= 0/* && !$mail->seen */) {
                    $ligne = array();

                    $ligne['uid']              = $mail->GetUid();
                    $ligne['position']         = ($nbr_mess) + ($pagination * $num_page); //($pagination * ( $num_page - 1 ) ) + ($pagination - $nbr_mess);
                    $ligne['seen']             = (!$mail->GetUnseen() ? 'seen ' : 'unseen ');
                    $ligne['cacheattachments'] = ($mail->GetCacheAttachments()) ? img_picto('Attachement',
                            'paperclip@dolmessage') : '&nbsp;';

                    $ligne['linked'] = ( (count($mail->GetLinked()) > 0) ? img_picto('sync', 'sync@dolmessage') : '&nbsp;' );



                    $ligne['answered'] = ( ($mail->GetAnswered()) ? img_picto('answered', 'answered@dolmessage') : '&nbsp;' );


                    $from           = '';
                    $certifiedEmail = in_array($mail->GetFromMail(), $knownEmails) ? ' '.img_object($langs->trans('KnownEmail'),
                            'opensurvey', ' style="vertical-align:middle"') : '';
                    if (count($mail->GetLinked()) > 0) {
                        $from .= '<span>';
                        $base = $mail->GetLinked();

                        foreach ($base as $type => $list)
                            foreach ($list as $obj)
                                if (in_array($type, array('societe'))) {
                                    $from .= $obj->getNomUrl(1, '', 16);
                                } elseif (in_array($type, array(/* 'societe', */'contact'))) {
                                    dol_include_once('/'.$type.'/class/'.$type.'.class.php');
                                    $class  = ucwords($type);
                                    $subobj = new Contact($db);
                                    $subobj->fetch(GETPOST('reference_rowid', 'int'));
                                    $from   .= $obj->getNomUrl(1, '', 16);
                                }
                        $from .= '</span>'.$mail->GetFromName().' &lt;'.$mail->GetFromMail().'&gt;'.$certifiedEmail;
                    } else { // from imap
                        $from .= '<span>'.$mail->GetFromMail().$certifiedEmail.'</span>'.$mail->GetFromName();
                    }

                    $ligne['to'] = $from.$certifiedEmail;



                    $ligne['object'] = $mail->getNomUrl(0, 'dolmessage', 0,
                        'number='.GETPOST('number').'&identifiid='.GETPOST('identifiid').'&folder='.urlencode(GETPOST('folder')));

                    $ligne['date']  = '<span>'.dol_print_date(strtotime($mail->GetDate()), 'dayhoursec').'</span>'.$mail->GetDate(true);
                    $ligne['heure'] = dol_print_date(strtotime($mail->GetDate()), 'dayhoursec');

                    $ligne['size'] = $mail->GetSize(true);

                    $ligne['flagged'] = ( ($mail->GetFlagged()) ? img_picto('flagged', 'flagged@dolmessage') : img_picto('unflagged',
                            'unflagged@dolmessage') );



                    $out  = '';
                    $form = '';

                    $form .= '<form class="attachlink" name="link_'.$ligne['position'].'" method="POST">';

                    $form .= '<table class="linkTable"><tr><td>';
                    $form .= '<span class="expend"><span class="ui-icon ui-icon-triangle-1-s"></span></span>';

                    $form .= '<div class="listopt">';

                    // mets ici tes champs de recherche
                    if (!empty($conf->agenda) && !empty($conf->agenda->enabled))
                            $form .= $langs->trans('DolmessageAddInCal').' <input name="addincal" type="checkbox"  placeholder="'.$langs->trans('Sender').'" value="1" checked="checked"  /><br /><br />';

                    $parameters = array();
                    $reshook    = $hookmanager->executeHooks('printActionAddLinkTo', $parameters);    // Note that $action and $object may have been modified by hook
// 												var_dump( $hookmanager->resPrint); 
                    if ($reshook >= 0 && version_compare(DOL_VERSION, '5.0', '>=')) {
                        $form .= $hookmanager->resPrint;
                    }



// 												if(!empty($conf->taskin) && !empty($conf->taskin->enabled) )
// 													$form.= $langs->trans('DolmessageAddInTaskin').' <input name="addincal" type="checkbox"  placeholder="'.$langs->trans('Sender').'" value="1" checked="checked"  /><br /><br />';

                    $form .= '</div>';
                    $form .= '</td><td>';
// 								if ($conf->use_javascript_ajax)
                    $out  .= ajax_multiautocompleter('reference_'.$ligne['position'],
                            array('reference_folder_'.$ligne['position'], 'reference_rowid_'.$ligne['position'], 'reference_type_element_'.$ligne['position'],
                            'reference_fk_socid_'.$ligne['position']),
                            dol_buildpath('/dolmessage/core/ajax/ajax.php', 1),
                            'num_ligne='.$ligne['position'].'&action=ownerlink')."\n";

                    $out  .= '<input id="reference_'.$ligne['position'].'" type="text" name="reference" value="';
                    $form .= $out.'">'."\n";
                    $form .= '<input class="reference_rowid" id="reference_rowid_'.$ligne['position'].'" type="hidden" name="reference_rowid" value="'.'">'."\n";
                    $form .= '<input id="reference_type_element_'.$ligne['position'].'" type="hidden" name="reference_type_element" value="'.'">'."\n";
                    $form .= '<input id="reference_fk_socid_'.$ligne['position'].'" type="hidden" name="reference_fk_socid" value="'.'">'."\n";
                    $form .= '<input id="reference_mail_uid_'.$ligne['position'].'" type="hidden" name="reference_mail_uid" value="'.$mail->GetUid().'">'."\n";
                    $form .= '<input id="reference_folder_'.$ligne['position'].'" type="hidden" name="reference_folder" value="'.GETPOST('folder').'">'."\n";

                    if (!empty($conf->global->DOLMESSAGE_LINKTOBYAJAX))
                            $form .= '<input  type="hidden" name="ajax" value="1">'."\n";

                    $form .= '<input id="position_'.$ligne['position'].'" type="hidden" name="position" value="'.$ligne['position'].'" />'."\n";

                    if (GETPOST('identifiid') > 0)
                            $form .= '<input  type="hidden" name="identifiid" value="'.GETPOST('identifiid').'">'."\n";

                    $form .= '<input  type="hidden" name="folder" value="'.GETPOST('folder').'">'."\n";
                    $form .= '<input  type="hidden" name="num_page" value="'.GETPOST('num_page').'">'."\n";
                    $form .= '<input  type="hidden" name="number" value="'.GETPOST('number').'">'."\n";
                    $form .= '</td><td>';
                    $form .= '<a class="linktobt" href="javascript:;" onclick="ProcessForm('.$ligne['position'].'); ">';
                    $form .= img_picto('attacher', 'lock');
                    $form .= '</a>';
                    $form .= '</td></tr></table>';
                    $form .= '</form>';

                    $ligne['form'] = $form;




                    $parameters = array('mail' => $mail, 'ligne' => $ligne);
                    $reshook    = $hookmanager->executeHooks('printFieldListValue', $parameters);    // Note that $action and $object may have been modified by hook

                    if ($reshook && version_compare(DOL_VERSION, '5.0', '>=')) {
                        $output['result'][] = $hookmanager->resArray;
                    } else $output['result'][] = $ligne;

                    $nbr_mess++;
                }
            }

            $output['total'] = $nbr_mess;
        }

        header('Content-Type: application/json');
        print json_encode($output);
        exit;
        break;


    case 'listlocal':
        dol_include_once('/user/class/usergroup.class.php');


// 			if(empty($conf->global->DOLMESSAGE_DISPLAYINLISTING) ) $pagination = 25;// $conf->global->PAGINATION_WEBMAIL;
// 			else $pagination = 10;

        $pagination = 10;

        if ($num_page <= 0) $num_page = 1;

        $offset = $pagination * ($num_page - 1); //* $num_page;

        if (!$sortfield) $sortfield = "rowid";
        if (!$sortorder) $sortorder = "ASC";

        $limit = $pagination /** ($num_page) */;
        if ($limit == 0) $limit = $limit + 1;

        // Protection if external user
        if ($user->societe_id > 0) {
            //accessforbidden();
        }

        $dolimap = new dolimap($db, $user);
        if (empty($identifiid)) $dolimap->SetUser($user->id, $number);
        elseif (!empty($identifiid)) $dolimap->SetUserGroup($identifiid, $number);

        $form = new Form($db);



        $array     = array();
        $UserGroup = new UserGroup($db);
        foreach ($UserGroup->listGroupsForUser($user->id) as $row)
            $array[]   = $row->id;

        $output               = array();
        $output['total']      = 0;
        $output['page']       = (int) $num_page;
        $output['pagination'] = $pagination;
        $output['result']     = array();


        $sql = "SELECT rowid, number,  message_id, message_uid, datec, recent, unseen, flagged, answered, joint  ";
        $sql .= " FROM ".MAIN_DB_PREFIX."message";
        $sql .= " WHERE  1 ";
        $sql .= " AND (user_id = '".$user->id."' ";
        if (count($array) > 0) $sql .= " OR usergroup_id  IN( ".implode(',', $array)." )  ";
        $sql .= "  ) ";
        $sql .= "  AND entity IN (".getEntity('dolmessage', 1).")";
        $sql .= $db->order($sortfield, $sortorder);
        $sql .= $db->plimit($pagination, $offset);

        $resql = $db->query($sql);
        if ($resql) {
            $num = $db->num_rows($resql);

            $i   = 0;
            $var = true;
            while ($i < min($num, $limit)) {
                $ligne = array();
                $objp  = $db->fetch_object($resql);

                $Mess = LoadMessage($objp->rowid, $objp->message_uid, $dolimap);


                $ligne['position'] = $objp->rowid;
                $ligne['date']     = '<span>'.date("d/m/Y H:i", strtotime($Mess->GetDate())).'</span>'.$Mess->GetDate(true);

                $dolmessage             = new dolmessage($db);
                $dolmessage->id         = $Mess->GetId();
                $dolmessage->message_id = $Mess->GetSubject();

                $ligne['subject'] = $dolmessage->getNomUrl(0, '', 0, 'number='.$objp->number);
                // 				echo '<td>';
                foreach ($Mess->GetLinked() as $type => $list)
                    foreach ($list as $obj)
                        if ($type == 'societe') $ligne['from']    = $obj->getNomUrl(1, '', 16);


                $go = '<span id="action-deleteLocal'.$objp->message_uid.'">'.$langs->trans('DolMessageDeleteLocal').'</span>'."\n";
                $go .= $form->formconfirm(dol_buildpath('/dolmessage/info.php', 1)."?number=".$objp->number.'&id='.$objp->rowid.'&identifiid='.GETPOST('identifiid'),
                    $langs->trans("DeleteDolMessage"), $langs->trans("ConfirmDeleteDolMessagetLocal"), "confirm_delete",
                    '', 0, "action-deleteLocal".$objp->message_uid."");

                $ligne['action'] = $go;

                $i++;

                $output['result'][] = $ligne;
            }

            $output['total'] = $num;
        }

        header('Content-Type: application/json');
        print json_encode($output);
        exit;

        break;
}

$db->close();
?>