<?php
/* Copyright (C) 2014 Oscim 	<support@oscim.fr>
 * Copyright (C) 2015 Oscss-Shop Team <support@oscss-shop.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * 	\defgroup   mymodule     Module MyModule
 *  \brief      Example of a module descriptor.
 * 				Such a file must be copied into htdocs/mymodule/core/modules directory.
 *  \file       htdocs/mymodule/core/modules/modMyModule.class.php
 *  \ingroup    mymodule
 *  \brief      Description and activation file for module MyModule
 */
// include_once(DOL_DOCUMENT_ROOT . "/core/modules/DolibarrModules.class.php");

global $conf;
if (isset($conf->framework) && $conf->framework->enabled) {
    dol_include_once('/framework/class/dolmodexts.class.php');
    global $langs;
    $langs->load('framework');
    class_alias('DolModExts', 'DolibarrModulesDolmessage');
} else class_alias('DolibarrModules', 'DolibarrModulesDolmessage');

/**
 *  Description and activation class for module Dolmessage
 */
class modDolmessage extends DolibarrModulesDolmessage
{

    /**
     *   Constructor. Define names, constants, directories, boxes, permissions
     *
     *   @param      DoliDB		$db      Database handler
     */
    function modDolmessage($db)
    {
        global $langs, $conf;

        $this->db = $db;

        // Id for module (must be unique).
        // Use here a free id (See in Home -> System information -> Dolibarr for list of used modules id).
        $this->numero = 121000;
        $this->name   = preg_replace('/^mod/i', '', get_class($this));

        if (isset($conf->framework) && $conf->framework->enabled) {
            $this->GetFileBuild();
            $this->loadOscssConf();
            // Boites
            $this->loadbox('/dolmessage/core/boxes/', '\CORE\DOLMESSAGE\\');
        } else
        // Boites
            $this->boxes = array();



        // Family can be 'crm','financial','hr','projects','products','ecm','technic','other'
        // It is used to group modules in module setup page
        //$this->family = "crm";
        // Module description, used if translation string 'ModuleXXXDesc' not found (where XXX is value of numeric property 'numero' of module)
        $this->description = "Gestion d'email avancé";




        // Defined all module parts (triggers, login, substitutions, menus, css, etc...)
        $this->module_parts = array(
            'triggers' => 1,
            'css' => array('/dolmessage/css/dolmessage.css'),
            'hooks' => array(
                'propalcard',
                'ordercard',
                'invoicecard',
                'ordersuppliercard',
                'invoicesuppliercard',
                'thirdpartycard',
                'contactcard',
                'globalcard',
                'main',
                'emailtemplates'
            )

            /**
              @remark Specifical section of framework compatibilitie view Oscss-Shop company
             */
            // default 0, 1 for active ; Construst in admin section the panel for manage extra fields  fo this object ; the menu of config section is auto adjusted
// 						 , 'useextrafields' => 	array(
// 									$this->code
// // 								, $this->code.'taskin'
// 							)
            // default 0, 1 for active ; Construst in admin section the panel for manage extra fields  fo this object ; the menu of config section is auto adjusted
// 						 , 'useextrafieldsline' => 0
            // Actiavte segment of odt , complement of models param
            // this section create In cst_table NAme of SAMPLE_ADDON_PDF
// 						, 'genericmodels' => array(
// 									'internal' =>array(
// 											'type'=> array('pdf', 'odt')
// 										)
// 								, 'external' =>array(
// 											'taskin'=>array(
// 													'type'=> array('pdf', 'odt')
// 													, 'perms' =>'!empty($conf->global->QUALITYREPORT_USE_TASKIN)'
// 												)
// 								)
// 							)
            // Activate module for generate ref in object
            // this section create In cst_table NAme of SAMPLE_ADDON
// 						, 'numberingrule' => array(
// 									'internal' =>array(
// 										'default' =>'mod_qualityreport_simple'
// 									)
// 								, 'external' =>array(
// 											'taskin'=>array(
// 													'default' =>'mod_qualityreport_simple'
// 													, 'perms' =>'!empty($conf->global->QUALITYREPORT_USE_TASKIN)'
// 												)
// 								)
// 							)
            , 'autotabs' => 1
        );

        // Data directories to create when module is enabled.
        // Example: this->dirs = array("/mymodule/temp");
        $this->dirs = array();

        // Config pages. Put here list of php page, stored into mymodule/admin directory, to use to setup module.
        $this->config_page_url = array("index.php?page=config@dolmessage");

        // Dependencies
        $this->depends    = array('modframework', 'modSociete');  // List of modules id that must be enabled if this module is enabled
        $this->requiredby = array(); // List of modules id to disable if this one is disabled




        $r++;
        $this->const[$r] = array(
            0 => "CODE_ACTIONCOMM_DOLMESSAGE"
            , 1 => "chaine"
            , 2 => "5"
            , 3 => "DolMessageTimeOutNego"
            , 4 => 0
            , 9 => array(
                'method' => 'InputText'
                , 'group' => 'setmainoptions'
            )
        );


        $r++;
        $this->const[$r] = array(
            0 => "DOLMESSAGE_TABS_TIERS"
            , 1 => "chaine"
            , 2 => "0"
            , 3 => "DolMessageTabsTiers"
            , 4 => 0
            , 9 => array(
                'method' => 'SelectYesNo'
                , 'group' => 'setmainoptions'
            )
        );


        $r++;
        $this->const[$r] = array(
            0 => "DOLMESSAGE_DISPLAYINLISTING"
            , 1 => "chaine"
            , 2 => "0"
            , 3 => "DolMessageDisplayInListing"
            , 4 => 0
            , 9 => array(
                'method' => 'SelectYesNo'
                , 'group' => 'setmainoptions'
            )
        );

        $r++;
        $this->const[$r] = array(
            0 => "DOLMESSAGE_DISPLAYSPLITPAGE"
            , 1 => "chaine"
            , 2 => "0"
            , 3 => "DolMessageDisplaySplitPage"
            , 4 => 0
            , 9 => array(
                'method' => 'SelectYesNo'
                , 'group' => 'setmainoptions'
            )
        );

        $r++;
        $this->const[$r] = array(
            0 => "DOLMESSAGE_LINKTOBYAJAX"
            , 1 => "chaine"
            , 2 => "0"
            , 3 => "DolMessageLinkToByAjax"
            , 4 => 0
            , 9 => array(
                'method' => 'SelectYesNo'
                , 'group' => 'setmainoptions'
            )
        );


        $this->tabs = array(
//             'user:+TabMessageConfig:MessageConfig:dolmessage@dolmessage:/dolmessage/tabs/user.mailconfig.php?id=__ID__',
//            'group:+TabMessageConfig:MessageConfig:dolmessage@dolmessage:/dolmessage/tabs/usergroup.mailconfig.php?id=__ID__',
//             'thirdparty:+TabMessage:dolmessage:@dolmessage:$conf->global->DOLMESSAGE_TABS_TIERS:/dolmessage/tabs/thirdparty.message.php?socid=__ID__',
            'project:+TabMessage:dolmessage:@dolmessage:/dolmessage/tabs/projet.message.php?id=__ID__',
        );


        // Cronjobs (List of cron jobs entries to add when module is enabled)
        $this->cronjobs      = array(
        );
        // Example: $this->cronjobs=array(0=>array('label'=>'My label', 'jobtype'=>'method', 'class'=>'/dir/class/file.class.php', 'objectname'=>'MyClass', 'method'=>'myMethod', 'parameters'=>'', 'comment'=>'Comment', 'frequency'=>2, 'unitfrequency'=>3600, 'status'=>0, 'test'=>true),
        //                                1=>array('label'=>'My label', 'jobtype'=>'command', 'command'=>'', 'parameters'=>'', 'comment'=>'Comment', 'frequency'=>1, 'unitfrequency'=>3600*24, 'status'=>0, 'test'=>true)
        // );
        // Dictionnaries
        $this->dictionnaries = array();


        // Permissions
        $r                   = 0;
        $this->rights[$r][0] = $this->numero + $r + 1;     // Permission id (must not be already used)
        $this->rights[$r][1] = 'Configuration IMAP'; // Permission label
        $this->rights[$r][2] = 'w';
        $this->rights[$r][3] = 0;      // Permission by default for new user (0/1)
        $this->rights[$r][4] = 'user';    // In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
        $this->rights[$r][5] = 'modifier';    // In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
        $r++;


        $this->rights[$r][0] = $this->numero + $r + 1;     // Permission id (must not be already used)
        $this->rights[$r][1] = 'Voir les fichiers message'; // Permission label
        $this->rights[$r][2] = 'r';
        $this->rights[$r][3] = 1;      // Permission by default for new user (0/1)
        $this->rights[$r][4] = 'message';    // In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
        $this->rights[$r][5] = 'view';    // In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
        $r++;

        $this->rights[$r][0] = $this->numero + $r + 1;     // Permission id (must not be already used)
        $this->rights[$r][1] = 'Supprimer un message sur le serveur'; // Permission label
        $this->rights[$r][2] = 'd';
        $this->rights[$r][3] = 0;      // Permission by default for new user (0/1)
        $this->rights[$r][4] = 'message';    // In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
        $this->rights[$r][5] = 'deleteonline';    // In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
        $r++;

        $this->rights[$r][0] = $this->numero + $r + 1;     // Permission id (must not be already used)
        $this->rights[$r][1] = 'Supprimer un message local'; // Permission label
        $this->rights[$r][2] = 'd';
        $this->rights[$r][3] = 0;      // Permission by default for new user (0/1)
        $this->rights[$r][4] = 'message';    // In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
        $this->rights[$r][5] = 'deletelocal';    // In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
        $r++;

        // Main menu entries
        $r              = 0;
        $this->menu[$r] = array('fk_menu' => 0, // Put 0 if this is a top menu
            'type' => 'top', // This is a Top menu entry
            'titre' => 'DolMessage',
            'mainmenu' => 'dolmessage',
//             'leftmenu' => 'dolmessage',
            'url' => '/dolmessage/index.php',
            'langs' => 'dolmessage@dolmessage', // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
            'position' => '100'.$this->numero,
            'enabled' => '$conf->dolmessage->enabled', // Define condition to show or hide menu entry. Use '$conf->mymodule->enabled' if entry must be visible if module is enabled.
            'perms' => '$user->rights->dolmessage->message->view', // Use 'perms'=>'$user->rights->mymodule->level1->level2' if you want your menu with a permission rules
            'target' => '',
            'user' => 2);                    // 0=Menu for internal users, 1=external users, 2=both
        $r++;




        /**
          @remarks End loaded config ans auto-config construct
         */
        if (isset($conf->framework) && $conf->framework->enabled) $this->EndLoader();
    }

    /**
     * 		Function called when module is enabled.
     * 		The init function add constants, boxes, permissions and menus (defined in constructor) into Dolibarr database.
     * 		It also creates data directories
     *
     *      @param      string	$options    Options when enabling module ('', 'noboxes')
     *      @return     int             	1 if OK, 0 if KO
     */
    function init($options = '')
    {
        global $langs;
        $sql = array(
            "INSERT IGNORE INTO ".MAIN_DB_PREFIX."c_actioncomm (id,code,libelle) VALUES(150, 'AC_DOLMSS', '".$langs->trans('NewDolMessagelinked')."')",
        );

        // FIX For upgrade DB message table
        if (version_compare($this->version, '2.5', '<')) /* if($this->version<=3.5) */
                $sql[] = "ALTER TABLE  `llx_message` CHANGE  `row_id`  `rowid` INT( 11 ) NOT NULL AUTO_INCREMENT";



        $result = $this->load_tables('/dolmessage/sql');

        return $this->_init($sql, $options);
    }

    /**
     * 		Function called when module is disabled.
     *      Remove from database constants, boxes and permissions from Dolibarr database.
     * 		Data directories are not deleted
     *
     *      @param      string	$options    Options when enabling module ('', 'noboxes')
     *      @return     int             	1 if OK, 0 if KO
     */
    function remove($options = '')
    {
        $sql = array();

        return $this->_remove($sql, $options);
    }
}
?>
