<?php
/* Copyright (C) 2014 Oscim 	<support@oscim.fr>
 * Copyright (C) 2015 Oscss-Shop Team <support@oscss-shop.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *   	\file       dev/skeletons/skeleton_page.php
 * 		\ingroup    mymodule othermodule1 othermodule2
 * 		\brief      This file is an example of a php page
 * 					Put here some comments
 */
 
namespace CORE;
$res = 0;
if (!$res && file_exists("../main.inc.php"))
    $res = @include("../main.inc.php");
if (!$res && file_exists("../../main.inc.php"))
    $res = @include("../../main.inc.php");
if (!$res && file_exists("../../../main.inc.php"))
    $res = @include("../../../main.inc.php");
if (!$res && file_exists("../../../../main.inc.php"))
    $res = @include("../../../../main.inc.php");
if (!$res && file_exists("../../../dolibarr/htdocs/main.inc.php"))
    $res = @include("../../../dolibarr/htdocs/main.inc.php");     // Used on dev env only
if (!$res && file_exists("../../../../dolibarr/htdocs/main.inc.php"))
    $res = @include("../../../../dolibarr/htdocs/main.inc.php");   // Used on dev env only
if (!$res && file_exists("../../../../../dolibarr/htdocs/main.inc.php"))
    $res = @include("../../../../../dolibarr/htdocs/main.inc.php");   // Used on dev env only
if (!$res)
    die("Include of main fails");

/**
	@brief Call Specific Class provider for OScssShop Exts 
		This class garanted process for dolibarr evolution 
*/
dol_include_once('/framework/main.inc.php');
dol_include_once('/framework/core/lib/framework.lib.php');


loadClass("Societe");


namespace CORE\DOLMESSAGE;
use \Form;
use \UserGroup;

use \CORE\FRAMEWORK\Societe as Societe;

use \Dolimap;
use \ActionCommDolMessage;
use \dolmessage;

require_once(DOL_DOCUMENT_ROOT . "/core/lib/agenda.lib.php");
require_once(DOL_DOCUMENT_ROOT . "/comm/action/class/cactioncomm.class.php");
require_once(DOL_DOCUMENT_ROOT . "/comm/action/class/actioncomm.class.php");


dol_include_once('/user/class/usergroup.class.php');


dol_include_once('dolmessage/class/connector/dolimap.class.php');
dol_include_once('dolmessage/class/connector/dollocalmessage.class.php');
dol_include_once('dolmessage/class/dolmessage.class.php');

dol_include_once('dolmessage/core/lib/message.lib.php');


// Load traductions files requiredby by page
$langs->load("companies");
$langs->load("other");
$langs->load("dolmessage@dolmessage");
$langs->load("agenda");


if (!function_exists('imap_timeout')) {
    print '<center class="alert" style="color:red"> les fonctions imap (php-imap) sont requise pour ce module </center>';
    exit;
}





global $conf;

// Get parameters
$id = GETPOST('id', 'int');
$number = GETPOST('number', 'int');
$action = GETPOST('action', 'alpha');
$folder = urldecode(GETPOST('folder', 'alpha'));
$sortfield = GETPOST('sortfield', 'alpha');
$sortorder = GETPOST('sortorder', 'alpha');
$num_page = GETPOST("num_page", 'int');



/* * *************************************************
 * VIEW
 *
 * Put here all code to build page
 * ************************************************** */

$s = "var DOLMESSAGE_DISPLAYSPLITPAGE ='".(int)$conf->global->DOLMESSAGE_DISPLAYSPLITPAGE."';";
$s.= "var pagination = '".(int)$pagination."'; ";
$s.= "var DOLMESSAGE_LINKTOBYAJAX = '".(int)$conf->global->DOLMESSAGE_LINKTOBYAJAX."'; ";
$s.= "var DOLMESSAGE_DISPLAYINLISTING = '".(int)$conf->global->DOLMESSAGE_DISPLAYINLISTING."'; ";
$s.= "var PHP_SELF = '".$_SERVER["PHP_SELF"]."'; ";
$s.= "var ajaxpath = '".dol_buildPath('/dolmessage/core/ajax/ajax.php?number='.$number.'&folder='.$folder.'&identifiid='.$identifiid, 2)."'; ";
$s.= "var loadingGif = '".img_picto('Loading', 'loading.gif@dolmessage')."'; ";
$s.= "var num_page = '".$num_page."'; ";
$s.= "var action= 'listlocal'; ";
 

$morejs=array( "/dolmessage/core/js/dolmessage.js","/dolmessage/core/js/dolmessage.config.js.php");
 
llxHeader(
				'',
				'Dolibarr Webmail',
        '', 
        '',
        '',
        '',
        $morejs 
			);
?>
<script type="text/javascript">
	<?php echo $s ?>
</script>
<?php 

dol_fiche_head(message_prepare_head(), 'dashboard', $langs->trans("Webmail"), 0, 'mailbox@dolmessage');







print '<table class="noborder listingEmail" width="100%">';
print '<thead><tr class="messages liste_titre" id="0">';
print '      <td class="liste_titre" align="center" colspan="1">' . $langs->trans("DolmessagelFrom") . '</td>';
print '      <td class="liste_titre" align="center">' . $langs->trans("DolmessagelObject") . '</td>';
print '      <td class="liste_titre" align="center">' . $langs->trans("DolmessagelDate") . '</td>';

print '      <td colspan="2" class="liste_titre"  align="center">' . $langs->trans("DolmessagelLinked") . '</td>';

print '    </tr></thead><tbody>';

print '</tbody></table>';


?>
<script type="text/javascript">

	// construct ligne of data in table
	function ProcessLigne(item, parity){
		if (parity) {
				parityClass = 'pair';
		} else {
				parityClass = 'impair';
		}
									

                        var row = '<tr class="messages inload ' + parityClass + ' " id="' + item.position + '">'
                                //
//                                 + '<td>' + item.linked + '</td>'
//                                 + '<td style="text-align:center;width:30px;">' + item.answered + '</td>'
                                + '<td class="hiddenInfo">' + item.from + '</td>'
                                + '<td>' + item.subject + '</td>'
                                + '<td class="hiddenInfo" style="text-align:center;width: 115px;">' + item.date + '</td>'
//                                 + '<td style="text-align:right;">' + item.size + '</td>'
//                                 + '<td align="center">' + item.flagged + '</td>'
                                + '<td align="center" width="180">' + item.action + '</td>'
                                + '</tr>';
						
		return row; 
	}
	

	$(document).ready(function () {

			$('#dolmess_search').Loader(); 

	});


</script>
<?php

// End of page
llxFooter();
$db->close();
?>