<?php
	/************************************************
	* Copyright (C) 2016	Sylvain Legrand - <contact@infras.fr>	InfraS - <http://www.infras.fr>
	*
	* This program is free software: you can redistribute it and/or modify
	* it under the terms of the GNU General Public License as published by
	* the Free Software Foundation, either version 3 of the License, or
	* (at your option) any later version.
	*
	* This program is distributed in the hope that it will be useful,
	* but WITHOUT ANY WARRANTY; without even the implied warranty of
	* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	* GNU General Public License for more details.
	*
	* You should have received a copy of the GNU General Public License
	* along with this program.  If not, see <http://www.gnu.org/licenses/>.
	************************************************/

	/************************************************
	* 	\file		../infraspack/admin/about.php
	* 	\ingroup	InfraS
	* 	\brief		about page
	************************************************/

	// Dolibarr environment *************************
	$res = 0;
	if (! $res && file_exists("../../main.inc.php"))	$res=@include("../../main.inc.php");	// For root directory
	if (! $res && file_exists("../../../main.inc.php"))	$res=@include("../../../main.inc.php");	// For "custom" directory

	// Libraries ************************************
	require_once DOL_DOCUMENT_ROOT.'/core/lib/admin.lib.php';
	dol_include_once('/infraspack/core/lib/infraspack.lib.php');

	// Translations *********************************
	$langs->load("admin");
	$langs->load('infraspack@infraspack');

	// Access control *******************************
	if (!$user->admin)	accessforbidden();

	// View *****************************************
	$page_name = $langs->trans("InfraSSetup") ." - ". $langs->trans("About");
	llxHeader('', $page_name);
	$linkback = '<a href="'.DOL_URL_ROOT.'/admin/modules.php">'.$langs->trans("BackToModuleList").'</a>';
	print_fiche_titre($page_name, $linkback, 'title_setup');

	// Configuration header *************************
	$head = infraspack_admin_prepare_head();
	$picto	= 'infraspack@infraspack';
	dol_fiche_head($head, 'about', $langs->trans("modcomname"), 0, $picto);

	// About page goes here *************************
	$thisName		= 'infraspack';
	$currentversion	= InfraS_getLocalVersionMinDoli($thisName);
	$ChangeLog		= InfraS_getChangeLog($thisName, $currentversion[2], $currentversion[3]);
	print	$ChangeLog;
	print	InfraS_getSupportInformation($currentversion[0]);
	llxFooter();
	$db->close();
?>
