<?php
	/************************************************
	* Copyright (C) 2016	Sylvain Legrand - <contact@infras.fr>	InfraS - <http://www.infras.fr>
	*
	* This program is free software: you can redistribute it and/or modify
	* it under the terms of the GNU General Public License as published by
	* the Free Software Foundation, either version 3 of the License, or
	* (at your option) any later version.
	*
	* This program is distributed in the hope that it will be useful,
	* but WITHOUT ANY WARRANTY; without even the implied warranty of
	* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	* GNU General Public License for more details.
	*
	* You should have received a copy of the GNU General Public License
	* along with this program.  If not, see <http://www.gnu.org/licenses/>.
	************************************************/

	/************************************************
	* 	\file		../infraspack/admin/adresses.php
	* 	\ingroup	InfraS
	* 	\brief		Page to setup adresses for the module InfraS
	************************************************/

	// Dolibarr environment *************************
	$res = 0;
	if (! $res && file_exists("../../main.inc.php"))	$res=@include("../../main.inc.php");	// For root directory
	if (! $res && file_exists("../../../main.inc.php"))	$res=@include("../../../main.inc.php");	// For "custom" directory

	// Libraries ************************************
	require_once DOL_DOCUMENT_ROOT.'/core/lib/admin.lib.php';
	require_once DOL_DOCUMENT_ROOT.'/core/lib/company.lib.php';
	require_once DOL_DOCUMENT_ROOT.'/core/lib/images.lib.php';
	require_once DOL_DOCUMENT_ROOT.'/core/lib/files.lib.php';
	require_once DOL_DOCUMENT_ROOT.'/core/class/html.formcompany.class.php';
	require_once DOL_DOCUMENT_ROOT.'/core/class/html.formfile.class.php';
	require_once DOL_DOCUMENT_ROOT.'/societe/class/address.class.php';
	dol_include_once('/infraspack/core/lib/infraspack.lib.php');

	// Translations *********************************
	$langs->load("admin");
	$langs->load('companies');
	$langs->load('errors');
	$langs->load('dict');
	$langs->load('infraspack@infraspack');

	// Access control *******************************
	if (!$user->admin)	accessforbidden();

	// Parameters ***********************************
	$form								= new Form($db);
	$formfile							= new FormFile($db);
	$formcompany						= new FormCompany($db);
	$object								= new Societe($db);
	$addresses							= new Address($db);
	$object->id							= 0;
	$addresses->lines					= array();
	$btnAction							= 'name="add" value="'.$langs->trans("Add");
	$confirm_mesg						= '';
	$action								= GETPOST('action', 'alpha');
	$confirm							= GETPOST('confirm', 'alpha');


	// Actions **************************************
	InfraS_test_new_fields('infraspack');	

	if (GETPOST('cancel'))				header('Location: '.$_SERVER["PHP_SELF"]);

	if($action == 'edit')
	{
		$objaddress						= new Address($db);
		$objaddress->fetch_address(GETPOST('id', 'int'));
		$btnAction						= 'name="save" value="'.$langs->trans("Save");
	}	// if($action == 'edit')

	if(($action == 'add' || GETPOST('save')) && !GETPOST('cancel'))
	{
		$parms_ok						= true;
		if (GETPOST('label', 'alpha') == '' || GETPOST('label', 'alpha') == $langs->trans('RequiredField'))
		{
			$parms_ok					= false;
			setEventMessages($langs->trans("AliasIsRequired"), null, 'errors');
		}	// if (GETPOST('label', 'alpha') == '' || GETPOST('label', 'alpha') == $langs->trans('RequiredField'))
		if (GETPOST('name', 'alpha') == '' || GETPOST('label', 'alpha') == $langs->trans('RequiredField'))
		{
			$parms_ok					= false;
			setEventMessages($langs->trans("NameIsRequired"), null, 'errors');
		}	// if (GETPOST('name', 'alpha') == '' || GETPOST('label', 'alpha') == $langs->trans('RequiredField'))
		if (GETPOST('save') && $parms_ok)
		{
			$sql_address				= 'SELECT rowid, label, name';
			$sql_address				.= ' FROM '.MAIN_DB_PREFIX.'societe_address';
			$sql_address				.= ' WHERE label = "'.GETPOST('label', 'alpha').'"';
			$sql_address				.= ' AND name = "'.GETPOST('name', 'alpha').'"';
			$sql_address				.= ' AND rowid <> "'.GETPOST('id', 'int').'"';
			$result_address				= $db->query($sql_address);
			if ($db->num_rows($result_address) === 1)
				setEventMessages($langs->trans("AddressAlredyExists"), null, 'errors');
			else
			{
				$sql_update				= 'UPDATE '. MAIN_DB_PREFIX.'societe_address';
				$sql_update				.= ' SET label = "'.GETPOST('label', 'alpha').'",';
				$sql_update				.= ' name = "'.GETPOST('name', 'alpha').'",';
				$sql_update				.= ' address = "'.GETPOST('address', 'alpha').'",';
				$sql_update				.= ' zip = "'.GETPOST('zipcode', 'alpha').'",';
				$sql_update				.= ' town = "'.GETPOST('town', 'alpha').'",';
				$sql_update				.= ' fk_pays = "'.GETPOST('country_id', 'alpha').'",';
				$sql_update				.= ' phone = "'.GETPOST('phone', 'alpha').'",';
				$sql_update				.= ' fax = "'.GETPOST('fax', 'alpha').'",';
				$sql_update				.= ' email = "'.GETPOST('email', 'alpha').'",';
				$sql_update				.= ' url = "'.GETPOST('url', 'alpha').'",';
				$sql_update				.= ' note = "'.GETPOST('note', 'alpha').'"';
				$sql_update				.= ' WHERE rowid = '.GETPOST('id', 'int');
				$result_update			= $db->query($sql_update);
				if ($result_update < 0)	setEventMessages($langs->trans("ErrorSavingAddress"), null, 'errors');
				else					setEventMessages($langs->trans("AddressUpdated"), null, 'mesgs');
				$db->free($result_update);
			}	// else	// if ($db->num_rows($result_address) === 1)
			$db->free($result_address);
		}	// if (GETPOST('save') && $parms_ok)
		if (($action == 'add' && $parms_ok) && !GETPOST('save'))
		{
			$sql_address				= 'SELECT DISTINCT label, name';
			$sql_address				.= ' FROM '.MAIN_DB_PREFIX.'societe_address';
			$sql_address				.= ' WHERE label = "'.GETPOST('label', 'alpha').'"';
			$sql_address				.= ' AND name = "'.GETPOST('name', 'alpha').'"';
			$result_address				= $db->query($sql_address);
			if ($db->num_rows($result_address) === 1)
				setEventMessages($langs->trans("AddressAlredyExists"), null, 'errors');
			else
			{
				$sql_insert				= 'INSERT INTO '. MAIN_DB_PREFIX.'societe_address(label, name, address, zip, town, fk_pays, phone, fax, email, url, note)';
				$sql_insert				.= 'VALUES ("'.GETPOST('label', 'alpha').'", "'
													.GETPOST('name', 'alpha').'", "'
													.GETPOST('address', 'alpha').'", "'
													.GETPOST('zipcode', 'alpha').'", "'
													.GETPOST('town', 'alpha').'", "'
													.GETPOST('country_id', 'int').'", "'
													.GETPOST('phone', 'alpha').'", "'
													.GETPOST('fax', 'alpha').'", "'
													.GETPOST('email', 'alpha').'", "'
													.GETPOST('url', 'alpha').'", "'
													.GETPOST('note', 'alpha').'")';
				$result_insert			= $db->query($sql_insert);
				if (!$result_insert || $result_insert < 0)
					setEventMessages($langs->trans("ErrorSavingAddress"), null, 'errors');
				else					setEventMessages($langs->trans("AddressSaved"), null, 'mesgs');
				$db->free($result_insert);
			}	// else	// if ($db->num_rows($result_address) === 1)
			$db->free($result_address);
		}	// if ($action == 'add' && $parms_ok)
	}	// if($action == 'add' || GETPOST('save'))
	
	if ($action == 'defaultL')	dolibarr_set_const($db, "INFRAS_PDF_DEFAULT_ADDR_DELIV", GETPOST('defaultaddrdeliv'),'chaine',0,'',$conf->entity);

	if ($action == 'delete')
		$confirm_mesg					= $form->formconfirm($_SERVER["PHP_SELF"].'?id='.GETPOST('id', 'int'), $langs->trans("DeleteAddress"), $langs->trans("ConfirmDeleteAddress"), 'delete_ok', '', 1, (int) $conf->use_javascript_ajax);

	if ($action == 'delete_ok' && $confirm == 'yes')
	{
		$sql_supp						= 'DELETE FROM '. MAIN_DB_PREFIX.'societe_address ';
		$sql_supp						.= ' WHERE rowid = '.GETPOST('id', 'int');
		$result_supp					= $db->query($sql_supp);
		if ($result_supp < 0)			setEventMessages($langs->trans("ErrorDeletingAddress"), null, 'errors');
		else							setEventMessages($langs->trans("Deleted"), null, 'mesgs');
		$db->free($result_supp);
	}	// if ($action == 'delete_ok' && $confirm == 'yes')

	$sql_show							= 'SELECT a.rowid as id, a.label, a.name, a.address, a.datec as date_creation, a.tms as date_modification, a.fk_soc';
	$sql_show							.= ', a.zip, a.town, a.fk_pays as country_id, a.phone, a.fax, a.email, a.url, a.note';
	$sql_show							.= ', c.code as country_code, c.label as country';
	$sql_show							.= ' FROM '.MAIN_DB_PREFIX.'societe_address as a';
	$sql_show							.= ' LEFT JOIN '.MAIN_DB_PREFIX.'c_country as c ON a.fk_pays = c.rowid';
	$sql_show							.= ' WHERE a.fk_soc = '.$object->id;
	$result_show						= $db->query($sql_show);
	if ($result_show)
	{
		$num							= $db->num_rows($result_show);
		$i								= 0;
		while ($i < $num)
		{
			$objp						= $db->fetch_object($result_show);
			$line						= new AddressLine($db);
			$line->id					= $objp->id;
			$line->date_creation		= $db->jdate($objp->date_creation);
			$line->date_modification	= $db->jdate($objp->date_modification);
			$line->label				= $objp->label;
			$line->name					= $objp->name;
			$line->address				= $objp->address;
			$line->zip					= $objp->zip;
			$line->town					= $objp->town;
			$line->country_id			= $objp->country_id;
			$line->country_code			= $objp->country_id?$objp->country_code:'';
			$line->country				= $objp->country_id?($langs->trans('Country'.$objp->country_code)!='Country'.$objp->country_code?$langs->trans('Country'.$objp->country_code):$objp->country):'';
			$line->phone				= $objp->phone;
			$line->fax					= $objp->fax;
			$line->email				= $objp->email;
			$line->url					= $objp->url;
			$line->note					= $objp->note;
			$addresses->lines[$i]		= $line;
			$i++;
		}
	}	// if ($result_show)
	else								dol_syslog(get_class($addresses).'::Fetch Erreur: aucune adresse', LOG_ERR);
	$db->free($result_show);

	// View *****************************************
	$page_name			= $langs->trans("InfraSSetup") ." - ". $langs->trans("Adresses");
	llxHeader('', $page_name);
	echo $confirm_mesg;
	$linkback			= '<a href="'.DOL_URL_ROOT.'/admin/modules.php">'.$langs->trans("BackToModuleList").'</a>';
	print_fiche_titre($page_name, $linkback, 'title_setup');
	
	// Configuration header *************************
	$head				= infraspack_admin_prepare_head();
	$picto				= 'infraspack@infraspack';
	dol_fiche_head($head, 'adresses', $langs->trans("modcomname"), 0, $picto);

	// setup page goes here *************************
	$var				= true;
	print load_fiche_titre($langs->trans("GestionAdresses"), '', 'title_companies.png');
	if ($conf->use_javascript_ajax)
	{
		print '<script type="text/javascript" language="javascript">
					$(document).ready(function () {
						$("#label").focus(function() {
							hideMessage("label","'.$langs->trans('RequiredField').'");
						});
						$("#label").blur(function() {
							displayMessage("label","'.$langs->trans('RequiredField').'");
						});
						$("#name").focus(function() {
							hideMessage("name","'.$langs->trans('RequiredField').'");
						});
						$("#name").blur(function() {
							displayMessage("name","'.$langs->trans('RequiredField').'");
						});
						displayMessage("label","'.$langs->trans('RequiredField').'");
						displayMessage("name","'.$langs->trans('RequiredField').'");
						$("#label").css("color","grey");
						$("#name").css("color","grey");
					})
			   </script>';
	}	// if ($conf->use_javascript_ajax)
	print '	<form action = "'.$_SERVER["PHP_SELF"].'" method = "post" enctype = "multipart/form-data">
				<input type = "hidden" name = "token" value = "'.$_SESSION['newtoken'].'">
				<input type = "hidden" name = "action" value = "add"/>
				<input type = "hidden" name = "id" value = "'.$objaddress->id.'"/>
				<table class = "noborder" width = "100%">
					<tr class = "liste_titre">
						<td colspan = "5" align = "center">'.$langs->trans('NewAdresse').'</td>
					</tr>';
	if (! empty($user->admin))
	{
		print '		<tr>
						<td class = "fieldrequired">'.fieldLabel('AdressAlias', 'label', 1).'</td>
						<td><input type = "text" class = "minwidth300" id = "label" name = "label" value="'.($objaddress->label ? $objaddress->label : $langs->trans('RequiredField')).'" style = "margin: 0; padding: 0;"></td>
						<td class = "fieldrequired">'.fieldLabel('AdressName', 'name', 1).'</td>
						<td><input type = "text" class = "minwidth300" id = "name" name = "name" value = "'.($objaddress->name ? $objaddress->name : $langs->trans('RequiredField')).'" style = "margin: 0; padding: 0;"></td>
						<td rowspan="6" align="center">
							<input class = "button" type = "submit" '.$btnAction.'" style = "width: 100px;">
							<br/><br/>
							<input class = "button" type = "submit" name = "cancel" value = "'.$langs->trans("Cancel").'" style = "width: 100px;">
						</td>
					</tr>';
		print '		<tr>
						<td class = "tdtop">'.fieldLabel('Address', 'address').'</td>
						<td colspan = "3"><textarea name = "address" id = "address" class = "quatrevingtpercent" rows = "3" wrap = "soft">'.$objaddress->address.'</textarea></td>
					</tr>';
		print '		<tr>
						<td>'.fieldLabel('Zip', 'zipcode').'</td>
						<td>'.$formcompany->select_ziptown($objaddress->zip, 'zipcode', array('town', 'selectcountry_id', 'state_id'), 6).'</td>
						<td>'.fieldLabel('Town', 'town').'</td>
						<td>'.$formcompany->select_ziptown($objaddress->town, 'town', array('zipcode', 'selectcountry_id', 'state_id')).'</td>
					</tr>';
		print '		<tr>
						<td>'.fieldLabel('Country', 'selectcounty_id').'</td>
						<td colspan = "3">'.$form->select_country($objaddress->country_id, 'country_id').info_admin($langs->trans("YouCanChangeValuesForThisListFromDictionarySetup"),1).'</td>
					</tr>';
		print '		<tr>
						<td>'.fieldLabel('Phone', 'phone').'</td>
						<td><input type = "text" class = "minwidth300" id = "phone" name = "phone" value = "'.$objaddress->phone.'" style = "margin: 0; padding: 0;"></td>
						<td>'.fieldLabel('Fax', 'fax').'</td>
						<td><input type = "text" class = "minwidth300" id = "fax" name = "fax" value = "'.$objaddress->fax.'" style = "margin: 0; padding: 0;"></td>
					</tr>';
		print '		<tr>
						<td>'.fieldLabel('Email', 'email').'</td>
						<td ><input type = "text" class = "minwidth300" id = "email" name = "email" value = "'.$objaddress->email.'" style = "margin: 0; padding: 0;"></td>
						<td>'.fieldLabel('Web', 'url').'</td>
						<td ><input type = "text" class = "minwidth300" id = "url" name = "url" value = "'.$objaddress->url.'" style = "margin: 0; padding: 0;"></td>
					</tr>';
		print '		<tr>
						<td class = "tdtop">'.fieldLabel('Note', 'note').'</td>
						<td colspan = "3"><textarea name = "note" id = "note" class = "quatrevingtpercent" rows = "6" wrap = "soft">'.$objaddress->note.'</textarea></td>
					</tr>';
		print '		<tr '.$bc[$var].' style="height: 1px; font-size: 0px;">
						<td colspan = "5" style="padding-top: 0px; padding-bottom: 0px;">&nbsp;</td>
					</tr>';
		$addrs	= array();
		$addrs	= scandir($conf->mycompany->dir_output.'/logos/');
		print '		<tr class="oddeven">
						<td colspan = "4">
							'.fieldLabel(''.$langs->trans("PDFInfraSParamDefaultAddrDeliv").'', 'defaultaddrdeliv').'
							<select name = "defaultaddrdeliv" class = "select2-choice" style = "margin: 0; padding: 0">
								<option name = "defaultaddrdeliv" value = "">'.$langs->trans('PDFInfraSParamNoAddrDeliv').'</option>';
		$selected_addr	= $conf->global->INFRAS_PDF_DEFAULT_ADDR_DELIV;
		foreach ($addresses->lines as $lineaddress)
		{
			print '				<option name = "defaultaddrdeliv" value = "'.$lineaddress->label.'"';
			if ($selected_addr === $lineaddress->label)	print ' selected';
			print '				>'.$lineaddress->label.'</option>';
		}	// foreach ($addresses->lines as $lineaddress)
		print '				</select>
						</td>
						<td align="center"><button class="button" type="submit" value="defaultL" name="action" style = "width: 100px;">'.$langs->trans("Validate").'</button></td>
					</tr>';
	}	// if (! empty($user->admin))
	print '		</table>
			</form>';
	print load_fiche_titre($langs->trans("AddressesForMyCompany"), '', 'title_project.png');
	print '	<form action = "'.$_SERVER["PHP_SELF"].'" method = "post" enctype = "multipart/form-data">
				<input type = "hidden" name = "token" value = "'.$_SESSION['newtoken'].'">
				<table class = "noborder" width = "100%">
					<tr class = "liste_titre">
						<td>'.$langs->trans('AdressAlias').'</td>
						<td>'.$langs->trans('AdressName').'</td>
						<td>'.$langs->trans('Address').'</td>
						<td>'.$langs->trans('Country').'</td>
						<td>'.$langs->trans('Email').'</td>
						<td>'.$langs->trans('Web').'</td>
						<td colspan = "2">&nbsp;</td>
					</tr>';
	if (! empty($user->admin))
	{
		if ($num > 0)
		{
			foreach ($addresses->lines as $lineaddress)
			{
						print '<tr class="oddeven">
						<td>'.$lineaddress->label.'</td>
						<td>'.$lineaddress->name.'</td>
						<td>'.$lineaddress->address.' - '.$lineaddress->zip.' '.$lineaddress->town.'</td>
						<td>'.$lineaddress->country.'</td>
						<td>'.$lineaddress->email.'</td>
						<td>'.$lineaddress->url.'</td>
						<td><a href = "'.$_SERVER["PHP_SELF"].'?action=edit&id='.$lineaddress->id.'" class = "deletefilelink">'.img_edit().'</a></td>
						<td><a href = "'.$_SERVER["PHP_SELF"].'?action=delete&id='.$lineaddress->id.'" class = "deletefilelink">'.img_delete().'</a></td>
					  </tr>';
			}	// foreach ($addresses->lines as $lineaddress)
		}	// if ($num > 0)
	}	// if (! empty($user->admin))
	print '		</table>
			</form>';	
	dol_fiche_end();
	llxFooter();
	$db->close();
?>