<?php
	/************************************************
	* Copyright (C) 2016	Sylvain Legrand - <contact@infras.fr>	InfraS - <http://www.infras.fr>
	*
	* This program is free software: you can redistribute it and/or modify
	* it under the terms of the GNU General Public License as published by
	* the Free Software Foundation, either version 3 of the License, or
	* (at your option) any later version.
	*
	* This program is distributed in the hope that it will be useful,
	* but WITHOUT ANY WARRANTY; without even the implied warranty of
	* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	* GNU General Public License for more details.
	*
	* You should have received a copy of the GNU General Public License
	* along with this program.  If not, see <http://www.gnu.org/licenses/>.
	************************************************/

	/************************************************
	* 	\file		../infraspack/admin/images.php
	* 	\ingroup	InfraS
	* 	\brief		Page to setup pictures for the module InfraS
	************************************************/

	// Dolibarr environment *************************
	$res = 0;
	if (! $res && file_exists("../../main.inc.php"))	$res=@include("../../main.inc.php");	// For root directory
	if (! $res && file_exists("../../../main.inc.php"))	$res=@include("../../../main.inc.php");	// For "custom" directory

	// Libraries ************************************
	require_once DOL_DOCUMENT_ROOT.'/core/lib/admin.lib.php';
	require_once DOL_DOCUMENT_ROOT.'/core/lib/images.lib.php';
	require_once DOL_DOCUMENT_ROOT.'/core/lib/files.lib.php';
	require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
	require_once DOL_DOCUMENT_ROOT.'/core/class/html.formfile.class.php';
	dol_include_once('/infraspack/core/lib/infraspack.lib.php');

	// Translations *********************************
	$langs->load("admin");
	$langs->load('companies');
	$langs->load('errors');
	$langs->load('infraspack@infraspack');

	// Access control *******************************
	if (!$user->admin)	accessforbidden();

	// Actions **************************************
	$form						= new Form($db);
	$formfile					= new FormFile($db);
	$confirm_mesg				= '';
	$action						= GETPOST('action', 'alpha');
	$confirm					= GETPOST('confirm', 'alpha');
	$urlfile					= GETPOST('urlfile', 'alpha');
	$result						= '';
	$use_iso_location			= isset($conf->global->MAIN_PDF_USE_ISO_LOCATION) ? $conf->global->MAIN_PDF_USE_ISO_LOCATION : 0;
	$hlogo						= isset($conf->global->MAIN_DOCUMENTS_LOGO_HEIGHT) ? $conf->global->MAIN_DOCUMENTS_LOGO_HEIGHT : 10;
	$maxhlogo					= ($use_iso_location ? 28 : 50);
	$hlogo						= ($hlogo > $maxhlogo ? $maxhlogo : $hlogo);
	dolibarr_set_const($db, "MAIN_DOCUMENTS_LOGO_HEIGHT", $hlogo, 'chaine', 0, '', $conf->entity);

	// Parameters
	if($action == 'add')
	{
		$extension				= pathinfo($_FILES['logofile']['name'], PATHINFO_EXTENSION);
		$dest_file				= GETPOST('logoname', 'alpha').'.'.$extension;
		$moved					= dol_move_uploaded_file($_FILES['logofile']['tmp_name'], $conf->mycompany->dir_output.'/logos/'.$dest_file, 1, 0, $_FILES['logofile']['error']);
		if ($moved > 0)
		{
			if ($isimage = image_format_supported($dest_file) === 1)
			{
				$imgThumbSmall	= vignette($conf->mycompany->dir_output.'/logos/'.$dest_file, $maxwidthsmall, $maxheightsmall, '_mini', $quality);
				$imgThumbSmall	= vignette($conf->mycompany->dir_output.'/logos/'.$dest_file, $maxwidthsmall, $maxheightsmall, '_small', $quality);
			}	// if ($isimage = image_format_supported($dest_file) === 1)
			setEventMessages($dest_file.' : '.$langs->trans("FileSaved"), null, 'mesgs');
		}	// if ($moved > 0)
		else if ($moved !== 1)	// errors
		{
			if ($moved < 0)		setEventMessages('UknownFileUploadError', null, 'errors');	// API documented error
			else				setEventMessages($moved, null, 'errors');	// We got an error string /o\
		}	// else if ($moved !== 1)
	}	// if($action == 'add')
	if ($action == 'defaultP')	$result	= dolibarr_set_const($db, "INFRAS_PDF_IMAGE_FOOT", GETPOST('defaultpied'), 'chaine', 0, '', $conf->entity);
	if ($action == 'defaultW')	$result	= dolibarr_set_const($db, "INFRAS_PDF_IMAGE_WATERMARK", GETPOST('defaultwatermark'), 'chaine', 0, '', $conf->entity);
	if ($action == 'delete')	$confirm_mesg	= $form->formconfirm($_SERVER["PHP_SELF"].'?urlfile='.$urlfile, $langs->trans("DeleteAFile"), $langs->trans("ConfirmDeleteAFile").' '.$urlfile.' ?', 'delete_ok', '', 1, (int) $conf->use_javascript_ajax);
	if ($action == 'delete_ok' && $confirm == 'yes')
	{
		$urlfile_dirname		= pathinfo($urlfile, PATHINFO_DIRNAME);
		$urlfile_filename		= pathinfo($urlfile, PATHINFO_FILENAME);
		$urlfile_ext			= pathinfo($urlfile, PATHINFO_EXTENSION);
		$urlfile_small			= $urlfile_dirname.$urlfile_filename.'_small.'.$urlfile_ext;
		$urlfile_mini			= $urlfile_dirname.$urlfile_filename.'_mini.'.$urlfile_ext;
		$a						= dol_delete_file($conf->mycompany->dir_output.'/logos'.$urlfile, 1);
		$b						= dol_delete_file($conf->mycompany->dir_output.'/logos/thumbs'.$urlfile_small, 1);
		$c						= dol_delete_file($conf->mycompany->dir_output.'/logos/thumbs'.$urlfile_mini, 1);
		if ($a && $b && $c)		setEventMessages($urlfile_filename.'.'.$urlfile_ext.' '.$langs->trans("Deleted"), null, 'mesgs');
		else					setEventMessages($langs->trans("ErrorFailToDeleteFile", $urlfile), null, 'errors');
	}	// if ($action == 'delete_ok' && $confirm == 'yes')
	if ($action == 'setpicture')		$result	= dolibarr_set_const($db, "INFRAS_PDF_WITH_PICTURE", GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setpicturesachat')	$result	= dolibarr_set_const($db, "INFRAS_PDF_SUPPLIER_ORDER_WITH_PICTURE", GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setoldpath')		$result	= dolibarr_set_const($db, "PRODUCT_USE_OLD_PATH_FOR_PHOTO", GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'sethighqual')		$result	= dolibarr_set_const($db, "CAT_HIGH_QUALITY_IMAGES", GETPOST('value'), 'chaine', 0, '', $conf->entity);
	$list								= array ('MAIN_DOCUMENTS_LOGO_HEIGHT', 'INFRAS_PDF_PICTURE_FOOT_WIDTH', 'INFRAS_PDF_PICTURE_FOOT_HEIGHT', 
													'INFRAS_PDF_PICTURE_WIDTH', 'INFRAS_PDF_PICTURE_HEIGHT', 'INFRAS_PDF_T_WATERMARK_OPACITY', 
													'INFRAS_PDF_I_WATERMARK_OPACITY');
	if ($action == 'update')
	{
		$error	= 0;
		foreach ($list as $constname)
		{
			$constvalue					= GETPOST($constname, 'alpha');
			$result						= dolibarr_set_const($db, $constname, $constvalue, 'chaine', 0, '', $conf->entity);
		}	// foreach ($list as $constname)
	}	// if ($action == 'update')

	if ($result == 1)					setEventMessages($langs->trans("SetupSaved"), null, 'mesgs');
	if ($result == -1)					setEventMessages($langs->trans("Error"), null, 'errors');

	// View *****************************************
	$page_name					= $langs->trans("InfraSSetup") ." - ". $langs->trans("Images");
	llxHeader('', $page_name);
	echo $confirm_mesg;
	$linkback					= '<a href="'.DOL_URL_ROOT.'/admin/modules.php">'.$langs->trans("BackToModuleList").'</a>';
	print_fiche_titre($page_name, $linkback, 'title_setup');
	
	// Configuration header *************************
	$head						= infraspack_admin_prepare_head();
	$picto						= 'infraspack@infraspack';
	dol_fiche_head($head, 'images', $langs->trans("modcomname"), 0, $picto);

	// setup page goes here *************************
	$var						= true;
	print load_fiche_titre($langs->trans("GestionLogos"), '', 'title_setup.png');
	print '		<form action="'.$_SERVER["PHP_SELF"].'" method = "post" enctype="multipart/form-data">
					<input type = "hidden" name = "token" value = "'.$_SESSION['newtoken'].'">
					<table class = "noborder" width = "100%">
						<colgroup>
							<col width = "*">
							<col width = "650px">
							<col width = "100px">
						</colgroup>
						<tr class = "liste_titre">
							<td colspan = "3" align="center">'.$langs->trans('NewLogo').'</td>
						</tr>';
	if (! empty($user->admin))
	{
		print '			<tr class="oddeven">
							<td>
								'.fieldLabel('LogoName', 'logoname').'
								<input type = "text" size = "30" id = "logoname" name = "logoname" style = "margin: 0; padding: 0;">
							</td>
							<td>
								'.fieldLabel('LogoFile', 'logofile').'
								<input type = "file" id = "logofile" name = "logofile" accept="image/*" style = "margin: 0; padding: 0;">
							</td>
							<td align = "center"><button class = "button" type = "submit" value = "add" name = "action">'.$langs->trans("Add").'</button></td>
						</tr>';
		$logos	= array();
		$logos	= scandir($conf->mycompany->dir_output.'/logos/');
		print '			<tr class="oddeven">
							<td colspan = "2">
								'.fieldLabel(''.$langs->trans("DefaultImageFooter").'', 'defaultpied').'
								<select name = "defaultpied" style = "margin: 0; padding: 0;">
									<option name = "defaultpied" value = "">'.$langs->trans('NoPied').'</option>';
		$selected_logo	= $conf->global->INFRAS_PDF_IMAGE_FOOT;
		for ($i = 0; $i < count($logos); $i++)
		{
			if ($logos[$i] === 'thumbs' || $logos[$i][0] === '.')	continue;	// Choose to ignore field which isn't image
			print '					<option name = "defaultpied" value = "'.$logos[$i].'"';
			if ($selected_logo === $logos[$i])	print ' selected';
			print '					>'.$logos[$i].'</option>';
		}	// for ($i = 0; $i < count($logos); $i++)
		print '					</select>
							</td>
							<td align = "center"><button class = "button" type = "submit" value = "defaultP" name = "action">'.$langs->trans("Validate").'</button></td>
						</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">
								'.fieldLabel(''.$langs->trans("DefaultWatermarkImage").'', 'defaultwatermark').'
								<select name = "defaultwatermark" style = "margin: 0; padding: 0;">
									<option name = "defaultwatermark" value = "">'.$langs->trans('NoWatermarkImage').'</option>';
		$selected_logo	= $conf->global->INFRAS_PDF_IMAGE_WATERMARK;
		for ($i = 0; $i < count($logos); $i++)
		{
			if ($logos[$i] === 'thumbs' || $logos[$i][0] === '.')	continue;	// Choose to ignore field which isn't image
			print '					<option name = "defaultwatermark" value = "'.$logos[$i].'"';
			if ($selected_logo === $logos[$i])	print ' selected';
			print '					>'.$logos[$i].'</option>';
		}	// for ($i = 0; $i < count($logos); $i++)
		print '					</select>
							</td>
							<td align = "center"><button class = "button" type = "submit" value = "defaultW" name = "action">'.$langs->trans("Validate").'</button></td>
						</tr>';
	}	// if (! empty($user->admin))
	print '			</table>
				</form>';	
	$logo_files	= dol_dir_list($conf->mycompany->dir_output.'/logos/', 'files', 0, '',  '', null, null, 1);
	$formfile->list_of_documents($logo_files, null, 'companylogo', '', 1, '', 1, 0, $langs->trans("NoLogo"), 0, $langs->trans("ListLogos"));
	print load_fiche_titre($langs->trans("ImagesSetup"), '', 'title_products.png');
	print '		<form action="'.$_SERVER["PHP_SELF"].'" method = "post">
					<input type = "hidden" name = "token" value = "'.$_SESSION['newtoken'].'">
					<table class="noborder" width="100%">
						<colgroup>
							<col width = "*">
							<col width = "130px">
							<col width = "100px">
						</colgroup>
						<tr class="liste_titre">
							<td>'.$langs->trans('Description').'</td>
							<td align="center">'.$langs->trans('Status').'</td>
							<td>&nbsp;</td>
						</tr>';
	if (! empty($user->admin))
	{
		print '			<tr>
							<td colspan="2" align="center">'.$langs->trans('AvertissementCalculImage').'</td>';
		print '				<td rowspan="12" align="center"><button class = "button" type = "submit" value = "update" name = "action">'.$langs->trans("Modify").'</button></td>
						</tr>';
		print '			<tr class="oddeven">
							<td>'.$langs->trans("PDFInfraSParamLogoHeight", $maxhlogo).'</td>
							<td align="center">
								<input type = "number" size = "10" style = "text-align: right; margin: 0; padding: 0;" dir="rtl" id = "MAIN_DOCUMENTS_LOGO_HEIGHT" name = "MAIN_DOCUMENTS_LOGO_HEIGHT" min = "10" max = "'.$maxhlogo.'" value = "'.$conf->global->MAIN_DOCUMENTS_LOGO_HEIGHT.'">&nbsp;pt
							</td>
						</tr>';
		print '			<tr class="oddeven">
							<td>'.$langs->trans("PDFInfraSParamPictureFootWidth").'</td>
							<td align="center">
								<input type = "number" size = "10" style = "text-align: right; margin: 0; padding: 0;" dir="rtl" id = "INFRAS_PDF_PICTURE_FOOT_WIDTH" name = "INFRAS_PDF_PICTURE_FOOT_WIDTH" min = "20" max = "190" value = "'.$conf->global->INFRAS_PDF_PICTURE_FOOT_WIDTH.'">&nbsp;pt
							</td>
						</tr>';
		print '			<tr class="oddeven">
							<td>'.$langs->trans("PDFInfraSParamPictureFootHeight").'</td>
							<td align="center">
								<input type = "number" size = "10" style = "text-align: right; margin: 0; padding: 0;" dir="rtl" id = "INFRAS_PDF_PICTURE_FOOT_HEIGHT" name = "INFRAS_PDF_PICTURE_FOOT_HEIGHT" min = "4" max = "30" value = "'.$conf->global->INFRAS_PDF_PICTURE_FOOT_HEIGHT.'">&nbsp;pt
							</td>
						</tr>';
		print '			<tr class="oddeven">
							<td>'.$langs->trans("PDFInfraSParamWithPicture").'</td>';
		if (! empty($conf->global->INFRAS_PDF_WITH_PICTURE))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setpicture&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setpicture&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>
						</tr>';
		print '			<tr class="oddeven">
							<td>'.$langs->trans("PDFInfraSParamSupplierOrderWithPicture").'</td>';
		if (! empty($conf->global->INFRAS_PDF_SUPPLIER_ORDER_WITH_PICTURE))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setpicturesachat&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setpicturesachat&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>
						</tr>';
		print '			<tr class="oddeven">
							<td>'.$langs->trans("PDFInfraSParamPictureWidth").'</td>
							<td align="center">
								<input type = "number" size = "10" style = "text-align: right; margin: 0; padding: 0;" dir="rtl" id = "INFRAS_PDF_PICTURE_WIDTH" name = "INFRAS_PDF_PICTURE_WIDTH" min = "16" max = "160" value = "'.$conf->global->INFRAS_PDF_PICTURE_WIDTH.'">&nbsp;pt
							</td>
						</tr>';
		print '			<tr class="oddeven">
							<td>'.$langs->trans("PDFInfraSParamPictureHeight").'</td>
							<td align="center">
								<input type = "number" size = "10" style = "text-align: right; margin: 0; padding: 0;" dir="rtl" id = "INFRAS_PDF_PICTURE_HEIGHT" name = "INFRAS_PDF_PICTURE_HEIGHT" min = "32" max = "320" value = "'.$conf->global->INFRAS_PDF_PICTURE_HEIGHT.'">&nbsp;pt
							</td>
						</tr>';
		print '			<tr class="oddeven">
							<td>'.$langs->trans("PDFInfraSParamOldPathPhoto").'</td>';
		if (! empty($conf->global->PRODUCT_USE_OLD_PATH_FOR_PHOTO))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setoldpath&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setoldpath&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td>'.$langs->trans("PDFInfraSParamHQPicture").'</td>';
		if (! empty($conf->global->CAT_HIGH_QUALITY_IMAGES))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=sethighqual&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=sethighqual&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td>'.$langs->trans("PDFInfraSParamWatermarkTOpacity").'</td>
							<td align="center">
								<input type = "number" size = "10" style = "text-align: right; margin: 0; padding: 0;" dir="rtl" id = "INFRAS_PDF_T_WATERMARK_OPACITY" name = "INFRAS_PDF_T_WATERMARK_OPACITY" min = "10" max = "50" value = "'.$conf->global->INFRAS_PDF_T_WATERMARK_OPACITY.'">&nbsp;%
							</td>
						</tr>';
		print '			<tr class="oddeven">
							<td>'.$langs->trans("PDFInfraSParamWatermarkIOpacity").'</td>
							<td align="center">
								<input type = "number" size = "10" style = "text-align: right; margin: 0; padding: 0;" dir="rtl" id = "INFRAS_PDF_I_WATERMARK_OPACITY" name = "INFRAS_PDF_I_WATERMARK_OPACITY" min = "1" max = "25" value = "'.$conf->global->INFRAS_PDF_I_WATERMARK_OPACITY.'">&nbsp;%
							</td>
						</tr>';
	}	// if (! empty($user->admin))
	print '			</table>
				</form>';
	
	dol_fiche_end();
	llxFooter();
	$db->close();
?>