<?php
	/************************************************
	* Copyright (C) 2018	Sylvain Legrand - <contact@infras.fr>	InfraS - <http://www.infras.fr>
	*
	* This program is free software: you can redistribute it and/or modify
	* it under the terms of the GNU General Public License as published by
	* the Free Software Foundation, either version 3 of the License, or
	* (at your option) any later version.
	*
	* This program is distributed in the hope that it will be useful,
	* but WITHOUT ANY WARRANTY; without even the implied warranty of
	* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	* GNU General Public License for more details.
	*
	* You should have received a copy of the GNU General Public License
	* along with this program.  If not, see <http://www.gnu.org/licenses/>.
	************************************************/

	/************************************************
	* 	\file		../infraspack/admin/infrassetup.php
	* 	\ingroup	InfraS
	* 	\brief		Page to setup the module InfraS
	************************************************/
	
	function num_col(&$selectvalue, $listselect)
	{
		$nums		= array('options' => '', 'err' => 0);
		for ($i = 1 ; $i < 11 ; $i++)
		{
			$afficher							= $i < 10 ? '0'.$i : $i;
			$nums['options']					.= '<option name = "'.$selectvalue['select'].'" value = "'.$i.'"';
			if ($selectvalue['value'] == $i)	$nums['options']	.= ' selected';
			$nums['options']					.= '>'.$afficher.'</option>';
		}	// for ($i = 1 ; $i < 11 ; $i++)
		foreach ($listselect as $selectvalues)
			if ($selectvalues['select'] != $selectvalue['select'] && $selectvalues['value'] == $selectvalue['value'])	$nums['err']++;
		return $nums;
	}	// function num_col(&$selectvalue, $listselect)

	// Dolibarr environment *************************
	$res = 0;
	if (! $res && file_exists("../../main.inc.php"))	$res=@include("../../main.inc.php");	// For root directory
	if (! $res && file_exists("../../../main.inc.php"))	$res=@include("../../../main.inc.php");	// For "custom" directory

	// Libraries ************************************
	require_once DOL_DOCUMENT_ROOT.'/core/lib/admin.lib.php';
	require_once DOL_DOCUMENT_ROOT.'/core/lib/files.lib.php';
	include_once DOL_DOCUMENT_ROOT.'/core/lib/functions2.lib.php';
	require_once DOL_DOCUMENT_ROOT.'/core/lib/pdf.lib.php';
	require_once DOL_DOCUMENT_ROOT.'/core/class/html.formother.class.php';
	dol_include_once('/infraspack/core/lib/infraspack.lib.php');

	// Translations *********************************
	$langs->load("admin");
	$langs->load("companies");
	$langs->load("bills");
	$langs->load('infraspack@infraspack');

	// Access control *******************************
	if (!$user->admin)	accessforbidden();

	// Actions **************************************
	$action								= GETPOST('action','alpha');
	$result								= '';
	
	// Parameters INFRAS_PDF_* and others
	if ($action == 'corechange')
	{
		$dolibranch										= explode('.', DOL_VERSION);
		$path											= dol_buildpath('infraspack', 0);
		$pathCoreChange									= $path.'/corechange-dlb'.$dolibranch[0].'0x';
		if (strtoupper(substr(PHP_OS, 0, 3)) != 'WIN')	$resultChmod	= InfraS_chmod_r($pathCoreChange, '0755', '0755', 'www-data', 'www-data');
		else											$resultChmod	= 1;
		if ($resultChmod)
		{
			$resultCopy	= dolCopyDir($pathCoreChange, DOL_DOCUMENT_ROOT, 0, 1);		
			if ($resultCopy > 0)
			{
				$validcorechg	= $conf->global->INFRAS_PDF_VALID_CORE_CHGT;
				$validcorechg	= $validcorechg	== 0 || $validcorechg	== '' ? 1 : $validcorechg;
				$result	= dolibarr_set_const($db, "INFRAS_PDF_VALID_CORE_CHGT",	$validcorechg, 'chaine', 0, '', $conf->entity);
			}	// if ($resultCopy > 0)
		}	// if ($resultChmod)
		else	$result	= -1;
	}	// if ($action == 'corechange')
	if ($action == 'setcadrerecep')		$result	= dolibarr_set_const($db, "INFRAS_PDF_HIDE_RECEP_FRAME", GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setrecepdetails')	$result	= dolibarr_set_const($db, "INFRAS_PDF_SHOW_RECEP_DETAILS", GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setheader2')		$result	= dolibarr_set_const($db, "INFRAS_PDF_SMALL_HEAD_2", GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'settitlebg')		$result	= dolibarr_set_const($db, "INFRAS_PDF_TITLE_BG", GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'settextcolorauto')	$result	= dolibarr_set_const($db, "INFRAS_PDF_TEXT_COLOR_AUTO", GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'sethidetoptable')	$result	= dolibarr_set_const($db, "INFRAS_PDF_HIDE_TOP_TABLE", GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setpagenumber')		$result	= dolibarr_set_const($db, "INFRAS_PDF_HIDE_PAGE_NUM", GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setlabelbold')		$result	= dolibarr_set_const($db, "INFRAS_PDF_LABEL_BOLD", GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'settypefoot')		$result	= dolibarr_set_const($db, "INFRAS_PDF_TYPE_FOOT", GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setnumwords' && in_array('numberwords', $conf->modules))
		$result							= dolibarr_set_const($db, "INFRAS_PDF_NUMBER_WORDS", GETPOST('value'), 'chaine', 0, '', $conf->entity);
	elseif ($action == 'setnumwords')	setEventMessages($langs->trans("ErrorNumWords"), null, 'errors');
	if ($action == 'setup')				$result	= dolibarr_set_const($db, "INFRAS_PDF_HIDE_UP", GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setvatcolumn')		$result	= dolibarr_set_const($db, "INFRAS_PDF_WITHOUT_VAT_COLUMN", GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setttctotvat')
	{
		$result	= dolibarr_set_const($db, "INFRAS_PDF_TTC_WITH_VAT_TOT", GETPOST('value'), 'chaine', 0, '', $conf->entity);
		if (! empty($conf->global->INFRAS_PDF_TTC_WITH_VAT_TOT))
			$result						= dolibarr_set_const($db, "INFRAS_PDF_WITHOUT_VAT", 0, 'chaine', 0, '', $conf->entity);
	}	// if ($action == 'setttctotvat')
	if ($action == 'setvat')
	{
		$result	= dolibarr_set_const($db, "INFRAS_PDF_WITHOUT_VAT", GETPOST('value'), 'chaine', 0, '', $conf->entity);
		if (! empty($conf->global->INFRAS_PDF_WITHOUT_VAT))
			$result						= dolibarr_set_const($db, "INFRAS_PDF_TTC_WITH_VAT_TOT", 0, 'chaine', 0, '', $conf->entity);
	}	// if ($action == 'setvat')
	if ($action == 'setdiscount')		$result	= dolibarr_set_const($db, "INFRAS_PDF_HIDE_DISCOUNT", GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setupdiscounted')	$result	= dolibarr_set_const($db, "INFRAS_PDF_SHOW_UP_DISCOUNTED", GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'settotloccur')		$result	= dolibarr_set_const($db, "INFRAS_PDF_SHOW_TOTAL_LOCAL_CUR", GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'sethidecols')		$result	= dolibarr_set_const($db, "INFRAS_PDF_HIDE_COLS", GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setcgvdef')			$result	= dolibarr_set_const($db, "INFRAS_PDF_CGV_BY_DEFAULT", GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setrefcol')			$result	= dolibarr_set_const($db, "INFRAS_PDF_WITH_REF_COLUMN", GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setsuprefcol')		$result	= dolibarr_set_const($db, "INFRAS_PDF_WITH_SUPPLIER_REF_COLUMN", GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setdescdev')
	{
		$result							= dolibarr_set_const($db, "INFRAS_PDF_SHOW_DESC_DEV", GETPOST('value'), 'chaine', 0, '', $conf->entity);
		$result							= dolibarr_set_const($db, "MAIN_GENERATE_DOCUMENTS_HIDE_DESC", GETPOST('value'), 'chaine', 0, '', $conf->entity);
	}	// if ($action == 'setdescdev')
	if ($action == 'setordered')		$result	= dolibarr_set_const($db, "INFRAS_PDF_HIDE_ORDERED", GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setoutstdbill')		$result	= dolibarr_set_const($db, "INFRAS_PDF_SHOW_OUTSTDBILL", GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setLCR')			$result	= dolibarr_set_const($db, "INFRAS_PDF_SHOW_LCR", GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setsignprop')		$result	= dolibarr_set_const($db, "INFRAS_PDF_PROPAL_SHOW_SIGNATURE", GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setsignpropst')		$result	= dolibarr_set_const($db, "INFRAS_PDF_PROPAL_ST_SHOW_SIGNATURE", GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setsigncom')		$result	= dolibarr_set_const($db, "INFRAS_PDF_COMMANDE_SHOW_SIGNATURE", GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setsignfi')			$result	= dolibarr_set_const($db, "INFRAS_PDF_INTERVENTION_SHOW_SIGNATURE", GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setlivadresse')		$result	= dolibarr_set_const($db, "INFRAS_PDF_SHOW_ADRESSE_LIVRAISON", GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setrecadresse')
	{
		$result							= dolibarr_set_const($db, "INFRAS_PDF_SHOW_ADRESSE_RECEPTION", GETPOST('value'), 'chaine', 0, '', $conf->entity);
		$result							= dolibarr_set_const($db, "SOCIETE_ADDRESSES_MANAGEMENT", GETPOST('value'), 'chaine', 0, '', $conf->entity);
	}	// if ($action == 'setrecadresse')
		
	if ($action == 'setfont')
	{
		$extension						= pathinfo($_FILES['fontfile']['name'], PATHINFO_EXTENSION);
		if ($extension == 'ttf' || $extension == 'TTF')
		{
			$pathfonts	= dol_buildpath('infraspack', 0).'/ttf/';
			$fontfile	= $_FILES['fontfile']['tmp_name'];
			$dest_file	= $_FILES['fontfile']['name'];
			$moved		= dol_move_uploaded_file($fontfile, $pathfonts.$dest_file, 1, 0, $_FILES['fontfile']['error']);
			if ($moved > 0)
			{
				$outpath					= dol_buildpath('infraspack', 0).'/tmp/';
				$fontname					= InfraS_Add_TCPDF_Font ('TrueTypeUnicode', '', 32, $outpath, 3, 1, true, false, $pathfonts.$dest_file);
				if ($fontname === false)	setEventMessages($langs->trans("PDFInfraSParamAddFontKo", $fontname), null, 'errors');
				else
				{
					dolCopyDir($outpath, dol_buildpath('infraspack', 0).'/fonts', 0, 1);	
					dolCopyDir($outpath, TCPDF_PATH.'fonts', 0, 1);
					array_map('unlink', glob($outpath.'*'));
					setEventMessages($langs->trans("PDFInfraSParamAddFontOk", $fontname), null, 'mesgs');
				}	// else	// if ($fontname === false)
			}	// if ($moved > 0)
		}	// if ($extension == 'ttf' || $extension == 'TTF')
		else	setEventMessages($langs->trans("PDFInfraSParamAddTTFKo", $_FILES['fontfile']['name']), null, 'errors');
	}	// if ($action == 'setfont')

	$list								= array('INFRAS_PDF_ROUNDED_REC', 'INFRAS_PDF_FOLD_MARK', 'INFRAS_PDF_X_PAGE_NUM', 'INFRAS_PDF_Y_PAGE_NUM', 'INFRAS_PDF_HT_SIGN_AREA');
	if ($action == 'update')
	{
		$result							= dolibarr_set_const($db, "INFRAS_PDF_FONT", GETPOST('defaultfont'), 'chaine', 0, '', $conf->entity);
		$rgb							= implode(', ', colorStringToArray(GETPOST('INFRAS_PDF_BACKGROUND_COLOR', 'alpha')));
		$result							= dolibarr_set_const($db, "INFRAS_PDF_BACKGROUND_COLOR", $rgb, 'chaine', 0, '', $conf->entity);
		$rgbtext						= implode(', ', colorStringToArray(GETPOST('INFRAS_PDF_TEXT_COLOR', 'alpha')));
		$result							= dolibarr_set_const($db, "INFRAS_PDF_TEXT_COLOR", $rgbtext, 'chaine', 0, '', $conf->entity);
		$error							= 0;
		foreach ($list as $constname)
		{
			$constvalue					= GETPOST($constname, 'alpha');
			$result						= dolibarr_set_const($db, $constname, $constvalue, 'chaine', 0, '', $conf->entity);
		}	// foreach ($list as $constname)
	}	// if ($action == 'update')

	$list2								= array('INFRAS_PDF_LARGCOL_REF', 	'INFRAS_PDF_LARGCOL_QTY',		'INFRAS_PDF_LARGCOL_UNIT',
												'INFRAS_PDF_LARGCOL_UP',	'INFRAS_PDF_LARGCOL_TVA',		'INFRAS_PDF_LARGCOL_DISC',
												'INFRAS_PDF_LARGCOL_UPD',	'INFRAS_PDF_LARGCOL_PROGRESS',	'INFRAS_PDF_LARGCOL_TOTAL',
												'INFRAS_PDF_NUMCOL_REF',	'INFRAS_PDF_NUMCOL_DESC',		'INFRAS_PDF_NUMCOL_QTY',
												'INFRAS_PDF_NUMCOL_UNIT',	'INFRAS_PDF_NUMCOL_UP',			'INFRAS_PDF_NUMCOL_TVA',
												'INFRAS_PDF_NUMCOL_DISC',	'INFRAS_PDF_NUMCOL_UPD',		'INFRAS_PDF_NUMCOL_PROGRESS',
												'INFRAS_PDF_NUMCOL_TOTAL');
	if ($action == 'update2')
	{
		foreach ($list2 as $constname)
		{
			$constvalue					= GETPOST($constname, 'alpha');
			$result						= dolibarr_set_const($db, $constname, $constvalue, 'chaine', 0, '', $conf->entity);
		}	// foreach ($list2 as $constname)
	}	// if ($action == 'update2')

	if($action == 'addcgv')
	{
		if ($_FILES['cgvfile']['name'])
		{
			$extension					= pathinfo($_FILES['cgvfile']['name'], PATHINFO_EXTENSION);
			$dest_file					= GETPOST('cgvname', 'alpha').'.'.$extension;
			$moved						= dol_move_uploaded_file($_FILES['cgvfile']['tmp_name'], $conf->mycompany->dir_output.'/'.$dest_file, 1, 0, $_FILES['cgvfile']['error']);
			if ($moved > 0)				$result	= dolibarr_set_const($db, "INFRAS_PDF_CGV", $dest_file, 'chaine', 0, '', $conf->entity);
			else if ($moved !== 1)	// errors
			{
				if ($moved < 0)			setEventMessages('UknownFileUploadError', null, 'errors');	// API documented error
				else					setEventMessages($moved, null, 'errors');	// We got an error string /o\
			}	// else if ($moved !== 1)
		}	// if ($_FILES['cgvfile']['name'])
		else
		{
			dol_delete_file($conf->mycompany->dir_output.'/'.$conf->global->INFRAS_PDF_CGV, 1);
			$result						= dolibarr_set_const($db, "INFRAS_PDF_CGV", '', 'chaine', 0, '', $conf->entity);
		}	// else	// if ($_FILES['cgvfile']['name'])
	}	// if($action == 'addcgv')
	if ($conf->global->INFRAS_PDF_CGV)
	{
		$cgvlabel						= $langs->trans("CGVNow", $conf->global->INFRAS_PDF_CGV);
		$btncgvlabel					= $langs->trans("Delete");
		$DisabledCGV					= 'disabled';
	}	// if ($conf->global->INFRAS_PDF_CGV)
	else
	{
		$cgvlabel						= $langs->trans("NoCGVNow");
		$btncgvlabel					= $langs->trans("Add");
		$DisabledCGV					= '';
	}	// else	// if ($conf->global->INFRAS_PDF_CGV)
	
	$list3								= array ('INFRAS_PDF_FACTURE_PAID_WATERMARK');
	if ($action == 'update3')
	{
		$error							= 0;
		foreach ($list3 as $constname)
		{
			$constvalue					= GETPOST($constname, 'alpha');
			$result						= dolibarr_set_const($db, $constname, $constvalue, 'chaine', 0, '', $conf->entity);
		}	// foreach ($list3 as $constname)
	}	// if ($action == 'update3')
	
	if ($result == 1)					setEventMessages($langs->trans("SetupSaved"), null, 'mesgs');
	if ($result == -1)					setEventMessages($langs->trans("Error"), null, 'errors');
	
	// init variables *******************************
	$validcorechg						= $conf->global->INFRAS_PDF_VALID_CORE_CHGT;
	$classcorechg						= $validcorechg	== 2 ? 'button' : 'butActionDelete';
	$dirfonts							= DOL_DOCUMENT_ROOT.'/includes/tecnickcom/tcpdf/fonts/';
	$listfonts							= dol_dir_list($dirfonts, 'files');
	$listfontuse						= array();
	foreach ($listfonts as $font)
	{
		$extension						= pathinfo($font['name'], PATHINFO_EXTENSION);
		if ($extension == 'php')
		{
			$fontname					= pathinfo($font['name'], PATHINFO_FILENAME);
			include_once ($font['fullname']);
			if ($name != '')			$listfontuse[]	= array('name' => $name, 'fontname' => $fontname);
			$name						= '';
		}	// if ($extension == 'php')
	}	// foreach ($listfonts as $font)
	$listselect							= array(array('select' => 'INFRAS_PDF_NUMCOL_REF',		'value' => isset($conf->global->INFRAS_PDF_NUMCOL_REF)			? $conf->global->INFRAS_PDF_NUMCOL_REF			: 1),
												array('select' => 'INFRAS_PDF_NUMCOL_DESC',		'value' => isset($conf->global->INFRAS_PDF_NUMCOL_DESC)			? $conf->global->INFRAS_PDF_NUMCOL_DESC			: 2),
												array('select' => 'INFRAS_PDF_NUMCOL_QTY',		'value' => isset($conf->global->INFRAS_PDF_NUMCOL_QTY)			? $conf->global->INFRAS_PDF_NUMCOL_QTY			: 3),
												array('select' => 'INFRAS_PDF_NUMCOL_UNIT',		'value' => isset($conf->global->INFRAS_PDF_NUMCOL_UNIT)			? $conf->global->INFRAS_PDF_NUMCOL_UNIT			: 4),
												array('select' => 'INFRAS_PDF_NUMCOL_UP',		'value' => isset($conf->global->INFRAS_PDF_NUMCOL_UP)			? $conf->global->INFRAS_PDF_NUMCOL_UP			: 5),
												array('select' => 'INFRAS_PDF_NUMCOL_TVA',		'value' => isset($conf->global->INFRAS_PDF_NUMCOL_TVA)			? $conf->global->INFRAS_PDF_NUMCOL_TVA			: 6),
												array('select' => 'INFRAS_PDF_NUMCOL_DISC',		'value' => isset($conf->global->INFRAS_PDF_NUMCOL_DISC)			? $conf->global->INFRAS_PDF_NUMCOL_DISC			: 7),
												array('select' => 'INFRAS_PDF_NUMCOL_UPD',		'value' => isset($conf->global->INFRAS_PDF_NUMCOL_UPD)			? $conf->global->INFRAS_PDF_NUMCOL_UPD			: 8),
												array('select' => 'INFRAS_PDF_NUMCOL_PROGRESS',	'value' => isset($conf->global->INFRAS_PDF_NUMCOL_PROGRESS)		? $conf->global->INFRAS_PDF_NUMCOL_PROGRESS		: 9),
												array('select' => 'INFRAS_PDF_NUMCOL_TOTAL',	'value' => isset($conf->global->INFRAS_PDF_NUMCOL_TOTAL)		? $conf->global->INFRAS_PDF_NUMCOL_TOTAL		: 10));
	$listcol							= array($langs->transnoentities("PDFInfrasRef"),
												$langs->transnoentities("Designation"),
												$langs->transnoentities("Qty"),
												$langs->transnoentities("Unit"),
												$langs->transnoentities("PriceU"),
												$langs->transnoentities("VAT"),
												$langs->transnoentities("ReductionShort"),
												$langs->transnoentities("PDFInfrasDiscountedPrice"),
												'('.$langs->transnoentities("Situation").')*',
												$langs->transnoentities("Total"));
	$listlarg							= array(array('key' => 'INFRAS_PDF_LARGCOL_REF',		'value' => isset($conf->global->INFRAS_PDF_LARGCOL_REF)			? $conf->global->INFRAS_PDF_LARGCOL_REF			: 28),
												array('key' => 'DESC',							'value' => 0),
												array('key' => 'INFRAS_PDF_LARGCOL_QTY',		'value' => isset($conf->global->INFRAS_PDF_LARGCOL_QTY)			? $conf->global->INFRAS_PDF_LARGCOL_QTY			: 10),
												array('key' => 'INFRAS_PDF_LARGCOL_UNIT',		'value' => isset($conf->global->INFRAS_PDF_LARGCOL_UNIT)		? $conf->global->INFRAS_PDF_LARGCOL_UNIT		: 10),
												array('key' => 'INFRAS_PDF_LARGCOL_UP',			'value' => isset($conf->global->INFRAS_PDF_LARGCOL_UP)			? $conf->global->INFRAS_PDF_LARGCOL_UP			: 22),
												array('key' => 'INFRAS_PDF_LARGCOL_TVA',		'value' => isset($conf->global->INFRAS_PDF_LARGCOL_TVA)			? $conf->global->INFRAS_PDF_LARGCOL_TVA			: 14),
												array('key' => 'INFRAS_PDF_LARGCOL_DISC',		'value' => isset($conf->global->INFRAS_PDF_LARGCOL_DISC)		? $conf->global->INFRAS_PDF_LARGCOL_DISC		: 14),
												array('key' => 'INFRAS_PDF_LARGCOL_UPD',		'value' => isset($conf->global->INFRAS_PDF_LARGCOL_UPD)			? $conf->global->INFRAS_PDF_LARGCOL_UPD			: 22),
												array('key' => 'INFRAS_PDF_LARGCOL_PROGRESS',	'value' => isset($conf->global->INFRAS_PDF_LARGCOL_PROGRESS)	? $conf->global->INFRAS_PDF_LARGCOL_PROGRESS	: 10),
												array('key' => 'INFRAS_PDF_LARGCOL_TOTAL',		'value' => isset($conf->global->INFRAS_PDF_LARGCOL_TOTAL)		? $conf->global->INFRAS_PDF_LARGCOL_TOTAL		: 24));
	$marge_gauche						= isset($conf->global->MAIN_PDF_MARGIN_LEFT)			? $conf->global->MAIN_PDF_MARGIN_LEFT							: 10;
	$marge_droite						= isset($conf->global->MAIN_PDF_MARGIN_RIGHT)			? $conf->global->MAIN_PDF_MARGIN_RIGHT							: 10;
	$largutil							= $marge_gauche + $marge_droite;
	foreach ($listlarg as $largs)
		if ($largs['key'] != 'DESC')	$largutil												+= $largs['value'];
	$formatarray						= pdf_getFormat();
	$larg_desc_progress					= $formatarray['width'] - $largutil;
	$larg_desc							= $larg_desc_progress + $listlarg[8]['value'];
	$listlarg[1]['value']				= $larg_desc.' / ('.$larg_desc_progress.')*';

	// View *****************************************
	$page_name							= $langs->trans("InfraSSetup")." - ".$langs->trans("InfraSPDF");
	llxHeader('', $page_name);
	$linkback							= '<a href="'.DOL_URL_ROOT.'/admin/modules.php">'.$langs->trans("BackToModuleList").'</a>';
	print_fiche_titre($page_name, $linkback, 'title_setup');
	
	// Configuration header *************************
	$head	= infraspack_admin_prepare_head();
	$picto	= 'infraspack@infraspack';
	dol_fiche_head($head, 'infrassetup', $langs->trans("modcomname"), 0, $picto);

	// setup page goes here *************************
	$form		= new Form($db);
	$formother	= new FormOther($db);
	print load_fiche_titre($langs->trans("Common"), '', 'title_setup.png');
	print '		<form action="'.$_SERVER["PHP_SELF"].'" method = "post" enctype="multipart/form-data">
					<input type = "hidden" name = "token" value = "'.$_SESSION['newtoken'].'">
					<table class = "noborder" width="100%">
						<colgroup>
							<col width = "*">
							<col width = "90px">
							<col width = "130px">
							<col width = "100px">
						</colgroup>
						<tr class = "liste_titre">
							<td colspan = "2" align = "center">'.$langs->trans('Description').'</td>
							<td colspan = "2" align = "center">'.$langs->trans('Status').'</td>
						</tr>';
	if (! empty($user->admin))
	{
		print '			<tr class="oddeven">
							<td colspan = "3" style = "font-size: 14px;">'.$langs->trans("PDFInfraSParamValidCoreChgt").'</td>
							<td align = "center"><button class = "'.$classcorechg.'" style = "width: 90px;" type = "submit" value = "corechange" name = "action">'.$langs->trans("PDFInfraSParamChange").'</button></td>
						</tr>';
		print '			<tr><td colspan = "4" align = "center" style = "padding: 0;"><hr></td></tr>';
		print '			<tr class="oddeven">
							<td>'.$langs->trans("PDFInfraSParamAddFont").'</td>
							<td colspan = "2" align = "center"><input type = "file" id = "fontfile" name = "fontfile" accept = ".ttf" style = "margin: 0; padding: 0;"></td>
							<td align = "center"><button class = "button" type = "submit" value = "setfont" name = "action">'.$langs->trans("Add").'</button></td>';
		print '			</tr>';
		print '			<tr><td colspan = "4" align = "center" style = "padding: 0;"><hr></td></tr>';
		print '	</form>';
		print '	<form action="'.$_SERVER["PHP_SELF"].'" method = "post" enctype="multipart/form-data">
					<input type = "hidden" name = "token" value = "'.$_SESSION['newtoken'].'">
						<tr>
							<td colspan = "3" align = "center">'.$langs->trans('CautionSave').'</td>
							<td rowspan = "19" align = "center"><button class = "button" type = "submit" value = "update" name = "action">'.$langs->trans("Modify").'</button></td>
						</tr>';
		$selected_font	= $conf->global->INFRAS_PDF_FONT;
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("PDFInfraSParamFont").'</td>';
		print '				<td align="center">
								<select name = "defaultfont" style = "margin: 0; padding: 0; width: 100%;">';
		for ($i = 0; $i < count($listfontuse); $i++)
		{
			print '					<option name = "defaultfont" value = "'.$listfontuse[$i]['fontname'].'"';
			if ($selected_font === $listfontuse[$i]['fontname'])	print ' selected';
			print '					>'.$listfontuse[$i]['name'].'</option>';
		}	// for ($i = 0; $i < count($listfontuse); $i++)
		print '					</select>
							</td>
						</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("PDFInfraSParamHideRecepFrame").'</td>';
		if (! empty($conf->global->INFRAS_PDF_HIDE_RECEP_FRAME))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setcadrerecep&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setcadrerecep&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("PDFInfraSParamshowRecepFDetails").'</td>';
		if (! empty($conf->global->INFRAS_PDF_SHOW_RECEP_DETAILS))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setrecepdetails&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setrecepdetails&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("PDFInfraSParamSmallHead2").'</td>';
		if (! empty($conf->global->INFRAS_PDF_SMALL_HEAD_2))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setheader2&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setheader2&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("PDFInfraSParamRoundedRec").'</td>
							<td align="center">
								<input type = "number" size = "10" style = "text-align: right; margin: 0; padding: 0;" dir="rtl" id = "INFRAS_PDF_ROUNDED_REC" name = "INFRAS_PDF_ROUNDED_REC" min = "0" max = "5" value = "'.$conf->global->INFRAS_PDF_ROUNDED_REC.'">&nbsp;pt
							</td>
						</tr>';
		$color		= colorArrayToHex(explode(',', $conf->global->INFRAS_PDF_BACKGROUND_COLOR));
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("PDFInfraSParamBackgroundColor", $conf->global->INFRAS_PDF_BACKGROUND_COLOR).'</td>
							<td align="center">'.$formother->selectColor($color, 'INFRAS_PDF_BACKGROUND_COLOR').'</td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("PDFInfraSParamtTitleBackground").'</td>';
		if (! empty($conf->global->INFRAS_PDF_TITLE_BG))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=settitlebg&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=settitlebg&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("PDFInfraSParamTextColorAuto").'</td>';
		if (! empty($conf->global->INFRAS_PDF_TEXT_COLOR_AUTO))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=settextcolorauto&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=settextcolorauto&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		$txtcolor	= colorArrayToHex(explode(',', $conf->global->INFRAS_PDF_TEXT_COLOR));
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("PDFInfraSParamTextColor", $conf->global->INFRAS_PDF_TEXT_COLOR).'</td>
							<td align="center">'.$formother->selectColor($txtcolor, 'INFRAS_PDF_TEXT_COLOR').'</td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("PDFInfraSParamhidetoptable").'</td>';
		if (! empty($conf->global->INFRAS_PDF_HIDE_TOP_TABLE))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=sethidetoptable&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=sethidetoptable&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("PDFInfraSParamFoldMark").'</td>
							<td align="center">
								<input type = "number" size = "10" style = "text-align: right; margin: 0; padding: 0;" dir="rtl" id = "INFRAS_PDF_FOLD_MARK" name = "INFRAS_PDF_FOLD_MARK" min = "0" max = "10" value = "'.$conf->global->INFRAS_PDF_FOLD_MARK.'">&nbsp;pt
							</td>
						</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("PDFInfraSParamHidePageNum").'</td>';
		if (! empty($conf->global->INFRAS_PDF_HIDE_PAGE_NUM))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setpagenumber&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setpagenumber&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("PDFInfraSParamPosXPageNum").'</td>
							<td align="center">
								<input type = "number" size = "10" style = "text-align: right; margin: 0; padding: 0;" dir="rtl" id = "INFRAS_PDF_X_PAGE_NUM" name = "INFRAS_PDF_X_PAGE_NUM" min = "10" max = "267" step="0.1" value = "'.$conf->global->INFRAS_PDF_X_PAGE_NUM.'">&nbsp;mm
							</td>
						</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("PDFInfraSParamPosYPageNum").'</td>
							<td align="center">
								<input type = "number" size = "10" style = "text-align: right; margin: 0; padding: 0;" dir="rtl" id = "INFRAS_PDF_Y_PAGE_NUM" name = "INFRAS_PDF_Y_PAGE_NUM" min = "10" max = "285" step="0.1" value = "'.$conf->global->INFRAS_PDF_Y_PAGE_NUM.'">&nbsp;mm
							</td>
						</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("PDFInfraSParamLabelBold").'</td>';
		if (! empty($conf->global->INFRAS_PDF_LABEL_BOLD))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setlabelbold&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setlabelbold&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("PDFInfraSParamTypeFooter").'</td>';
		if (! empty($conf->global->INFRAS_PDF_TYPE_FOOT))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=settypefoot&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=settypefoot&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("PDFInfraSParamNumWords").'<a href="'.$langs->trans("PDFInfraSParamNumWordsLink").'" target="_blank">'.$langs->trans("PDFInfraSParamNumWordsLinkText").'</a></td>';
		if (! empty($conf->global->INFRAS_PDF_NUMBER_WORDS))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setnumwords&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setnumwords&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("PDFInfraSParamHtSignArea").'</td>
							<td align="center">
								<input type = "number" size = "10" style = "text-align: right; margin: 0; padding: 0;" dir="rtl" id = "INFRAS_PDF_HT_SIGN_AREA" name = "INFRAS_PDF_HT_SIGN_AREA" min = "8" max = "48" value = "'.$conf->global->INFRAS_PDF_HT_SIGN_AREA.'">&nbsp;pt
							</td>
						</tr>';
		print '			<tr><td colspan = "4" align = "center" style = "padding: 0;"><hr></td></tr>';
		print '	</form>';
		print '	<form action="'.$_SERVER["PHP_SELF"].'" method = "post" enctype="multipart/form-data">
					<input type = "hidden" name = "token" value = "'.$_SESSION['newtoken'].'">
						<tr>
							<td colspan = "3" align = "center">'.$langs->trans('CautionSave').'</td>
							<td rowspan = "10" align = "center"><button class = "button" type = "submit" value = "update2" name = "action">'.$langs->trans("Modify").'</button></td>
						</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("PDFInfraSParamHideUP").'</td>';
		if (! empty($conf->global->INFRAS_PDF_HIDE_UP))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setup&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setup&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("PDFInfraSParamHideVATColumn").'</td>';
		if (! empty($conf->global->INFRAS_PDF_WITHOUT_VAT_COLUMN))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setvatcolumn&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setvatcolumn&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("PDFInfraSParamTTCWithVATTotal").'</td>';
		if (! empty($conf->global->INFRAS_PDF_TTC_WITH_VAT_TOT))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setttctotvat&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setttctotvat&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("PDFInfraSParamHideAnyVATInformation").'</td>';
		if (! empty($conf->global->INFRAS_PDF_WITHOUT_VAT))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setvat&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setvat&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("PDFInfraSParamHideDiscount").'</td>';
		if (! empty($conf->global->INFRAS_PDF_HIDE_DISCOUNT))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setdiscount&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setdiscount&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("PDFInfraSParamShowUPDiscounted").'</td>';
		if (! empty($conf->global->INFRAS_PDF_SHOW_UP_DISCOUNTED))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setupdiscounted&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setupdiscounted&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("PDFInfraSParamShowTotLocCur").'</td>';
		if (! empty($conf->global->INFRAS_PDF_SHOW_TOTAL_LOCAL_CUR))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=settotloccur&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=settotloccur&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("PDFInfraSParamHideCols").'</td>';
		if (! empty($conf->global->INFRAS_PDF_HIDE_COLS))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=sethidecols&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=sethidecols&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class = "oddeven">
							<td colspan = "3">
								<table width = "100%">
									<tr>
										<td style = "margin: 0; padding: 0; border: none;">
											'.$langs->trans("PDFInfraSParamColNum").'
										</td>';
		foreach ($listselect as $selectvalues)
		{
			$numcol	= num_col($selectvalues, $listselect);
			print '						<td style = "text-align: center; margin: 0; padding: 0; border: none;">
											<select name = "'.$selectvalues['select'].'" style = "margin: 0; padding: 0; border: none;';
			if ($numcol['err'] > 0)	print ' background-color: red;">';
			else					print '">';
			print								$numcol['options'].'
											</select>
										</td>';
		}	// foreach ($listselect as $selectvalues)
		print '						</tr>';
		print '						<tr>
										<td style = "margin: 0; padding: 0; border: none;">
											'.$langs->trans("PDFInfraSParamColName").'
										</td>';
		foreach ($listcol as $col)
			print '						<td style = "text-align: center; margin: 0; padding: 0; border: none;">'.$col.'</td>';
		print '						</tr>';
		print '						<tr>
										<td style = "margin: 0; padding: 0; border: none;">
											'.$langs->trans("PDFInfraSParamColLarg").'
										</td>';
		foreach ($listlarg as $largs)
		{
			print '						<td style = "text-align: center; margin: 0; padding: 0; border: none;">';
			if ($largs['key'] == 'INFRAS_PDF_LARGCOL_PROGRESS')	print '(';
			if ($largs['key'] == 'DESC')	print $largs['value'];
			else
			{
				print '						<input type = "number" size = "2" style = "text-align: center; margin: 0; padding: 0;" dir="rtl" id = "'.$largs['key'].'" name = "'.$largs['key'].'"';
				if ($largs['key'] == 'INFRAS_PDF_LARGCOL_REF' && empty($conf->global->INFRAS_PDF_WITH_REF_COLUMN) && empty($conf->global->INFRAS_PDF_WITH_SUPPLIER_REF_COLUMN))
					print '					 min = "0" max = "0" value = "0" readonly>';
				elseif ($largs['key'] == 'INFRAS_PDF_LARGCOL_UNIT' && empty($conf->global->PRODUCT_USE_UNITS))
					print '					 min = "0" max = "0" value = "0" readonly>';
				elseif ($largs['key'] == 'INFRAS_PDF_LARGCOL_UP' && ! empty($conf->global->INFRAS_PDF_HIDE_UP))
					print '					 min = "0" max = "0" value = "0" readonly>';
				elseif ($largs['key'] == 'INFRAS_PDF_LARGCOL_TVA' && (! empty($conf->global->INFRAS_PDF_WITHOUT_VAT) || ! empty($conf->global->INFRAS_PDF_WITHOUT_VAT_COLUMN) || ! empty($conf->global->INFRAS_PDF_TTC_WITH_VAT_TOT)))
					print '					 min = "0" max = "0" value = "0" readonly>';
				elseif (($largs['key'] == 'INFRAS_PDF_LARGCOL_DISC' || $largs['key'] == 'INFRAS_PDF_LARGCOL_UPD') && ! empty($conf->global->INFRAS_PDF_HIDE_DISCOUNT))
					print '					 min = "0" max = "0" value = "0" readonly>';
				elseif ($largs['key'] == 'INFRAS_PDF_LARGCOL_UPD' && empty($conf->global->INFRAS_PDF_SHOW_UP_DISCOUNTED))
					print '					 min = "0" max = "0" value = "0" readonly>';
				else
					print '					 min = "10" max = "40" value = "'.$largs['value'].'">';
			}	// else	// if ($largs['key'] == 'DESC')
			if ($largs['key'] == 'INFRAS_PDF_LARGCOL_PROGRESS')	print ')*';
			print '						</td>';
		}	// foreach ($listlarg as $largs)
		print '						</tr>';
		print '						<tr>
										<td colspan = "11" align = "center">'.$langs->trans('PDFInfraSParamColProgress').'</td>
									</tr>';
		print '					</table>
							</td>
						</tr>';
		print '	</form>';
		print '			<tr><td colspan = "4" align = "center" style = "padding: 0;"><hr></td></tr>';
		print '	<form action="'.$_SERVER["PHP_SELF"].'" method = "post" enctype="multipart/form-data">
					<input type = "hidden" name = "token" value = "'.$_SESSION['newtoken'].'">
						<tr>
							<td colspan = "3" align = "center"><span>'.$cgvlabel.'</span></td>
							<td rowspan = "3" align = "center"><button class = "button" type = "submit" value = "addcgv" name = "action">'.$btncgvlabel.'</button></td>
						</tr>';
		print '			<tr class="oddeven">
							<td colspan ="3">
								<table width = "100%">
								<tr>
										<td width = "40%">
											'.fieldLabel('CGVName', 'cgvname').'
											<input type = "text" size = "30" id = "cgvname" name = "cgvname" '.$DisabledCGV.'>
										</td>
										<td align = "right">
											'.fieldLabel('CGVFile', 'cgvfile').'
											<input type = "file" id = "cgvfile" name = "cgvfile" accept="*/*" '.$DisabledCGV.'>
										</td>
									</tr>
								</table>
							</td>
						</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("PDFInfraSParamCGVbyDef").'</td>';
		if (! empty($conf->global->INFRAS_PDF_CGV_BY_DEFAULT))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setcgvdef&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setcgvdef&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
	}	// if (! empty($user->admin))
	print '			</table>
				</form>
				<br>
				<form action="'.$_SERVER["PHP_SELF"].'" method = "post" enctype="multipart/form-data">
					<input type = "hidden" name = "token" value = "'.$_SESSION['newtoken'].'">';
	print load_fiche_titre($langs->trans("Specific"), '', 'title_setup.png');
	print '			<table class = "noborder" width = "100%">
						<colgroup>
							<col width = "*">
							<col width = "130px">
							<col width = "100px">
						</colgroup>
						<tr class = "liste_titre">
							<td colspan = "2" align = "center">'.$langs->trans('Description').'</td>
							<td colspan = "2" align = "center">'.$langs->trans('Value').'</td>
						</tr>';
	print '				<tr>
							<td colspan = "3" align = "center">'.$langs->trans('CautionSave').'</td>
							<td rowspan = "14" align = "center"><button class = "button" type = "submit" value = "update3" name = "action">'.$langs->trans("Modify").'</button></td>
						</tr>';
	if (! empty($user->admin))
	{
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("PDFInfraSParamShowRefCol").'</td>';
		if (! empty($conf->global->INFRAS_PDF_WITH_REF_COLUMN))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setrefcol&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setrefcol&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("PDFInfraSParamShowSupRefCol").'</td>';
		if (! empty($conf->global->INFRAS_PDF_WITH_SUPPLIER_REF_COLUMN))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setsuprefcol&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setsuprefcol&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("PDFInfraSParamShowDescDev").'</td>';
		if (! empty($conf->global->INFRAS_PDF_SHOW_DESC_DEV))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setdescdev&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setdescdev&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("PDFInfraSParamHideOrdered").'</td>';
		if (! empty($conf->global->INFRAS_PDF_HIDE_ORDERED))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setordered&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setordered&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("PDFInfraSParamShowOutStdBill").'</td>';
		if (! empty($conf->global->INFRAS_PDF_SHOW_OUTSTDBILL))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setoutstdbill&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setoutstdbill&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("PDFInfraSParamInvoicePaidMark").'</td>
							<td align="center"><input type = "text" size = "20" style = "text-align: center; margin: 0; padding: 0;" id = "INFRAS_PDF_FACTURE_PAID_WATERMARK" name = "INFRAS_PDF_FACTURE_PAID_WATERMARK" value = "'.$conf->global->INFRAS_PDF_FACTURE_PAID_WATERMARK.'"></td>
						</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("PDFInfraSParamShowLCR").'</td>';
		if (! empty($conf->global->INFRAS_PDF_SHOW_LCR))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setLCR&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setLCR&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("PDFInfraSParamShowSignature").'</td>';
		if (! empty($conf->global->INFRAS_PDF_PROPAL_SHOW_SIGNATURE))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setsignprop&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setsignprop&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("PDFInfraSParamShowSignatureSt").'</td>';
		if (! empty($conf->global->INFRAS_PDF_PROPAL_ST_SHOW_SIGNATURE))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setsignpropst&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setsignpropst&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("PDFInfraSParamShowSignatureCom").'</td>';
		if (! empty($conf->global->INFRAS_PDF_COMMANDE_SHOW_SIGNATURE))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setsigncom&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setsigncom&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("PDFInfraSParamShowSignatureFi").'</td>';
		if (! empty($conf->global->INFRAS_PDF_INTERVENTION_SHOW_SIGNATURE))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setsignfi&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setsignfi&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("PDFInfraSParamShowAdrLivr").'</td>';
		if (! empty($conf->global->INFRAS_PDF_SHOW_ADRESSE_LIVRAISON))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setlivadresse&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setlivadresse&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("PDFInfraSParamShowAdrRecep").'</td>';
		if (! empty($conf->global->INFRAS_PDF_SHOW_ADRESSE_RECEPTION))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setrecadresse&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setrecadresse&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
	}	// if (! empty($user->admin))
	print '			</table>
				</form>';
	dol_fiche_end();
	llxFooter();
	$db->close();
?>