<?php
	/************************************************
	* Copyright (C) 2016	Sylvain Legrand - <contact@infras.fr>	InfraS - <http://www.infras.fr>
	*
	* This program is free software: you can redistribute it and/or modify
	* it under the terms of the GNU General Public License as published by
	* the Free Software Foundation, either version 3 of the License, or
	* (at your option) any later version.
	*
	* This program is distributed in the hope that it will be useful,
	* but WITHOUT ANY WARRANTY; without even the implied warranty of
	* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	* GNU General Public License for more details.
	*
	* You should have received a copy of the GNU General Public License
	* along with this program.  If not, see <http://www.gnu.org/licenses/>.
	************************************************/

	/************************************************
	* 	\file		../infrassupprice/class/actions_infraspack.class.php
	* 	\ingroup	InfraS
	* 	\brief		Hook to overload class file for the module InfraS
	************************************************/

	// Libraries ************************************
	require_once DOL_DOCUMENT_ROOT.'/core/lib/admin.lib.php';
	dol_include_once('/infraspack/core/lib/infraspack.lib.php');

	/************************************************
	 * Class infraspack
	************************************************/
	class Actionsinfraspack
	{
		/**
		 * @var array Hook results. Propagated to $hookmanager->resArray for later reuse
		 */
		public $results = array();

		/**
		 * @var string String displayed by executeHook() immediately after return
		 */
		public $resprints;

		/**
		 * @var array Errors
		 */
		public $errors = array();

		/**
		 * Constructor
		 */
		public function __construct($db)
		{
			$this->db	= $db;
		}	// public function __construct($db)

		/************************************************
		* When login
		*
		* @param   array()         $parameters     Hook metadatas (context, etc...)
		* @param   CommonObject    &$object        The object to process (an invoice if you are in invoice module, a propale in propale's module, etc...)
		* @param   string          &$action        Current action (if set). Generally create or edit or null
		* @param   HookManager     $hookmanager    Hook manager propagated to allow calling another hook
		* @return  int                             < 0 on error, 0 on success, 1 to replace standard code
		************************************************/
		public function afterLogin($parameters, &$object, &$action, $hookmanager)
		{
			global $user;
			
			if ($user->admin)	infras_chgtVersions ();
			InfraS_test_new_fields('infraspack');
		}	// public function afterLogin($parameters, &$object, &$action, $hookmanager)

		/************************************************
		* Table build to generate new document and to show linked objects
		*
		* @param   array()         $parameters     Hook metadatas (context, etc...)
		* @param   CommonObject    &$object        The object to process (an invoice if you are in invoice module, a propale in propale's module, etc...)
		* @param   string          &$action        Current action (if set). Generally create or edit or null
		* @param   HookManager     $hookmanager    Hook manager propagated to allow calling another hook
		* @return  int                             < 0 on error, 0 on success, 1 to replace standard code
		************************************************/
		public function formBuilddocOptions($parameters, &$object, &$action, $hookmanager)
		{
			global $bc, $conf, $db, $langs ,$var; // Handle alternate lines classes
			$langs->load('infraspack@infraspack');
			InfraS_test_new_fields('infraspack');
			if (empty($conf->global->INFRAS_PDF_VALID_CORE_CHGT))	setEventMessages($langs->trans('PDFInfrasWarningValidCoreChgt'), null, 'warnings');
			$TContext				= explode(':', $parameters['context']);
			if (in_array('propalcard', $TContext) || in_array('ordercard', $TContext) || in_array('expeditioncard', $TContext) || in_array('contractcard', $TContext) 
				|| in_array('interventioncard', $TContext) || in_array('invoicecard', $TContext) || in_array('supplier_proposalcard', $TContext) 
				|| in_array('ordersuppliercard', $TContext) || in_array('productcard', $TContext))
			{
				$selected_logo		= GETPOST('logo', 'alpha');
				$selected_adr		= GETPOST('adr', 'alpha');
				$selected_pied		= GETPOST('pied', 'alpha');
				$logos				= array();
				$logos				= scandir($conf->mycompany->dir_output.'/logos/');	// Check directory to get logo
				$this->resprints	= ' <tr class="oddeven">
											<input type = "hidden" name = "token" value = "'.$_SESSION['newtoken'].'">
											<td>
												<label for = "logo">'.$langs->trans('Logo').'</label>&nbsp;
												<select class = "flat" name = "logo">
													<option name = "logo" value = "">'.$langs->trans('PDFInfrasDefaultLogo').'</option>';
				for ($i = 0; $i < count($logos); $i++)
				{
					if ($logos[$i] === 'thumbs' || $logos[$i][0] === '.')	continue;	// Choose to ignore field which isn't image
					$this->resprints					.= '<option name = "logo" value = "'.$logos[$i].'"';
					if ($selected_logo === $logos[$i])	$this->resprints	.= ' selected';
					$this->resprints					.= '>'.$logos[$i].'</option>';
				}	// for ($i = 0; $i < count($logos); $i++)
				$this->resprints	.=			'</select>
											</td>';
				unset($i);
				$this->resprints	.=		'<td>
												<label for = "adr">'.$langs->trans('Address').'</label>&nbsp;
												<select class = "flat" name = "adr">
													<option name = "adr" value = "">'.$langs->trans('PDFInfrasDefaultAddress').'</option>';
				$sql_adr			= 'SELECT DISTINCT label, fk_soc';
				$sql_adr			.= ' FROM '.MAIN_DB_PREFIX.'societe_address';
				$sql_adr			.= ' WHERE fk_soc = "0"';
				$resultat_adr		= $db->query($sql_adr);
				if ($resultat_adr)
				{
					$obj_adr		= array();
					$num			= $db->num_rows($resultat_adr);
					for ($i = 0; $i < $num; $i++)
					{
						$obj_adr						= $db->fetch_array($resultat_adr);
						$adr							= $obj_adr['label'];
						$this->resprints				.= '<option name = "adr" value = "'.$adr.'"';
						if ($selected_adr === $adr)		$this->resprints	.= ' selected';
						$this->resprints				.= '>'.$adr.'</option>';
					}	// for ($i = 0; $i < $num; $i++)
				}	// if ($resultat_adr)
				$this->resprints	.=			'</select>
											</td>';
				$db->free($resultat_adr);
				$sql_defaultfoot		= 'SELECT value';
				$sql_defaultfoot		.= ' FROM '.MAIN_DB_PREFIX.'const';
				$sql_defaultfoot		.= ' WHERE name = "INFRAS_PDF_IMAGE_FOOT"';
				$sql_defaultfoot		.= ' AND entity = "'.$conf->entity.'"';
				$resultat_defaultfoot	= $db->query($sql_defaultfoot);
				if ($resultat_defaultfoot)
				{
					$obj 				= $db->fetch_object($resultat_defaultfoot);
					$defaultimagefoot	= $obj->value;
				}	// if ($resultat_defaultfoot)
				$this->resprints	.=		'<td colspan = "2">
												<label for = "pied">'.$langs->trans('Pied').'</label>&nbsp;
												<select class = "flat" name = "pied">
													<option name = "pied" value = "'.$defaultimagefoot.'">'.$langs->trans('PDFInfrasDefaultPied').'</option>';
				for ($i = 0; $i < count($logos); $i++)
				{
					if ($logos[$i] === 'thumbs' || $logos[$i][0] === '.')	continue;	// Choose to ignore field which isn't image
					$this->resprints					.= '<option name = "pied" value = "'.$logos[$i].'"';
					if ($selected_pied === $logos[$i])	$this->resprints	.= ' selected';
					$this->resprints					.= '>'.$logos[$i].'</option>';
				}	// for ($i = 0; $i < count($logos); $i++)
				$this->resprints	.=			'</select>
											</td>
										</tr>';
				unset($i);
				$db->free($resultat_defaultfoot);
			}	// if (in_array('propalcard', $TContext) || in_array('ordercard', $TContext) || in_array('expeditioncard', $TContext) || in_array('contractcard', $TContext) 
				//		|| in_array('interventioncard', $TContext) || in_array('invoicecard', $TContext) || in_array('supplier_proposalcard', $TContext) 
				//		|| in_array('ordersuppliercard', $TContext) || in_array('productcard', $TContext))
			if (in_array('propalcard', $TContext) || in_array('ordercard', $TContext) || in_array('expeditioncard', $TContext) || in_array('interventioncard', $TContext) 
				|| in_array('invoicecard', $TContext))
			{
				$showadrlivr		= isset($conf->global->INFRAS_PDF_SHOW_ADRESSE_RECEPTION) ? $conf->global->INFRAS_PDF_SHOW_ADRESSE_RECEPTION : 0;
				$def_adrlivr		= 'Vide';
				$client				= $object->thirdparty;
				$sel_adrliv			= GETPOST('adrlivr', 'alpha') ? GETPOST('adrlivr', 'alpha') : $def_adrlivr;
				if ($showadrlivr)
				{
					in_array('interventioncard', $TContext) ? $typeadr = $langs->trans('PDFInfrasAdrInter') : $typeadr = $langs->trans('PDFInfrasAdrLivr');
					$this->resprints	.= ' <tr class="oddeven">
												<input type = "hidden" name = "token" value = "'.$_SESSION['newtoken'].'">
												<td>
													<label for = "adrlivr">'.$typeadr.'</label>&nbsp;
													<select class = "flat" name = "adrlivr">
														<option name = "adrlivr" value = "Vide"';
					if ($sel_adrliv === 'Vide')	$this->resprints		.= ' selected';
					$this->resprints	.= '>&nbsp;</option>
														<option name = "adrlivr" value = "Default"';
					if ($sel_adrliv === 'Default')	$this->resprints	.= ' selected';
					$this->resprints	.= '>'.$langs->trans('PDFInfrasBaseAddress').'</option>';
					$sql_adrlivr		= 'SELECT DISTINCT label, fk_soc';
					$sql_adrlivr		.= ' FROM '.MAIN_DB_PREFIX.'societe_address AS sa';
					$sql_adrlivr		.= ' INNER JOIN '.MAIN_DB_PREFIX.'societe AS s';
					$sql_adrlivr		.= ' ON sa.fk_soc = s.rowid';
					$sql_adrlivr		.= ' WHERE s.nom = "'.$client->name.'"';
					$resultat_adrlivr	= $db->query($sql_adrlivr);
					if ($resultat_adrlivr)
					{
						$obj_adrlivr	= array();
						$num			= $db->num_rows($resultat_adrlivr);
						for ($i = 0; $i < $num; $i++)
						{
							$obj_adrlivr						= $db->fetch_array($resultat_adrlivr);
							$adrlivr							= $obj_adrlivr['label'];
							$this->resprints					.= '<option name = "adrlivr" value = "'.$adrlivr;
							if ($sel_adrliv === $adrlivr)		$this->resprints	.= '" selected>';
							else								$this->resprints	.= '">';
							if ($def_adrlivr === $adrlivr)		$this->resprints	.= $adrlivr.' '.$langs->trans('PDFInfrasDefaultAddressLivr').'</option>';
							else								$this->resprints	.= $adrlivr.'</option>';
						}	// for ($i = 0; $i < $num; $i++)
					}	// if ($resultat_adrlivr)
					$this->resprints	.=			'</select>
												</td>';
					if (in_array('expeditioncard', $TContext))	$this->resprints	.= '</tr>';
					$db->free($resultat_adrlivr);
				}	// if ($showadrlivr)
			}	// if (in_array('propalcard', $TContext) || in_array('ordercard', $TContext) || in_array('expeditioncard', $TContext) || in_array('interventioncard', $TContext) 
				//		|| in_array('invoicecard', $TContext))
			if (in_array('contractcard', $TContext) || in_array('invoicecard', $TContext))
			{
				$cgvbydef									= isset($conf->global->INFRAS_PDF_CGV_BY_DEFAULT) ? $conf->global->INFRAS_PDF_CGV_BY_DEFAULT : 0;
				if (in_array('contractcard', $TContext))	$this->resprints	.= ' <tr class="oddeven">
																						<td>&nbsp;</td>';
				$CGV										= isset($conf->global->INFRAS_PDF_CGV) ? $conf->global->INFRAS_PDF_CGV : '';
				if ($CGV)
				{
					$this->resprints	.= '	<td colspan = "3" >
													<label for = "cgvchk">'.$langs->trans('PDFInfrasCGVchk').'</label>&nbsp;
													<input type = "checkbox" name = "cgvchk" value = "cgvchk" '.($cgvbydef ? 'checked' : '').'>
												</td>';
				}	// if ($CGV)
				$this->resprints	.= '</tr>';
			}	// if (in_array('contractcard', $TContext) || in_array('invoicecard', $TContext))
			if (in_array('propalcard', $TContext) || in_array('ordercard', $TContext))
			{
				$cgvbydef									= isset($conf->global->INFRAS_PDF_CGV_BY_DEFAULT) ? $conf->global->INFRAS_PDF_CGV_BY_DEFAULT : 0;
				$hidecols									= isset($conf->global->INFRAS_PDF_HIDE_COLS) ? $conf->global->INFRAS_PDF_HIDE_COLS : 0;
				$CGV										= isset($conf->global->INFRAS_PDF_CGV) ? $conf->global->INFRAS_PDF_CGV : '';
				$this->resprints		.= '	<td>
													<label for = "hidecolschk">'.$langs->trans('PDFInfrasHideColschk').'</label>&nbsp;
													<input type = "checkbox" name = "hidecolschk" value = "hidecolschk" '.($hidecols ? 'checked' : '').'>
												</td>';
				if ($CGV)
				{
					$this->resprints	.= '	<td colspan = "2" >
													<label for = "cgvchk">'.$langs->trans('PDFInfrasCGVchk').'</label>&nbsp;
													<input type = "checkbox" name = "cgvchk" value = "cgvchk" '.($cgvbydef ? 'checked' : '').'>
												</td>';
				}	// if ($CGV)
				$this->resprints	.= '</tr>';
			}	// if (in_array('propalcard', $TContext) || in_array('ordercard', $TContext))
			if (in_array('supplier_proposalcard', $TContext) || in_array('ordersuppliercard', $TContext))
			{
				$showadrlivr		= isset($conf->global->INFRAS_PDF_SHOW_ADRESSE_LIVRAISON) ? $conf->global->INFRAS_PDF_SHOW_ADRESSE_LIVRAISON : 0;
				$def_adrlivr		= isset($conf->global->INFRAS_PDF_DEFAULT_ADDR_DELIV) ? $conf->global->INFRAS_PDF_DEFAULT_ADDR_DELIV : '';
				$sel_adrliv			= GETPOST('adrlivr', 'alpha') ? GETPOST('adrlivr', 'alpha') : $def_adrlivr;
				if ($showadrlivr)
				{
					$this->resprints	.= ' <tr class="oddeven">
												<input type = "hidden" name = "token" value = "'.$_SESSION['newtoken'].'">
												<td colspan = "4">
													<label for = "adrlivr">'.$langs->trans('PDFInfrasAdrLivr').'</label>&nbsp;
													<select class = "flat" name = "adrlivr">
														<option name = "adrlivr" value = "Vide"';
					if ($sel_adrliv === 'Vide')	$this->resprints	.= ' selected';
					$this->resprints	.= '>&nbsp;</option>
														<option name = "adrlivr" value = "Default"';
					if ($sel_adrliv === 'Default')	$this->resprints	.= ' selected';
					$this->resprints	.= '>'.$langs->trans('PDFInfrasBaseAddress').'</option>';
					$sql_adrlivr		= 'SELECT DISTINCT label, fk_soc';
					$sql_adrlivr		.= ' FROM '.MAIN_DB_PREFIX.'societe_address';
					$sql_adrlivr		.= ' WHERE fk_soc = "0"';
					$resultat_adrlivr	= $db->query($sql_adrlivr);
					if ($resultat_adrlivr)
					{
						$obj_adrlivr	= array();
						$num			= $db->num_rows($resultat_adrlivr);
						for ($i = 0; $i < $num; $i++)
						{
							$obj_adrlivr						= $db->fetch_array($resultat_adrlivr);
							$adrlivr							= $obj_adrlivr['label'];
							$this->resprints					.= '<option name = "adrlivr" value = "'.$adrlivr;
							if ($sel_adrliv === $adrlivr)		$this->resprints	.= '" selected>';
							else								$this->resprints	.= '">';
							if ($def_adrlivr === $adrlivr)		$this->resprints	.= $adrlivr.' '.$langs->trans('PDFInfrasDefaultAddressLivr').'</option>';
							else								$this->resprints	.= $adrlivr.'</option>';
						}	// for ($i = 0; $i < $num; $i++)
					}	// if ($resultat_adrlivr)
					$this->resprints	.=			'</select>
												</td>
											</tr>';
					$db->free($resultat_adrlivr);
				}	// if ($showadrlivr)
			}	// if (in_array('supplier_proposalcard', $TContext) || in_array('ordersuppliercard', $TContext))
			return 0;
		}	// public function formBuilddocOptions($parameters, &$object, &$action, $hookmanager)
		
		/************************************************
		 * Allow to change logo and address document
		 *
		 * @param   array()         $parameters     Hook metadatas (context, etc...)
		 * @param   CommonObject    &$object        The object to process (an invoice if you are in invoice module, a propale in propale's module, etc...)
		 * @param   string          &$action        Current action (if set). Generally create or edit or null
		 * @param   HookManager     $hookmanager    Hook manager propagated to allow calling another hook
		 * @return  int                             < 0 on error, 0 on success, 1 to replace standard code
		************************************************/
		public function beforePDFCreation($parameters, &$object, &$action, $hookmanager)
		{
			global $conf, $db, $mysoc;
			$TContext							= explode(':', $parameters['context']);
			if (in_array('propalcard', $TContext) || in_array('ordercard', $TContext) || in_array('expeditioncard', $TContext) || in_array('contractcard', $TContext) 
				|| in_array('interventioncard', $TContext) || in_array('invoicecard', $TContext) || in_array('supplier_proposalcard', $TContext) 
				|| in_array('ordersuppliercard', $TContext) || in_array('productcard', $TContext))
			{
				$selected_logo					= GETPOST('logo', 'alpha');
				$selected_adr					= GETPOST('adr', 'alpha');
				$selected_pied					= GETPOST('pied', 'alpha');
				if (!empty($selected_logo))		$mysoc->logo = $selected_logo;	// Replace default logo
				if (!empty($selected_adr))										// Replace default address
				{
					$sql_address				= 'SELECT a.name, a.address, a.zip, a.town, a.phone, a.fax, a.email, a.url, c.code';
					$sql_address				.= ' FROM '.MAIN_DB_PREFIX.'societe_address AS a';
					$sql_address				.= ' JOIN '.MAIN_DB_PREFIX.'c_country AS c ON c.rowid = a.fk_pays';
					$sql_address				.= ' WHERE a.label = "'.$selected_adr.'"';
					$result_address				= $db->query($sql_address);
					if ($result_address)
					{
						$obj_address			= $db->fetch_object($result_address);
						$mysoc->name			= $obj_address->name;
						$mysoc->address			= $obj_address->address;
						$mysoc->zip				= $obj_address->zip;
						$mysoc->town			= $obj_address->town;
						$mysoc->country_code	= $obj_address->code;
						$mysoc->phone			= $obj_address->phone;
						$mysoc->fax				= $obj_address->fax;
						$mysoc->email			= $obj_address->email;
						$mysoc->url				= $obj_address->url;
					}	// if ($result_address)
					$db->free($result_address);
				}	// if (!empty($selected_adr))
				if (!empty($selected_pied))		$this->results['pied']	= $selected_pied;	// Replace default footer
			}	// if (in_array('propalcard', $TContext) || in_array('ordercard', $TContext) || in_array('expeditioncard', $TContext) || in_array('contractcard', $TContext) 
				//		|| in_array('interventioncard', $TContext) || in_array('invoicecard', $TContext) || in_array('supplier_proposalcard', $TContext) 
				//		|| in_array('ordersuppliercard', $TContext) || in_array('productcard', $TContext))
			if (in_array('contractcard', $TContext) || in_array('invoicecard', $TContext))
			{
				$this->results['chkCGV']			=  GETPOST('cgvchk', 'alpha');
			}	// if (in_array('contractcard', $TContext) || in_array('invoicecard', $TContext))
			if (in_array('propalcard', $TContext) || in_array('ordercard', $TContext))
			{
				$this->results['hidecols']			=  GETPOST('hidecolschk', 'alpha');
				$this->results['chkCGV']			=  GETPOST('cgvchk', 'alpha');
			}	// if (in_array('propalcard', $TContext) || in_array('ordercard', $TContext) || in_array('contractcard', $TContext) || in_array('invoicecard', $TContext))
			if (in_array('propalcard', $TContext) || in_array('ordercard', $TContext) || in_array('expeditioncard', $TContext) || in_array('interventioncard', $TContext) 
				|| in_array('invoicecard', $TContext))
			{
				$showadrlivr					= isset($conf->global->INFRAS_PDF_SHOW_ADRESSE_RECEPTION) ? $conf->global->INFRAS_PDF_SHOW_ADRESSE_RECEPTION : 0;
				if ($showadrlivr)
				{
					$sel_adrliv					= GETPOST('adrlivr', 'alpha');
					if (!empty($sel_adrliv) && $sel_adrliv != 'Default')										// Replace default address
					{
						$sql_adrlivr			= 'SELECT a.name, a.address, a.zip, a.town, a.phone, a.fax, a.email, c.code';
						$sql_adrlivr			.= ' FROM '.MAIN_DB_PREFIX.'societe_address AS a';
						$sql_adrlivr			.= ' JOIN '.MAIN_DB_PREFIX.'c_country AS c ON c.rowid = a.fk_pays';
						$sql_adrlivr			.= ' WHERE a.label = "'.$sel_adrliv.'"';
						$result_adrlivr			= $db->query($sql_adrlivr);
						if ($result_adrlivr)
						{
							$obj_adrlivr				= $db->fetch_object($result_adrlivr);
							$this->results['adrlivr']		= $obj_adrlivr;
						}	// if ($result_adrlivr)
						$db->free($result_adrlivr);
					}	// if (!empty($sel_adrliv) && $sel_adrliv != 'Default')
					else if ($sel_adrliv == 'Default')	$this->results['adrlivr']	= $sel_adrliv;
					else if ($sel_adrliv == 'Vide')		$this->results['adrlivr']	= '';
				}	// if ($showadrlivr)
			}	// if (in_array('propalcard', $TContext) || in_array('ordercard', $TContext) || in_array('expeditioncard', $TContext) || in_array('interventioncard', $TContext) 
				//		|| in_array('invoicecard', $TContext))
			if (in_array('supplier_proposalcard', $TContext) || in_array('ordersuppliercard', $TContext))
			{
				$showadrlivr					= isset($conf->global->INFRAS_PDF_SHOW_ADRESSE_LIVRAISON) ? $conf->global->INFRAS_PDF_SHOW_ADRESSE_LIVRAISON : 0;
				if ($showadrlivr)
				{
					$sel_adrliv					= GETPOST('adrlivr', 'alpha');
					if (!empty($sel_adrliv) && $sel_adrliv != 'Default')										// Replace default address
					{
						$sql_adrlivr			= 'SELECT a.name, a.address, a.zip, a.town, a.phone, a.fax, a.email, c.code';
						$sql_adrlivr			.= ' FROM '.MAIN_DB_PREFIX.'societe_address AS a';
						$sql_adrlivr			.= ' JOIN '.MAIN_DB_PREFIX.'c_country AS c ON c.rowid = a.fk_pays';
						$sql_adrlivr			.= ' WHERE a.label = "'.$sel_adrliv.'"';
						$result_adrlivr			= $db->query($sql_adrlivr);
						if ($result_adrlivr)
						{
							$obj_adrlivr				= $db->fetch_object($result_adrlivr);
							$this->results['adrlivr']		= $obj_adrlivr;
						}	// if ($result_adrlivr)
						$db->free($result_adrlivr);
					}	// if (!empty($sel_adrliv) && $sel_adrliv != 'Default')
					else if ($sel_adrliv == 'Default')	$this->results['adrlivr']	= $sel_adrliv;
					else if ($sel_adrliv == 'Vide')		$this->results['adrlivr']	= '';
				}	// if ($showadrlivr)
			}	// if (in_array('supplier_proposalcard', $TContext) || in_array('ordersuppliercard', $TContext))
			return 0;
		}	// public function beforePDFCreation($parameters, &$object, &$action, $hookmanager)
		
		/************************************************
		 * Change logo and address document for default ones
		 *
		 * @param   array()         $parameters     Hook metadatas (context, etc...)
		 * @param   CommonObject    &$object        The object to process (an invoice if you are in invoice module, a propale in propale's module, etc...)
		 * @param   string          &$action        Current action (if set). Generally create or edit or null
		 * @param   HookManager     $hookmanager    Hook manager propagated to allow calling another hook
		 * @return  int                             < 0 on error, 0 on success, 1 to replace standard code
		************************************************/
		public function afterPDFCreation($parameters, &$object, &$action, $hookmanager)
		{
			$TContext							= explode(':', $parameters['context']);
			if (in_array('propalcard', $TContext) || in_array('ordercard', $TContext) || in_array('expeditioncard', $TContext) || in_array('contractcard', $TContext) 
				|| in_array('interventioncard', $TContext) || in_array('invoicecard', $TContext) || in_array('supplier_proposalcard', $TContext) 
				|| in_array('ordersuppliercard', $TContext))
			{
				global $conf, $db, $mysoc;
				$mysoc->setMysoc($conf);
			}	// if (in_array('propalcard', $TContext) || in_array('ordercard', $TContext) || in_array('expeditioncard', $TContext) || in_array('contractcard', $TContext) 
				//		|| in_array('interventioncard', $TContext) || in_array('invoicecard', $TContext) || in_array('supplier_proposalcard', $TContext) 
				//		|| in_array('ordersuppliercard', $TContext))
			return 0;
		}	// public function afterPDFCreation($parameters, &$object, &$action, $hookmanager)

	}	// class Actionsinfraspack
?>